/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.yylivesdk4cloud.YYLiveAudioCapture;
import com.yy.yylivesdk4cloud.YYLiveBridgeLib;
import com.yy.yylivesdk4cloud.YYLiveChannelLayout;
import com.yy.yylivesdk4cloud.YYLiveDefaultCamera;
import com.yy.yylivesdk4cloud.YYLiveDefaultMic;
import com.yy.yylivesdk4cloud.YYLiveLayout;
import com.yy.yylivesdk4cloud.YYLivePublishChannel;
import com.yy.yylivesdk4cloud.YYLiveVideoCapture;
import com.yy.yylivesdk4cloud.YYPublishAudioConfig;
import com.yy.yylivesdk4cloud.YYPublishInfo;
import com.yy.yylivesdk4cloud.YYPublishVideoConfig;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import java.util.ArrayList;
import java.util.HashMap;

class YYLivePublishChannelImp
implements YYLivePublishChannel {
    private YYLiveVideoCapture mVideoCapture = null;
    private YYLiveAudioCapture mAudioCapture = null;
    private YYLiveDefaultCamera mDefaultCamera = new YYLiveDefaultCamera();
    private YYLiveDefaultMic mDefaultMic = new YYLiveDefaultMic();
    private String mChannelId = null;
    private String mUidString = null;
    private long mUid = 0L;
    private boolean mOwner = false;
    private boolean mPublishing = false;
    private boolean mAudioOnly = false;
    private boolean mEnableVideo = false;
    private boolean mEnableAudio = false;
    private int mPublishMode = -1;
    private int mPlayType = 0;
    private int mCamaraPosition = 0;
    private int mPubOrientation = 0;
    private int mChannelProfile = 0;
    private int mAudioProfile = 0;
    private int mCommunitMode = 0;
    private int mScenarioMode = 0;

    YYLivePublishChannelImp() {
    }

    @Override
    public int startPreview(Object view, int playType, int publishMode) {
        this.mPlayType = playType;
        this.mPublishMode = publishMode;
        YYLiveLog.info("ycall-Java", "startPreview view:%s", view.toString());
        int convertType = this.convertPlayType(playType);
        return YYLiveNative.startVideoPreview(view, convertType, publishMode);
    }

    @Override
    public int stopPreview() {
        YYLiveLog.info("ycall-Java", "stopVideoPreview");
        return YYLiveNative.stopVideoPreview();
    }

    @Override
    public int startLiveInteract(YYLiveLayout layout) {
        if (this.mChannelId == null) {
            YYLiveLog.info("ycall-Java", "startLiveInteract channelId null");
            return -1;
        }
        if (layout == null) {
            YYLiveLog.info("ycall-Java", "startLiveInteract layout error");
            return -1;
        }
        if (layout.layouts.size() == 0 || layout.speakers.size() == 0) {
            YYLiveLog.info("ycall-Java", "startLiveInteract param error");
            return -1;
        }
        this.mAudioOnly = false;
        this.mPlayType = 1;
        YYPublishVideoConfig videoConfig = this.convertVideoConfig();
        YYPublishAudioConfig audioConfig = this.convertAudioConfig();
        if (layout.layouts.size() == 1) {
            YYLiveChannelLayout channelLayout = layout.layouts.get(0);
            if (this.mPublishing) {
                YYLiveNative.updatePublishLive(channelLayout.channelId, true, videoConfig, audioConfig, layout);
            } else {
                this.mPublishing = true;
                if (this.mAudioCapture == null) {
                    YYLiveNative.attachAudioCapture(this.mDefaultMic);
                }
                YYLiveNative.startPublishLive(channelLayout.channelId, true, videoConfig, audioConfig, layout);
            }
            this.mOwner = channelLayout.owner;
        } else {
            for (YYLiveChannelLayout channelLayout : layout.layouts) {
                YYLiveLayout liveLayout = this.convertLayout(layout, channelLayout);
                YYLiveNative.updatePublishLive(channelLayout.channelId, false, videoConfig, audioConfig, liveLayout);
            }
            this.mOwner = true;
        }
        YYLiveLog.info("ycall-Java", "startLiveInteract %s", layout.toString());
        return 0;
    }

    @Override
    public int stopLiveInteract() {
        YYLiveLog.info("ycall-Java", "stopLiveInteract %b", this.mOwner);
        if (this.mOwner) {
            this.mAudioOnly = false;
            this.mPlayType = 0;
            YYPublishVideoConfig videoConfig = this.convertVideoConfig();
            YYPublishAudioConfig audioConfig = this.convertAudioConfig();
            YYLiveLayout layout = this.makeLayout(null);
            return YYLiveNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        return this.stopSinglePublish();
    }

    @Override
    public int startAudioInteract(ArrayList<String> speakers) {
        if (this.mChannelId == null) {
            YYLiveLog.info("ycall-Java", "startAudioInteract channelId null");
            return -1;
        }
        if (speakers == null) {
            YYLiveLog.info("ycall-Java", "startAudioInteract speakers error");
            return -1;
        }
        this.mAudioOnly = true;
        this.mPlayType = 0;
        YYPublishVideoConfig videoConfig = this.convertVideoConfig();
        YYPublishAudioConfig audioConfig = this.convertAudioConfig();
        YYLiveLayout layout = this.makeLayout(speakers);
        if (this.mPublishing) {
            YYLiveNative.updatePublishLive(this.mChannelId, true, videoConfig, audioConfig, layout);
        } else {
            this.mPublishing = true;
            if (this.mAudioCapture == null) {
                YYLiveNative.attachAudioCapture(this.mDefaultMic);
            }
            videoConfig.encodeResolutionHeight = 0;
            videoConfig.encodeResolutionWidth = 0;
            YYLiveNative.startPublishLive(this.mChannelId, true, videoConfig, audioConfig, layout);
        }
        YYLiveChannelLayout channelLayout = layout.getChannelLayout(0);
        this.mOwner = channelLayout.owner;
        YYLiveLog.info("ycall-Java", "startAudioInteract %s", layout.toString());
        return 0;
    }

    @Override
    public int stopAudioInteract() {
        YYLiveLog.info("ycall-Java", "stopAudioInteract %b", this.mOwner);
        if (this.mOwner) {
            this.mAudioOnly = false;
            this.mPlayType = 0;
            YYPublishVideoConfig videoConfig = this.convertVideoConfig();
            YYPublishAudioConfig audioConfig = this.convertAudioConfig();
            YYLiveLayout layout = this.makeLayout(null);
            return YYLiveNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        return this.stopSinglePublish();
    }

    @Override
    public int startSinglePublish(int playType, int publishMode) {
        if (this.mChannelId == null) {
            YYLiveLog.info("ycall-Java", "startPublish channelId null");
            return -1;
        }
        this.mPlayType = playType;
        this.mPublishMode = publishMode;
        this.mPublishing = true;
        this.mAudioOnly = false;
        this.mOwner = true;
        if (this.mAudioCapture == null) {
            YYLiveNative.attachAudioCapture(this.mDefaultMic);
        }
        YYPublishVideoConfig videoConfig = this.convertVideoConfig();
        YYPublishAudioConfig audioConfig = this.convertAudioConfig();
        YYLiveLayout layout = this.makeLayout(null);
        YYLiveLog.info("ycall-Java", "startPublish %s", layout.toString());
        return YYLiveNative.startPublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
    }

    @Override
    public int stopSinglePublish() {
        YYLiveLog.info("ycall-Java", "stopPublish %s", this.mChannelId);
        if (this.mChannelId == null) {
            return 0;
        }
        this.mPublishing = false;
        this.mOwner = false;
        this.mAudioOnly = false;
        return YYLiveNative.stopPublishLive(this.mChannelId);
    }

    @Override
    public int updatePublishMode(int publishMode) {
        if (this.mPublishMode == publishMode) {
            YYLiveLog.info("ycall-Java", "updatePublishMode ignore same");
            return 0;
        }
        if (!this.mPublishing) {
            this.mPublishMode = publishMode;
            YYLiveLog.info("ycall-Java", "updatePublishMode not publishing");
            return 0;
        }
        boolean bSuport = false;
        int convertType = this.convertPlayType(this.mPlayType);
        HashMap<Integer, String> modeMap = YYLiveNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            YYLiveLog.info("ycall-Java", "updatePublishMode empty");
            return -1;
        }
        for (Integer key : modeMap.keySet()) {
            if (key != publishMode) continue;
            bSuport = true;
            break;
        }
        if (bSuport) {
            this.mPublishMode = publishMode;
            YYPublishVideoConfig videoConfig = this.convertVideoConfig();
            if (this.mPlayType == 1) {
                YYLiveNative.updateVideoConfig(videoConfig);
                return 0;
            }
            YYPublishAudioConfig audioConfig = this.convertAudioConfig();
            YYLiveLayout layout = this.makeLayout(null);
            YYLiveNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        YYLiveLog.info("ycall-Java", "updatePublishMode %d %b", publishMode, bSuport);
        return 0;
    }

    @Override
    public HashMap<Integer, String> getPublishMode(int playType) {
        int convertType = this.convertPlayType(playType);
        return YYLiveNative.getSupportModeInfoWithPlayType(convertType);
    }

    @Override
    public int getDefaultPublishMode(int playType) {
        int convertType = this.convertPlayType(playType);
        return YYLiveNative.getDefaultPublishVideoMode(convertType);
    }

    @Override
    public YYPublishInfo getCurrentPublishInfo() {
        YYPublishInfo publishInfo = YYLiveNative.getPublishInfo();
        if (publishInfo != null) {
            publishInfo.publishOrientation = this.mPubOrientation;
            publishInfo.cameraPosition = this.mCamaraPosition;
        }
        return publishInfo;
    }

    @Override
    public boolean setCameraPosition(int position) {
        this.mCamaraPosition = position;
        YYLiveLog.info("ycall-Java", "setCameraPosition %d", position);
        return YYLiveNative.setCameraPosition(position);
    }

    @Override
    public void setPublishOrientation(int orientation) {
        this.mPubOrientation = orientation;
        YYLiveNative.setOrientation(orientation);
    }

    @Override
    public int setWatermark(int posX, int posY, Bitmap image) {
        if (image == null) {
            return -1;
        }
        YYLiveLog.info("ycall-Java", "setWatermark in (%d,%d)", posX, posY);
        return YYLiveNative.setWatermark(posX, posY, image);
    }

    @Override
    public int setFaceBeautyLevel(float level) {
        if (level >= 1.000001f) {
            level = 1.0f;
        } else if (level < 1.0E-6f) {
            level = 0.0f;
        }
        YYLiveLog.info("ycall-Java", "setFaceBeautyLevel %f", Float.valueOf(level));
        return YYLiveNative.setFaceBeautyLevel(level);
    }

    @Override
    public boolean setMicVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        YYLiveLog.info("ycall-Java", "setMicVolume %d", volume);
        return YYLiveNative.setMicVolume(volume);
    }

    @Override
    public OrangeFilterWrapper getBeautyFilter() {
        return YYLiveBridgeLib.getInstance().getBeautyFilter();
    }

    public YYLiveDefaultMic getDefaluteMic() {
        return this.mDefaultMic;
    }

    @Override
    public void attachAudioCapture(YYLiveAudioCapture capture) {
        this.mAudioCapture = capture == null ? this.mDefaultMic : capture;
        YYLiveLog.info("ycall-Java", "attachAudioCapture %s", this.mAudioCapture.toString());
        YYLiveNative.attachAudioCapture(this.mAudioCapture);
    }

    @Override
    public void attachVideoCapture(YYLiveVideoCapture capture) {
        this.mVideoCapture = capture == null ? this.mDefaultCamera : capture;
        YYLiveLog.info("ycall-Java", "attachVideoCapture %s", this.mVideoCapture.toString());
        YYLiveNative.attachVideoCapture(this.mVideoCapture);
    }

    @Override
    public void syncUserInfo(String channelId, String uid, boolean is32Bit, int userRole) {
        this.mChannelId = channelId;
        this.mUidString = uid;
        if (is32Bit) {
            this.mUid = uid == null ? 0L : Long.parseLong(uid);
        }
    }

    @Override
    public void updateProfile(int channelProfile, int audioProfile, int commutMode, int scenarioMode) {
        this.mChannelProfile = channelProfile;
        this.mAudioProfile = audioProfile;
        this.mCommunitMode = commutMode;
        this.mScenarioMode = scenarioMode;
    }

    @Override
    public int startCapture() {
        YYLiveLog.info("ycall-Java", "start capture");
        return YYLiveNative.startCapture();
    }

    @Override
    public int stopCapture() {
        YYLiveLog.info("ycall-Java", "stop capture");
        return YYLiveNative.stopCapture();
    }

    private YYPublishVideoConfig convertVideoConfig() {
        int convertType = this.convertPlayType(this.mPlayType);
        YYPublishVideoConfig config = YYLiveNative.getRemoteVideoConfig(convertType, this.mPublishMode);
        return config;
    }

    private YYPublishAudioConfig convertAudioConfig() {
        YYPublishAudioConfig config = new YYPublishAudioConfig(5);
        config.bUseAudioProfile = true;
        if (this.mAudioProfile == 0 && this.mCommunitMode == 0 && this.mScenarioMode == 0) {
            if (this.mPlayType == 0 || this.mPlayType == 2) {
                config.audioProfile = 3;
                config.commutMode = 2;
                config.scenarioMode = 2;
            } else if (this.mPlayType == 1) {
                config.audioProfile = 3;
                config.commutMode = 1;
                config.scenarioMode = 1;
            }
        } else {
            config.audioProfile = this.mAudioProfile;
            config.commutMode = this.mCommunitMode;
            config.scenarioMode = this.mScenarioMode;
        }
        config.channelProfile = this.mChannelProfile;
        return config;
    }

    private YYLiveLayout convertLayout(YYLiveLayout liveLayout, YYLiveChannelLayout channelLayout) {
        ArrayList<YYLiveChannelLayout> layouts = new ArrayList<YYLiveChannelLayout>();
        layouts.add(channelLayout);
        YYLiveLayout layout = new YYLiveLayout();
        layout.width = liveLayout.width;
        layout.height = liveLayout.height;
        layout.layouts = layouts;
        layout.speakers = liveLayout.speakers;
        return layout;
    }

    private YYLiveLayout makeLayout(ArrayList<String> speakers) {
        int convertType = this.convertPlayType(this.mPlayType);
        YYPublishVideoConfig config = YYLiveNative.getRemoteVideoConfig(convertType, this.mPublishMode);
        Rect rect = new Rect(0, 0, config.encodeResolutionWidth, config.encodeResolutionHeight);
        YYLiveChannelLayout channelLayout = new YYLiveChannelLayout();
        channelLayout.channelId = this.mChannelId;
        channelLayout.layoutNo = 0;
        channelLayout.layout = rect;
        ArrayList<YYLiveChannelLayout> layouts = new ArrayList<YYLiveChannelLayout>();
        layouts.add(channelLayout);
        YYLiveLayout layout = new YYLiveLayout();
        layout.width = 0;
        layout.height = 0;
        layout.layouts = layouts;
        if (speakers == null || speakers.isEmpty()) {
            channelLayout.owner = true;
            ArrayList<String> spk = new ArrayList<String>();
            spk.add(this.mUidString);
            layout.speakers = spk;
        } else {
            channelLayout.owner = this.mPublishing;
            layout.speakers = speakers;
        }
        return layout;
    }

    private int convertPlayType(int playType) {
        if (this.mAudioOnly) {
            return 0;
        }
        switch (playType) {
            case 0: {
                playType = 0;
                break;
            }
            case 1: {
                playType = 1;
                break;
            }
            case 2: {
                playType = 5;
                break;
            }
        }
        return playType;
    }

    @Override
    public void setAudioEnable(boolean enableAudio) {
        if (this.mEnableAudio == enableAudio) {
            return;
        }
        this.mEnableAudio = enableAudio;
        if (enableAudio) {
            YYLiveNative.setAudioSourceType(0);
            if (this.mEnableVideo) {
                this.mAudioOnly = false;
                this.startSinglePublish(this.mPlayType, this.mPublishMode);
            } else {
                this.mAudioOnly = true;
                YYPublishAudioConfig audioConfig = this.convertAudioConfig();
                YYPublishVideoConfig videoConfig = new YYPublishVideoConfig();
                YYLiveLayout layout = this.makeLayout(null);
                if (this.mAudioCapture == null) {
                    YYLiveNative.attachAudioCapture(this.mDefaultMic);
                }
                YYLiveNative.startPublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
                this.mPublishing = true;
            }
        } else {
            this.mAudioOnly = false;
            if (this.mEnableVideo) {
                YYPublishAudioConfig audioConfig = this.convertAudioConfig();
                YYPublishVideoConfig videoConfig = this.convertVideoConfig();
                YYLiveLayout layout = this.makeLayout(null);
                YYLiveNative.stopPublishAudio();
                YYLiveNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
            } else {
                YYLiveNative.stopPublishLive(this.mChannelId);
                this.mPublishing = false;
            }
        }
    }

    @Override
    public void setVideoEnable(boolean enableVideo) {
        if (enableVideo == this.mEnableVideo) {
            return;
        }
        this.mEnableVideo = enableVideo;
        if (enableVideo) {
            this.mAudioOnly = false;
            if (this.mEnableAudio) {
                this.startSinglePublish(this.mPlayType, this.mPublishMode);
            } else {
                YYPublishVideoConfig videoConfig = this.convertVideoConfig();
                YYPublishAudioConfig audioConfig = new YYPublishAudioConfig(0);
                YYLiveLayout layout = this.makeLayout(null);
                YYLiveNative.startPublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
                this.mPublishing = true;
            }
        } else if (this.mEnableAudio) {
            this.mAudioOnly = true;
            YYPublishVideoConfig videoConfig = new YYPublishVideoConfig();
            YYPublishAudioConfig audioConfig = this.convertAudioConfig();
            YYLiveLayout layout = this.makeLayout(null);
            YYLiveNative.stopPublishVideo();
            YYLiveNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        } else {
            this.mAudioOnly = false;
            YYLiveNative.stopPublishLive(this.mChannelId);
            this.mPublishing = false;
        }
    }

    @Override
    public int updatePlayTypeAndPublishMode(int playType, int publishMode) {
        if (this.mPlayType == playType && this.mPublishMode == publishMode) {
            YYLiveLog.info("ycall-Java", "updatePlayTypeAndPublishMode ignore same");
            return 0;
        }
        boolean bSupport = this.isPublishParamValid(playType, publishMode);
        YYLiveLog.info("ycall-Java", "updatePlayTypeAndPublishMode %d %d %b", playType, publishMode, bSupport);
        if (!bSupport) {
            return -1;
        }
        if (this.mEnableVideo) {
            this.mPlayType = playType;
            this.mPublishMode = publishMode;
            YYPublishVideoConfig videoConfig = this.convertVideoConfig();
            YYPublishAudioConfig audioConfig = this.convertAudioConfig();
            YYLiveLayout layout = this.makeLayout(null);
            YYLiveNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        } else {
            this.mPlayType = playType;
            this.mPublishMode = publishMode;
            YYPublishVideoConfig videoConfig = this.convertVideoConfig();
            YYLiveNative.updateVideoConfig(videoConfig);
        }
        return 0;
    }

    private boolean isPublishParamValid(int playType, int publishMode) {
        int convertType = this.convertPlayType(playType);
        HashMap<Integer, String> modeMap = YYLiveNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            YYLiveLog.info("ycall-Java", "updatePlayTypeAndPublishMode empty");
            return false;
        }
        if (publishMode == -1) {
            return true;
        }
        for (Integer key : modeMap.keySet()) {
            if (key != publishMode) continue;
            return true;
        }
        return false;
    }
}

