/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

public class YYLiveAudioFilePlayer
implements Comparable<YYLiveAudioFilePlayer> {
    private IYYLiveAudioFilePlayerCallback mCallback = null;
    private long nativeCtx = YYLiveNative.createAudioFilePlayer(this);
    private boolean mIsDestroy = false;
    private final int PLAY_EVENT_END = 1;
    private final int FILE_PLAY_VOLUME = 2;

    public synchronized void setPlayerNotify(IYYLiveAudioFilePlayerCallback callback) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer setPlayerNotify");
        if (this.mIsDestroy) {
            return;
        }
        this.mCallback = callback;
    }

    public synchronized void enableVolumeIndication(boolean enable, int interval) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer enableVolumeNotify enable = %b, interval=%d ", enable, interval);
        if (this.mIsDestroy) {
            return;
        }
        if (interval <= 0) {
            interval = 200;
        }
        YYLiveNative.enableAudioFileVolumeCallback(this.nativeCtx, enable, interval);
    }

    public boolean open(String path) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer open path = %s", path);
        if (this.mIsDestroy) {
            return false;
        }
        int ret = (int)YYLiveNative.audioFileOpen(this.nativeCtx, path);
        return ret == 1;
    }

    public void close() {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer close");
        if (this.mIsDestroy) {
            return;
        }
        YYLiveNative.audioFileClose(this.nativeCtx);
    }

    public void play() {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer play");
        if (this.mIsDestroy) {
            return;
        }
        YYLiveNative.audioFilePlay(this.nativeCtx);
    }

    public void stop() {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer stop");
        if (this.mIsDestroy) {
            return;
        }
        YYLiveNative.audioFileStop(this.nativeCtx);
    }

    public void pause() {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer pause");
        if (this.mIsDestroy) {
            return;
        }
        YYLiveNative.audioFilePause(this.nativeCtx);
    }

    public void resume() {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer resume");
        if (this.mIsDestroy) {
            return;
        }
        YYLiveNative.audioFileResume(this.nativeCtx);
    }

    public void seek(long timeMS) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer seek timems = %d ", timeMS);
        if (this.mIsDestroy) {
            return;
        }
        YYLiveNative.audioFileSeek(this.nativeCtx, timeMS);
    }

    public long getTotalPlayTimeMS() {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer getTotalPlayTimeMS ");
        if (this.mIsDestroy) {
            return 0L;
        }
        return YYLiveNative.audioFileGetTotalTime(this.nativeCtx);
    }

    public long getCurrentPlayTimeMS() {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer getCurrentPlayTimeMS ");
        if (this.mIsDestroy) {
            return 0L;
        }
        return YYLiveNative.audioFileGetCurrentPlayTime(this.nativeCtx);
    }

    public void setPlayVolume(int volume) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer setPlayVolume volume = %d", volume);
        if (this.mIsDestroy) {
            return;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        YYLiveNative.audioFileSetPlayVolume(this.nativeCtx, volume);
    }

    public void setSemitone(int val) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer setSemitone val = %d", val);
        if (this.mIsDestroy) {
            return;
        }
        float tone = val;
        YYLiveNative.audioFileSetSemitone(this.nativeCtx, tone);
    }

    public void enablePublish(boolean enable) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer enablePublish: enable=%b", enable);
        if (this.mIsDestroy) {
            return;
        }
        YYLiveNative.audioFileEnablePublish(this.nativeCtx, enable);
    }

    public void setKaraokeCompensateValue(int value) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer setKaraokeCompensateValue value = %d ", value);
        YYLiveNative.audioFileSetCompensateValue(this.nativeCtx, value);
    }

    public void onPlayEvent(int event) {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer onPlayEvent event = %d", event);
        if (this.mIsDestroy) {
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        switch (event) {
            case 1: {
                this.mCallback.onAudioFilePlayEnd();
            }
        }
    }

    public synchronized void onAudioFileVolume(long volume, long currentMs, long totalMs) {
        if (this.mIsDestroy) {
            return;
        }
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onAudioFileVolume(volume, currentMs, totalMs);
    }

    void destroyAudioFilePlayer() {
        YYLiveLog.release("ycall-Java", "YYLiveAudioFilePlayer destroyAudioFilePlayer");
        this.setPlayerNotify(null);
        YYLiveNative.destroyAudioFilePlayer(this.nativeCtx);
        this.mIsDestroy = true;
        this.nativeCtx = 0L;
    }

    protected void finalize() {
        this.destroyAudioFilePlayer();
    }

    @Override
    public int compareTo(YYLiveAudioFilePlayer audioFilePlayer) {
        if (audioFilePlayer == null) {
            throw new NullPointerException();
        }
        if (this == audioFilePlayer) {
            return 0;
        }
        return 1;
    }

    public static interface IYYLiveAudioFilePlayerCallback {
        public void onAudioFilePlayEnd();

        public void onAudioFileVolume(long var1, long var3, long var5);
    }
}

