/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import com.yy.mediaframework.VideoLibAPI;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.yylivesdk4cloud.IYYLogCallback;
import com.yy.yylivesdk4cloud.YYDeviceInfo;
import com.yy.yylivesdk4cloud.YYLivePlayer;
import com.yy.yylivesdk4cloud.YYLivePublishChannel;
import com.yy.yylivesdk4cloud.YYLivePublishChannelImp;
import com.yy.yylivesdk4cloud.YYLivePublisher;
import com.yy.yylivesdk4cloud.YYLiveServiceChannel;
import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import com.yy.yylivesdk4cloud.system.YYForeBackgroundListener;
import com.yy.yylivesdk4cloud.system.YYNetStateService;
import com.yy.yylivesdk4cloud.video.serviceConfig.ArgoServiceImp;
import java.util.HashMap;
import java.util.HashSet;

public class YYLiveAPI {
    private YYLivePlayer mPlayer = null;
    private YYLivePublisher mPublisher = null;
    private YYLivePublishChannel mPubChannel = null;
    private YYNetStateService mNetStateService = null;
    private YYForeBackgroundListener mForeBackgroundListener = null;
    private String mVersion = null;
    private int mVersionInt = 0;
    private YYLiveNative.NotificationDispatcher mNotificationDispatcher = null;
    private ArgoServiceImp mArgoService = null;
    private boolean mIsInited = false;
    private boolean m32BitUid = true;
    private YYLiveServiceChannel mServiceChannel = null;

    private YYLiveAPI() {
        try {
            System.loadLibrary("yyvideoplayer");
        }
        catch (Throwable e) {
            e.printStackTrace();
            YYLiveLog.error("ycall-Java", "load yyvideoplayer failed!");
        }
        try {
            System.loadLibrary("yylivesdk4cloud");
        }
        catch (Throwable e) {
            e.printStackTrace();
            YYLiveLog.error("ycall-Java", "load yylivesdk4cloud failed!");
            return;
        }
        this.mPlayer = new YYLivePlayer();
        this.mPublisher = new YYLivePublisher();
        this.mPubChannel = new YYLivePublishChannelImp();
        this.mServiceChannel = new YYLiveServiceChannel();
    }

    public static YYLiveAPI sharedInstance() {
        if (SingletonHolder.INSTANCE == null) {
            SingletonHolder.INSTANCE = new YYLiveAPI();
        }
        return SingletonHolder.INSTANCE;
    }

    public static void enableLog(boolean enable, int level, String logPath, IYYLogCallback callback) {
        YYLiveAPI.sharedInstance();
        YYLiveNative.enableLog(enable, callback, level, logPath);
        YYLiveLog.release("ycall-Java", "enableLog enable:%b level:%d", enable, level);
    }

    public void fetchedLogConfig() {
        YYLiveNative.fetchedLogConfig();
    }

    public String getVersion() {
        return this.mVersion;
    }

    public int getVersionInt() {
        return this.mVersionInt;
    }

    public boolean initWithAppId(long appId, long sceneId, Context appContext) {
        if (this.mIsInited) {
            return false;
        }
        YYLiveLog.release("ycall-Java", "init appId:%d sceneId:%d appContext:%s", appId, sceneId, appContext.toString());
        if (this.mNetStateService != null) {
            this.mNetStateService.fini();
        }
        if (this.mForeBackgroundListener != null) {
            this.mForeBackgroundListener.fini();
        }
        this.mNotificationDispatcher = new YYLiveNative.NotificationDispatcher(){
            private final HashSet<Handler> mNotificationHandlers = new HashSet();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNotificationHandler(Handler handler) {
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    this.mNotificationHandlers.add(handler);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNotificationHandler(Handler handler) {
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    this.mNotificationHandlers.remove(handler);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object[] collectNotificationHandlers() {
                Object[] handlers = null;
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    if (this.mNotificationHandlers.size() > 0) {
                        handlers = this.mNotificationHandlers.toArray();
                    }
                }
                return handlers;
            }
        };
        YYDeviceInfo info = new YYDeviceInfo(appContext);
        YYVideoLibMgr.instance().init(appContext, "1.0", "YYLiveDemo", Build.VERSION.RELEASE, Build.MODEL, null);
        int ret = YYLiveNative.init(appId, sceneId, appContext, info, this.mNotificationDispatcher);
        if (ret < 0) {
            YYLiveLog.error("ycall-Java", "init failed!");
            return false;
        }
        if (this.mServiceChannel != null) {
            this.mServiceChannel.init(appContext, appId);
            this.mServiceChannel.registBroadcastListener();
        }
        this.mNetStateService = new YYNetStateService(appContext);
        this.mForeBackgroundListener = new YYForeBackgroundListener(appContext);
        this.mNetStateService.init();
        this.mForeBackgroundListener.init();
        VideoLibAPI.instance().initVideoLib(appId, sceneId, appContext);
        YYVideoLibMgr.instance().init(appContext, "1.0", "YYLiveDemo", Build.VERSION.RELEASE, Build.MODEL, null);
        this.mVersion = YYLiveNative.getVersion();
        this.mVersionInt = YYLiveNative.getVersionInt();
        this.mArgoService = new ArgoServiceImp(appContext, info, appId, sceneId);
        this.mIsInited = true;
        YYLiveLog.release("ycall-Java", "init succeeded, version %s", this.mVersion, " versionInt %u", this.mVersionInt);
        return true;
    }

    public void deInit() {
        if (!this.mIsInited) {
            return;
        }
        if (this.mNetStateService != null) {
            this.mNetStateService.fini();
        }
        if (this.mForeBackgroundListener != null) {
            this.mForeBackgroundListener.fini();
        }
        if (this.mServiceChannel != null) {
            this.mServiceChannel.unregistBroadcastListener();
        }
        if (this.mArgoService != null) {
            this.mArgoService.fini();
        }
        YYLiveNative.fini();
        this.mNetStateService = null;
        this.mForeBackgroundListener = null;
        this.mArgoService = null;
        this.mVersion = null;
        this.mVersionInt = 0;
        this.mIsInited = false;
        SingletonHolder.INSTANCE = null;
        YYLiveLog.release("ycall-Java", "[call] YYLiveAPI.deInit success");
    }

    public void registerNotificationHandler(Handler handler) {
        YYLiveLog.release("ycall-Java", "registerNotificationHandler %s", handler.toString());
        this.mNotificationDispatcher.registerNotificationHandler(handler);
    }

    public void unregisterNotificationHandler(Handler handler) {
        YYLiveLog.release("ycall-Java", "unregisterNotificationHandler %s", handler.toString());
        this.mNotificationDispatcher.unregisterNotificationHandler(handler);
    }

    public void setAreaType(int areaType) {
        YYLiveLog.release("ycall-Java", "setAreaType %d", areaType);
        YYLiveNative.setAreaType(areaType);
    }

    public void enableVad(boolean enable) {
        YYLiveLog.release("ycall-Java", "enableVad %b", enable);
        YYLiveNative.enableVad(enable);
    }

    public void setSceneId(long sceneId) {
        if (this.mArgoService != null) {
            this.mArgoService.setProfileParam("scene_id", String.valueOf(sceneId));
            this.mArgoService.queryConfigs();
        }
        YYLiveLog.release("ycall-Java", "setSceneId %d", sceneId);
        YYLiveNative.setSceneId(sceneId);
    }

    public void updateToken(byte[] token) {
        if (token == null) {
            return;
        }
        YYLiveLog.release("ycall-Java", "updateToken sToken %d", token.length);
        YYLiveNative.updateToken(token, null);
    }

    public void joinMedia(long uid) {
        YYLiveLog.release("ycall-Java", "joinMedia %d", uid);
        this.fetchConfigsWith(Long.toString(uid));
        YYLiveNative.joinMedia(uid, 0L, 0L);
    }

    public void joinMedia(long uid, long sid, long subSid) {
        YYLiveLog.release("ycall-Java", "joinMedia %d %d %d", uid, sid, subSid);
        this.fetchConfigsWith(Long.toString(uid));
        YYLiveNative.joinMedia(uid, sid, subSid);
    }

    public void joinMedia(String uid, long sid, long subSid) {
        String _uid = uid != null ? uid : new String();
        YYLiveLog.release("ycall-Java", "joinMedia %s %d %d", _uid, sid, subSid);
        this.fetchConfigsWith(_uid);
        YYLiveNative.joinMedia(_uid, sid, subSid);
    }

    private void fetchConfigsWith(String uid) {
        if (this.mArgoService != null) {
            YYLiveLog.release("ycall-Java", "fetchConfigsWith %s", uid);
            this.mArgoService.setProfileParam("uid", uid);
            this.mArgoService.queryConfigs();
        }
    }

    public void leaveMedia() {
        YYLiveLog.release("ycall-Java", "leaveMedia");
        YYLiveNative.leaveMedia();
    }

    public boolean joinChannel(String channelId, String uid, int userRole) {
        if (channelId == null || uid == null) {
            YYLiveLog.info("ycall-Java", "joinChannel param error");
            return false;
        }
        if (this.mServiceChannel != null) {
            this.mServiceChannel.subscribeBroadcast(channelId, uid);
        }
        if (this.mArgoService != null) {
            this.mArgoService.setProfileParam("uid", uid);
            this.mArgoService.setProfileParam("channel_id", channelId);
            this.mArgoService.queryConfigs();
        }
        YYLiveLog.info("ycall-Java", "joinChannel %s %s %d", channelId, uid, userRole);
        YYLiveNative.joinChannel(channelId, uid, this.m32BitUid, userRole);
        return true;
    }

    public void leaveChannel() {
        if (this.mServiceChannel != null) {
            this.mServiceChannel.unSubscribeBroadcast();
        }
        YYLiveLog.info("ycall-Java", "leaveChannel");
        YYLiveNative.leaveChannel();
    }

    private void set32BitUid(boolean is32Bit) {
        YYLiveLog.release("ycall-Java", "set32BitUid %b", is32Bit);
        this.m32BitUid = is32Bit;
    }

    public void setUserRole(int role) {
        YYLiveLog.release("ycall-Java", "setUserRole %d", role);
        YYLiveNative.setUserRole(role);
    }

    public void enableLowLatency(boolean enable) {
        YYLiveLog.release("ycall-Java", "enableLowLatency %b", enable);
        YYLiveNative.enableLowLatency(enable);
    }

    public void setChannelProfile(int profile) {
        YYLiveLog.release("ycall-Java", "setChannelProfile %d", profile);
        YYLiveNative.setChannelProfile(profile);
    }

    public void setPlayVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        YYLiveNative.setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    public void setCaptureVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        YYLiveNative.setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        return YYLiveNative.startAudioSaver(fileName, saverMode, fileMode);
    }

    public boolean stopAudioSaver() {
        return YYLiveNative.stopAudioSaver();
    }

    public YYLivePublisher getPublisher() {
        return this.mPublisher;
    }

    public YYLivePublishChannel getPublishChannel() {
        return this.mPubChannel;
    }

    public YYLivePlayer getPlayer() {
        return this.mPlayer;
    }

    public void setExternalAudioProcessor(long eap) {
        YYLiveLog.release("ycall-Java", "setExternalAudioProcessor %d", eap);
        YYLiveNative.setExternalAudioProcessor(eap);
    }

    public void enableAudioPlaySpectrum(boolean enable) {
        YYLiveNative.enableAudioPlaySepctrum(enable);
    }

    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        YYLiveNative.setAudioPlaySepctrumInfo(spectrumLen, notifyIntervalMS);
    }

    public void enableAudioDataIndication(boolean enable) {
        YYLiveNative.enableAudioDataIndication(enable);
    }

    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        YYLiveNative.enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        if (!(sampleRate != -1 && sampleRate != 8000 && sampleRate != 16000 && sampleRate != 441000 && sampleRate != 480000 || channel != -1 && channel != 1 && channel != 2)) {
            YYLiveNative.enableRenderPcmDataCallBack(enable, sampleRate, channel);
            return true;
        }
        return false;
    }

    public void sendUserAppMsgData(byte[] msgData) {
        if (msgData == null) {
            return;
        }
        YYLiveNative.sendUserAppMsgData(msgData);
    }

    public void setArgoConfig(HashMap<Integer, Integer> cfg) {
        if (this.mIsInited) {
            YYLiveNative.setArgoConfig(cfg);
        }
    }

    public void setHttpsBinaryResponse(String reqUrl, byte[] response, int statusCode, int errCode, int target) {
        YYLiveNative.setHttpsBinaryResponse(reqUrl, response, statusCode, errCode, target);
    }

    public void setHttpsTextResponse(String reqUrl, String response, int statusCode, int errCode, int target) {
        YYLiveNative.setHttpsTextResponse(reqUrl, response, statusCode, errCode, target);
    }

    public int setPreviewRenderMode(int mode) {
        return YYLiveNative.setPreviewRenderMode(mode);
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        YYLiveNative.registerAudioFrameObserver(observer);
        return 0;
    }

    public int setRecordingAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        YYLiveNative.setRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
        return 0;
    }

    public int setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        YYLiveNative.setPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
        return 0;
    }

    private static class SingletonHolder {
        private static YYLiveAPI INSTANCE = new YYLiveAPI();

        private SingletonHolder() {
        }
    }
}

