/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import com.yy.yylivesdk4cloud.IVideoFrameConsumer;
import com.yy.yylivesdk4cloud.IVideoSource;
import com.yy.yylivesdk4cloud.YYLivePublisher;
import com.yy.yylivesdk4cloud.YYLiveVideoCapture;
import com.yy.yylivesdk4cloud.YYVideoCaptureConfig;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;

public class ExternalVideoSource
extends YYLiveVideoCapture {
    IVideoSource mVideoSource = null;
    YYLivePublisher.IVideoPublisher mPublisher = null;

    public ExternalVideoSource(IVideoSource videoSource) {
        this.mVideoSource = videoSource;
    }

    @Override
    public void startCapture(YYLivePublisher.IVideoPublisher proxy) {
        this.mPublisher = proxy;
        if (this.mVideoSource != null) {
            this.mVideoSource.onInitialize(new IVideoFrameConsumer(){

                @Override
                public void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation, long timestamp) {
                    if (ExternalVideoSource.this.mPublisher != null) {
                        ExternalVideoSource.this.mPublisher.pushVideoData(data, format, width, height, rotation, timestamp);
                    }
                }
            });
            this.mVideoSource.onStart();
        } else {
            YYLiveLog.info("yrtc", "warning,  need set videoSource...");
        }
    }

    @Override
    public void stopCapture() {
        if (this.mVideoSource != null) {
            this.mVideoSource.onStop();
            this.mVideoSource.onDispose();
        } else {
            YYLiveLog.info("yrtc", "warning,  need set videoSource...");
        }
    }

    @Override
    public YYVideoCaptureConfig getCaptureConfig() {
        return null;
    }
}

