package com.yy.yylivesdk4cloud.video.serviceConfig;

import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;

import java.util.List;

/**
 * Created by Administrator on 2018/8/14.
 */

public class VideoLiveConfig {
    //开播
    public int videoLevel;      //视频清晰度（标清、高清、超清）见Level定义，对应key参数
    public int videoWidth;      //编码视频宽度
    public int videoHeight;     //编码视频高度
    public int minRate;         //开播码率下限
    public int maxRate;         //开播码率上限
    public int curRate;         //开播初始码率
    public int minFrameRate;    //最小帧率
    public int maxFrameRate;    //最大帧率
    public int frameRate;       //当前设置帧率
    public int cameraWidth = 720;   //摄像头预览宽度
    public int cameraHeight = 1280; //摄像头预览高度
    public int cameraFrameRate;     //摄像头预览帧率
    public VideoEncoderType encodeId;        //开播编码类型
    public String encodeParam;  //开播编码param
    public int playType;            //开播方式
    public int isDefault;       //默认开播
    public int codeRate_trans;   //传输使用
    public String description;  //当前档位描述
    public int intervalSecs;    //分辨率档位变更最小间隔
    public int transcoding;     //转码档位信息

    public List<ResolutionModifyConfig> modifyConfigs;    //动态

    class EncodeType{
        public static final int PHONE_CODEC_HW_H264 = 200; //h264硬编
        public static final int PHONE_CODEC_X264 = 201; //libx264软编
        public static final int PHONE_CODEC_HW_H265 = 220; //h265硬编
        public static final int PHONE_CODEC_X265 = 221; //libx265软编
    }

    class DecodeType{
        public static final int CODEC_DECODEC_H264_HW = 1; //h264硬解
        public static final int CODEC_DECODEC_H264_SOFT = 0; //libx264软解
        public static final int CODEC_DECODEC_H265_NO = 0; //不支持265
        public static final int CODEC_DECODEC_H265_SOFT = 1; //libx265软编
        public static final int CODEC_DECODEC_H265_HW = 2; //265硬解
    }

    class StreamType{
        public static final int STREAM_TYPE_H264 = 1;   //h264
        public static final int STREAM_TYPE_H265 = 2;   //h265
    }

    class Type {
        public static final int SINGLE = 0;             //单人开播
//        public static final int LIANMAI_1st = 1;        //连麦 一麦开播
//        public static final int LIANMAI_2st = 2;        //连麦 二麦开播
        public static final int LIANMAI = 1;              //连麦
        public static final int ACROSS      = 3;        //跨直播间连麦
        public static final int ARENA_CROSS = 4;        //竞技场跨频道直播
        public static final int SCREEN_CAPTURE = 5;     //手游录屏
        public static final int MULIT_LIVE  = 6;        // 多人音视频房主开播
        public static final int MULIT_LIVE_LIANMAI = 7; // 多人音视频连麦开播
        public static final int ONE_TO_ONE  = 8;        //一对一音视频聊天
        public static final int PLAYER_H264     = 9;    //H264硬解观看
        public static final int PLAYER_H265     = 10;   //H265观看
        public static final int BEAUTIFYLEVEL   = 11;   //美颜等级
        public static final int BLACKENCODEC    = 12;   //编码黑名单
        public static final int PLAYTRANSCODING    = 13;   //编码黑名单
        public static final int TOTAL_TYPE  = 14;       //玩法种类
    }


    //观看
    public int decodeType;    //观看解码器类型


    //美颜
    public int beautifyLevel;   //美颜等级


    //编码器黑名单
    String[] blockEncode;

    //多人连麦
    public int minUsers;        //多人连麦当前参数适用的最小用户数
    public int maxUsers;        //多人连麦当前参数适用的最大用户数


    @Override
    public String toString(){
        String tmp = "" +
                "key:" + videoLevel +
                ",width:" + videoWidth +
                ",height:" + videoHeight +
                ",previewWidth:" + cameraWidth +
                ",previewHeight:" + cameraHeight +
                ",previewFrameRate:" + cameraFrameRate +
                ",minRate:" + minRate +
                ",curRate:" + curRate +
                ",maxRate:" + maxRate +
                ",codeRate_trans:" + codeRate_trans +
                ",minFrameRate:" + minFrameRate +
                ",frameRate:" + frameRate +
                ",maxFrameRate:" + maxFrameRate +
                ",beauty_level:" + beautifyLevel +
                ",encode_id:" + encodeId +
                ",encode_param:" + encodeParam +
                ",isDefault:" + isDefault +
                ",playType:" + playType +
				",description:" + description +
                ",decodeType:" + decodeType;
        if(modifyConfigs != null) {
            tmp += ", modifyConfigs[";

            for (int i = 0; i < modifyConfigs.size(); i++) {
                tmp += "width:" + modifyConfigs.get(i).width +
                        ",height:" + modifyConfigs.get(i).height +
                        ",minCodeRate:" + modifyConfigs.get(i).minCodeRate +
                        ",minCodeRate:" + modifyConfigs.get(i).maxCodeRate +
                        ",minFrameRate:" + modifyConfigs.get(i).minFrameRate +
                        ",maxFrameRate:" + modifyConfigs.get(i).maxFrameRate +
                        ",encode_id:" + modifyConfigs.get(i).videoEncoderType +
                        ",encode_param:" + modifyConfigs.get(i).encoderParams;
            }
            tmp += "]";
        }
        return tmp;
    }
}
