package com.yy.yylivesdk4cloud.video.serviceConfig;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;

import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Administrator on 2018/8/13.
 */

public class JsonParseImp implements IJsonParseInterface{
    private final static String TAG = "cfg_JsonParseImp";
    private HandlerThread mProcessJsonParseThread;
    private Handler mProcessJsonParseHandler;
    private IVideoConfigCallbackInterface mCallback;
    private boolean mReady = false;

    private static final int MESSAGE_ENCODECONFIG_SINGLE       = 0;
    private static final int MESSAGE_DECODECONFIG_H264  = 1;
    private static final int MESSAGE_DECODECONFIG_H265  = 2;
    private static final int MESSAGE_WEAKNETWORK        = 3;
    private static final int MESSAGE_BEAUTIFY_LEVEL     = 4;
    private static final int MESSAGE_ENCODECONFIG_LIANMAI       = 5;
    //private static final int MESSAGE_ENCODECONFIG_LIANMAI_1ST       = 5;
    //private static final int MESSAGE_ENCODECONFIG_LIANMAI_2ST       = 6;
    private static final int MESSAGE_ENCODECONFIG_ACROSS            = 7;
    private static final int MESSAGE_ENCODECONFIG_BLOCKENCODE       = 8;
    private static final int MESSAGE_SCREEN_CAPTURE     = 9;
    private static final int MESSAGE_PLAY_TRANSCODING   = 10;
    private int interval = 10;

    public JsonParseImp(IVideoConfigCallbackInterface callback ) {
        mCallback = callback;
        mProcessJsonParseThread = new HandlerThread("JsonParseThread");
        mProcessJsonParseThread.start();
        mProcessJsonParseHandler = new Handler(mProcessJsonParseThread.getLooper()){
            @Override
            public void handleMessage(Message msg) {
                if (!mReady) {
                    YYLiveLog.warn(TAG, " ProcessJsonParseHandler not Ready !");
                    return;
                }

                try {
                    String data = (String) msg.obj;
                    switch (msg.what) {
                        case MESSAGE_ENCODECONFIG_SINGLE:
                            handlderParseVideoEncodeConfig(VideoLiveConfig.Type.SINGLE ,data);
                            break;
                        case MESSAGE_ENCODECONFIG_LIANMAI:
                            handlderParseVideoEncodeConfig(VideoLiveConfig.Type.LIANMAI ,data);
                            break;
//                        case MESSAGE_ENCODECONFIG_LIANMAI_2ST:
//                            handlderParseVideoEncodeConfig(VideoLiveConfig.Type.LIANMAI_2st ,data);
//                            break;
                        case MESSAGE_ENCODECONFIG_ACROSS:
                            handlderParseVideoEncodeConfig(VideoLiveConfig.Type.ACROSS ,data);
                            break;
                        case MESSAGE_DECODECONFIG_H264:
                            handlderParseVideoDecodeH264Config(data);
                            break;
                        case MESSAGE_DECODECONFIG_H265:
                            handlderParseVideoDecodeH265Config(data);
                            break;
                        case MESSAGE_WEAKNETWORK:

                            break;
                        case MESSAGE_BEAUTIFY_LEVEL:
                            handlderParseVideoBeautifyLevelConfig(data);
                            break;
                        case MESSAGE_ENCODECONFIG_BLOCKENCODE:
                            handlderParseVideoBlockEncodeConfig(data);
                            break;
                        case MESSAGE_SCREEN_CAPTURE:
                            handlderParseVideoEncodeConfig(VideoLiveConfig.Type.SCREEN_CAPTURE ,data);
                            break;
                        case MESSAGE_PLAY_TRANSCODING:
                            handlderParseVideoPlatTranscoding(data);
                            break;
                        default:
                            break;
                    }
                }catch (Exception e){
                    YYLiveLog.error(TAG, " mProcessJsonParseHandler deal error :"+ e.toString());
                }
            }
        };
        mReady = true;
    }

    private void handlderParseVideoPlatTranscoding(final String response){
        if(response == null || response.isEmpty()){
            return;
        }
        try {
            HashMap<Integer, Integer> playTranscodingMap =  new HashMap<>();
            JSONObject jsonObject = new JSONObject(response);



            JSONArray jsonArray = jsonObject.names();

            for(int i =0 ;i < jsonArray.length() ; i++){
                Integer key = jsonArray.getInt(i);
                playTranscodingMap.put(key, jsonObject.optInt(key.toString()));
            }


            if(jsonArray == null || jsonArray.length() == 0){
                return;
            }

            if(mCallback != null){
                mCallback.notifyJsonPlayModeMap(playTranscodingMap);
            }else {
                YYLiveLog.error(TAG," handlderParseVideoPlatTranscoding no callback");
            }

        }catch(Exception e){
            YYLiveLog.error(TAG," handlderParseVideoPlatTranscoding error");
        }
    }


    private VideoEncoderType convertEncodeIdToType(int encodeId){
        if(encodeId == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H264){
            return VideoEncoderType.HARD_ENCODER_H264;
        }else if(encodeId == VideoLiveConfig.EncodeType.PHONE_CODEC_X264){
            return VideoEncoderType.SOFT_ENCODER_X264;
        }else if(encodeId == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H265){
            return VideoEncoderType.HARD_ENCODER_H265;
        }else if(encodeId == VideoLiveConfig.EncodeType.PHONE_CODEC_X265){
            return VideoEncoderType.SOFT_ENCODER_H265;
        }else {
            return VideoEncoderType.SOFT_ENCODER_X264;
        }
    }


    private VideoLiveConfig[] getFieldFromJson(final JSONArray jsonArray, final int playType){
        JSONObject item;
        VideoLiveConfig[] configs = new VideoLiveConfig[jsonArray.length()];
        try {
            for (int i = 0; i < jsonArray.length(); i++) {
                VideoLiveConfig config = new VideoLiveConfig();
                item = jsonArray.getJSONObject(i);

                config.playType = playType;
                config.intervalSecs = interval;
                config.videoLevel = item.optInt("key");
                config.isDefault = item.optInt("isDefault");
                config.videoWidth = item.optInt("width");
                config.videoHeight = item.optInt("height");
                config.frameRate = item.optInt("frameRate");
                config.encodeId = convertEncodeIdToType(item.optInt("encode_id"));
                config.encodeParam = item.optString("encode_param");
                config.cameraWidth = item.optInt("previewWidth");
                config.cameraHeight = item.optInt("previewHeight");
                config.cameraFrameRate = item.optInt("previewFrameRate");
                config.codeRate_trans = item.optInt("codeRate") * 1000;
                config.maxRate = item.optInt("maxrate") * 1000;
                config.curRate = item.optInt("currate") * 1000;
                config.minRate = item.optInt("minrate") * 1000;
                config.description = item.optString("description");
                config.transcoding = item.optInt("transcoding");

                //ModifyConfigs
                JSONArray resolutionModifies = item.optJSONArray("modifyConfig");
                if (resolutionModifies != null) {
                    List<ResolutionModifyConfig> modifyconfigs = new ArrayList<>(resolutionModifies.length());
                    for (int j = 0; j < resolutionModifies.length(); j++) {
                        item = resolutionModifies.getJSONObject(j);
                        ResolutionModifyConfig tmp = new ResolutionModifyConfig(item.optInt("width"),
                                item.optInt("height"),
                                item.optInt("minCodeRate") * 1000,
                                item.optInt("maxCodeRate") * 1000,
                                item.optInt("minFrameRate"),
                                item.optInt("maxFrameRate"),
                                convertEncodeIdToType(item.optInt("encode_id")),
                                item.optString("encode_param"));
                        modifyconfigs.add(tmp);
                    }
                    config.modifyConfigs = modifyconfigs;
                }
                configs[i] = config;
            }
        }catch (Exception e){
            YYLiveLog.error(TAG, " getFieldFromJson error :" + e.toString());
            configs = null;
        }
        return configs;
    }

    private void handlderParseVideoBlockEncodeConfig(final String response){
        if(response == null || response.isEmpty()){
            return;
        }
        try {
            VideoLiveConfig[] configs = new VideoLiveConfig[1];
            configs[0] = new VideoLiveConfig();
            configs[0].playType = VideoLiveConfig.Type.BLACKENCODEC;

            JSONObject jsonObject = new JSONObject(response);
            String codeArray = jsonObject.optString("blackCodec");

            if(codeArray == null || codeArray.length() == 0){
                return;
            }
            configs[0].blockEncode = codeArray.split(",");

            if(mCallback != null){
                mCallback.notifyJsonConfigResult(configs);
            }else {
                YYLiveLog.error(TAG," handlderParseVideoBeautifyLevelConfig no callback");
            }

        }catch(Exception e){

        }
    }

    private void handlderParseVideoBeautifyLevelConfig(final String response){
        if(response == null || response.isEmpty()){
            return;
        }
        VideoLiveConfig[] configs = new VideoLiveConfig[1];
        configs[0] = new VideoLiveConfig();
        int beautifyLevel = Integer.parseInt(response);
        configs[0].playType = VideoLiveConfig.Type.BEAUTIFYLEVEL;
        configs[0].beautifyLevel = beautifyLevel;
        if(mCallback != null){
            mCallback.notifyJsonConfigResult(configs);
        }else {
            YYLiveLog.error(TAG," handlderParseVideoBeautifyLevelConfig no callback");
        }
    }

    private void handlderParseVideoEncodeConfig(final int palyType, final String response){
        try {
            JSONObject jsonObject = new JSONObject(response);
            interval = jsonObject.optInt("resolutionModifyInterval") == 0 ? 10 : jsonObject.optInt("resolutionModifyInterval") ;
            JSONArray jsonArray = jsonObject.optJSONArray("resolution2");
            VideoLiveConfig[] configs = getFieldFromJson(jsonArray, palyType);
            if(mCallback != null){
                mCallback.notifyJsonConfigResult(configs);
            }else {
                YYLiveLog.error(TAG," handlderParseVideoEncodeConfig no callback");
            }
        }catch (Exception e){
            YYLiveLog.error(TAG, " handlderParseVideoEncodeConfig :"+ e.toString());
        }
    }

    //0: soft 1:hard
    private void handlderParseVideoDecodeH264Config(final String response){
        if(response == null || response.isEmpty()){
            return;
        }
        VideoLiveConfig[] configs = new VideoLiveConfig[1];
        configs[0] = new VideoLiveConfig();
        int decodeType = Integer.parseInt(response);
        configs[0].playType = VideoLiveConfig.Type.PLAYER_H264;
        configs[0].decodeType = decodeType;
        if(mCallback != null){
            mCallback.notifyJsonConfigResult(configs);
        }else {
            YYLiveLog.error(TAG," handlderParseVideoDecodeH264Config no callback");
        }
    }
    //0: no support 1:soft 2: hard
    private void handlderParseVideoDecodeH265Config(final String response){
        if(response == null || response.isEmpty()){
            return;
        }
        VideoLiveConfig[] configs = new VideoLiveConfig[1];
        configs[0] = new VideoLiveConfig();
        int decodeType = Integer.parseInt(response);
        configs[0].playType = VideoLiveConfig.Type.PLAYER_H265;
        configs[0].decodeType = decodeType;

        if(mCallback != null){
            mCallback.notifyJsonConfigResult(configs);
        }else {
            YYLiveLog.error(TAG," handlderParseVideoDecodeH265Config no callback");
        }
    }


    @Override
    public void parseVideoPlayTranscodingMap(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_PLAY_TRANSCODING;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoBlackEncodeConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_ENCODECONFIG_BLOCKENCODE;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoBeautifyLevelConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_BEAUTIFY_LEVEL;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoEncodeConfigLianMai(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_ENCODECONFIG_LIANMAI;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }

//    @Override
//    public void parseVideoEncodeConfigLianMai2st(String response) {
//        if(mReady){
//            Message msg = Message.obtain();
//            msg.what = MESSAGE_ENCODECONFIG_LIANMAI_2ST;
//            msg.obj = response;
//            mProcessJsonParseHandler.sendMessage(msg);
//        }
//    }

    @Override
    public void parseVideoEncodeConfigAcross(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_ENCODECONFIG_ACROSS;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoEncodeConfigSingle(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_ENCODECONFIG_SINGLE;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoEncodeConfigScreenCapture(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_SCREEN_CAPTURE;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }



    @Override
    public void parseVideoH264DecodeConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_DECODECONFIG_H264;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoH265DecodeConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_DECODECONFIG_H265;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseWeakNetworkConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_WEAKNETWORK;
            msg.obj = response;
            mProcessJsonParseHandler.sendMessage(msg);
        }
    }
}
