package com.yy.yylivesdk4cloud.video;


import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;

import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.PublishVideoConfig;
import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.yylivesdk4cloud.BuildConfig;
import com.yy.yylivesdk4cloud.YYLiveScreenCapture;
import com.yy.yylivesdk4cloud.YYPreviewConfig;
import com.yy.yylivesdk4cloud.YYConstant;
import com.yy.yylivesdk4cloud.YYLiveDefaultCamera;
import com.yy.yylivesdk4cloud.YYLivePlayerView;
import com.yy.yylivesdk4cloud.YYLivePreviewView;
import com.yy.yylivesdk4cloud.YYLivePublisher;
import com.yy.yylivesdk4cloud.YYLiveVideoCapture;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoConfigManager;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.LogRecord;

/**
 * Created by xiaojun on 2018/1/4.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

/* 对应 C++ 代码的 YYVideoEngineImp 类 */
public class YYVideoEngineImp implements IPublishListener, ITextureListener {

    public static final int YYPUBLISH_VIDEO_STATE_NONE = 0;
    public static final int YYPUBLISH_VIDEO_STATE_PREVIEW = 1;
    public static final int YYPUBLISH_VIDEO_STATE_ENCODE = 2;

    HashMap<String, YYLivePlayerView> mVideoViewMap;
    HashMap<String, Long> mVideoViewStreamKeyAndIdMap;
    HashMap<String, Integer> mVideoScaleModeMap;
    private VideoPublish mPublisher = null;
    private long mCallBackPtr = 0;
    private boolean bMixMode = false;
    private YYLiveVideoCapture mCapture;
    private OrangeFilterWrapper mOrangeFilterWrapper;

    private final static int VIDEO_STAT_FPS = 0;
    private final static int VIDEO_STAT_BITRATE = 1;
    private final static int VIDEO_STATE_RESOLUTION = 2;
    private VideoConfigManager mVideoConfigManager;
    private int mVideoPublishState = YYPUBLISH_VIDEO_STATE_NONE;
    private YVideoPublishVideoConfig mCurrentVideoConfig = null;
    private Handler mUiHandler = null;
    private Map<String, WeakReference> mPlayViewAndStreamKeyMap = new HashMap<>();
    private YYVideoPlayListener mYYVideoPlayListener = null;

    public YYVideoEngineImp() {
        //比拉取配置要早,异步检查硬编兼容性
        YYVideoCodec.testVideoEncoderCrash();
    }

    public void init() {
        mVideoViewMap = new HashMap<String, YYLivePlayerView>();
        mVideoScaleModeMap = new HashMap<String, Integer>();
        mVideoViewStreamKeyAndIdMap = new HashMap<String, Long>();
        mPublisher = VideoPublish.getInstance();
        mVideoConfigManager = VideoConfigManager.instance();
        mYYVideoPlayListener = new YYVideoPlayListener(YYVideoLibMgr.instance().getAppContext(), this);
        YYVideoLibMgr.instance().setVideoInfoListener(mYYVideoPlayListener);
        mUiHandler = new android.os.Handler(Looper.getMainLooper());
        YYVideoConfig config = new YYVideoConfig();
        YYVideoSDK.getInstance().enbaleSTLibrary(false);
        config.AsyncLoad();
    }

    public void setPreviewScaleMode(int scaleMode) {
        if (mPublisher != null) {
            mPublisher.setScaleMode(scaleMode);
        }
    }

    public static String getVideoEngineVersion() {
        return "Android: " + BuildConfig.YY_VIDEOLIB_VERSION
                + "&" + BuildConfig.YY_VIDEOPLAYER_VERSION;
    }

    public void updatePlayVideoStream(String streamKey, long streamId, final int streamType, boolean bSoftDecode) {
        YYLiveLog.info(YYLiveLog.kLogTagVideo, "updatePlayVideoStream bSoftDecode ==" + Boolean.toString(bSoftDecode));
        //先拆掉前面的流程,releaseDecoder是传输拆掉，view是在setDecodeType里面拆掉重建
        final YYLivePlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            YYLiveLog.warn(YYLiveLog.kLogTagVideo,
                    "updatePlayVideoStream: cann't find video view for stream:%s",
                    streamKey);
            return;
        }

        long oldStreamId = mVideoViewStreamKeyAndIdMap.get(streamKey) == null ? -1 : mVideoViewStreamKeyAndIdMap.get(streamKey);

        if ((bSoftDecode == true /*&& view.getViewType() != 0*/)) {
            YYLiveLog.info(YYLiveLog.kLogTagVideo, "updatePlayVideoStream bSoftDecode == true, view == hard,need change");
            view.unLinkFromStream(oldStreamId);

            if(Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()){
                view.prepareView(VideoConstant.DecoderType.SOFT_DEOCDER);
            }else {
                //新建程流
                final CountDownLatch barrier = new CountDownLatch(1);
                mUiHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        view.prepareView(VideoConstant.DecoderType.SOFT_DEOCDER);
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                } catch (InterruptedException e) {
                    YYLiveLog.error("YYVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
                }
            }
            YYLiveLog.info(YYLiveLog.kLogTagVideo, "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
            view.linkToStream(streamId);
        } else{
//         if(((mVideoConfigManager.getPlayViewTypeFromStream(streamType) == VideoConstant.DecoderType.SOFT_DEOCDER && view.getViewType() == 0 )||
//                mVideoConfigManager.getPlayViewTypeFromStream(streamType) == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 && view.getViewType() == 1) &&
//                oldStreamId == streamId){
//            YYLiveLog.info(YYLiveLog.kLogTagVideo, "updatePlayVideoStream unchange stream:%s - %d - %d - %d", streamKey, streamId, oldStreamId, streamType);
//            return;
//        }
            YYLiveLog.info(YYLiveLog.kLogTagVideo, "updatePlayVideoStream unlink stream:%s-%d", streamKey, oldStreamId);
            view.unLinkFromStream(oldStreamId);

            //新建流程
            setDecodeType(streamKey, streamType);

            YYLiveLog.info(YYLiveLog.kLogTagVideo, "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
            view.linkToStream(streamId);
        }

        int scaleMode = mVideoScaleModeMap.get(streamKey) == null ? -1 : mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            YYLiveLog.error("YYVideoEngineImp", "updatePlayVideoStream mVideoScaleModeMap can't find scaleMode in map :" + mVideoScaleModeMap.size());
            return;
        }
        view.setScaleMode(scaleMode);
        return;
    }

    public void setLowDelayMode(boolean mode){
        if( mCurrentVideoConfig != null  && mCurrentVideoConfig.bLowLatency != mode ){
            mPublisher.setLowDelayMode(mode);
            mCurrentVideoConfig.bLowLatency = mode;
        }

        YYLiveLog.info("YYVideoEngineImp", "setLowDelayMode new mode " + mode + " old :" + (mCurrentVideoConfig != null ? mCurrentVideoConfig.bLowLatency : "null"));
    }

    public int setDecodeType(String streamKey, final int streamType) {
        final int decodeType = mVideoConfigManager.getPlayViewTypeFromStream(streamType);
        YYLiveLog.info("YYVideoEngineImp", "setDecodeType streamKey " + streamKey + " type:" + streamType);
        if (mVideoConfigManager == null) {
            YYLiveLog.error("YYVideoEngineImp", "setDecodeType mVideoConfigManager == null!");
            return -1;
        }
        int scaleMode = mVideoScaleModeMap.get(streamKey) == null ? -1 : mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            YYLiveLog.error("YYVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find scaleMode in map :" + mVideoScaleModeMap.size());
            return -1;
        }

        final YYLivePlayerView view = mVideoViewMap.get(streamKey);
        if (mVideoViewMap.get(streamKey) == null) {
            YYLiveLog.error("YYVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find view in map :" + mVideoViewMap.size());
            return -1;
        }
        if(Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()){
            view.prepareView(decodeType);
        }else {
            final CountDownLatch barrier = new CountDownLatch(1);
            mUiHandler.post(new Runnable() {
                @Override
                public void run() {
                    view.prepareView(decodeType);
                    barrier.countDown();
                }
            });
            try {
                barrier.await();
            } catch (InterruptedException e) {
                YYLiveLog.error("YYVideoEngineImp", "setDecodeType .barrier.await" + e.toString());
            }

        }
//		if (!bSuccess) {
//			YYLiveLog.error(YYLiveLog.kLogTagVideo,
//					"setDecodeType: prepareView failed for " + streamType + " streamkey:" + streamKey);
//			return ;
//		}
        view.setScaleMode(scaleMode);
        YYLiveLog.info("YYVideoEngineImp", streamKey + " setDecodeType success : scaleMode" + scaleMode + ", decodeType: " + decodeType);

        return (decodeType == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 ? 1 : 0);
    }

    public boolean H265PlaySupport() {
        if (mVideoConfigManager == null) {
            return false;
        }
        YYLiveLog.info("YYVideoEngineImp", "H265PlaySupport " + mVideoConfigManager.H265PlaySupport());
        return mVideoConfigManager.H265PlaySupport();
    }

    public boolean startVideoEngine() {
        return true;
    }

    public int getVideoDecodeTranscoding(int transcoding) {
        if (mVideoConfigManager == null) {
            return transcoding;
        }
        return mVideoConfigManager.getVideoDecodeTranscoding(transcoding);
    }


    public int getVideoEncodeTranscoding(int playType, int mode) {
        if (mVideoConfigManager == null) {
            return mode;
        }
        return mVideoConfigManager.getVideoEncodeTranscoding(playType, mode);
    }

    public boolean stopVideoEngine() {
        return true;
    }

    public void setVideoEngineCallBack(long ptr) {
        mCallBackPtr = ptr;
    }

    private boolean isUsingDefaultCamera() {
        return !bMixMode && (mCapture instanceof YYLiveDefaultCamera);
    }

    public void attachVideoCapture(Object capture) {
        if (mCapture != null) {
            YYLiveLog.info(YYLiveLog.kLogTagVideo, "detach capture: " + mCapture.toString());
            mCapture = null;
        }
        if (capture != null) {
            mCapture = (YYLiveVideoCapture) capture;
            YYLiveLog.info(YYLiveLog.kLogTagVideo, "attach capture: " + mCapture.toString());
        }
    }

    private CameraPreviewConfig getCameraPreviewConfigByType(int playType, int previewMode) {
        CameraPreviewConfig result = mVideoConfigManager.getCameraPreviewConfigByType(playType, previewMode);
        YYLiveLog.info("YYVideoEngineImp", "getCameraPreviewConfigByType:" + result.toString());
        return result;
    }

    private int getBeautyLevelInCurrentConfig() {
        int result = 0;
        if (mVideoConfigManager != null) {
            result = mVideoConfigManager.getCurrentBeautifyLevel();
        }

        YYLiveLog.info("YYVideoEngineImp", "getBeautyLevelInCurrentConfig:" + result);
        return result;
    }

    private VideoEncoderConfig getVideoEncoderConfigByType(int playType, int mode) {
        VideoEncoderConfig result = mVideoConfigManager.getVideoEncodeConfigByType(playType, mode);
        YYLiveLog.info("YYVideoEngineImp", "getVideoEncoderConfigByType:" + result.toString());
        return result;
    }

    private boolean checkLowDelayByType(int playType) {
        return mVideoConfigManager.checkLowDelayByType(playType);
    }

    private CameraPreviewConfig toCamerePreviewConfig(YYPreviewConfig config) {
        CameraPreviewConfig newConf = new CameraPreviewConfig(CameraPreviewConfig.PREVIEW_MODE_NORMAL);
        newConf.mCaptureResolutionWidth = config.captureResolutionWidth;
        newConf.mCaptureResolutionHeight = config.captureResolutionHeight;
        newConf.mCameraPosition = config.cameraPosition;
        newConf.mCaptureFrameRate = config.captureFrameRate;
        newConf.mCaptureOrientation = config.captureOrientation;
        return newConf;
    }

    public YVideoPublishVideoConfig setOrientation(int orientatin) {
        YYLiveLog.info("YYVideoEngineImp", " setOrientation " + orientatin + " mCapture == null ?" +(mCapture == null ? "true" : "false"));
        if (mCapture instanceof YYLiveScreenCapture) {
            YYLiveScreenCapture yyLiveScreenCapture = (YYLiveScreenCapture) mCapture;
            if ((yyLiveScreenCapture.isLandscap() && orientatin != YYConstant.YYPublishOrientation.YYPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) ||
                    (!yyLiveScreenCapture.isLandscap()) && (orientatin != YYConstant.YYPublishOrientation.YYPUBLISH_VIDEO_ORIENTATION_PORTRAIT)) {
                stopEncodeVideo();
                yyLiveScreenCapture.setIslandScape(orientatin == YYConstant.YYPublishOrientation.YYPUBLISH_VIDEO_ORIENTATION_LANDSCAPE);
                startEncodeVideo(mCurrentVideoConfig.bMirrorFrontCamera, mCurrentVideoConfig.bLowLatency, mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);
            }

            return mCurrentVideoConfig;
        } else if(mCapture != null){

            YYLiveDefaultCamera camera = (YYLiveDefaultCamera) mCapture;
            YYPreviewConfig config = (YYPreviewConfig) camera.getCaptureConfig();
            if (orientatin != config.captureOrientation) {
                //横竖屏变换
                config.captureOrientation = orientatin;
                config.captureResolutionWidth = config.captureResolutionWidth + config.captureResolutionHeight;
                config.captureResolutionHeight = config.captureResolutionWidth - config.captureResolutionHeight;
                config.captureResolutionWidth = config.captureResolutionWidth - config.captureResolutionHeight;
                camera.setCaptureConfig(config);
            }

            if (mVideoPublishState == YYPUBLISH_VIDEO_STATE_PREVIEW) {
                mPublisher.updateCameraPreviewParam(toCamerePreviewConfig(config));
            } else if (mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE) {
                stopEncodeVideo();
                mPublisher.updateCameraPreviewParam(toCamerePreviewConfig(config));
                startEncodeVideo(mCurrentVideoConfig.bMirrorFrontCamera, mCurrentVideoConfig.bLowLatency, mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);
            } else {
                YYLiveLog.warn("YYVideoEngineImp", "setOrientation wrong!");
            }

            if (mCurrentVideoConfig != null) {
                mCurrentVideoConfig.orientation = orientatin;
                mCurrentVideoConfig.encodeResolutionWidth = mCurrentVideoConfig.encodeResolutionWidth + mCurrentVideoConfig.encodeResolutionHeight;
                mCurrentVideoConfig.encodeResolutionHeight = mCurrentVideoConfig.encodeResolutionWidth - mCurrentVideoConfig.encodeResolutionHeight;
                mCurrentVideoConfig.encodeResolutionWidth = mCurrentVideoConfig.encodeResolutionWidth - mCurrentVideoConfig.encodeResolutionHeight;
            }

            if (mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE) {
                return mCurrentVideoConfig;
            } else {
                return null;
            }
        }
        return null;
    }

    public int startPreview(Object toView, int playType, int publishMode) {

        if (isUsingDefaultCamera()) {
            YYLiveDefaultCamera camera = (YYLiveDefaultCamera) mCapture;
            YYPreviewConfig config = (YYPreviewConfig) camera.getCaptureConfig();

            mPublisher.setPhonePerformanceLevel(getBeautyLevelInCurrentConfig());

            CameraPreviewConfig newConfig = getCameraPreviewConfigByType(playType, publishMode);
            newConfig.mCameraPosition = ((YYPreviewConfig) camera.getCaptureConfig()).cameraPosition;
            if (config.captureOrientation == YYConstant.YYPublishOrientation.YYPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
                //横屏模式
                if (newConfig.mCaptureResolutionWidth < newConfig.mCaptureResolutionHeight) {
                    int mid = newConfig.mCaptureResolutionWidth;
                    newConfig.mCaptureResolutionWidth = newConfig.mCaptureResolutionHeight;
                    newConfig.mCaptureResolutionHeight = mid;
                }
            }
            mPublisher.startPreviewWithView(((YYLivePreviewView) toView).getSurfaceView(),
                    newConfig, this);

            if (camera.getCameraDataCallback() != null) {
                YYLiveLog.info(YYLiveLog.kLogTagVideo, "setTextureListener %s %s",
                        camera.getCameraDataCallback().toString(), this.toString());
                mPublisher.setTextureListener(this);
            }
            mOrangeFilterWrapper = mPublisher.getOrangeFilterWrapperObject();

            //同步当前camera的config
            config.captureFrameRate = newConfig.mCaptureFrameRate;
            config.captureResolutionHeight = newConfig.mCaptureResolutionHeight;
            config.captureResolutionWidth = newConfig.mCaptureResolutionWidth;
            camera.setCaptureConfig(config);

        } else {
            mCapture.startCapture(new YYLivePublisher.IVideoPublisher() {
                @Override
                public void pushVideoData() {

                }

                @Override
                public void pushVideoData(byte[] encodedData,
                                          YYConstant.YYVideoEncodeType type,
                                          long dts,
                                          long pts) {

                }
            });
        }

        mVideoPublishState = YYPUBLISH_VIDEO_STATE_PREVIEW;
        return 0;
    }

    public int stopPreview() {
        if (isUsingDefaultCamera()) {
            if (mVideoPublishState != YYPUBLISH_VIDEO_STATE_PREVIEW) {
                YYLiveLog.info(YYLiveLog.kLogTagVideo, "stopPreview videoState wrong:" + mVideoPublishState);
            }
            mVideoPublishState = YYPUBLISH_VIDEO_STATE_NONE;
            return mPublisher.stopPreview();
        }
        return -1;
    }

    /**
     * 从配置中心提取配置开播
     *
     * @param bMirrorFrontCamera 镜像
     * @param bLowLatency        低延时
     * @param playType           玩法
     * @param mode               模式
     * @return 实际使用的编码参数
     */
    public YVideoPublishVideoConfig startEncodeVideo(
            boolean bMirrorFrontCamera,
            boolean bLowLatency,
            int playType,
            int mode) {


        VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(playType, mode);
        if (mCapture.getClass() == YYLiveScreenCapture.class && ((YYLiveScreenCapture) mCapture).isLandscap()) {
            int mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;
        } else if (mCapture.getClass() == YYLiveDefaultCamera.class && ((YYPreviewConfig) mCapture.getCaptureConfig()).captureOrientation == YYConstant.YYPublishOrientation.YYPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
            //横屏模式
            if (newEncoderConfig.mEncodeWidth < newEncoderConfig.mEncodeHeight) {
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;
            }
        }

        newEncoderConfig.mLowDelay = checkLowDelayByType(playType);

        YYLiveLog.info(YYLiveLog.kLogTagVideo, "startPublishVideo %dx%d %d %d %s %b %b",
                newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate,
                newEncoderConfig.mEncodeType.name(), bMirrorFrontCamera, newEncoderConfig.mLowDelay );

        mPublisher.enableMirror(bMirrorFrontCamera);
        if (mCapture.getClass() == YYLiveScreenCapture.class) {
            // 录屏
            YYLiveScreenCapture yyLiveScreenCapture = (YYLiveScreenCapture) mCapture;
            mPublisher.initScreenLiveSession(yyLiveScreenCapture.getMediaProjection(), this, yyLiveScreenCapture.isLandscap());
        }

        //设置动态分辨率
        mPublisher.setResolutionModifyConfigs(mVideoConfigManager.getCurrentModifyConfig(), mVideoConfigManager.getCurrentIntervalSecs());

        int ret = mPublisher.startPublishVideo("general", null, newEncoderConfig);

        if (ret == 0) {
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }

            int videoLevel = mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;

            if (mCurrentVideoConfig == null) {
                mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth,
                        newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }

            mCurrentVideoConfig.bLowLatency = newEncoderConfig.mLowDelay ;
            mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
            mCurrentVideoConfig.playType = playType;
            mCurrentVideoConfig.mode = videoLevel;
            mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            mCurrentVideoConfig.bHardwareEncoder = hard;
            mCurrentVideoConfig.encodeType = encodeType;

            mCurrentVideoConfig.orientation = mCurrentVideoConfig.encodeResolutionWidth > mCurrentVideoConfig.encodeResolutionHeight ?
                    YYConstant.YYPublishOrientation.YYPUBLISH_VIDEO_ORIENTATION_LANDSCAPE : YYConstant.YYPublishOrientation.YYPUBLISH_VIDEO_ORIENTATION_PORTRAIT;
        }

        if (mVideoPublishState != YYPUBLISH_VIDEO_STATE_PREVIEW) {
            YYLiveLog.info(YYLiveLog.kLogTagVideo, "startPublishVideo videoState wrong:" + mVideoPublishState);
        }
        mVideoPublishState = YYPUBLISH_VIDEO_STATE_ENCODE;
        return mCurrentVideoConfig;
    }

    public int stopEncodeVideo() {
        mVideoConfigManager.resetCurrentVideoLiveConfig();
        if (mVideoPublishState != YYPUBLISH_VIDEO_STATE_ENCODE) {
            YYLiveLog.info(YYLiveLog.kLogTagVideo, "stopEncodeVideo videoState wrong:" + mVideoPublishState);
        }
        mVideoPublishState = YYPUBLISH_VIDEO_STATE_PREVIEW;
        mPublisher.stopPublishVideo();

        if(mCapture != null) {
            if (mCapture.getClass() == YYLiveScreenCapture.class) {
                mPublisher.deInitScreenLiveSession();
            }
        }
        return 0;
    }


    public void changeScreenLiveMode(boolean pictureMode, Object bitmap) {
        mPublisher.changeScreenLiveMode(pictureMode, (Bitmap) bitmap);
    }

    public int startPlayVideoStream(String streamKey,
                                    Object toView,
                                    int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return -1;
        }
        YYLivePlayerView view = (YYLivePlayerView) toView;
        YYLiveLog.info(YYLiveLog.kLogTagVideo, "startPlayVideoStream " + streamKey + " scaleMode:" + scaleMode);

        mVideoScaleModeMap.put(streamKey, scaleMode);
        mVideoViewMap.put(streamKey, view);
        return 0;
    }

    public int stopPlayVideoStream(String streamKey) {
        final YYLivePlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            return -1;
        }
        YYLiveLog.debug(YYLiveLog.kLogTagVideo, "stopPlayVideoStream" + streamKey);
        view.unLinkFromStream();

        if(Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()){
            view.unPrepareView();
        }else {
            mUiHandler.post(new Runnable() {
                @Override
                public void run() {
                    view.unPrepareView();
                }
            });
        }
        mVideoViewMap.remove(streamKey);
        mVideoViewStreamKeyAndIdMap.remove(streamKey);
        return 0;
    }

    public void setPlayVideoViewScaleMode(Object toView, int scaleMode){
        String streamKey = null;
        if(toView == null) {
            return;
        }
        Set<Map.Entry<String,YYLivePlayerView>> entrySet = mVideoViewMap.entrySet();
        Iterator<Map.Entry<String,YYLivePlayerView>> it = entrySet.iterator();
        while (it.hasNext()){
            Map.Entry<String,YYLivePlayerView> me = it.next();
            if(toView.equals(me.getValue())){
                streamKey = me.getKey();
                mVideoScaleModeMap.put(streamKey, scaleMode);
                me.getValue().setScaleMode(scaleMode);
                return;
            }
        }
        YYLiveLog.warn(YYLiveLog.kLogTagVideo, "setPlayVideoViewScaleMode toView is not found!");
        return;
    }

    public boolean updatePlayVideoView(String streamKey, Object toView, int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return false;
        }

        YYLivePlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            return false;
        }

        if (!view.equals(toView)) {
            YYLiveLog.warn(YYLiveLog.kLogTagVideo, "may toView is change!");
            return false;
        }
        mVideoScaleModeMap.put(streamKey, scaleMode);
        YYLiveLog.debug(YYLiveLog.kLogTagVideo, "update play scale mode: " + scaleMode);
        return view.setScaleMode(scaleMode);
    }


    /**
     * *  更新预览和开播参数,从配置中心中依据playType 和 mode 匹配详细的参数值
     *
     * @param bMirrorFrontCamera 镜像开启
     * @param bLowLatency        低延时
     * @param playType           玩法{@link com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig.Type}
     * @param mode               模式{@link com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig.Level}
     * @return 实际使用的编码参数 {@link YVideoPublishVideoConfig}
     */
    public YVideoPublishVideoConfig updatePublishVideoConfig(
            boolean bMirrorFrontCamera,
            boolean bLowLatency,
            int playType,
            int mode) {
        if (mCurrentVideoConfig == null || playType != mCurrentVideoConfig.playType || mode != mCurrentVideoConfig.mode) {
            VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(playType, mode);
            PublishVideoConfig videoConfig = new PublishVideoConfig();
            videoConfig.assign(newEncoderConfig);

            videoConfig.mLowDelay = checkLowDelayByType(playType);

            if (videoConfig.mLowDelay != bLowLatency) {
                YYLiveLog.info(YYLiveLog.kLogTagVideo, "updatePublishVideoConfig %b :%d", bLowLatency, playType);
            }

            //设置动态分辨率
            mPublisher.setResolutionModifyConfigs(mVideoConfigManager.getCurrentModifyConfig(), mVideoConfigManager.getCurrentIntervalSecs());

            mPublisher.updatePublishVideoConfig(videoConfig);

            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }

            int videoLevel = mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;

            if (mCurrentVideoConfig == null) {
                mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth,
                        newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }

            mCurrentVideoConfig.playType = playType;
            mCurrentVideoConfig.mode = videoLevel;
            mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            mCurrentVideoConfig.bHardwareEncoder = hard;
            mCurrentVideoConfig.encodeType = encodeType;
            if(mCapture!=null) {
                mCurrentVideoConfig.orientation = ((YYPreviewConfig) mCapture.getCaptureConfig()).captureOrientation;
            } else {
                mCurrentVideoConfig.orientation = 0;
            }

            mCurrentVideoConfig.bLowLatency = videoConfig.mLowDelay;
        }

//		if(bLowLatency != mCurrentVideoConfig.bLowLatency){
//			mPublisher.setLowDelayMode(bLowLatency);
//			mCurrentVideoConfig.bLowLatency = bLowLatency;
//		}

        if (bMirrorFrontCamera != mCurrentVideoConfig.bMirrorFrontCamera) {
            mPublisher.enableMirror(bMirrorFrontCamera);
            mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
        }

        return mCurrentVideoConfig;
    }

    public boolean setCameraPosition(int position) {
        ((YYPreviewConfig) mCapture.getCaptureConfig()).cameraPosition = position;
        return mPublisher.setCameraPosition(position);
    }

    public int setPubWatermark(float x, float y, Object image) {
        return mPublisher.setWatermark((Bitmap) image, (int) x, (int) y);
    }

    public int setPubFaceBeautyLevel(float level) {
//		mPublisher.setBeautyParam(level);
        if (mOrangeFilterWrapper != null) {
            mOrangeFilterWrapper.setBeautyParam(level);
        }
        return 0;
    }

    public int onVideoStreamArrive(String streamKey, long streamId) {
        YYLivePlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            YYLiveLog.warn(YYLiveLog.kLogTagVideo,
                    "onVideoStreamArrive: cannot find video view for stream:%s",
                    streamKey);
            return -1;
        }
        YYLiveLog.info(YYLiveLog.kLogTagVideo, "link stream:%s, %d", streamKey, streamId);
        view.linkToStream(streamId);
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback(mYYVideoPlayListener);
        }
        mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
        return 0;
    }

    public int onVideoStreamStop(String streamKey, long streamId) {
        YYLivePlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            YYLiveLog.warn(YYLiveLog.kLogTagVideo,
                    "onVideoStreamStop: cann't find video view for stream:%s",
                    streamKey);
            return -1;
        }
        YYLiveLog.info(YYLiveLog.kLogTagVideo, "unlink stream:%s-%d", streamKey, streamId);
        view.unLinkFromStream(streamId);
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback(null);
        }
        return 0;
    }

    public int onRequestIFrame() {
        mPublisher.requestEncodeIFrame();
        return 0;
    }

    //弱网
    public int onDynamicBitrate(long bitrate) {
        // 传输回调回来的比特率数值单位是 kbps
        mPublisher.setNetworkBitrateSuggest((int) bitrate * 1000);
        return 0;
    }

    /**
     * 获取海度统计数据
     */
    public String getAnchorHiidoStatInfo(long streamId) {
        return VideoDataStat.getInstance().getAnchorVideoData(streamId);
    }

    public String getAudienceHiidoStatInfo(long streamId) {
        return VideoPlayerDataStat.getInstance().getAudienceVideoData(streamId);
    }

    /**
     * 获取视频实时统计数据
     */
    public int getPublishRuntimeInfo(int type) {
        switch (type) {
            case VIDEO_STAT_FPS:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.FRAME);
            case VIDEO_STAT_BITRATE:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.BITRATE);
            case VIDEO_STATE_RESOLUTION:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.RESOLUTION);
        }
        return 0;
    }

    public long getPlayRuntimeInfo(long streamId, int type) {
        switch (type) {
            case VIDEO_STAT_FPS:
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.FRAME);
            case VIDEO_STAT_BITRATE:
                break; // 播放不统计码率
            case VIDEO_STATE_RESOLUTION:
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
        }
        return 0;
    }

    /**
     * 后台配置下发的主播端采集时间戳校正值
     *
     * @param adjustVal
     * @return
     */
    public int setPublisherPtsAdjustVal(int adjustVal) {
        if (mPublisher != null) {
            YYLiveLog.debug(YYLiveLog.kLogTagVideo, "setPublisherPtsAdjustVal " + adjustVal);
            mPublisher.setDeltaYYPtsMillions(adjustVal);
        }
        return 0;
    }

    /**
     * 视频数据回调函数，传回的是编码后的数据
     */
    @Override
    public void onEncodeFrameData(byte[] data,
                                  int len,
                                  long pts,
                                  long dts,
                                  int frameType,
                                  VideoEncoderType encoderType) {
        int encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
        boolean bHardware = false;

        switch (encoderType) {
            case SOFT_ENCODER_X264:
                bHardware = false;
                encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
                break;
            case HARD_ENCODER_H264:
                bHardware = true;
                encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264;
                break;
            case SOFT_ENCODER_H265:
                bHardware = false;
                encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H265;
                break;
            case HARD_ENCODER_H265:
                bHardware = true;
                encodeType = YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H265;
                break;
            case DEFAULT:
            case ERROR:
                YYLiveLog.warn(YYLiveLog.kLogTagVideo, "unknown encoder type" + encoderType.toString());
        }

        if (mCallBackPtr != 0) {
            onVideoEncodedFrame(mCallBackPtr, data, len, pts, dts, frameType, encodeType, bHardware);
        }
    }

    /**
     * 采集回调
     */
    @Override
    public int onTextureCallback(int textureId, int width, int height) {
//		YYLiveLog.info(YYLiveLog.kLogTagVideo, "onTextureCallback %d %dx%d",
//				textureId, width, height);
        if (!isUsingDefaultCamera()) {
            return textureId;
        }
        YYLiveDefaultCamera camera = (YYLiveDefaultCamera) mCapture;
        if (camera.getCameraDataCallback() == null) {
            return textureId;
        }
        return camera.getCameraDataCallback().onTextureCallback(textureId, width, height);
    }

    void onVideoRenderNotify(final ArrayList<VideoRenderNotify> notifications) {
        if (mCallBackPtr != 0) {
            YYLiveNative.onVideoRenderEvent(mCallBackPtr, notifications);
        }
    }

    void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        YYLiveLog.info(YYLiveLog.kLogTagVideo, "onHardwareDecodeErrorNotify %d",
                errorType);
//		if (errorType < 4) { //0 reset_error 1 init_error 2 decoding_error 3 stop_block_error
        YYLiveNative.enableHardwareDecoder(false, YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H264);
        YYLiveNative.enableHardwareDecoder(false, YYConstant.YYVideoEncodeType.YYVIDEO_ENCODE_TYPE_H265);
        if (mVideoConfigManager != null) {
            mVideoConfigManager.disableHardDecode(true);
        }
//		}
    }

    private native void onVideoEncodedFrame(long callback,
                                            byte[] data,
                                            int len,
                                            long pts,
                                            long dts,
                                            int frameType,
                                            int encodeType,
                                            boolean bHardware);

    /**
     * 返回给Jni层当前实际使用的配置
     */
    private static class YVideoPublishVideoConfig {
        int encodeFrameRate;
        int encodeBitrate;
        int encodeResolutionWidth;
        int encodeResolutionHeight;
        int encodeType;
        boolean bHardwareEncoder;
        int mode;
        boolean bMirrorFrontCamera;
        boolean bLowLatency;
        int playType;
        int orientation;

        public YVideoPublishVideoConfig(int encodeFrameRate, int encodeBitrate, int encodeResolutionWidth, int encodeResolutionHeight, int encodeType, boolean bHardwareEncoder, int mode) {
            this.encodeFrameRate = encodeFrameRate;
            this.encodeBitrate = encodeBitrate;
            this.encodeResolutionWidth = encodeResolutionWidth;
            this.encodeResolutionHeight = encodeResolutionHeight;
            this.encodeType = encodeType;
            this.bHardwareEncoder = bHardwareEncoder;
            this.mode = mode;
        }

        @Override
        public String toString() {
            String tmp = "" + this.encodeResolutionWidth +
                    "x" + this.encodeResolutionHeight +
                    "@" + this.encodeFrameRate +
                    " " + this.encodeBitrate +
                    " hard:" + this.bHardwareEncoder +
                    " mode:" + this.mode;
            return tmp;
        }
    }


    public void stopAndRecoverVideoEncode(boolean stop) {
        if (mPublisher != null && mVideoPublishState != YYPUBLISH_VIDEO_STATE_NONE) {
            mPublisher.stopAndRecoverStream(stop);
        }
    }

    public void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec,  int eatenFrames) {
        YYLiveNative.onFirstFrameRenderNotify(userGroupId,streamId,currentSystemMilliSecond,firstFrameToRenderInMilliSec,eatenFrames);
    }

    public void onUpdateVideoSizeChanged(long streamId, int width, int height) {
        YYLiveNative.onUpdateVideoSizeChanged(streamId,width,height);
    }
}
