package com.yy.yylivesdk4cloud.helper;


import com.yy.yylivesdk4cloud.YYConstant;

import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_DEBUG;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_ERROR;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_INFO;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_RELEASE;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_TRACE;
import static com.yy.yylivesdk4cloud.YYConstant.YYLogLevel.YYLOG_LEVEL_WARN;

/**
 * Created by xiaojun on 2017/11/23.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class YYLiveLog {

	public static final class YYLogModule {
		public static final int YYLOG_MODULE_UNKNOWN = 0;
		public static final int YYLOG_MODULE_PLATFORM = 100;
		public static final int YYLOG_MODULE_AUDIO = 101;
		public static final int YYLOG_MODULE_VIDEO = 102;
		public static final int YYLOG_MODULE_TRANS = 103;
	}

	public static final String kLogTagRtcEngine = "yrtc";
	public static final String kLogTagCall = "ycall-Java";
	public static final String kLogTagCallback = "ycallback-Java";
	public static final String kLogTagVideo = "yvideo-Java";
	public static final String kLogTagSdk = "ysdk-Java";

	public static void trace(String tag, String format, Object... args) {
		String text = String.format(format, args);
		logM(YYLOG_LEVEL_TRACE, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void trace(String tag, String text) {
		logM(YYLOG_LEVEL_TRACE, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void debug(String tag, String format, Object... args) {
		String text = String.format(format, args);
		logM(YYLOG_LEVEL_DEBUG, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void debug(String tag, String text) {
		logM(YYLOG_LEVEL_DEBUG, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void info(String tag, String format, Object... args) {
		String text = String.format(format, args);
		logM(YYLOG_LEVEL_INFO, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void info(String tag, String text) {
		logM(YYLOG_LEVEL_INFO, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void warn(String tag, String format, Object... args) {
		String text = String.format(format, args);
		logM(YYLOG_LEVEL_WARN, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void warn(String tag, String text) {
		logM(YYLOG_LEVEL_WARN, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void error(String tag, String format, Object... args) {
		String text = String.format(format, args);
		logM(YYLOG_LEVEL_ERROR, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void error(String tag, String text) {
		logM(YYLOG_LEVEL_ERROR, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void release(String tag, String format, Object... args) {
		String text = String.format(format, args);
		logM(YYLOG_LEVEL_RELEASE, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void release(String tag, String text) {
		logM(YYLOG_LEVEL_RELEASE, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
	}

	public static void logM(int level, int module, String tag, String text) {
		YYLiveNative.logText(level, module, tag, text);
	}
}
