package com.yy.yylivesdk4cloud.helper;

import com.yy.yylivesdk4cloud.YYLiveAPI;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * 使用https协议发起请求
 * 注意！勿在main thread内发起网络连接
 * @author  dw_yangqiao
 */
public class YYLiveHttpsRequestHandler {
	private final static String TAG = "HttpsRequestHandler";
	private final static int ERR_NONE = 0;
	private final static int ERR_MALFORMED_URL = 10;
	// indicate that there is an error in the underlying protocol, such as a TCP error
	private final static int ERR_PROTOCOL = 11;
	// I/O exception
	private final static int ERR_IOEXCEPTION = 12;

	public YYLiveHttpsRequestHandler() {
	}

	public void send(final String reqUrl, final int target) {
		new Thread(new Runnable() {
			@Override
			public void run() {
				YYLiveLog.info(TAG, "fetching...");
				HttpsURLConnection connection = null;
				try {
					URL url = new URL(reqUrl);
					connection = (HttpsURLConnection) url.openConnection();
					//设置请求方法
					connection.setRequestMethod("GET");
					//设置连接超时时间（毫秒）
					connection.setConnectTimeout(5000);
					//设置读取超时时间（毫秒）
					connection.setReadTimeout(5000);

					int statusCode = connection.getResponseCode();// 调用此方法就不必再使用conn.connect()方法
					if (statusCode == 200) {
						onHttpsResponse(connection, reqUrl, statusCode, target);
					} else {
						// https connection没有问题，但拿不到我们想要的结果，也认为是失败
						onHttpsFailed(reqUrl, statusCode, ERR_NONE, target);
					}
				} catch (MalformedURLException e) {
					onHttpsFailed(reqUrl, 0, ERR_MALFORMED_URL, target);
					e.printStackTrace();
				} catch (ProtocolException e) {
					onHttpsFailed(reqUrl, 0, ERR_PROTOCOL, target);
					e.printStackTrace();
				} catch (IOException e) {
					onHttpsFailed(reqUrl, 0, ERR_IOEXCEPTION, target);
					e.printStackTrace();
				} finally {
					if (connection != null) {//关闭连接
						connection.disconnect();
					}
				}
			}
		}).start();
	}

	private void onHttpsResponse(HttpsURLConnection connection,
								 String reqUrl,
								 int statusCode,
								 int target) {
		String contentType = connection.getContentType();
		int contentLength = connection.getContentLength();
		YYLiveLog.info(TAG, "contentType=" + contentType + " contentLength=" + contentLength);
		if (contentType.indexOf("text") != -1) { //text
			try {
				StringBuffer sb = new StringBuffer();
				String line;
				BufferedReader responseReader =
						new BufferedReader(new InputStreamReader(connection.getInputStream()));
				// 处理响应流，必须与服务器响应流输出的编码一致
				while (null != (line = responseReader.readLine())) {
					sb.append(line);
				}
				responseReader.close();
				YYLiveAPI.sharedInstance().setHttpsTextResponse(reqUrl, sb.toString(),
						statusCode, ERR_NONE, target);
			} catch (IOException e) {
				// 读取时发生io异常，statuscode重置为0
				onHttpsFailed(reqUrl,0, ERR_IOEXCEPTION, target);
			}
		} else { //binary
			try {
				InputStream is = connection.getInputStream();
				ByteArrayOutputStream os = new ByteArrayOutputStream();
				byte[] buffer = new byte[contentLength];
				int len = -1;
				while ((len = is.read(buffer)) != -1) {
					os.write(buffer, 0, len);
				}
				is.close();
				os.close();
				YYLiveAPI.sharedInstance().setHttpsBinaryResponse(reqUrl, os.toByteArray(),
						statusCode, ERR_NONE, target);
			} catch (IOException e) {
				// 读取时发生io异常，statuscode重置为0
				onHttpsFailed(reqUrl,0, ERR_IOEXCEPTION, target);
			}
		}
	}

	private void onHttpsFailed(String reqUrl,
							   int statusCode,
							   int errCode,
							   int target) {
		YYLiveLog.warn(TAG, "onHttpsFailed statusCode=" + statusCode + " errCode=" + errCode
			+ " target=" + target);
		YYLiveAPI.sharedInstance().setHttpsTextResponse(reqUrl, "", statusCode, errCode, target);
	}
}
