package com.yy.yylivesdk4cloud.audio;

import com.yy.yylivesdk4cloud.YYConstant;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;

public class YYAudioEngineImp {
    private AudioEncodeConfig m_currentEncodeCofig = null;
    private AudioPrePConfig m_currentPrePConfig = null;

    public void init() {
    }

    private AudioEncodeConfig getAudioCodecConfigByType(int type) {
        AudioCodecConfig config = AudioConfigManager.instance().getAudioCodecConfigByType(type);
        if (config != null) {
            m_currentEncodeCofig = new AudioEncodeConfig(config.codecId, config.bitRate, config.sampleRate, config.channels);
            YYLiveLog.info("YYAudioEngineImp", " getAudioCodecConfigByType :" + m_currentEncodeCofig.toString());
            return m_currentEncodeCofig;
        }
        return null;
    }

    private AudioPrePConfig getAudioPreProcConfigByType(int type) {
        AudioPreProcConfig config = AudioConfigManager.instance().getAudioPreProcConfigByType(type);
        if (config != null) {
            m_currentPrePConfig = new AudioPrePConfig(config.sceneId, config.aec, config.agc, config.vad);
            YYLiveLog.info("YYAudioEngineImp", " getAudioPreProcConfigByType :" + m_currentPrePConfig.toString());
            return m_currentPrePConfig;
        }
        return null;
    }

    private static class AudioEncodeConfig {
        int codecId;
        int bitRate;
        int sampleRate;
        int channels;

        public AudioEncodeConfig(int id, int bitRate, int sampleRate, int channels) {
            this.codecId = id;
            this.bitRate = bitRate;
            this.sampleRate = sampleRate;
            this.channels = channels;
        }
        @Override
        public String toString() {
            String tmp = "AudioEncodeConfig:" + "["+"codecId:" + codecId +
                    ",bitRate:" + bitRate +
                    ",sampleRate:" + sampleRate +
                    ",channels:" + channels + "]";
            return tmp;
        }
    }

    private static class AudioPrePConfig {
        int sceneId;
        int aec;
        int agc;
        int vad;

        public AudioPrePConfig(int id, int aec, int agc, int vad) {
            this.sceneId = id;
            this.aec = aec;
            this.agc = agc;
            this.vad = vad;
        }
        @Override
        public String toString() {
            String tmp = "AudioPrePConfig:" + "["+"sceneId:" + sceneId +
                    ",aec:" + aec +
                    ",agc:" + agc +
                    ",vad:" + vad + "]";
            return tmp;
        }
    }
}
