package com.yy.yylivesdk4cloud;

import android.media.projection.MediaProjection;
import android.provider.MediaStore;

import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

/**
 * Created by jping on 2018/6/14.
 */
public class YYLiveScreenCapture extends YYLiveDefaultCamera {

    private MediaProjection mediaProjection;
    private boolean islandScape;

    public YYLiveScreenCapture(MediaProjection mediaProjection, boolean islandScape)
    {
        this.mediaProjection = mediaProjection;
        this.islandScape = islandScape;
    }

    public MediaProjection getMediaProjection() {
        return mediaProjection;
    }

    public boolean isLandscap() {
        return islandScape;
    }

    public void setIslandScape(boolean islandScape) {
        this.islandScape = islandScape;
    }

    /**
     * 切换录屏的状态到picture模式
     * @param bPicMode true:进入picture模式 带上bitmap， false：通话结束，不带bitmap
     * @param bitmap 图片对象
     */
    public void changeScreenLiveMode(boolean bPicMode, Object bitmap) {
        YYLiveLog.info(YYLiveLog.kLogTagCall, "changeScreenLiveMode %b", bPicMode);
        YYLiveNative.changeScreenLiveMode(bPicMode, bitmap);
    }

    @Override
    public void startCapture(YYLivePublisher.IVideoPublisher publisher) {
        super.startCapture(publisher);
    }

    @Override
    public void stopCapture() {
        super.stopCapture();
    }

    @Override
    public YYVideoCaptureConfig getCaptureConfig() {
        return super.getCaptureConfig();
    }
}
