package com.yy.yylivesdk4cloud;

public final class YYLiveRtcConstant {
    public YYLiveRtcConstant(){
    }

    public static final class ChannelProfile{
        public static final int YR_ChannelProfile_Live              = 0; //直播 （音质高、交互模式无）（连麦时切换到音质中、交互模式强）
        public static final int YR_ChannelProfile_Communication     = 1; //通信 （音质中、交互模式强）
        public static final int YR_ChannelProfile_Game              = 3; //游戏 （音质低、交互模式强）
        public static final int YR_ChannelProfile_MultiAudioRoom    = 4; //多人语音房间 （音质中、省流量、交互模式强）

        public ChannelProfile(){
        }
    }

    public static final class AudioProfile{
        public static final int YR_AUDIO_PROFILE_DEFAULT                   = 0; //默认设置。通信模式下为 1，直播模式下为 2
        public static final int YR_AUDIO_PROFILE_SPEECH_STANDARD           = 1; //指定 16 KHz采样率，语音编码, 单声道，编码码率约 18 kbps, SILK
        public static final int YR_AUDIO_PROFILE_MUSIC_STANDARD_STEREO     = 2; //指定 44.1 KHz采样率，音乐编码, 双声道，编码码率约 24 kbps，编码延迟高,EAAC+
        public static final int YR_AUDIO_PROFILE_MUSIC_STANDARD            = 3; //指定 44.1 KHz采样率，音乐编码, 双声道，编码码率约 40 kbps，编码延迟低,ELD AAC
        public static final int YR_AUDIO_PROFILE_MUSIC_HIGH_QUALITY_STEREO = 4; //指定 44.1KHz采样率，音乐编码, 双声道，编码码率约 128kbps,AAC LC
        public static final int YR_AUDIO_PROFILE_MUSIC_HIGH_QUALITY_STEREO_192 = 5; //指定 44.1KHz采样率，音乐编码, 双声道，编码码率约 192kbps
    }

    public static final class CommutMode {
        public static final int YR_COMMUT_MODE_DEFAULT = 0; //默认=1
        public static final int YR_COMMUT_MODE_HIGH    = 1; //强交互模式
        public static final int YR_COMMUT_MODE_LOW     = 2; //弱交互模式
    }



    public static final class ScenarioMode {
        public static final int YR_SCENARIO_MODE_DEFAULT = 0; //默认=1
        public static final int YR_SCENARIO_MODE_STABLE_FIRST = 1; //流畅优先：推荐注重稳定的教育
        public static final int YR_SCENARIO_MODE_QUALITY_FIRST = 2; //音质优先：推荐很少或者不连麦的秀场
    }



    public static final class LogLevel {
        public static final int YR_LOG_LEVEL_TRACE = 0;
        public static final int YR_LOG_LEVEL_DEBUG = 1;
        public static final int YR_LOG_LEVEL_INFO = 2;
        public static final int YR_LOG_LEVEL_WARN = 3;
        public static final int YR_LOG_LEVEL_ERROR = 4;

        public LogLevel() {
        }
    }

    public static final class AreaType{
        public static final int YR_AREA_DEFAULT   = 0; //默认值(国内)
        public static final int YR_AREA_FOREIGN	= 1; //国外
        public static final int YR_AREA_RESERVED = 2; //yy-reserved
    }

    public static final class AuthResult{
        public static final int YR_AUTHRES_SUCCUSS             = 0;     //鉴权成功
        public static final int YR_AUTHRES_ERR_SERVER_INTERNAL = 10000; //服务器内部错误，可以重试
        public static final int YR_AUTHRES_ERR_NO_TOKEN        = 10001; //没有带token，需要调用[YYLiveAPI updateToken:]
        public static final int YR_AUTHRES_ERR_TOKEN_ERR       = 10002; //token校验失败（数字签名不对），可能使用的appSecret不对
        public static final int YR_AUTHRES_ERR_APPID           = 10003; //token中appid跟鉴权时带的appid不一致
        public static final int YR_AUTHRES_ERR_UID             = 10004; //token中uid跟鉴权时带的uid不一致
        public static final int YR_AUTHRES_ERR_TOKEN_EXPIRE    = 10005; //token已过期
        public static final int YR_AUTHRES_ERR_NO_APP          = 10006; //app不存在，没有在管理后台注册
    }

    public static final class PublishMode{
        public static final int YR_PUBLISH_MODE_MIC              = 0; //麦克风
        public static final int YR_PUBLISH_MODE_FILE             = 1; //文件
        public static final int YR_PUBLISH_MODE_MIX              = 2; //文件+麦克风
        public static final int YR_PUBLISH_MODE_NONE             = 10; // 停止所有音频数据上行
        public PublishMode(){
        }
    }

    public static final class SoundEffectMode{
        public static final int YR_SOUND_EFFECT_MODE_NONE                 = 0; //关闭模式
        public static final int YR_SOUND_EFFECT_MODE_VALLEY              = 1; //VALLEY模式
        public static final int YR_SOUND_EFFECT_MODE_RANDB               = 2; //R&B模式
        public static final int YR_SOUND_EFFECT_MODE_KTV                  = 3; //KTV模式
        public static final int YR_SOUND_EFFECT_MODE_CHARMING            = 4; // CHARMING模式
        public SoundEffectMode(){
        }
    }
	
	 public static final class AudioSaverMode{
        public static final int YR_AUDIO_SAVER_ONLY_CAPTURE      = 0; //只保存频道内所有的上行的音频数据。上行的音频数据指的是：无论是主播的音频数据还是是伴奏的音频数据，只有被设置成上行，才被保存
        public static final int YR_AUDIO_SAVER_ONLY_RENDER       = 1; //保存除主播以外的音频数据，例如伴奏的音频数据和观众端的音频数据
        public static final int YR_AUDIO_SAVER_BOTH                = 2; //保存所有的音频数据

        public AudioSaverMode(){
        }
    }

    public static final class AudioSaverWfMode{
        public static final int YR_AUDIO_SAVER_FILE_APPEND        = 0; //追加打开一个文本文件，并在文件末尾写数据
        public static final int YR_AUDIO_SAVER_FILE_OVERRIDE      = 1; //打开一个文本文件，写入的数据会覆盖文件本身的内容

        public AudioSaverWfMode(){
        }
    }

    public static final class YYLiveAudioRawFrameOperationMode {

        public static final int YR_AUDIO_RAW_FRAME_OPERATION_MODE_READ_ONLY = 1;  //只读模式，用户仅从 AudioFrame 获取原始音频数据
        public static final int YR_AUDIO_RAW_FRAME_OPERATION_MODE_WRITE_ONLY = 2; //只写模式，用户替换 AudioFrame 中的数据以供 Thunder SDK 编码传输
        public static final int YR_AUDIO_RAW_FRAME_OPERATION_MODE_READ_WRITE = 3; //读写模式，用户从 AudioFrame 获取并修改数据，并返回给 Thunder SDK 进行编码传输

        public YYLiveAudioRawFrameOperationMode() {

        }
    }
}