package com.yy.yylivesdk4cloud;

import android.graphics.Bitmap;
import android.graphics.Rect;

import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by aoe on 2018/12/19.
 */

 class YYLivePublishChannelImp implements YYLivePublishChannel {
    private YYLiveVideoCapture mVideoCapture = null;
    private YYLiveAudioCapture mAudioCapture = null;
    private YYLiveDefaultCamera mDefaultCamera = new YYLiveDefaultCamera();
    private YYLiveDefaultMic mDefaultMic = new YYLiveDefaultMic();

    private String mChannelId = null;
    private String mUidString = null;
    private long mUid = 0;
    private boolean mOwner = false;
    private boolean mPublishing = false;
    private boolean mAudioOnly = false;
    private boolean mEnableVideo = false;
    private boolean mEnableAudio = false;
    private int mPublishMode = YYConstant.YYPublishVideoMode.YYPUBLISH_VIDEO_MODE_DEFAULT;
    private int mPlayType = YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SINGLE;
    private int mCamaraPosition = YYConstant.YYCameraPosition.YYCAMERA_POSITION_FRONT;
    private int mPubOrientation = YYConstant.YYPublishOrientation.YYPUBLISH_VIDEO_ORIENTATION_PORTRAIT;

    private int mChannelProfile = YYLiveRtcConstant.ChannelProfile.YR_ChannelProfile_Live;
    private int mAudioProfile = YYLiveRtcConstant.AudioProfile.YR_AUDIO_PROFILE_DEFAULT;
    private int mCommunitMode = YYLiveRtcConstant.CommutMode.YR_COMMUT_MODE_DEFAULT;
    private int mScenarioMode = YYLiveRtcConstant.ScenarioMode.YR_SCENARIO_MODE_DEFAULT;


    public int startPreview(Object view, int playType, int publishMode) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        mPlayType = playType;
        mPublishMode = publishMode;

        if (mVideoCapture == null) {
            this.attachVideoCapture(mDefaultCamera);
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "startPreview view:%s", view.toString());
        int convertType = convertPlayType(playType);
        return YYLiveNative.startVideoPreview(view, convertType, publishMode);
    }


    public int stopPreview() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "stopVideoPreview");
        return YYLiveNative.stopVideoPreview();
    }

    public int startLiveInteract(YYLiveLayout layout) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "startLiveInteract channelId null");
            return -1;
        }
        if (layout == null) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "startLiveInteract layout error");
            return -1;
        }
        if (layout.layouts.size() == 0 || layout.speakers.size() == 0) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "startLiveInteract param error");
            return -1;
        }

        mAudioOnly = false;
        mPlayType = YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_INTERACT;
        YYPublishVideoConfig videoConfig = convertVideoConfig();
        YYPublishAudioConfig audioConfig = convertAudioConfig();
        if (layout.layouts.size() == 1) { //同频道
            YYLiveChannelLayout channelLayout = layout.layouts.get(0);
            if (mPublishing) {
                YYLiveNative.updatePublishLive(channelLayout.channelId, true,  videoConfig, audioConfig, layout);
            } else {
                mPublishing = true;
                if (mAudioCapture == null) {
                    YYLiveNative.attachAudioCapture(mDefaultMic);
                }
                YYLiveNative.startPublishLive(channelLayout.channelId, true, videoConfig, audioConfig, layout);
            }
            mOwner = channelLayout.owner;
        }else { //跨频道
            for (YYLiveChannelLayout channelLayout : layout.layouts) {
                YYLiveLayout liveLayout = convertLayout(layout, channelLayout);
                YYLiveNative.updatePublishLive(channelLayout.channelId, false, videoConfig, audioConfig, liveLayout);
            }
            mOwner = true;
        }

        YYLiveLog.info(YYLiveLog.kLogTagCall, "startLiveInteract %s", layout.toString());
        return 0;
    }

    public int stopLiveInteract() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        YYLiveLog.info(YYLiveLog.kLogTagCall, "stopLiveInteract %b", mOwner);
        if (mOwner) {
            mAudioOnly = false;
            mPlayType = YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SINGLE;
            YYPublishVideoConfig videoConfig = convertVideoConfig();
            YYPublishAudioConfig audioConfig = convertAudioConfig();
            YYLiveLayout layout = makeLayout(null);
            return YYLiveNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }else {
            return stopSinglePublish();
        }
    }

    public int startAudioInteract(ArrayList<String> speakers) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "startAudioInteract channelId null");
            return -1;
        }
        if (speakers == null) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "startAudioInteract speakers error");
            return -1;
        }
        mAudioOnly = true;
        mPlayType = YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SINGLE;
        YYPublishVideoConfig videoConfig = convertVideoConfig();
        YYPublishAudioConfig audioConfig = convertAudioConfig();
        YYLiveLayout layout = makeLayout(speakers);
        if (mPublishing) {
            YYLiveNative.updatePublishLive(mChannelId, true,  videoConfig, audioConfig, layout);
        } else {
            mPublishing = true;
            if (mAudioCapture == null) {
                YYLiveNative.attachAudioCapture(mDefaultMic);
            }
            videoConfig.encodeResolutionHeight = 0;
            videoConfig.encodeResolutionWidth = 0;
            YYLiveNative.startPublishLive(mChannelId, true, videoConfig, audioConfig, layout);
        }
        YYLiveChannelLayout channelLayout = layout.getChannelLayout(0);
        mOwner = channelLayout.owner;

        YYLiveLog.info(YYLiveLog.kLogTagCall, "startAudioInteract %s", layout.toString());
        return 0;
    }

    public int stopAudioInteract() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        YYLiveLog.info(YYLiveLog.kLogTagCall, "stopAudioInteract %b", mOwner);
        if (mOwner) {
            mAudioOnly = false;
            mPlayType = YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SINGLE;
            YYPublishVideoConfig videoConfig = convertVideoConfig();
            YYPublishAudioConfig audioConfig = convertAudioConfig();
            YYLiveLayout layout = makeLayout(null);
            return YYLiveNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }else {
            return stopSinglePublish();
        }
    }

    public int startSinglePublish(int playType, int publishMode) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "startPublish channelId null");
            return -1;
        }

        mPlayType = playType;
        mPublishMode = publishMode;
        mPublishing = true;
        mAudioOnly = false;
        mOwner = true;

        if (mAudioCapture == null) {
            YYLiveNative.attachAudioCapture(mDefaultMic);
        }

        YYPublishVideoConfig videoConfig = convertVideoConfig();
        YYPublishAudioConfig audioConfig = convertAudioConfig();
        YYLiveLayout layout = makeLayout(null);

        YYLiveLog.info(YYLiveLog.kLogTagCall, "startPublish %s", layout.toString());
        return YYLiveNative.startPublishLive(mChannelId, false, videoConfig, audioConfig, layout);
    }

    public int stopSinglePublish() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "stopPublish %s", mChannelId);
        if (mChannelId == null) {
            return 0;
        }

        mPublishing = false;
        mOwner = false;
        mAudioOnly = false;
        return YYLiveNative.stopPublishLive(mChannelId);
    }

    public int updatePublishMode(int publishMode) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        if (mPublishMode == publishMode) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "updatePublishMode ignore same");
            return 0;
        }
        if (!mPublishing) {
            mPublishMode = publishMode;
            YYLiveLog.info(YYLiveLog.kLogTagCall, "updatePublishMode not publishing");
            return 0;
        }

        boolean bSuport = false;
        int convertType = convertPlayType(mPlayType);
        HashMap<Integer, String> modeMap = YYLiveNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "updatePublishMode empty");
            return -1;
        }
        for (Integer key : modeMap.keySet()) {
            if (key == publishMode) {
                bSuport = true;
                break;
            }
        }
        if (bSuport) {
            mPublishMode = publishMode;
            YYPublishVideoConfig videoConfig = convertVideoConfig();
            if (mPlayType == YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_INTERACT) {
                YYLiveNative.updateVideoConfig(videoConfig);
                return 0;
            }
            YYPublishAudioConfig audioConfig = convertAudioConfig();
            YYLiveLayout layout = makeLayout(null);
            YYLiveNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "updatePublishMode %d %b", publishMode, bSuport);
        return 0;
    }

    public HashMap<Integer, String> getPublishMode(int playType) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return null;
        }

        int convertType = convertPlayType(playType);
        return YYLiveNative.getSupportModeInfoWithPlayType(convertType);
    }

    public int getDefaultPublishMode(int playType){
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        int convertType = convertPlayType(playType);
        return YYLiveNative.getDefaultPublishVideoMode(convertType);
    }

    public YYPublishInfo getCurrentPublishInfo() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return null;
        }
        YYPublishInfo publishInfo = YYLiveNative.getPublishInfo();

        if (publishInfo != null) {
            publishInfo.publishOrientation = mPubOrientation;
            publishInfo.cameraPosition = mCamaraPosition;
        }
        return publishInfo;
    }

    public boolean setCameraPosition(int position) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return false;
        }
        mCamaraPosition = position;
        YYLiveLog.info(YYLiveLog.kLogTagCall, "setCameraPosition %d", position);
        return YYLiveNative.setCameraPosition(position);
    }

    public void setPublishOrientation(int orientation){
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return;
        }
        mPubOrientation = orientation;
        YYLiveNative.setOrientation(orientation);
    }

    public int setWatermark(int posX, int posY, Bitmap image) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        if (image == null) {
            return -1;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "setWatermark in (%d,%d)", posX, posY);
        return YYLiveNative.setWatermark(posX, posY, image);
    }

    public int setFaceBeautyLevel(float level) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        // float保证六位有效数字
        if (level >= 1.000001f) {
            level = 1.0f;
        } else if (level < 0.000001f) {
            level = 0.0f;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "setFaceBeautyLevel %f", level);
        return YYLiveNative.setFaceBeautyLevel(level);
    }

    public boolean setMicVolume(int volume) {
        if (volume < 0) {
            volume  = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "setMicVolume %d", volume);

        return YYLiveNative.setMicVolume(volume);
    }

    public OrangeFilterWrapper getBeautyFilter(){
        return YYLiveBridgeLib.getInstance().getBeautyFilter();
    }

    public YYLiveDefaultMic getDefaluteMic() {
        if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
            return null;
        }
        return mDefaultMic;
    }

    public void attachAudioCapture(YYLiveAudioCapture capture) {
        if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
            return;
        }
        if (capture == null) {
            mAudioCapture = mDefaultMic;
        } else {
            mAudioCapture = capture;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "attachAudioCapture %s", mAudioCapture.toString());
        YYLiveNative.attachAudioCapture(mAudioCapture);

    }

    public void attachVideoCapture(YYLiveVideoCapture capture) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return;
        }
        if (capture == null) {
            mVideoCapture = mDefaultCamera;
        } else {
            mVideoCapture = capture;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "attachVideoCapture %s", mVideoCapture.toString());
        YYLiveNative.attachVideoCapture(mVideoCapture);
    }

    public void syncUserInfo(String channelId, String uid, boolean is32Bit, int userRole) {
        mChannelId = channelId;
        mUidString = uid;
        if (is32Bit) {
            if (uid == null) {
                mUid = 0;
            }else {
                mUid = Long.parseLong(uid);
            }
        }
    }

    public void updateProfile(int channelProfile, int audioProfile,
                              int commutMode, int scenarioMode) {
        mChannelProfile = channelProfile;
        mAudioProfile =audioProfile;
        mCommunitMode = commutMode;
        mScenarioMode = scenarioMode;
    }

    @Override
    public int startCapture() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return -1;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "start capture");
        return YYLiveNative.startCapture();
    }

    @Override
    public int stopCapture() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return -1;
        }
        YYLiveLog.info(YYLiveLog.kLogTagCall, "stop capture");
        return YYLiveNative.stopCapture();
    }

    private YYPublishVideoConfig convertVideoConfig() {
        int convertType = convertPlayType(mPlayType);
        YYPublishVideoConfig config = YYLiveNative.getRemoteVideoConfig(convertType, mPublishMode);
        return config;
    }

    private YYPublishAudioConfig convertAudioConfig() {
        YYPublishAudioConfig config = new YYPublishAudioConfig(YYPublishAudioConfig.YYPUBLISH_AUDIO_MODE_NORMALDELAY_NORMALFLOW_HIGHQUALITY_BROADCAST);
        config.bUseAudioProfile = true;


        //业务（如：hamo）侧未调用setAudioProfile接口，则使用代码中hardcode的
        if ((mAudioProfile == YYLiveRtcConstant.AudioProfile.YR_AUDIO_PROFILE_DEFAULT) &&
                (mCommunitMode == YYLiveRtcConstant.CommutMode.YR_COMMUT_MODE_DEFAULT) &&
                (mScenarioMode == YYLiveRtcConstant.ScenarioMode.YR_SCENARIO_MODE_DEFAULT)) {

            if (mPlayType == YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SINGLE ||
                    mPlayType == YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SCREENCAP) {
                config.audioProfile = YYLiveRtcConstant.AudioProfile.YR_AUDIO_PROFILE_MUSIC_STANDARD;
                config.commutMode = YYLiveRtcConstant.CommutMode.YR_COMMUT_MODE_LOW;
                config.scenarioMode = YYLiveRtcConstant.ScenarioMode.YR_SCENARIO_MODE_QUALITY_FIRST;
            }else  if (mPlayType == YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_INTERACT) {
                config.audioProfile = YYLiveRtcConstant.AudioProfile.YR_AUDIO_PROFILE_MUSIC_STANDARD;
                config.commutMode = YYLiveRtcConstant.CommutMode.YR_COMMUT_MODE_HIGH;
                config.scenarioMode = YYLiveRtcConstant.ScenarioMode.YR_SCENARIO_MODE_STABLE_FIRST;
            }
        } else {
            config.audioProfile = mAudioProfile;
            config.commutMode = mCommunitMode;
            config.scenarioMode = mScenarioMode;
        }

        config.channelProfile = mChannelProfile;

        return config;
    }

    private YYLiveLayout convertLayout(YYLiveLayout liveLayout, YYLiveChannelLayout channelLayout) {
        ArrayList<YYLiveChannelLayout> layouts = new ArrayList<YYLiveChannelLayout>();
        layouts.add(channelLayout);
        YYLiveLayout layout = new YYLiveLayout();
        layout.width = liveLayout.width;
        layout.height = liveLayout.height;
        layout.layouts = layouts;
        layout.speakers = liveLayout.speakers;
        return layout;
    }

    private YYLiveLayout makeLayout(ArrayList<String> speakers) {
        int convertType = convertPlayType(mPlayType);
        YYPublishVideoConfig config = YYLiveNative.getRemoteVideoConfig(convertType, mPublishMode);
        Rect rect = new Rect(0, 0, config.encodeResolutionWidth, config.encodeResolutionHeight);

        YYLiveChannelLayout channelLayout = new YYLiveChannelLayout();
        channelLayout.channelId = mChannelId;
        channelLayout.layoutNo = 0;
        channelLayout.layout = rect;

        ArrayList<YYLiveChannelLayout> layouts = new ArrayList<YYLiveChannelLayout>();
        layouts.add(channelLayout);
        YYLiveLayout layout = new YYLiveLayout();
        layout.width = 0;
        layout.height = 0;
        layout.layouts = layouts;
        if (speakers == null || speakers.isEmpty()) {

            channelLayout.owner = true;
            ArrayList<String> spk = new ArrayList<String>();
            spk.add(mUidString);
            layout.speakers = spk;

        } else {

            channelLayout.owner = mPublishing;
            layout.speakers = speakers;
        }

        return layout;
    }

    private int convertPlayType(int playType) {
        if (mAudioOnly) {
            return YYPublishVideoConfig.YYPUBLISH_PLAYTYPE_SINGLE;
        }
        switch (playType) {
            case YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SINGLE:
                playType = YYPublishVideoConfig.YYPUBLISH_PLAYTYPE_SINGLE;
                break;
            case YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_INTERACT:
                playType = YYPublishVideoConfig.YYPUBLISH_PLAYTYPE_LIANMAI;
                break;
            case YYConstant.YYPublishPlayType.YYPUBLISH_PLAY_SCREENCAP:
                playType = YYPublishVideoConfig.YYPUBLISH_PLAYTYPE_SCREEN_CAPTURE;
                break;
            default:
                break;
        }
        return playType;
    }

    //audio
    public void setAudioEnable(boolean enableAudio) {

        if (this.mEnableAudio == enableAudio)
        {
            return;
        }
        this.mEnableAudio = enableAudio;
        //开播
        if (enableAudio) {
            YYLiveNative.setAudioSourceType(0);
            if (mEnableVideo) {             /*********already start video, update publish********/
                mAudioOnly= false;
                startSinglePublish(mPlayType, mPublishMode);
            } else {                        /*********only start audio********/
                mAudioOnly = true;
                YYPublishAudioConfig audioConfig = convertAudioConfig();
                YYPublishVideoConfig videoConfig = new YYPublishVideoConfig();//default
                YYLiveLayout layout = makeLayout(null);

                if (mAudioCapture == null) {
                    YYLiveNative.attachAudioCapture(mDefaultMic);
                }

                YYLiveNative.startPublishLive(mChannelId, false, videoConfig, audioConfig, layout);
                mPublishing = true;
            }
        }
        else {  //停播
            mAudioOnly = false;
            if (mEnableVideo) {             /*********only stop audio, update publish********/
                YYPublishAudioConfig audioConfig = convertAudioConfig();
                YYPublishVideoConfig videoConfig = convertVideoConfig();
                YYLiveLayout layout = makeLayout(null);
                YYLiveNative.stopPublishAudio();
                YYLiveNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
            } else {                         /*********stop all********/
                YYLiveNative.stopPublishLive(mChannelId);
                mPublishing = false;
            }
        }
    }

    //video
    public void setVideoEnable(boolean enableVideo) {
        if (enableVideo == this.mEnableVideo) {
            return;
        }
        this.mEnableVideo = enableVideo;
        if (enableVideo) {  //开播
            mAudioOnly = false;
            if (this.mEnableAudio) {    /*********already start audio, update publish********/
                startSinglePublish(mPlayType, mPublishMode);
            } else {                    /*********only start video********/
                YYPublishVideoConfig videoConfig = convertVideoConfig();
                YYPublishAudioConfig audioConfig = new YYPublishAudioConfig(YYPublishAudioConfig.YYPUBLISH_AUDIO_MODE_LOWDELAY_LOWFLOW_SUPERLOWQUALITY_VOIP);   //default
                YYLiveLayout layout = makeLayout(null);
                YYLiveNative.startPublishLive(mChannelId, false, videoConfig, audioConfig, layout);
                mPublishing = true;
            }
        } else {    //停播
            if (this.mEnableAudio) {    /*********only stop video, update publish********/
                mAudioOnly = true;
                YYPublishVideoConfig videoConfig = new YYPublishVideoConfig();
                YYPublishAudioConfig audioConfig = convertAudioConfig();
                YYLiveLayout layout = makeLayout(null);
                YYLiveNative.stopPublishVideo();
                YYLiveNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
            } else {                    /*********stop all********/
                mAudioOnly = false;
                YYLiveNative.stopPublishLive(mChannelId);
                mPublishing = false;
            }
        }
    }

    public int updatePlayTypeAndPublishMode(int playType, int publishMode) {

        if ((mPlayType == playType) && (mPublishMode == publishMode)) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "updatePlayTypeAndPublishMode ignore same");
            return 0;
        }

        boolean bSupport = isPublishParamValid(playType, publishMode);
        YYLiveLog.info(YYLiveLog.kLogTagCall, "updatePlayTypeAndPublishMode %d %d %b", playType, publishMode, bSupport);

        if (!bSupport) {
            return -1;
        }

        if (mEnableVideo) { //already publish video
            mPlayType = playType;
            mPublishMode = publishMode;
            YYPublishVideoConfig videoConfig = convertVideoConfig();
            YYPublishAudioConfig audioConfig = convertAudioConfig();
            YYLiveLayout layout = makeLayout(null);
            YYLiveNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }
        else    //is not publishing video
        {
            mPlayType = playType;
            mPublishMode = publishMode;
            YYPublishVideoConfig videoConfig = convertVideoConfig();
            YYLiveNative.updateVideoConfig(videoConfig);
        }
        return 0;
    }

    private boolean isPublishParamValid(int playType, int publishMode) {

        int convertType = convertPlayType(playType);
        HashMap<Integer, String> modeMap = YYLiveNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            YYLiveLog.info(YYLiveLog.kLogTagCall, "updatePlayTypeAndPublishMode empty");
            return false;
        }
        for (Integer key : modeMap.keySet()) {
            if (key == publishMode) {
                return true;
            }
        }
        return false;
    }
}
