package com.yy.yylivesdk4cloud;

import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;

/**
 * 手机自带的麦克风
 *
 * Created by xiaojun on 2018/4/3.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */
public class YYLiveDefaultMic extends YYLiveAudioCapture {

	/**
	 * 麦克风采集回调
	 */
	public interface IYYLiveDefaultMicDataCallback {
		/**
		 * 采集数据回调
		 * @param audioSamples 采样数据
		 * @param bActiveAudio 当前帧实际是否有声音
		 */
		void onAudioDataCallback(byte[] audioSamples, boolean bActiveAudio);
	}

	private IYYLiveDefaultMicDataCallback mMicDataCallback;
	private int mSampleRate;
	private int mChannels;
	private int mSampleBitDepth;


	/**
	 * 禁止从外部创建麦克风对象，通过接口获取 {@link YYLivePublisher#getDefaluteMic()}
	 */
	YYLiveDefaultMic() {
		mSampleRate = 16000;
		mChannels = 2;
		mSampleBitDepth = 16; //默认的采集只支持16bit的采样位深

		mMicDataCallback = null;
	}

	/**
	 * 设置麦克风的采集回调，用于获得采集的数据
	 * 支持设置采样率和通道数，采样位深固定为16bit
	 * @param sampleRate 采样频率
	 * @param channels 采样通道数
	 * @param callback 采集回调
	 */
	public void setMicDataCallback(int sampleRate,
								   int channels,
								   IYYLiveDefaultMicDataCallback callback) {
		YYLiveLog.release(YYLiveLog.kLogTagCall,
				"setMicDataCallback sampleRate=%d, channels=%d, callback=%s",
				sampleRate, channels, callback.toString());
		this.mSampleRate = sampleRate;
		this.mChannels = channels;
		this.mMicDataCallback = callback;
	}

	/**
	 * 获取设置的麦克风采集回调
	 *
	 * @return  外部设置进来的采集回调
	 */
	public IYYLiveDefaultMicDataCallback getMicDataCallback() {
		return mMicDataCallback;
	}

	@Override
	public void startCapture(YYLivePublisher.IAudioPublisher publisher) {
		// 默认的麦克风将采集的数据直接推出去，不需要再从外面推
	}

	@Override
	public void stopCapture() {
		//
	}

	@Override
	public int getSampleRate() {
		return mSampleRate;
	}

	@Override
	public int getChannels() {
		return mChannels;
	}

	@Override
	public int getBitDepth() {
		return mSampleBitDepth;
	}
}
