package com.yy.yylivesdk4cloud;

import java.util.HashMap;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import org.json.JSONObject;
import java.util.Iterator;

public class TransJsonParseImp implements ITransJsonParseInterface {
    private final static String TAG = "TransJsonParseImp";
    private HandlerThread mProcessTransJsonParseThread;
    private Handler mProcessTransJsonParseHandler;
    private ITransConfigCallbackInterface mCallback;
    private boolean mReady = false;

    private static final int MESSAGE_COMMON_CONFIG = 0;

    public TransJsonParseImp(ITransConfigCallbackInterface callBack) {
        mCallback = callBack;
        mProcessTransJsonParseThread = new HandlerThread("TransJsonParseThread");
        mProcessTransJsonParseThread.start();
        mProcessTransJsonParseHandler = new Handler(mProcessTransJsonParseThread.getLooper()) {
            @Override
            public void handleMessage(Message msg) {
                if (!mReady) {
                    YYLiveLog.warn(TAG, " mProcessTransJsonParseThread not Ready !");
                    return;
                }

                try {
                    String data = (String) msg.obj;
                    switch (msg.what) {
                        case MESSAGE_COMMON_CONFIG:
                            handleParseCommonConfig(data);
                            break;
                        default:
                            break;
                    }
                } catch (Exception e) {
                    YYLiveLog.error(TAG, " mProcessTransJsonParseThread deal error :" + e.toString());
                }
            }
        };
        mReady = true;
    }

    private void handleParseCommonConfig(final String config) {

        if (config == null || config.isEmpty()) {
            return;
        }
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            JSONObject configJson = new JSONObject(config);
            Iterator iterator = configJson.keys();
            while (iterator.hasNext()) {
                String keyStr = iterator.next().toString();
                int key = (int) Long.parseLong(keyStr);
                int val = (int) configJson.getLong(keyStr);
                result.put(key, val);
                Log.d(TAG, String.format("key:%d, val:%d", key, val));
            }
        } catch (Exception e) {
            Log.d(TAG, "error" + e.toString());
            return;
        }
        mCallback.notifyCommonConfigResult(result);
    }

    @Override
    public void parseCommonConfig(String response) {
        if (mReady) {
            Message msg = Message.obtain();
            msg.what = MESSAGE_COMMON_CONFIG;
            msg.obj = response;
            mProcessTransJsonParseHandler.sendMessage(msg);
        }

    }

}
