/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.yy.videoplayer.vr.IAdvanceGestureListener;

public class VRTouchHelper {
    private IAdvanceGestureListener mAdvanceGestureListener;
    private GestureDetector mGestureDetector;
    private int mCurrentMode = 0;
    private PinchInfo mPinchInfo = new PinchInfo();
    private boolean mPinchEnabled;
    private float mGlobalScale;
    private static final int MODE_INIT = 0;
    private static final int MODE_PINCH = 1;
    private float maxScale = 5.0f;
    private float minScale = 1.0f;
    private float defaultScale = 1.0f;
    private float mSensitivity = 3.0f;

    public VRTouchHelper(Context context) {
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                return VRTouchHelper.this.mCurrentMode != 1;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (VRTouchHelper.this.mCurrentMode == 1) {
                    return false;
                }
                if (VRTouchHelper.this.mAdvanceGestureListener != null) {
                    VRTouchHelper.this.mAdvanceGestureListener.onDrag(distanceX / VRTouchHelper.this.mGlobalScale, distanceY / VRTouchHelper.this.mGlobalScale);
                }
                return true;
            }
        });
    }

    public boolean handleTouchEvent(MotionEvent event) {
        int action = event.getAction() & 0xFF;
        if (action == 1 || action == 3) {
            if (this.mCurrentMode == 1) {
                // empty if block
            }
            this.mCurrentMode = 0;
        } else if (action == 6) {
            if (this.mCurrentMode == 1 && event.getPointerCount() > 2) {
                if (event.getAction() >> 8 == 0) {
                    this.markPinchInfo(event.getX(1), event.getY(1), event.getX(2), event.getY(2));
                } else if (event.getAction() >> 8 == 1) {
                    this.markPinchInfo(event.getX(0), event.getY(0), event.getX(2), event.getY(2));
                }
            }
        } else if (action == 5) {
            this.mCurrentMode = 1;
            this.markPinchInfo(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
        } else if (action == 2 && this.mCurrentMode == 1 && event.getPointerCount() > 1) {
            float distance = VRTouchHelper.calDistance(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
            this.handlePinch(distance);
        }
        this.mGestureDetector.onTouchEvent(event);
        return true;
    }

    public void scaleTo(float scale) {
        this.setScaleInner(this.mPinchInfo.setScale(scale));
    }

    public void reset() {
        this.setScaleInner(this.mPinchInfo.reset());
    }

    private void handlePinch(float distance) {
        if (this.mPinchEnabled) {
            this.setScaleInner(this.mPinchInfo.pinch(distance));
        }
    }

    private void setScaleInner(float scale) {
        if (this.mAdvanceGestureListener != null) {
            this.mAdvanceGestureListener.onPinch(scale);
        }
        this.mGlobalScale = scale;
    }

    private void markPinchInfo(float x1, float y1, float x2, float y2) {
        this.mPinchInfo.mark(x1, y1, x2, y2);
    }

    private static float calDistance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public void setAdvanceGestureListener(IAdvanceGestureListener listener) {
        this.mAdvanceGestureListener = listener;
    }

    public void setPinchEnabled(boolean mPinchEnabled) {
        this.mPinchEnabled = mPinchEnabled;
    }

    public void setPinchConfig(float scale) {
        this.setScaleInner(scale);
        if (this.mPinchInfo != null) {
            this.mPinchInfo.setScale(scale);
        }
    }

    private class PinchInfo {
        private float x1;
        private float y1;
        private float x2;
        private float y2;
        private float oDistance;
        private float prevScale;
        private float currentScale;

        private PinchInfo() {
        }

        public void mark(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.oDistance = VRTouchHelper.calDistance(x1, y1, x2, y2);
            this.prevScale = this.currentScale;
        }

        public float pinch(float distance) {
            if (this.oDistance == 0.0f) {
                this.oDistance = distance;
            }
            float scale = distance / this.oDistance - 1.0f;
            this.currentScale = this.prevScale + (scale *= VRTouchHelper.this.mSensitivity);
            this.currentScale = Math.max(this.currentScale, VRTouchHelper.this.minScale);
            this.currentScale = Math.min(this.currentScale, VRTouchHelper.this.maxScale);
            return this.currentScale;
        }

        public float setScale(float scale) {
            this.prevScale = scale;
            this.currentScale = scale;
            return this.currentScale;
        }

        public float reset() {
            return this.setScale(VRTouchHelper.this.defaultScale);
        }
    }
}

