/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr;

import android.content.Context;
import com.yy.videoplayer.vr.VRAbsObject3D;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class VRSphere3D
extends VRAbsObject3D {
    private static final String TAG = "VRSphere3D";

    @Override
    protected void executeLoad(Context context) {
        VRSphere3D.generateSphere(this);
    }

    private static void generateSphere(VRAbsObject3D object3D) {
        VRSphere3D.generateSphere(18.0f, 75, 150, object3D);
    }

    private static void generateSphere(float radius, int rings, int sectors, VRAbsObject3D object3D) {
        int s;
        int r;
        float PI = (float)Math.PI;
        float PI_2 = 1.5707964f;
        float R2 = 1.0f / (float)rings;
        float S = 1.0f / (float)sectors;
        int numPoint = (rings + 1) * (sectors + 1);
        float[] vertexs = new float[numPoint * 3];
        float[] texcoords = new float[numPoint * 2];
        short[] indices = new short[numPoint * 6];
        int t = 0;
        int v = 0;
        for (r = 0; r < rings + 1; r = (int)((short)(r + 1))) {
            for (s = 0; s < sectors + 1; s = (int)((short)(s + 1))) {
                float x = (float)(Math.cos((float)Math.PI * 2 * (float)s * S) * Math.sin((float)Math.PI * (float)r * R2));
                float y = -((float)Math.sin(-1.5707964f + (float)Math.PI * (float)r * R2));
                float z = (float)(Math.sin((float)Math.PI * 2 * (float)s * S) * Math.sin((float)Math.PI * (float)r * R2));
                texcoords[t++] = (float)s * S;
                texcoords[t++] = 1.0f - (float)r * R2;
                vertexs[v++] = x * radius;
                vertexs[v++] = y * radius;
                vertexs[v++] = z * radius;
            }
        }
        int counter = 0;
        int sectorsPlusOne = sectors + 1;
        for (r = 0; r < rings; r = (int)((short)(r + 1))) {
            for (s = 0; s < sectors; s = (int)((short)(s + 1))) {
                indices[counter++] = (short)(r * sectorsPlusOne + s);
                indices[counter++] = (short)((r + 1) * sectorsPlusOne + s);
                indices[counter++] = (short)(r * sectorsPlusOne + (s + 1));
                indices[counter++] = (short)(r * sectorsPlusOne + (s + 1));
                indices[counter++] = (short)((r + 1) * sectorsPlusOne + s);
                indices[counter++] = (short)((r + 1) * sectorsPlusOne + (s + 1));
            }
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(vertexs.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer vertexBuffer = bb.asFloatBuffer();
        vertexBuffer.put(vertexs);
        vertexBuffer.position(0);
        ByteBuffer cc = ByteBuffer.allocateDirect(texcoords.length * 4);
        cc.order(ByteOrder.nativeOrder());
        FloatBuffer texBuffer = cc.asFloatBuffer();
        texBuffer.put(texcoords);
        texBuffer.position(0);
        ByteBuffer dlb = ByteBuffer.allocateDirect(indices.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        ShortBuffer indexBuffer = dlb.asShortBuffer();
        indexBuffer.put(indices);
        indexBuffer.position(0);
        object3D.setIndicesBuffer(indexBuffer);
        object3D.setTexCoordinateBuffer(0, texBuffer);
        object3D.setTexCoordinateBuffer(1, texBuffer);
        object3D.setVerticesBuffer(0, vertexBuffer);
        object3D.setVerticesBuffer(1, vertexBuffer);
        object3D.setNumIndices(indices.length);
    }
}

