/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr;

import android.content.Context;
import android.opengl.GLES20;
import com.yy.videoplayer.R;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.vr.VRAbsObject3D;
import com.yy.videoplayer.vr.VRDirector;
import com.yy.videoplayer.vr.VRGLHandler;
import com.yy.videoplayer.vr.util.GLUtil;

public class VRProgram {
    private int mMVPMatrixHandle;
    private int mMVMatrixHandle;
    private int mTextureUniformHandle;
    private int mPositionHandle;
    private int mTextureCoordinateHandle;
    private int mSTMatrixHandle;
    private int mUseTextureTransformHandle;
    private int mSampleYLoc = -1;
    private int mSampleULoc = -1;
    private int mSampleVLoc = -1;
    private int mProgramHandle;
    private int mVertexShaderHandle;
    private int mFragmentShaderHandle;
    private static final int[] sUseTransform = new int[]{1};
    private boolean mIsHardDecoder = true;
    private int surfaceWidth;
    private int surfaceHeight;

    public VRProgram(boolean hardDecoder) {
        this.mIsHardDecoder = hardDecoder;
        VRGLHandler.getInstance().markAsInitialize();
    }

    public void build(Context context) {
        if (this.mIsHardDecoder) {
            String vertexShader = GLUtil.readTextFileFromRaw(context, R.raw.per_pixel_vertex_shader);
            String fragmentShader = GLUtil.readTextFileFromRaw(context, R.raw.per_pixel_fragment_shader);
            this.mVertexShaderHandle = GLUtil.compileShader(35633, vertexShader);
            this.mFragmentShaderHandle = GLUtil.compileShader(35632, fragmentShader);
        } else {
            String vertexShader = GLUtil.readTextFileFromRaw(context, R.raw.per_pixel_vertex_shader);
            String fragmentShader = GLUtil.readTextFileFromRaw(context, R.raw.per_pixel_fragment_shader_yuv);
            this.mVertexShaderHandle = GLUtil.compileShader(35633, vertexShader);
            this.mFragmentShaderHandle = GLUtil.compileShader(35632, fragmentShader);
        }
        this.mProgramHandle = GLUtil.createAndLinkProgram(this.mVertexShaderHandle, this.mFragmentShaderHandle, new String[]{"a_Position", "a_TexCoordinate"});
        this.mMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"u_MVPMatrix");
        this.mMVMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"u_MVMatrix");
        this.mTextureUniformHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"u_Texture");
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"a_Position");
        this.mTextureCoordinateHandle = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"a_TexCoordinate");
        this.mSTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"u_STMatrix");
        this.mUseTextureTransformHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"u_UseSTM");
        this.mSampleYLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"tex_y");
        this.mSampleULoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"tex_u");
        this.mSampleVLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"tex_v");
    }

    protected String getVertexShader(Context context) {
        return GLUtil.readTextFileFromRaw(context, R.raw.per_pixel_vertex_shader);
    }

    protected String getFragmentShader(Context context) {
        return GLUtil.readTextFileFromRaw(context, R.raw.per_pixel_fragment_shader);
    }

    public void use() {
        GLES20.glUseProgram((int)this.mProgramHandle);
    }

    public int getMVPMatrixHandle() {
        return this.mMVPMatrixHandle;
    }

    public int getMVMatrixHandle() {
        return this.mMVMatrixHandle;
    }

    public int getTextureUniformHandle() {
        return this.mTextureUniformHandle;
    }

    public int getPositionHandle() {
        return this.mPositionHandle;
    }

    public int getTextureCoordinateHandle() {
        return this.mTextureCoordinateHandle;
    }

    public int getSTMatrixHandle() {
        return this.mSTMatrixHandle;
    }

    public int getUseTextureTransformHandle() {
        return this.mUseTextureTransformHandle;
    }

    public void release() {
        if (this.mProgramHandle != -1) {
            GLES20.glDeleteShader((int)this.mVertexShaderHandle);
            GLES20.glDeleteShader((int)this.mFragmentShaderHandle);
            GLES20.glDeleteProgram((int)this.mProgramHandle);
            this.mFragmentShaderHandle = -1;
            this.mVertexShaderHandle = -1;
            this.mProgramHandle = -1;
        }
        VRGLHandler.getInstance().markAsDestroy();
    }

    public void drawFrame(int textureId, float[] transformMatrix, int ytextureId, int utextureId, int vtextureId, VRAbsObject3D object3D) {
        VRGLHandler.getInstance().dealMessage();
        VRDirector.getInstance().updateViewport(this.surfaceWidth, this.surfaceHeight);
        GLES20.glFrontFace((int)2304);
        GLES20.glCullFace((int)1028);
        GLES20.glEnable((int)2884);
        GLES20.glUseProgram((int)this.mProgramHandle);
        GLUtil.glCheck("mProgram use");
        GLES20.glUniform1iv((int)this.mUseTextureTransformHandle, (int)1, (int[])sUseTransform, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mSTMatrixHandle, (int)1, (boolean)false, (float[])transformMatrix, (int)0);
        object3D.uploadVerticesBufferIfNeed(this, 0);
        object3D.uploadTexCoordinateBufferIfNeed(this, 0);
        if (this.mSampleYLoc >= 0) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)ytextureId);
            GLES20.glUniform1i((int)this.mSampleYLoc, (int)0);
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)utextureId);
            GLES20.glUniform1i((int)this.mSampleULoc, (int)1);
            GLES20.glActiveTexture((int)33986);
            GLES20.glBindTexture((int)3553, (int)vtextureId);
            GLES20.glUniform1i((int)this.mSampleVLoc, (int)2);
        } else {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)36197, (int)textureId);
            GLES20.glUniform1i((int)this.mTextureUniformHandle, (int)0);
        }
        VRDirector.getInstance().beforeShot();
        VRDirector.getInstance().shot(this);
        object3D.draw();
        object3D.disableDataFromProgram(this);
        if (this.mSampleYLoc >= 0) {
            GLES20.glBindTexture((int)3553, (int)0);
        } else {
            GLES20.glBindTexture((int)36197, (int)0);
        }
        GLES20.glUseProgram((int)0);
        GLES20.glDisable((int)2884);
    }

    public void updateViewport(int width, int height) {
        YMFLog.info(this, "[Vr      ]", "updateViewport, width:" + width + " ,height:" + height);
        this.surfaceWidth = width;
        this.surfaceHeight = height;
    }
}

