/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr;

import android.content.Context;
import android.view.MotionEvent;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.vr.IAdvanceGestureListener;
import com.yy.videoplayer.vr.MotionWithTouchStrategy;
import com.yy.videoplayer.vr.VRTouchHelper;

public class VRMotionWithTouchWrapper
implements IAdvanceGestureListener {
    private MotionWithTouchStrategy motionWithTouchStrategy;
    private VRTouchHelper vrTouchHelper;
    private Context context;
    private float scale = 1.0f;
    private VRScaleListener mVRScaleListener;

    public VRMotionWithTouchWrapper(Context context) {
        YMFLog.info(this, "[Vr      ]", "new VRMotionWithTouchWrapper");
        this.context = context;
    }

    public void initVrScaleParam(float scale) {
        this.scale = scale;
    }

    public void initWrapper() {
        this.motionWithTouchStrategy = new MotionWithTouchStrategy(this.context);
        this.motionWithTouchStrategy.setDirectorScaleParam(this.scale);
        this.vrTouchHelper = new VRTouchHelper(this.context);
        this.vrTouchHelper.setPinchConfig(this.scale);
        this.vrTouchHelper.setPinchEnabled(true);
        this.vrTouchHelper.setAdvanceGestureListener(this);
    }

    public void deInitWrapper() {
        if (null != this.vrTouchHelper) {
            this.vrTouchHelper.setAdvanceGestureListener(null);
        }
    }

    public void enableSensor() {
        if (null != this.motionWithTouchStrategy) {
            this.motionWithTouchStrategy.enableSensor();
        }
    }

    public void disableSensor() {
        if (null != this.motionWithTouchStrategy) {
            this.motionWithTouchStrategy.disableSensor();
        }
    }

    public boolean isSensorSupport() {
        boolean result = false;
        if (null != this.motionWithTouchStrategy) {
            result = this.motionWithTouchStrategy.isSensorSupport();
        }
        return result;
    }

    public boolean isSensorEnabled() {
        boolean result = false;
        if (null != this.motionWithTouchStrategy) {
            result = this.motionWithTouchStrategy.isSensorEnabled();
        }
        return result;
    }

    public void handleTouchEvent(MotionEvent event) {
        if (null != this.vrTouchHelper) {
            this.vrTouchHelper.handleTouchEvent(event);
        }
        if (this.mVRScaleListener != null) {
            this.mVRScaleListener.onScaleChange(this.getVrScaleParam());
        }
    }

    public void setVRScaleListener(VRScaleListener listener) {
        this.mVRScaleListener = listener;
    }

    public float getVrScaleParam() {
        if (null != this.motionWithTouchStrategy) {
            return this.motionWithTouchStrategy.getVrScaleParam();
        }
        return 1.0f;
    }

    @Override
    public void onDrag(float distanceX, float distanceY) {
        if (null != this.motionWithTouchStrategy) {
            this.motionWithTouchStrategy.handleDrag(distanceX, distanceY);
        }
    }

    @Override
    public void onPinch(float scale) {
        if (null != this.motionWithTouchStrategy) {
            this.motionWithTouchStrategy.handlePinch(scale);
        }
    }

    public static interface VRScaleListener {
        public void onScaleChange(float var1);
    }
}

