/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.vr.MotionWithTouchStrategy;
import com.yy.videoplayer.vr.VRProgram;
import com.yy.videoplayer.vr.util.VRUtil;
import java.util.Arrays;

public class VRDirector {
    private static final String TAG = "VRDirector";
    private static final float sNear = 0.7f;
    private float[] mModelMatrix = new float[16];
    private float[] mViewMatrix = new float[16];
    private float[] mProjectionMatrix = new float[16];
    private float[] mMVMatrix = new float[16];
    private float[] mMVPMatrix = new float[16];
    private float mEyeX = 0.0f;
    private float mEyeY = 0.0f;
    private float mEyeZ = 0.0f;
    private float mRatio = 1.5f;
    private float mNearScale = 1.0f;
    private float mLookX = 0.0f;
    private float mLookY = 0.0f;
    private int mViewportWidth = 2;
    private int mViewportHeight = 1;
    private float[] mWorldRotationMatrix = new float[16];
    private float[] mWorldRotationInvertMatrix = new float[16];
    private float[] mCurrentRotationPost = new float[16];
    private float[] mSensorMatrix = new float[16];
    private float[] mLastSensorMatrix = new float[16];
    private float[] mTempMatrix = new float[16];
    private float[] mCameraMatrix = new float[16];
    private float[] mIdentityMatrix = new float[16];
    private float mDeltaX;
    private float mDeltaY;
    private boolean mCameraMatrixInvalidate = true;
    private boolean mWorldRotationMatrixInvalidate = true;
    private MotionWithTouchStrategy mMotionWithTouchStrategy;
    private static volatile VRDirector mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized VRDirector getInstance() {
        if (mInstance != null) return mInstance;
        Class<VRDirector> clazz = VRDirector.class;
        synchronized (VRDirector.class) {
            if (mInstance != null) return mInstance;
            mInstance = new VRDirector();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private VRDirector() {
        this.initModel();
    }

    public float getDeltaY() {
        return this.mDeltaY;
    }

    public void setDeltaY(float mDeltaY) {
        this.mDeltaY = mDeltaY;
        this.mWorldRotationMatrixInvalidate = true;
    }

    public float getDeltaX() {
        return this.mDeltaX;
    }

    public void setDeltaX(float mDeltaX) {
        this.mDeltaX = mDeltaX;
        this.mWorldRotationMatrixInvalidate = true;
    }

    private void initModel() {
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mSensorMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
    }

    public void beforeShot() {
        this.updateViewMatrixIfNeed();
    }

    public void shot(VRProgram program) {
        Matrix.multiplyMM((float[])this.mMVMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mModelMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mMVMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)program.getMVMatrixHandle(), (int)1, (boolean)false, (float[])this.mMVMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)program.getMVPMatrixHandle(), (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
    }

    private void updateViewMatrixIfNeed() {
        boolean mHasChanged = this.isSensorMatrixChanged();
        if (this.mCameraMatrixInvalidate || this.mWorldRotationMatrixInvalidate || mHasChanged) {
            if (this.mCameraMatrixInvalidate) {
                this.updateCameraMatrix();
                this.mCameraMatrixInvalidate = false;
            }
            if (this.mWorldRotationMatrixInvalidate || mHasChanged) {
                this.updateWorldRotationMatrix();
                this.mWorldRotationMatrixInvalidate = false;
            }
            Matrix.multiplyMM((float[])this.mViewMatrix, (int)0, (float[])this.mCameraMatrix, (int)0, (float[])this.mWorldRotationMatrix, (int)0);
        }
    }

    public void updateViewport(int width, int height) {
        this.mViewportWidth = width;
        this.mViewportHeight = height;
        this.mRatio = (float)width * 1.0f / (float)height;
        this.updateProjection();
    }

    public void updateProjectionNearScale(float scale) {
        YMFLog.info(this, "[Vr      ]", "updateProjectionNearScale, scale:" + scale);
        this.mNearScale = scale;
        this.updateProjection();
    }

    protected void updateProjection() {
        float left = -this.mRatio / 2.0f;
        float right = this.mRatio / 2.0f;
        float bottom = -0.5f;
        float top = 0.5f;
        float far = 500.0f;
        Matrix.frustumM((float[])this.getProjectionMatrix(), (int)0, (float)left, (float)right, (float)-0.5f, (float)0.5f, (float)this.getNear(), (float)500.0f);
    }

    protected float getNear() {
        return this.mNearScale * 0.7f;
    }

    private boolean isSensorMatrixChanged() {
        System.arraycopy(this.mSensorMatrix, 0, this.mLastSensorMatrix, 0, 16);
        if (null != this.mMotionWithTouchStrategy) {
            this.mSensorMatrix = this.mMotionWithTouchStrategy.getSensorMatrix();
        }
        return !Arrays.equals(this.mSensorMatrix, this.mLastSensorMatrix);
    }

    protected float getRatio() {
        return this.mRatio;
    }

    public float[] getProjectionMatrix() {
        return this.mProjectionMatrix;
    }

    public int getViewportWidth() {
        return this.mViewportWidth;
    }

    public int getViewportHeight() {
        return this.mViewportHeight;
    }

    public float[] getViewMatrix() {
        return this.mViewMatrix;
    }

    private void updateCameraMatrix() {
        float eyeX = this.mEyeX;
        float eyeY = this.mEyeY;
        float eyeZ = this.mEyeZ;
        float lookX = this.mLookX;
        float lookY = this.mLookY;
        float lookZ = -1.0f;
        float upX = 0.0f;
        float upY = 1.0f;
        float upZ = 0.0f;
        Matrix.setIdentityM((float[])this.mCameraMatrix, (int)0);
        Matrix.setLookAtM((float[])this.mCameraMatrix, (int)0, (float)eyeX, (float)eyeY, (float)eyeZ, (float)lookX, (float)lookY, (float)-1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void updateWorldRotationMatrix() {
        Matrix.setIdentityM((float[])this.mWorldRotationMatrix, (int)0);
        Matrix.rotateM((float[])this.mWorldRotationMatrix, (int)0, (float)(-this.mDeltaY), (float)1.0f, (float)0.0f, (float)0.0f);
        Matrix.setIdentityM((float[])this.mCurrentRotationPost, (int)0);
        Matrix.rotateM((float[])this.mCurrentRotationPost, (int)0, (float)(-this.mDeltaX), (float)0.0f, (float)1.0f, (float)0.0f);
        Matrix.setIdentityM((float[])this.mTempMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mTempMatrix, (int)0, (float[])this.mCurrentRotationPost, (int)0, (float[])this.mModelMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mCurrentRotationPost, (int)0, (float[])this.mSensorMatrix, (int)0, (float[])this.mTempMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mTempMatrix, (int)0, (float[])this.mWorldRotationMatrix, (int)0, (float[])this.mCurrentRotationPost, (int)0);
        System.arraycopy(this.mTempMatrix, 0, this.mWorldRotationMatrix, 0, 16);
        boolean success = VRUtil.invertM(this.mWorldRotationInvertMatrix, this.mWorldRotationMatrix);
        if (!success) {
            Matrix.setIdentityM((float[])this.mWorldRotationInvertMatrix, (int)0);
        }
    }

    public void updateSensorMatrix(float[] sensorMatrix) {
        System.arraycopy(sensorMatrix, 0, this.mSensorMatrix, 0, 16);
        this.mWorldRotationMatrixInvalidate = true;
    }

    public void resetMatrix() {
        YMFLog.info(this, "[Vr      ]", "Director reset...");
        this.mDeltaY = 0.0f;
        this.mDeltaX = 0.0f;
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mSensorMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
        this.mWorldRotationMatrixInvalidate = true;
    }

    public void setScaleParam(float scale) {
        YMFLog.info(this, "[Vr      ]", "Director setScaleParam:" + scale);
        this.mNearScale = scale;
    }

    public void setMotionWithTouchStrategy(MotionWithTouchStrategy motionWithTouchStrategy) {
        this.mMotionWithTouchStrategy = motionWithTouchStrategy;
    }

    public float getScaleParam() {
        return this.mNearScale;
    }
}

