/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr;

import android.content.Context;
import android.opengl.GLES20;
import android.util.SparseArray;
import com.yy.videoplayer.vr.VRProgram;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public abstract class VRAbsObject3D {
    private static final int sPositionDataSize = 3;
    private static final int sTextureCoordinateDataSize = 2;
    private ShortBuffer mIndicesBuffer;
    private int mNumIndices;
    private SparseArray<FloatBuffer> mTexCoordinateBuffers = new SparseArray(2);
    private SparseArray<FloatBuffer> mVerticesBuffers = new SparseArray(2);

    public void uploadVerticesBufferIfNeed(VRProgram program, int index) {
        FloatBuffer vertexBuffer = this.getVerticesBuffer(index);
        if (vertexBuffer == null) {
            return;
        }
        vertexBuffer.position(0);
        int positionHandle = program.getPositionHandle();
        GLES20.glVertexAttribPointer((int)positionHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)positionHandle);
    }

    public void uploadTexCoordinateBufferIfNeed(VRProgram program, int index) {
        FloatBuffer textureBuffer = this.getTexCoordinateBuffer(index);
        if (textureBuffer == null) {
            return;
        }
        textureBuffer.position(0);
        int textureCoordinateHandle = program.getTextureCoordinateHandle();
        GLES20.glVertexAttribPointer((int)textureCoordinateHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)textureCoordinateHandle);
    }

    public void disableDataFromProgram(VRProgram program) {
        GLES20.glDisableVertexAttribArray((int)program.getPositionHandle());
        GLES20.glDisableVertexAttribArray((int)program.getTextureCoordinateHandle());
    }

    protected abstract void executeLoad(Context var1);

    public int getNumIndices() {
        return this.mNumIndices;
    }

    public void setNumIndices(int mNumIndices) {
        this.mNumIndices = mNumIndices;
    }

    public FloatBuffer getVerticesBuffer(int index) {
        return (FloatBuffer)this.mVerticesBuffers.get(index);
    }

    public void setVerticesBuffer(int index, FloatBuffer verticesBuffer) {
        this.mVerticesBuffers.put(index, (Object)verticesBuffer);
    }

    public FloatBuffer getTexCoordinateBuffer(int index) {
        return (FloatBuffer)this.mTexCoordinateBuffers.get(index);
    }

    public void setTexCoordinateBuffer(int index, FloatBuffer texCoordinateBuffer) {
        this.mTexCoordinateBuffers.put(index, (Object)texCoordinateBuffer);
    }

    public ShortBuffer getIndicesBuffer() {
        return this.mIndicesBuffer;
    }

    public void setIndicesBuffer(ShortBuffer mIndicesBuffer) {
        this.mIndicesBuffer = mIndicesBuffer;
    }

    public void draw() {
        if (this.getIndicesBuffer() != null) {
            this.getIndicesBuffer().position(0);
            GLES20.glDrawElements((int)4, (int)this.getNumIndices(), (int)5123, (Buffer)this.getIndicesBuffer());
        } else {
            GLES20.glDrawArrays((int)4, (int)0, (int)this.getNumIndices());
        }
    }
}

