/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class YVideoViewExt
extends SurfaceView
implements SurfaceHolder.Callback,
YSpVideoView {
    private long context = 0L;
    private int bgColor = 0;
    private Bitmap drawBmp = null;
    private ByteBuffer bmpByteBuffer = null;
    protected int picWidth = 0;
    protected int picHeight = 0;
    int mPicRealWidth = 0;
    PlayNotify playNotify;
    VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    boolean mAutoOrientation = false;
    boolean mIsReleased = false;
    private long mStreamId = -1L;
    private long mGroupId = -1L;
    private int mRenderCnt = 0;
    private long mCurTime = 0L;
    private long mLastTime = 0L;
    private IVideoInfoCallback mVideoInfoCallback = null;
    private boolean mFirstFrameSeeFlag = false;
    private long mFirstFrameArrivedTime = 0L;
    private long mLastStatisticsTime = 0L;
    private AtomicInteger mMissRenderFrameCount = new AtomicInteger(0);
    private AtomicBoolean mFrameRendered = new AtomicBoolean(false);
    public static final int kScaleModeFillParent = 0;
    public static final int kScaleModeAspectFit = 1;
    public static final int kScaleModeClipToBounds = 2;
    public static final int kRotateAngle0 = 0;
    public static final int kRotateAngle90 = 1;
    public static final int kRotateAngle180 = 2;
    public static final int kRotateAngle270 = 3;
    private static final int kSurfaceCreated = 0;
    private static final int kSurfaceDestroyed = 1;

    @Override
    public void stopRender() {
    }

    public YVideoViewExt(Context context) {
        super(context.getApplicationContext());
        this.init(context.getApplicationContext(), true);
    }

    public YVideoViewExt(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.init(context.getApplicationContext(), true);
    }

    public YVideoViewExt(Context context, boolean useCanvas) {
        super(context.getApplicationContext());
        this.init(context.getApplicationContext(), useCanvas);
    }

    private void init(Context ctx, boolean useCanvas) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[Render  ]", "LoadLibarary failed, YYVideoView init context:%d", this.context);
            this.context = 0L;
            return;
        }
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.setFocusable(true);
        this.context = this.CreateView(this.getWidth(), this.getHeight(), useCanvas);
        try {
            this.playNotify = new PlayNotify();
            this.playNotify.Init();
            this.mIsReleased = false;
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Render  ]", "failed to init notifier, exception:" + e.toString());
        }
        YMFLog.info(this, "[Render  ]", "YYVideoView init context:%d", this.context);
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.SFView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        if (scaleMode == VideoConstant.ScaleMode.AspectFit) {
            return this.setScaleMode(1);
        }
        if (scaleMode == VideoConstant.ScaleMode.ClipToBounds) {
            return this.setScaleMode(2);
        }
        if (scaleMode == VideoConstant.ScaleMode.FillParent) {
            return this.setScaleMode(0);
        }
        return false;
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        if (scaleMode == VideoConstant.ScaleMode.AspectFit) {
            return this.setScaleMode(1);
        }
        if (scaleMode == VideoConstant.ScaleMode.ClipToBounds) {
            return this.setScaleMode(2);
        }
        if (scaleMode == VideoConstant.ScaleMode.FillParent) {
            return this.setScaleMode(0);
        }
        return false;
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        return this.mScaleMode;
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        this.playNotify.setPlayListner(pl);
    }

    @Override
    public void linkToStream(long userGroupId, long streamId) {
        this.mStreamId = streamId;
        this.mGroupId = userGroupId;
        this.linkToVideo(userGroupId, streamId);
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        this.unlinkFromVideo(userGroupId, streamId);
        this.mStreamId = -1L;
        this.mGroupId = -1L;
    }

    @Override
    public void unLinkFromStream() {
        this.unlinkFromVideo(this.mGroupId, this.mStreamId);
        this.mStreamId = -1L;
        this.mGroupId = -1L;
    }

    @Override
    public void init() {
        this.init(null, true);
    }

    @Override
    public void release() {
        block7: {
            if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
                YMFLog.error((Object)this, "[Render  ]", "LoadLibarary failed, YVideoView release");
                this.context = 0L;
                return;
            }
            YMFLog.info(this, "[Render  ]", "[YYVideoView release context:%d", this.context);
            try {
                this.mIsReleased = true;
                if (this.playNotify != null) {
                    this.playNotify.Release();
                    this.playNotify = null;
                }
            }
            catch (Exception e) {
                if (e == null) break block7;
                YMFLog.error((Object)this, "[Render  ]", "release playNOtify exception:" + e.getMessage());
            }
        }
        this.getHolder().removeCallback((SurfaceHolder.Callback)this);
        if (this.drawBmp != null) {
            this.drawBmp.recycle();
            this.drawBmp = null;
            this.bmpByteBuffer = null;
        }
        if (this.mStreamId != -1L || this.mGroupId != -1L) {
            this.unLinkFromStream(this.mGroupId, this.mStreamId);
        }
        this.ReleaseView(this.context);
        this.context = 0L;
        if (this.drawBmp != null) {
            this.drawBmp.recycle();
            this.drawBmp = null;
            this.bmpByteBuffer = null;
        }
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
    }

    @Override
    public boolean isReleased() {
        return this.mIsReleased;
    }

    @Override
    public YYRenderFrameBuffer getRenderFrameBuffer() {
        return null;
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    public long getViewContext() {
        return this.context;
    }

    public boolean setScaleMode(int scaleMode) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[Render  ]", "LoadLibarary failed, setScaleMode, mode:%d", scaleMode);
            return false;
        }
        YMFLog.info(this, "[Render  ]", "setScaleMode, mode:%d", scaleMode);
        return this.SetScaleMode(this.context, scaleMode);
    }

    public boolean setRotateAngle(int rotateAngle) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[Render  ]", "LoadLibarary failed, setRotateAngle, rotateAngle:%d", rotateAngle);
            return false;
        }
        YMFLog.info(this, "[Render  ]", "setRotateAngle, rotateAngle:%d", rotateAngle);
        return this.SetRotageAngle(this.context, rotateAngle);
    }

    public boolean setClearColor(int color) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[Render  ]", "LoadLibarary failed,setClearColor, color:%d", color);
            return false;
        }
        YMFLog.error(this, "[Render  ]", "YYVideoView setClearColor, color:%d", color);
        this.bgColor = color;
        return this.SetClearColor(this.context, (byte)Color.red((int)color), (byte)Color.green((int)color), (byte)Color.blue((int)color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean linkToVideo(long userGroupId, long streamId) {
        YVideoViewExt yVideoViewExt = this;
        synchronized (yVideoViewExt) {
            if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
                YMFLog.error(this, "[Render  ]", "LoadLibarary failed,linkToVideo groupId:%d %d, streamId:%d %d, context:%d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, this.context);
                return false;
            }
            int result = this.LinkToVideoStream(this.context, userGroupId, streamId);
            YMFLog.info(this, "[Render  ]", "linkFromVideo groupId:%d %d, streamId:%d %d, res:%d, context:%d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, result, this.context);
            this.playNotify.EndPlay(false);
            this.playNotify.setVideoIds(userGroupId, streamId);
            StateMonitor.instance().NotifyAddView(streamId, 0, VideoConstant.ViewType.NO_GL_VIDEO_VIEW, "YVideoViewExt");
            return result == 0;
        }
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        this.unLinkFromStream(userGroupId, streamId);
    }

    public boolean unlinkFromVideo(long userGroupId, long streamId) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[Render  ]", "LoadLibarary failed, unlinkFromVideo groupId:%d %d, streamId:%d %d, context:%d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, this.context);
            return false;
        }
        StateMonitor.instance().NotifyRemoveView(streamId);
        int result = this.UnlinkFromVideoStream(this.context, userGroupId, streamId);
        if (this.playNotify != null) {
            this.playNotify.EndPlay(true);
        }
        YMFLog.info(this, "[Render  ]", "unlinkFromVideo groupId:%d %d, streamId:%d %d, res:%d context:%d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, result, this.context);
        return result == 0;
    }

    public boolean isLinkToVideo(long userGroupId, long streamId) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render  ]", "LoadLibarary failed, IsLinkToVideoStream");
            return false;
        }
        return this.IsLinkToVideoStream(this.context, userGroupId, streamId);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[Render  ]", "LoadLibarary failed, SetSurfaceState, context:%d, state:%d", this.context, 0);
            return;
        }
        this.ChangeSurface(this.context, holder.getSurface());
        YMFLog.info(this, "[Render  ]", "SetSurfaceState, context:%d, state:%d", this.context, 0);
        this.SetSurfaceState(this.context, 0);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render  ]", "LoadLibarary failed, ChangeFrame");
            return;
        }
        YMFLog.info(this, "[Render  ]", "ChangeFrame, width:%d, height:%d, context:%d", width, height, this.context);
        this.ChangeFrame(this.context, 0, 0, width, height);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[Render  ]", "LoadLibarary failed, SetSurfaceState, context:%d state:%d.", this.context, 1);
            return;
        }
        YMFLog.info(this, "[Render  ]", "YYVideoView.SetSurfaceState, context:%d state:%d.", this.context, 1);
        this.SetSurfaceState(this.context, 1);
    }

    public void newRenderFrameArrived(int index) {
        long T1;
        if (this.mLastStatisticsTime == 0L) {
            this.mLastStatisticsTime = System.currentTimeMillis();
        }
        if (!this.mFrameRendered.get()) {
            this.mMissRenderFrameCount.getAndIncrement();
        }
        if ((T1 = System.currentTimeMillis()) - this.mLastStatisticsTime >= 6000L) {
            StateMonitor.NotifyRenderLostRate(this.mStreamId, (float)(this.mMissRenderFrameCount.getAndSet(0) * 1000) / (float)(T1 - this.mLastStatisticsTime));
            this.mLastStatisticsTime = T1;
        }
        this.mFrameRendered.set(false);
    }

    public ByteBuffer createByteBuffer(int index, int width, int height, int bits) {
        block8: {
            if (this.drawBmp != null) {
                this.drawBmp.recycle();
                this.drawBmp = null;
                this.bmpByteBuffer = null;
            }
            this.picWidth = width;
            this.picHeight = height;
            try {
                if (bits == 32) {
                    this.drawBmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    break block8;
                }
                if (bits == 16) {
                    this.drawBmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
                    break block8;
                }
                return null;
            }
            catch (OutOfMemoryError oom) {
                YMFLog.error((Object)this, "[Render  ]", "createBitmap out of memory!");
                return null;
            }
        }
        if (this.bmpByteBuffer != null) {
            return this.bmpByteBuffer;
        }
        try {
            this.bmpByteBuffer = ByteBuffer.allocateDirect(bits / 8 * width * height);
        }
        catch (Throwable e) {
            YMFLog.error((Object)this, "[Render  ]", "allocate buffer exception:" + e.getMessage());
        }
        this.mFirstFrameArrivedTime = System.currentTimeMillis();
        return this.bmpByteBuffer;
    }

    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        return this.getVideoScreenshot();
    }

    @Override
    public Bitmap getVideoScreenshot() {
        if (this.drawBmp == null || this.drawBmp.isRecycled() || this.mPicRealWidth == 0) {
            return null;
        }
        return Bitmap.createBitmap((Bitmap)this.drawBmp, (int)0, (int)0, (int)this.mPicRealWidth, (int)this.picHeight);
    }

    public void drawCanvas(int index, int x, int y, int width, int height, int picRealWidth) {
        if (this.bmpByteBuffer == null) {
            YMFLog.error((Object)this, "[Render  ]", "Invalid draw canvas request, byte buffer is not found!");
            return;
        }
        if (this.drawBmp == null || this.drawBmp.isRecycled()) {
            YMFLog.error((Object)this, "[Render  ]", "Invalid draw canvas request, draw bitmap is not found!");
            return;
        }
        this.mPicRealWidth = picRealWidth;
        Rect srcRect = new Rect(0, 0, picRealWidth, this.picHeight);
        RectF dstRect = new RectF((float)x, (float)y, (float)width, (float)height);
        try {
            Canvas canvas;
            this.bmpByteBuffer.rewind();
            this.drawBmp.copyPixelsFromBuffer((Buffer)this.bmpByteBuffer);
            this.playNotify.DrawNotify();
            if (!this.mFirstFrameSeeFlag) {
                YYVideoLibMgr.instance().onFirstFrameSeeNotify(this.mGroupId, this.mStreamId, System.currentTimeMillis() - this.mFirstFrameArrivedTime);
                this.mFirstFrameSeeFlag = true;
            }
            if ((canvas = this.getHolder().lockCanvas()) != null) {
                canvas.drawColor(this.bgColor, PorterDuff.Mode.CLEAR);
                if (this.mAutoOrientation && picRealWidth < this.picHeight != canvas.getWidth() < canvas.getHeight()) {
                    this.caculateNewRenderDstRect(dstRect);
                    canvas.rotate(90.0f, (dstRect.left + dstRect.right) / 2.0f, (dstRect.top + dstRect.bottom) / 2.0f);
                }
                canvas.drawBitmap(this.drawBmp, srcRect, dstRect, null);
                this.getHolder().unlockCanvasAndPost(canvas);
                canvas = null;
                ++this.mRenderCnt;
                this.mCurTime = TimeUtil.getTickCount();
                if (this.mLastTime == 0L) {
                    this.mLastTime = this.mCurTime;
                    StateMonitor.NotifyFirstFrameRendered(this.mStreamId, this.mCurTime);
                }
                if (this.mCurTime - this.mLastTime >= 1000L) {
                    StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId, this.mRenderCnt);
                    this.mLastTime = this.mCurTime;
                    this.mRenderCnt = 0;
                }
                this.mFrameRendered.set(true);
            } else {
                YMFLog.error((Object)this, "[Render  ]", "Lock canvas failed!");
            }
        }
        catch (Throwable e) {
            YMFLog.error((Object)this, "[Render  ]", "drawCanvas exception:" + e.getMessage());
        }
    }

    private void caculateNewRenderDstRect(RectF rec) {
        float videoWidth = rec.bottom - rec.top;
        float videoHeight = rec.right - rec.left;
        float canvasWidth = this.getWidth();
        float canvasHeight = this.getHeight();
        float wRatio = videoWidth / canvasWidth;
        float hRatio = videoHeight / canvasHeight;
        float renderWidth = canvasWidth;
        float renderHeight = canvasHeight;
        if (wRatio >= hRatio) {
            renderWidth = canvasWidth;
            renderHeight = videoHeight / wRatio;
        } else {
            renderWidth = videoWidth / hRatio;
            renderHeight = canvasHeight;
        }
        float tmp = renderWidth;
        renderWidth = renderHeight;
        renderHeight = tmp;
        float renderX = (canvasWidth - renderWidth) / 2.0f;
        float renderY = (canvasHeight - renderHeight) / 2.0f;
        rec.left = renderX;
        rec.right = renderX + renderWidth;
        rec.top = renderY;
        rec.bottom = renderY + renderHeight;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        this.mVideoInfoCallback = iVideoInfoCallback;
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        return null;
    }

    private native long CreateView(int var1, int var2, boolean var3);

    private native void ReleaseView(long var1);

    private native void ChangeSurface(long var1, Object var3);

    private native void SetSurfaceState(long var1, int var3);

    private native void ChangeFrame(long var1, int var3, int var4, int var5, int var6);

    private native boolean SetScaleMode(long var1, int var3);

    private native boolean SetRotageAngle(long var1, int var3);

    private native boolean SetClearColor(long var1, byte var3, byte var4, byte var5);

    private native boolean IsLinkToVideoStream(long var1, long var3, long var5);

    private native int LinkToVideoStream(long var1, long var3, long var5);

    private native int UnlinkFromVideoStream(long var1, long var3, long var5);

    public static native int LoadTest();
}

