/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YLightweightVideoViewExt;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import java.lang.ref.WeakReference;

public class YTextureVideoViewExt
extends TextureView
implements YSpVideoView,
TextureView.SurfaceTextureListener,
YLightweightVideoViewExt {
    private Surface mSurface;
    private WeakReference<HardDecodeWay> mWeakHard;
    private int mWidth = 64;
    private int mHeight = 64;
    private int mParentWidth = 64;
    private int mParentHeight = 64;
    private VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    private YSpVideoView.OrientationType mOrientationType = YSpVideoView.OrientationType.Normal;
    private int mRotateAngle = 0;
    private PlayNotify mPlayNotify;
    private long mUserGroupId;
    private long mStreamId;
    boolean mIsReleased = false;
    private IVideoInfoCallback mVideoInfoCallback = null;

    @Override
    public void stopRender() {
    }

    public YTextureVideoViewExt(Context context) {
        super(context.getApplicationContext());
        this.init();
    }

    public YTextureVideoViewExt(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context.getApplicationContext(), attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public YTextureVideoViewExt(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context.getApplicationContext(), attrs, defStyleAttr);
        this.init();
    }

    public YTextureVideoViewExt(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.init();
    }

    private void notifySurfaceToDecoderStaff(boolean fromSurfaceChange) {
        if (this.mWeakHard == null || this.mSurface == null) {
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return;
        }
        hardDecodeWay.SetPlayNotify(this.mPlayNotify);
        this.notifySurfaceCreatedToDecoderStaff();
        hardDecodeWay.OnSurfaceChanged((View)this, this.mSurface, this.mWidth, this.mHeight, this.mParentWidth, this.mParentHeight, this.mRotateAngle, this.mOrientationType, this.mScaleMode);
    }

    private void notifySurfaceRedrawToDecoderStaff() {
        if (this.mWeakHard == null) {
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return;
        }
        hardDecodeWay.OnSurfaceRedraw();
    }

    private void notifyDecoderStaffToReleaseSurface() {
        if (this.mWeakHard == null) {
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return;
        }
        hardDecodeWay.SetPlayNotify(null);
        if (this.mSurface != null) {
            hardDecodeWay.OnSurfaceDestroyed(this.mSurface);
            hardDecodeWay.setVideoInfoCallback(null);
        }
    }

    private void notifySurfaceCreatedToDecoderStaff() {
        if (this.mWeakHard == null) {
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return;
        }
        hardDecodeWay.OnSurfaceCreated();
    }

    @Override
    public void HoldDecoderStaff() {
        HardDecodeWay hardDecodeWay = VideoDecoderCenterExt.getDecoderStaff(this.mStreamId);
        if (hardDecodeWay != null) {
            this.mWeakHard = new WeakReference<HardDecodeWay>(hardDecodeWay);
            this.notifySurfaceToDecoderStaff(false);
            hardDecodeWay.setVideoInfoCallback(this.mVideoInfoCallback);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        YMFLog.info(this, "[Render  ]", "SurfaceTextureAvailable streamId:" + this.mStreamId + ", userGroupId:" + this.mUserGroupId + ",width:" + width + ",height:" + height);
        this.mWidth = width;
        this.mHeight = height;
        this.notifySurfaceToDecoderStaff(true);
        this.notifySurfaceRedrawToDecoderStaff();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        YMFLog.info(this, "[Render  ]", "Texture width:" + width + ",height:" + height);
        this.mWidth = width;
        this.mHeight = height;
        this.notifySurfaceToDecoderStaff(true);
        this.notifySurfaceRedrawToDecoderStaff();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        YMFLog.info(this, "[Render  ]", "SurfaceTextureDestroyed streamId:" + this.mStreamId + ", userGroupId:" + this.mUserGroupId);
        this.notifyDecoderStaffToReleaseSurface();
        this.mSurface.release();
        this.mSurface = null;
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.TXHardView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        this.notifySurfaceToDecoderStaff(false);
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        this.notifySurfaceToDecoderStaff(false);
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        return this.mScaleMode;
    }

    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        return this.getVideoScreenshot();
    }

    @Override
    public Bitmap getVideoScreenshot() {
        if (this.mWeakHard == null) {
            return null;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return null;
        }
        return hardDecodeWay.GetScreenShot();
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        this.mPlayNotify.setPlayListner(pl);
    }

    @Override
    public void linkToStream(long userGroupId, long streamId) {
        YMFLog.info(this, "[Render  ]", "linktostream streamId:" + streamId + ", userGroupId:" + userGroupId);
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
        if (this.mPlayNotify != null) {
            this.mPlayNotify.EndPlay(false);
            this.mPlayNotify.setVideoIds(userGroupId, streamId);
        }
        VideoDecoderCenterExt.Link(streamId, this);
        this.HoldDecoderStaff();
        ViewLiveStatManager.getInstace().notifyEventTime(0, 1);
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        this.notifyDecoderStaffToReleaseSurface();
        VideoDecoderCenterExt.Unlink(streamId);
        if (this.mPlayNotify != null) {
            this.mPlayNotify.EndPlay(true);
        }
        this.mWeakHard = null;
        ViewLiveStatManager.getInstace().notifyEventTime(4, 1);
        YMFLog.info(this, "[Render  ]", "unlinktostream streamId:" + streamId + ", userGroupId:" + userGroupId);
    }

    @Override
    public void unLinkFromStream() {
        YMFLog.info(this, "[Render  ]", "unlinktostream no param,streamId:" + this.mStreamId);
        this.notifyDecoderStaffToReleaseSurface();
        VideoDecoderCenterExt.Unlink(this.mStreamId);
        if (this.mPlayNotify != null) {
            this.mPlayNotify.EndPlay(true);
        }
        this.mWeakHard = null;
        ViewLiveStatManager.getInstace().notifyEventTime(4, 1);
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        this.unLinkFromStream(userGroupId, streamId);
    }

    @Override
    public void init() {
        this.setSurfaceTextureListener(this);
        try {
            this.setFocusable(true);
            this.setBackgroundColor(0);
            this.mPlayNotify = new PlayNotify();
            this.mPlayNotify.Init();
            this.mIsReleased = false;
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Render  ]", "failed to init notifier, exception:" + e.toString());
        }
    }

    @Override
    public void release() {
        block3: {
            try {
                this.mIsReleased = true;
                if (this.mPlayNotify != null) {
                    this.mPlayNotify.Release();
                    this.mPlayNotify = null;
                }
            }
            catch (Exception e) {
                if (e == null) break block3;
                YMFLog.error((Object)this, "[Render  ]", "release exception:" + e.getMessage());
            }
        }
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        this.mOrientationType = orientationType;
        this.mRotateAngle = rotateAngle;
        this.notifySurfaceToDecoderStaff(false);
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
        this.mParentWidth = w;
        this.mParentHeight = h;
        this.notifySurfaceToDecoderStaff(false);
    }

    @Override
    public boolean isReleased() {
        return this.mIsReleased;
    }

    @Override
    public YYRenderFrameBuffer getRenderFrameBuffer() {
        return null;
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        this.mVideoInfoCallback = iVideoInfoCallback;
        if (this.mWeakHard == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mWeakHard == null");
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface hardDecodeWay == null");
            return;
        }
        hardDecodeWay.setVideoInfoCallback(iVideoInfoCallback);
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        if (this.mWeakHard == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mWeakHard == null");
            return null;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface hardDecodeWay == null");
            return null;
        }
        return hardDecodeWay.getVideoViewInfo(streamid);
    }
}

