/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YLightweightVideoViewExt;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import java.lang.ref.WeakReference;

public class YSurfaceVideoViewExt
extends SurfaceView
implements SurfaceHolder.Callback2,
YSpVideoView,
YLightweightVideoViewExt {
    private static final String TAG = "YSurfaceVideoViewExt";
    private WeakReference<HardDecodeWay> mWeakHard;
    private SurfaceHolder mSurfaceHolder;
    private int mWidth = 64;
    private int mHeight = 64;
    private int mParentWidth = 64;
    private int mParentHeight = 64;
    private VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    private YSpVideoView.OrientationType mOrientationType = YSpVideoView.OrientationType.Normal;
    private int mRotateAngle = 0;
    private PlayNotify mPlayNotify;
    private long mUserGroupId;
    private long mStreamId;
    private boolean mIsReleased = false;
    private boolean mIsVrStream = false;
    private IVideoInfoCallback mVideoInfoCallback = null;
    private Object mLockObject = new Object();

    @Override
    public void stopRender() {
    }

    public YSurfaceVideoViewExt(Context context) {
        super(context.getApplicationContext());
        this.init();
    }

    public YSurfaceVideoViewExt(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.init();
    }

    public YSurfaceVideoViewExt(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context.getApplicationContext(), attrs, defStyleAttr);
        this.init();
    }

    public YSurfaceVideoViewExt(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context.getApplicationContext(), attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySurfaceToDecoderStaff(boolean fromSurfaceChange) {
        YSurfaceVideoViewExt ySurfaceVideoViewExt = this;
        synchronized (ySurfaceVideoViewExt) {
            if (this.mWeakHard == null || this.mSurfaceHolder == null) {
                return;
            }
            HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
            if (hardDecodeWay == null) {
                return;
            }
            try {
                SurfaceHolder tmpSurfaceHolder = this.mSurfaceHolder;
                if (tmpSurfaceHolder == null) {
                    return;
                }
                hardDecodeWay.SetPlayNotify(this.mPlayNotify);
                hardDecodeWay.setVrStream(this.mIsVrStream);
                hardDecodeWay.OnSurfaceCreated();
                hardDecodeWay.OnSurfaceChanged((View)this, tmpSurfaceHolder.getSurface(), this.mWidth, this.mHeight, this.mParentWidth, this.mParentHeight, this.mRotateAngle, this.mOrientationType, this.mScaleMode);
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Render  ]", "notifySurfaceToDecoderStaff exception:" + YMFLog.stackTraceOf(e));
            }
        }
    }

    private void notifySurfaceCreatedToDecoderStaff() {
        if (this.mWeakHard == null) {
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return;
        }
        hardDecodeWay.OnSurfaceCreated();
    }

    private void notifySurfaceRedrawToDecoderStaff() {
        if (this.mWeakHard == null) {
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return;
        }
        hardDecodeWay.OnSurfaceRedraw();
    }

    private void notifyDecoderStaffToReleaseSurface() {
        if (this.mWeakHard == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mWeakHard == null");
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface hardDecodeWay == null");
            return;
        }
        hardDecodeWay.SetPlayNotify(null);
        if (this.mSurfaceHolder != null) {
            hardDecodeWay.OnSurfaceDestroyed(this.mSurfaceHolder.getSurface());
            hardDecodeWay.setVideoInfoCallback(null);
        } else {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mSurfaceHolder == null");
        }
    }

    @Override
    public void HoldDecoderStaff() {
        HardDecodeWay hardDecodeWay = VideoDecoderCenterExt.getDecoderStaff(this.mStreamId);
        YMFLog.info(this, "[Render  ]", "HoldDecoderStaff mStreamId:" + this.mStreamId + " hardDecodeWay:" + (hardDecodeWay != null));
        if (hardDecodeWay != null) {
            this.mWeakHard = new WeakReference<HardDecodeWay>(hardDecodeWay);
            this.notifySurfaceToDecoderStaff(false);
            hardDecodeWay.setVideoInfoCallback(this.mVideoInfoCallback);
        }
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
        this.notifySurfaceRedrawToDecoderStaff();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        this.notifySurfaceCreatedToDecoderStaff();
        YMFLog.info(this, "[Render  ]", "surfaceCreated streamId:" + this.mStreamId + ", userGroupId:" + this.mUserGroupId);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        YMFLog.info(this, "[Render  ]", "surfaceChanged streamId:" + this.mStreamId + " userGroupId:" + this.mUserGroupId + " width:" + width + " height:" + height);
        this.mSurfaceHolder = holder;
        this.mWidth = width;
        this.mHeight = height;
        this.notifySurfaceToDecoderStaff(true);
        this.notifySurfaceRedrawToDecoderStaff();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(this, "[Render  ]", "surfaceDestroyed streamId:" + this.mStreamId + ", userGroupId:" + this.mUserGroupId);
        this.mSurfaceHolder = holder;
        this.notifyDecoderStaffToReleaseSurface();
        this.mSurfaceHolder = null;
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.SFHardView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        YMFLog.info(this, "[Render  ]", "setScaleMode:" + (Object)((Object)scaleMode));
        this.mScaleMode = scaleMode;
        this.notifySurfaceToDecoderStaff(false);
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        YMFLog.info(this, "[Render  ]", "setScaleMode:" + (Object)((Object)scaleMode));
        this.mScaleMode = scaleMode;
        this.notifySurfaceToDecoderStaff(false);
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        return this.mScaleMode;
    }

    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        return this.getVideoScreenshot();
    }

    @Override
    public Bitmap getVideoScreenshot() {
        if (this.mWeakHard == null) {
            return null;
        }
        YMFLog.info(this, "[Render  ]", "getVideoScreenshot");
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return null;
        }
        return hardDecodeWay.GetScreenShot();
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        this.mPlayNotify.setPlayListner(pl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkToStream(long userGroupId, long streamId) {
        YMFLog.info(this, "[Render  ]", "linktostream streamId:" + streamId + ", userGroupId:" + userGroupId);
        Object object = this.mLockObject;
        synchronized (object) {
            this.mUserGroupId = userGroupId;
            this.mStreamId = streamId;
            if (this.mPlayNotify != null) {
                this.mPlayNotify.EndPlay(false);
                this.mPlayNotify.setVideoIds(userGroupId, streamId);
            }
            VideoDecoderCenterExt.Link(streamId, this);
            this.HoldDecoderStaff();
            StateMonitor.instance().NotifyAddView(this.mStreamId, 0, VideoConstant.ViewType.SURFACE_VIDEO_VIEW, TAG);
            ViewLiveStatManager.getInstace().notifyEventTime(0, 0);
        }
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        this.unLinkFromStream(userGroupId, streamId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLinkFromStream() {
        YMFLog.info(this, "[Render  ]", "unlinktostream no param, mStreamId:" + this.mStreamId);
        Object object = this.mLockObject;
        synchronized (object) {
            this.notifyDecoderStaffToReleaseSurface();
            VideoDecoderCenterExt.Unlink(this.mStreamId);
            if (this.mPlayNotify != null) {
                this.mPlayNotify.EndPlay(true);
            }
            this.mWeakHard = null;
            StateMonitor.instance().NotifyRemoveView(this.mStreamId);
            ViewLiveStatManager.getInstace().notifyEventTime(4, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        YMFLog.info(this, "[Render  ]", "unlinktostream streamId:" + streamId + ", userGroupId:" + userGroupId);
        Object object = this.mLockObject;
        synchronized (object) {
            this.notifyDecoderStaffToReleaseSurface();
            VideoDecoderCenterExt.Unlink(streamId);
            if (this.mPlayNotify != null) {
                this.mPlayNotify.EndPlay(true);
            }
            this.mWeakHard = null;
            StateMonitor.instance().NotifyRemoveView(this.mStreamId);
            ViewLiveStatManager.getInstace().notifyEventTime(4, 0);
        }
    }

    @Override
    public void init() {
        try {
            YMFLog.info(this, "[Render  ]", "YSurfaceVideoView init");
            this.setFocusable(true);
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            this.setBackgroundColor(0);
            this.mPlayNotify = new PlayNotify();
            this.mPlayNotify.Init();
            this.mIsReleased = false;
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Render  ]", "YSurfaceVideoView failed init, exception:" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        YMFLog.info(this, "[Render  ]", "YSurfaceVideoView release");
        Object object = this.mLockObject;
        synchronized (object) {
            block6: {
                try {
                    this.mIsReleased = true;
                    if (this.mPlayNotify != null) {
                        this.mPlayNotify.Release();
                        this.mPlayNotify = null;
                    }
                }
                catch (Exception e) {
                    if (e == null) break block6;
                    YMFLog.error((Object)this, "[Render  ]", "release playNotify exception:" + e.getMessage());
                }
            }
        }
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        YMFLog.info(this, "[Render  ]", "setOrientation orientationType:" + (Object)((Object)orientationType) + " rotateAngle:" + rotateAngle);
        this.mOrientationType = orientationType;
        this.mRotateAngle = rotateAngle;
        this.notifySurfaceToDecoderStaff(false);
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
        YMFLog.info(this, "[Render  ]", "onParentSizeChanged width:" + w + " height:" + h);
        this.mParentWidth = w;
        this.mParentHeight = h;
        this.notifySurfaceToDecoderStaff(false);
    }

    @Override
    public boolean isReleased() {
        return this.mIsReleased;
    }

    @Override
    public YYRenderFrameBuffer getRenderFrameBuffer() {
        return null;
    }

    @Override
    public void setVrStream(boolean vrStream) {
        this.mIsVrStream = vrStream;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        this.mVideoInfoCallback = iVideoInfoCallback;
        if (this.mWeakHard == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mWeakHard == null");
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface hardDecodeWay == null");
            return;
        }
        hardDecodeWay.setVideoInfoCallback(iVideoInfoCallback);
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        if (this.mWeakHard == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mWeakHard == null");
            return null;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface hardDecodeWay == null");
            return null;
        }
        return hardDecodeWay.getVideoViewInfo(streamid);
    }
}

