/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.SmoothnessCounter;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoSizeUtils;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.decoder.gles_decoder.EglCore;
import com.yy.videoplayer.decoder.gles_decoder.FullFrameRect;
import com.yy.videoplayer.decoder.gles_decoder.GlUtil;
import com.yy.videoplayer.decoder.gles_decoder.Texture2dProgram;
import com.yy.videoplayer.decoder.gles_decoder.WindowSurface;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.stat.PlayerExceptionDataStat;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.stat.YMFPlayerUsrBehaviorStat;
import com.yy.videoplayer.utils.GLUtil;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.VideoEntities;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.VideoPosition;
import com.yy.videoplayer.videoview.VsyncRelay;
import com.yy.videoplayer.videoview.YMultiVideoViewParams;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import com.yy.videoplayer.vr.VRLibrary;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class YCustomGLVideoViewHighEGLMultiVideo
extends SurfaceView
implements Runnable,
VsyncRelay.VsyncNotifier,
SurfaceHolder.Callback2,
YSpVideoView {
    private static final String TAG = "YCustomGLVideoViewHighEGLMultiVideo";
    private static final int MSG_QUIT = 0;
    private static final int MSG_SURFACE_REDRAWNEEDED = 1;
    private static final int MSG_SURFACE_CREATED = 2;
    private static final int MSG_SURFACE_CHANGED = 3;
    private static final int MSG_SURFACE_DESTROYED = 4;
    private static final int MSG_SET_SCALEMODE = 5;
    private static final int MSG_GET_SCREENSHOT = 6;
    private static final int MSG_SET_PLAYLISTENER = 7;
    private static final int MSG_LINKTOSTREAM = 8;
    private static final int MSG_UNLINKTOSTREAM = 9;
    private static final int MSG_SET_ORIENTATION = 10;
    private static final int MSG_VSYNC_ARRIVED = 11;
    private static final int MSG_LINKTOSTREAMEXT = 12;
    private static final int MSG_UNLINKTOSTREAMEXT = 13;
    private static final int MSG_SET_SCALEMODEEXT = 14;
    private static final int MSG_GET_SCREENSHOTEXT = 15;
    private static final int MSG_SETVIDEINFOCALLBACK = 16;
    private static final int MSG_UPDATE_LAYOUT = 17;
    private static final int MSG_NEW_YUV_FRAME_ARRIVE = 18;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private final Object mStartLock = new Object();
    private final Object mQuitLock = new Object();
    private final Object mScreenShotLock = new Object();
    private final Object mSurfaceDestroyLock = new Object();
    private RenderHandler mHandler;
    private EglCore mEglCore;
    private EGLSurface mEnvSurface;
    private FullFrameRect mVideoScreen;
    private FullFrameRect mBackgroundScreen;
    private WindowSurface mVideoWindowSurface;
    private TexturePack mYChannel;
    private TexturePack mUChannel;
    private TexturePack mVChannel;
    private int[] mImageWidth;
    private int[] mImageHeight;
    private int[] mImageStrideWidth;
    private float[] mSrcTransform;
    private float[] mTransform;
    private VideoEntities.VideoSizes[] mVideoSizes;
    private SurfaceScaleInfo[] mSurfaceScaleInfo;
    private boolean mIsImageLoaded = false;
    private Thread mThread;
    private PlayNotify mPlayNotify;
    private YYRenderFrameBuffer[] mFrameBuffer;
    private long[] mUserGroupId;
    private long[] mStreamId;
    private SmoothnessCounter mSmoothnessCounter = new SmoothnessCounter(5000L);
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys = new ArrayList();
    private IVideoInfoCallback mVideoInfoCallback = null;
    private YYRenderFrameBuffer.newYUVFrameArrivedCallBack mFrameCallbck;
    private ReentrantLock mSurfaceDestoryedLock = new ReentrantLock(true);
    private AtomicBoolean mSurfaceDestoryedState = new AtomicBoolean(false);
    private static final int VIDEO_DATA_LOG = 500;
    private long[] mVideoDataCnt;
    private long[] mRenderFailCnt;
    private VRLibrary mVRLibrary;
    private boolean mIsVrStream = false;
    private boolean mStopRender = false;
    private boolean[] mFirstFrameRendered;
    private long[] mFirstFrameTs;
    private int[] mFrames;
    private int[] mRenderCnt;
    private long[] mCurTime;
    private long[] mLastTime;
    private int mRowCnt = 0;
    private int mColCnt = 0;
    private int mTotalVideoCnt = 0;
    private VideoPosition[] mDrawPosition;
    private int mBackGroundTexture = -1;
    private Bitmap mBackGroundBitmap = null;
    private VideoPosition mBackGroundPosition = null;
    private VideoPosition[] originposition;
    private VideoPosition originBackGroundPosition;
    private boolean[] mFirstFrameSeeFlag;
    private YspVideoViewInfo mViewVideoInfo = new YspVideoViewInfo();
    private long mMultiStreamID = 11111L;
    private VsyncRelay mVsyncRelay = VsyncRelay.getInstance();
    private int mSurfaceWidth = 0;
    private int mSurfaceHeight = 0;
    static final long kNotifyTimeGap = 500L;
    static final int kNofifySizeGap = 15;
    long vsyncT = 0L;
    long vsyncCnt = 0L;
    long index = 0L;

    @Override
    public void stopRender() {
        this.mStopRender = true;
    }

    public void updateVideoPosition(int index) {
        int width_offset = this.mVideoSizes[index].mViewWidth / this.mRowCnt;
        int height_offset = this.mVideoSizes[index].mViewHeight / this.mColCnt;
        int x = this.mVideoSizes[index].mViewX;
        int y = this.mVideoSizes[index].mViewY + this.mVideoSizes[index].mViewHeight - height_offset;
        int width = width_offset;
        int height = height_offset;
        int videoIndex = 0;
        YMFLog.info(this, "[Render  ]", "updateVideoPosition mViewWidth:" + this.mVideoSizes[index].mViewWidth + " mVideoSizes.mViewHeight:" + this.mVideoSizes[index].mViewHeight + " x:" + x + " y:" + y + " width:" + width + " height:" + height);
        for (int i = 0; i < this.mColCnt; ++i) {
            for (int j = 0; j < this.mRowCnt; ++j) {
                this.mDrawPosition[videoIndex].mIndex = videoIndex;
                this.mDrawPosition[videoIndex].mX = x;
                this.mDrawPosition[videoIndex].mY = y;
                this.mDrawPosition[videoIndex].mWidth = width;
                this.mDrawPosition[videoIndex].mHeight = height;
                YMFLog.info(this, "[Render  ]", "updateVideoPosition videoIndex:" + videoIndex + " x:" + this.mDrawPosition[videoIndex].mX + " y:" + this.mDrawPosition[videoIndex].mY + " w:" + this.mDrawPosition[videoIndex].mWidth + " h:" + this.mDrawPosition[videoIndex].mHeight);
                ++videoIndex;
                x += width_offset;
            }
            x = this.mVideoSizes[index].mViewX;
            y -= height_offset;
        }
    }

    public YCustomGLVideoViewHighEGLMultiVideo(Context context, YMultiVideoViewParams params) {
        super(context.getApplicationContext());
        YMFLog.info(this, "[Render  ]", "new YCustomGLVideoViewHighEGLMultiVideo begin");
        this.mYChannel = new TexturePack();
        this.mUChannel = new TexturePack();
        this.mVChannel = new TexturePack();
        this.initParams(params);
        StateMonitor.NotifyMultiVideoOriginPosition(this.originposition, this.originBackGroundPosition);
        this.InitThread();
        YMFLog.info(this, "[Render  ]", "new YCustomGLVideoViewHighEGLMultiVideo done");
    }

    public YCustomGLVideoViewHighEGLMultiVideo(Context context, int row_count, int col_count, Bitmap bitmap) {
        super(context.getApplicationContext());
        this.mRowCnt = row_count;
        this.mColCnt = col_count;
        this.mTotalVideoCnt = this.mRowCnt * this.mColCnt;
        this.mDrawPosition = new VideoPosition[this.mTotalVideoCnt];
        this.mFrameBuffer = new YYRenderFrameBuffer[this.mTotalVideoCnt];
        this.mYChannel = new TexturePack();
        this.mUChannel = new TexturePack();
        this.mVChannel = new TexturePack();
        this.mVideoDataCnt = new long[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.mRenderFailCnt = new long[this.mTotalVideoCnt];
        this.mFirstFrameRendered = new boolean[this.mTotalVideoCnt];
        this.mFirstFrameTs = new long[this.mTotalVideoCnt];
        this.mFrames = new int[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.mCurTime = new long[this.mTotalVideoCnt];
        this.mLastTime = new long[this.mTotalVideoCnt];
        this.mFirstFrameSeeFlag = new boolean[this.mTotalVideoCnt];
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mDrawPosition[i] = new VideoPosition();
            this.mFrameBuffer[i] = new YYRenderFrameBuffer(true);
            this.mVideoDataCnt[i] = 0L;
            this.mRenderFailCnt[i] = 0L;
            this.mRenderCnt[i] = 0;
            this.mFirstFrameRendered[i] = false;
            this.mFirstFrameTs[i] = -1L;
            this.mFrames[i] = 0;
            this.mRenderCnt[i] = 0;
            this.mCurTime[i] = 0L;
            this.mLastTime[i] = 0L;
            this.mFirstFrameSeeFlag[i] = false;
        }
        this.mStreamId = new long[this.mTotalVideoCnt];
        this.mUserGroupId = new long[this.mTotalVideoCnt];
        this.mBackGroundBitmap = bitmap;
        this.mBackGroundPosition = new VideoPosition();
        this.mBackGroundBitmap = bitmap;
        YMFLog.info(this, "[Render  ]", "YCustomGLVideoViewHighEGLMultiVideo row_count:" + row_count + " col_count:" + col_count);
        this.InitThread();
    }

    public YCustomGLVideoViewHighEGLMultiVideo(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.InitThread();
    }

    public YCustomGLVideoViewHighEGLMultiVideo(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context.getApplicationContext(), attrs, defStyleAttr);
        this.InitThread();
    }

    public YCustomGLVideoViewHighEGLMultiVideo(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context.getApplicationContext(), attrs, defStyleAttr, defStyleRes);
        this.InitThread();
    }

    private void initParams(YMultiVideoViewParams params) {
        this.mTotalVideoCnt = params.mTotalVideoCnt;
        this.mDrawPosition = new VideoPosition[this.mTotalVideoCnt];
        this.originposition = new VideoPosition[this.mTotalVideoCnt];
        this.mFrameBuffer = new YYRenderFrameBuffer[this.mTotalVideoCnt];
        this.mVideoDataCnt = new long[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.mRenderFailCnt = new long[this.mTotalVideoCnt];
        this.mFirstFrameRendered = new boolean[this.mTotalVideoCnt];
        this.mFirstFrameTs = new long[this.mTotalVideoCnt];
        this.mFrames = new int[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.mCurTime = new long[this.mTotalVideoCnt];
        this.mLastTime = new long[this.mTotalVideoCnt];
        this.mVideoSizes = new VideoEntities.VideoSizes[this.mTotalVideoCnt];
        this.mSurfaceScaleInfo = new SurfaceScaleInfo[this.mTotalVideoCnt];
        this.mImageWidth = new int[this.mTotalVideoCnt];
        this.mImageHeight = new int[this.mTotalVideoCnt];
        this.mImageStrideWidth = new int[this.mTotalVideoCnt];
        this.mFirstFrameSeeFlag = new boolean[this.mTotalVideoCnt];
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mDrawPosition[i] = new VideoPosition();
            this.originposition[i] = new VideoPosition();
            YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.mDrawPosition[i]);
            YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.originposition[i]);
            this.mFrameBuffer[i] = new YYRenderFrameBuffer(true);
            this.mVideoSizes[i] = new VideoEntities.VideoSizes();
            this.mSurfaceScaleInfo[i] = new SurfaceScaleInfo();
            this.mVideoDataCnt[i] = 0L;
            this.mRenderFailCnt[i] = 0L;
            this.mRenderCnt[i] = 0;
            this.mFirstFrameRendered[i] = false;
            this.mFirstFrameTs[i] = -1L;
            this.mFrames[i] = 0;
            this.mRenderCnt[i] = 0;
            this.mCurTime[i] = 0L;
            this.mLastTime[i] = 0L;
            this.mFirstFrameSeeFlag[i] = false;
        }
        this.mStreamId = new long[this.mTotalVideoCnt];
        this.mUserGroupId = new long[this.mTotalVideoCnt];
        this.mBackGroundBitmap = params.background;
        if (this.mBackGroundBitmap != null && this.mBackGroundTexture >= 0) {
            GLUtil.updateTextureWithBitmap(this.mBackGroundTexture, this.mBackGroundBitmap);
        }
        this.mBackGroundPosition = new VideoPosition();
        this.originBackGroundPosition = new VideoPosition();
        if (this.mBackGroundBitmap != null) {
            YMultiVideoViewParams.clonePosition(params.backgroudPosition, this.mBackGroundPosition);
            YMultiVideoViewParams.clonePosition(params.backgroudPosition, this.originBackGroundPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitThread() {
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        YMFLog.info(this, "[Render  ]", "YCustomGLVideoView construct");
        YMFPlayerUsrBehaviorStat.getInstance().notifyGlManagerState(2, true);
        YMFPlayerUsrBehaviorStat.getInstance().notifyVideoPlayerViewState(2, true);
        this.mThread = new Thread(this);
        this.mThread.setPriority(10);
        this.mThread.setName("YCustomGLVideoView");
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                this.mThread.start();
                this.mStartLock.wait(500L);
            }
            catch (Throwable e) {
                YMFLog.error((Object)this, "[Render  ]", "init thread exception:" + e.getMessage());
            }
        }
        YMFLog.info(this, "[Render  ]", "YCustomGLVideoView construct done");
    }

    public void updateMultiVideoViewParams(YMultiVideoViewParams params) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(17, params));
        }
    }

    private void handleUpdateMultiVideoViewParams(YMultiVideoViewParams params) {
        YMFLog.info(this, "[Render  ]", "handleUpdateMultiVideoViewParams begin");
        this.tryLockSurfaceDestoryLock();
        if (params != null && params.mTotalVideoCnt != this.mTotalVideoCnt) {
            this.initParams(params);
        } else {
            if (params.background != null) {
                this.mBackGroundBitmap = params.background;
                if (this.mBackGroundBitmap != null && this.mBackGroundTexture >= 0) {
                    GLUtil.updateTextureWithBitmap(this.mBackGroundTexture, this.mBackGroundBitmap);
                } else if (this.mBackGroundBitmap != null && this.mBackGroundTexture <= 0) {
                    this.mBackGroundTexture = GLUtil.genTextureWithBitmap(this.mBackGroundBitmap);
                }
            }
            YMultiVideoViewParams.clonePosition(params.backgroudPosition, this.originBackGroundPosition);
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.mDrawPosition[i]);
                YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.originposition[i]);
            }
        }
        this.updateVideoLayout();
        this.tryUnlockSurfaceDestroyLock();
        YMFLog.info(this, "[Render  ]", "handleUpdateMultiVideoViewParams done");
        StateMonitor.NotifyMultiVideoOriginPosition(this.originposition, this.originBackGroundPosition);
    }

    @Override
    public YYRenderFrameBuffer getRenderFrameBuffer() {
        return this.mFrameBuffer[0];
    }

    public YYRenderFrameBuffer getRenderFrameBufferExt(int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt) {
            return null;
        }
        return this.mFrameBuffer[videoIndex];
    }

    @Override
    public void setVrStream(boolean vrStream) {
        this.mIsVrStream = vrStream;
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.CustomGLView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, (Object)scaleMode));
        }
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mSurfaceScaleInfo[0].scaleMode;
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        if (this.mReady.get()) {
            ScaleModeEx scaleModeEx = new ScaleModeEx();
            scaleModeEx.scaleMode = scaleMode;
            scaleModeEx.videoIndex = videoIndex;
            YMFLog.info(this, "[Render  ]", " setScaleModeEx videoIndex:" + videoIndex + " mode:" + (Object)((Object)scaleMode));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(14, scaleModeEx));
        }
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        if (videoIndex < 0 || videoIndex >= this.mTotalVideoCnt) {
            return VideoConstant.ScaleMode.FillParent;
        }
        return this.mSurfaceScaleInfo[videoIndex].scaleMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getVideoScreenshot() {
        Bitmap bmp = null;
        ScreenShotInfo info = new ScreenShotInfo();
        info.isSuccess = false;
        info.videoIndex = 0;
        if (this.mReady.get()) {
            Object object = this.mScreenShotLock;
            synchronized (object) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(6, info));
                try {
                    this.mScreenShotLock.wait(500L);
                }
                catch (Throwable t) {
                    YMFLog.info(this, "[Render  ]", "mScreenShot wait exception:" + t.getMessage());
                }
            }
        }
        if (info.isSuccess) {
            bmp = Bitmap.createBitmap((int)info.width, (int)info.height, (Bitmap.Config)Bitmap.Config.RGB_565);
            if (bmp == null) {
                YMFLog.error((Object)this, "[Render  ]", "create Bitmap failed!");
            } else {
                bmp.copyPixelsFromBuffer(info.pixelBuffer);
            }
        } else if (this.mStreamId[info.videoIndex] == 0L) {
            bmp = Bitmap.createBitmap((int)this.mDrawPosition[info.videoIndex].mWidth, (int)this.mDrawPosition[info.videoIndex].mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
            if (bmp == null) {
                YMFLog.error((Object)this, "[Render  ]", "create Bitmap failed!");
            } else {
                bmp.eraseColor(-16777216);
                YMFLog.info(this, "[Render  ]", "handleGetVideoScreenshotExt black ");
            }
        } else {
            YMFLog.error((Object)this, "[Render  ]", "GetScreenShot something wrong" + this.mStreamId[info.videoIndex]);
        }
        YMFLog.info(this, "[Render  ]", "GetScreenShot isSuccess:" + info.isSuccess + " width:" + info.width + " height:" + info.height);
        return bmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)this, "[Render  ]", "Invalid videoIndex:" + videoIndex);
            return null;
        }
        Bitmap bmp = null;
        ScreenShotInfo info = new ScreenShotInfo();
        info.isSuccess = false;
        info.videoIndex = videoIndex;
        if (this.mReady.get()) {
            Object object = this.mScreenShotLock;
            synchronized (object) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(15, info));
                try {
                    this.mScreenShotLock.wait(500L);
                }
                catch (Throwable t) {
                    YMFLog.info(this, "[Render  ]", "mScreenShot wait exception:" + t.getMessage());
                }
            }
        }
        if (info.isSuccess) {
            bmp = Bitmap.createBitmap((int)info.width, (int)info.height, (Bitmap.Config)Bitmap.Config.RGB_565);
            if (bmp == null) {
                YMFLog.error((Object)this, "[Render  ]", "create Bitmap failed!");
            } else {
                bmp.copyPixelsFromBuffer(info.pixelBuffer);
            }
        } else if (this.mStreamId != null && this.mStreamId[info.videoIndex] == 0L) {
            bmp = Bitmap.createBitmap((int)this.mDrawPosition[info.videoIndex].mWidth, (int)this.mDrawPosition[info.videoIndex].mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
            if (bmp == null) {
                YMFLog.error((Object)this, "[Render  ]", "create Bitmap failed!");
            } else {
                bmp.eraseColor(-16777216);
                YMFLog.info(this, "[Render  ]", "handleGetVideoScreenshotExt black ");
            }
        } else {
            YMFLog.error((Object)this, "[Render  ]", "GetScreenShot isSuccess:" + info.isSuccess + " width:" + info.width + " height:" + info.height + "index:" + videoIndex);
        }
        YMFLog.info(this, "[Render  ]", "GetScreenShot isSuccess:" + info.isSuccess + " width:" + info.width + " height:" + info.height);
        return bmp;
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(7, pl));
        }
    }

    @Override
    public void linkToStream(long userGroupId, long streamId) {
        this.linkToStreamExt(userGroupId, streamId, 0);
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)this, "[Render  ]", "video Index error, index:" + videoIndex);
            return;
        }
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewLinkStream(2, streamId, true);
        if (this.mReady.get()) {
            ViewLiveStatManager.getInstace().notifyEventTime(0, 3);
            StateMonitor.instance().NotifyAddView(streamId, videoIndex, VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_HIGH_MULTIVIDEO, TAG);
            StreamInfo si = new StreamInfo();
            si.userGroupId = userGroupId;
            si.streamId = streamId;
            si.videoIndex = videoIndex;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(12, si));
        }
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        this.unLinkFromStreamExt(userGroupId, streamId, 0);
    }

    @Override
    public void unLinkFromStream() {
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)this, "[Render  ]", "video Index error, index:" + videoIndex);
            return;
        }
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewLinkStream(2, streamId, false);
        if (this.mReady.get()) {
            StreamInfo si = new StreamInfo();
            si.userGroupId = userGroupId;
            si.streamId = streamId;
            si.videoIndex = videoIndex;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(13, si));
            StateMonitor.instance().NotifyRemoveView(streamId);
            ViewLiveStatManager.getInstace().notifyEventTime(4, 3);
        }
    }

    @Override
    public void init() {
        if (this.mThread == null) {
            this.InitThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        YMFLog.info(this, "[Render  ]", "release...");
        this.getHolder().removeCallback((SurfaceHolder.Callback)this);
        YMFPlayerUsrBehaviorStat.getInstance().notifyVideoPlayerViewState(2, false);
        if (this.mReady.get()) {
            Object object = this.mQuitLock;
            synchronized (object) {
                try {
                    this.mHandler.removeCallbacksAndMessages(11);
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
                    this.mQuitLock.wait(500L);
                    YMFLog.info(this, "[Render  ]", "YCustomGLVideoView Quit");
                }
                catch (Throwable e) {
                    YMFLog.error((Object)this, "[Render  ]", "YCustomGLVideoView Quit exception:" + e.getMessage());
                }
            }
            this.mThread = null;
            this.mStreamId = null;
            this.mUserGroupId = null;
        }
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(10, rotateAngle, adjustImmediately ? 1 : 0, (Object)orientationType));
        }
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
    }

    @Override
    public boolean isReleased() {
        return this.mThread == null;
    }

    @Override
    public void OnVsyncArrived(long frameTimeNanos) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(11, frameTimeNanos));
        }
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, holder.getSurface()));
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        YMFLog.info(this, "[Render  ]", "surface created");
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewOnSurface(2, true);
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, holder.getSurface()));
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        YMFLog.info(this, "[Render  ]", "surface changed width:%d height:%d", width, height);
        if (this.mReady.get()) {
            this.tryLockSurfaceDestoryLock();
            this.mSurfaceDestoryedState.set(false);
            this.tryUnlockSurfaceDestroyLock();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, width, height, holder.getSurface()));
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(TAG, "[Render  ]", "surface destroyed");
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewOnSurface(2, false);
        if (this.mReady.get()) {
            this.tryLockSurfaceDestoryLock();
            this.mSurfaceDestoryedState.set(true);
            this.tryUnlockSurfaceDestroyLock();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, holder.getSurface()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mHandler = new RenderHandler(this);
            this.mReady.set(true);
            this.InitEGL();
            YMFLog.info(this, "[Render  ]", "YCustomGLVideoView construct done GLThread");
            Object object = this.mStartLock;
            synchronized (object) {
                this.mStartLock.notifyAll();
            }
            Looper.loop();
            this.mReady.set(false);
        }
        catch (Throwable t) {
            PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mMultiStreamID, "2", "101", t.getMessage());
            YMFLog.error((Object)this, "[Render  ]", "YCustomGLVideoView end looper exception: " + t.getMessage());
        }
        finally {
            YMFLog.info(this, "[Render  ]", "YCustomGLVideoView end GLThread");
            YMFPlayerUsrBehaviorStat.getInstance().notifyGlManagerState(2, false);
            try {
                this.DeInitEGL();
            }
            catch (Throwable t) {
                PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mMultiStreamID, "2", "103", t.getMessage());
                YMFLog.error((Object)this, "[Render  ]", "YCustomGLVideoView DeInitEGL exception:" + t.getMessage());
            }
            Object t = this.mQuitLock;
            synchronized (t) {
                this.mQuitLock.notifyAll();
            }
        }
    }

    private void onVideoRenderNotify(int videoIndex, long userGroupId, long streamId, long pts, long renderTimeStamp, long decodeStamp) {
        if (this.mVideoRenderNotifys == null) {
            return;
        }
        this.mVideoRenderNotifys.add(new VideoRenderNotify(userGroupId, streamId, pts, renderTimeStamp, decodeStamp));
        Iterator<VideoRenderNotify> it = this.mVideoRenderNotifys.iterator();
        if (!it.hasNext()) {
            return;
        }
        long firstPts = it.next().mPts;
        if (pts - firstPts < 500L && this.mVideoRenderNotifys.size() < 15 && this.mFirstFrameRendered[videoIndex]) {
            return;
        }
        if (!this.mFirstFrameRendered[videoIndex]) {
            YMFLog.info(this, "[Render  ]", "first frame finish decode");
        }
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
    }

    private boolean checkFrameArrived() {
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            boolean frameChanged = this.mFrameBuffer[i].hasFrame();
            ByteBuffer frame = this.mFrameBuffer[i].getFrame();
            if (null == frame || !frameChanged) continue;
            return true;
        }
        return false;
    }

    private void handleNewYUVFrameArrived() {
        this.renderFrame();
    }

    private void renderFrame() {
        try {
            this.tryLockSurfaceDestoryLock();
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20.glClear((int)16384);
            if (this.mBackGroundBitmap != null && this.mBackGroundTexture > 0) {
                GLES20.glViewport((int)this.mBackGroundPosition.mX, (int)this.mBackGroundPosition.mY, (int)this.mBackGroundPosition.mWidth, (int)this.mBackGroundPosition.mHeight);
                this.mBackgroundScreen.drawFrame(this.mBackGroundTexture, this.mTransform, -1);
            }
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                if (this.mStreamId[i] == -1L) continue;
                this.handleVsync(0L, i);
            }
            if (this.mVideoWindowSurface != null) {
                this.mVideoWindowSurface.swapBuffers();
            }
            this.tryUnlockSurfaceDestroyLock();
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Render  ]", "handleOnVsyncArrived exception::" + e.toString());
        }
        finally {
            this.tryUnlockSurfaceDestroyLock();
        }
    }

    public void handleOnVsyncArrived(long frameTimeNanos) {
        ++this.vsyncCnt;
        long t1 = System.currentTimeMillis();
        if (t1 - this.vsyncT > 6000L) {
            this.vsyncT = t1;
            YMFLog.debug((Object)this, "[Render  ]", "YCustomGLVideoView vsync count in 6 seconds " + this.vsyncCnt);
            this.vsyncCnt = 0L;
        }
        ++this.index;
        if (this.index % 2L == 0L) {
            this.renderFrame();
        }
    }

    private void handleVsync(long frameTimeNanos, int videoIndex) {
        if (this.mFrameBuffer != null && this.mFrameBuffer[videoIndex] != null) {
            boolean frameChanged = this.mFrameBuffer[videoIndex].hasFrame();
            ByteBuffer frame = this.mFrameBuffer[videoIndex].getFrame();
            int pts = this.mFrameBuffer[videoIndex].getCurFramePts();
            if (null != frame && this.mFrameBuffer[videoIndex].checkDataComplete()) {
                StateMonitor.NotifyPts(this.mStreamId[videoIndex], pts);
                ViewLiveStatManager.getInstace().reportFrameEvent(0);
                int n = videoIndex;
                long l = this.mVideoDataCnt[n];
                this.mVideoDataCnt[n] = l + 1L;
                if (l % 500L == 0L) {
                    YMFLog.info(this, "[Render  ]", "handleVsync frame count:" + this.mVideoDataCnt[videoIndex]);
                }
                if (!this.mFirstFrameRendered[videoIndex]) {
                    this.mFirstFrameTs[videoIndex] = System.currentTimeMillis();
                }
                if (this.mImageWidth[videoIndex] != this.mFrameBuffer[videoIndex].getPixWidth() || this.mImageHeight[videoIndex] != this.mFrameBuffer[videoIndex].getHeight() || this.mImageStrideWidth[videoIndex] != this.mFrameBuffer[videoIndex].getWidth()) {
                    this.mImageWidth[videoIndex] = this.mFrameBuffer[videoIndex].getPixWidth();
                    this.mImageHeight[videoIndex] = this.mFrameBuffer[videoIndex].getHeight();
                    this.mImageStrideWidth[videoIndex] = this.mFrameBuffer[videoIndex].getWidth();
                    this.mSrcTransform = this.calcSrcTransform(this.mImageWidth[videoIndex], this.mImageHeight[videoIndex], this.mImageStrideWidth[videoIndex], this.mImageHeight[videoIndex]);
                    System.arraycopy(this.mSrcTransform, 0, this.mTransform, 0, 16);
                    this.mVideoSizes[videoIndex].mVideoWidth = this.mImageWidth[videoIndex];
                    this.mVideoSizes[videoIndex].mVideoHeight = this.mImageHeight[videoIndex];
                    this.updateDisplayRegion(videoIndex);
                    if (this.mVideoInfoCallback != null) {
                        this.mVideoInfoCallback.onUpdateVideoSizeChanged(this.mStreamId[videoIndex], this.mImageWidth[videoIndex], this.mImageHeight[videoIndex]);
                    }
                }
                this.mVideoScreen.upDateVertexCoord(this.mImageWidth[videoIndex], this.mImageHeight[videoIndex], this.mDrawPosition[videoIndex].mWidth, this.mDrawPosition[videoIndex].mHeight, this.mSurfaceScaleInfo[videoIndex].scaleMode);
                if (this.mVideoDataCnt[videoIndex] == 1L) {
                    ViewLiveStatManager.getInstace().notifyEventTime(2, 3, new ViewLiveStatManager.StatVideoHeaderInfo(this.mImageStrideWidth[videoIndex], this.mImageHeight[videoIndex]));
                }
                this.tryLockSurfaceDestoryLock();
                if (!this.mSurfaceDestoryedState.get()) {
                    this.loadDataToTexture(this.mYChannel, frame.position(this.mFrameBuffer[videoIndex].getOffsetY()), this.mFrameBuffer[videoIndex].getWidthY(), this.mFrameBuffer[videoIndex].getHeightY());
                    this.loadDataToTexture(this.mUChannel, frame.position(this.mFrameBuffer[videoIndex].getOffsetU()), this.mFrameBuffer[videoIndex].getWidthUV(), this.mFrameBuffer[videoIndex].getHeightUV());
                    this.loadDataToTexture(this.mVChannel, frame.position(this.mFrameBuffer[videoIndex].getOffsetV()), this.mFrameBuffer[videoIndex].getWidthUV(), this.mFrameBuffer[videoIndex].getHeightUV());
                    this.mIsImageLoaded = true;
                    this.drawCurrentFrame(videoIndex);
                }
                this.tryUnlockSurfaceDestroyLock();
                this.mFrameBuffer[videoIndex].setFrameRendered();
                if (frameChanged) {
                    long currentTs;
                    ViewLiveStatManager.getInstace().reportFrameEvent(1);
                    if (this.mVideoDataCnt[videoIndex] == 1L) {
                        ViewLiveStatManager.getInstace().notifyEventTime(3, 3);
                    }
                    if (this.mSmoothnessCounter.RenderOneFrame(this.mStreamId[videoIndex], currentTs = System.currentTimeMillis())) {
                        double coef = this.mSmoothnessCounter.ComputeCoefficientOfVariationAndReset();
                        YYVideoLibMgr.instance().onCoefficientOfVariationOfRenderInterval(this.mUserGroupId[videoIndex], this.mStreamId[videoIndex], this.mSmoothnessCounter.GetIntervalMilliTs(), coef);
                    }
                    this.onVideoRenderNotify(videoIndex, this.mUserGroupId[videoIndex], this.mStreamId[videoIndex], pts, TimeUtil.getTickCountLong(), this.mFrameBuffer[videoIndex].getLastDecodeTimeStamp());
                    int n2 = videoIndex;
                    this.mFrames[n2] = this.mFrames[n2] + 1;
                    if (!this.mFirstFrameRendered[videoIndex]) {
                        YMFLog.info(this, "[Render  ]", "handleVsync notify first frame out, cost time:" + (currentTs - this.mFirstFrameTs[videoIndex]));
                        YYVideoLibMgr.instance().onFirstFrameRenderNotify(this.mUserGroupId[videoIndex], this.mStreamId[videoIndex], currentTs, currentTs - this.mFirstFrameTs[videoIndex], this.mFrames[videoIndex]);
                        StateMonitor.instance();
                        StateMonitor.NotifyFirstFrameRendered(this.mStreamId[videoIndex], TimeUtil.getTickCount());
                        this.mFirstFrameRendered[videoIndex] = true;
                    }
                    int n3 = videoIndex;
                    this.mRenderCnt[n3] = this.mRenderCnt[n3] + 1;
                    this.mCurTime[videoIndex] = TimeUtil.getTickCountLong();
                    if (this.mLastTime[videoIndex] == 0L) {
                        this.mLastTime[videoIndex] = this.mCurTime[videoIndex];
                    }
                    if (this.mCurTime[videoIndex] - this.mLastTime[videoIndex] >= 1000L) {
                        StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId[videoIndex], this.mRenderCnt[videoIndex]);
                        this.mLastTime[videoIndex] = this.mCurTime[videoIndex];
                        this.mRenderCnt[videoIndex] = 0;
                    }
                }
            } else if (frame == null) {
                ViewLiveStatManager.getInstace().reportDecError(0);
                int n = videoIndex;
                long l = this.mRenderFailCnt[n];
                this.mRenderFailCnt[n] = l + 1L;
                if (l % 500L == 0L) {
                    YMFLog.info(this, "[Render  ]", "handleVsync failed, frameChanged:" + frameChanged + ", count:" + this.mRenderFailCnt[videoIndex]);
                }
            }
        }
    }

    private void loadDataToTexture(TexturePack texturePack, Buffer data, int width, int height) {
        if (data == null || texturePack.textureId <= 0 || width <= 0 || height <= 0) {
            YMFLog.error((Object)this, "[Render  ]", "loadDataToTexture invalid parameter");
            return;
        }
        GLES20.glBindTexture((int)3553, (int)texturePack.textureId);
        if (texturePack.width != width || texturePack.height != height) {
            if ((width & 3) != 0) {
                YMFLog.info(this, "[Render  ]", "glTexImage2D width:" + width + " GL_UNPACK_ALIGNMENT: 1");
                GLES20.glPixelStorei((int)3317, (int)1);
            } else {
                GLES20.glPixelStorei((int)3317, (int)4);
            }
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)width, (int)height, (int)0, (int)6409, (int)5121, (Buffer)data);
            GlUtil.checkGlErrorNoException("glTexImage2D");
            texturePack.height = height;
            texturePack.width = width;
        } else {
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6409, (int)5121, (Buffer)data);
            GlUtil.checkGlErrorNoException("glTexSubImage2D");
        }
    }

    private float[] calcSrcTransform(int imageWidth, int imageHeight, int frameWidth, int frameHeight) {
        float[] mt = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix.scaleM((float[])mt, (int)0, (float)(1.0f * (float)(--imageWidth) / (float)frameWidth), (float)(1.0f * (float)(--imageHeight) / (float)frameHeight), (float)1.0f);
        Matrix.rotateM((float[])mt, (int)0, (float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Matrix.translateM((float[])mt, (int)0, (float)0.0f, (float)-1.0f, (float)0.0f);
        return mt;
    }

    private void drawCurrentFrame(int videoIndex) {
        if (this.mVideoWindowSurface != null && this.mIsImageLoaded && !this.mSurfaceDestoryedState.get()) {
            try {
                if (this.mPlayNotify != null) {
                    this.mPlayNotify.DrawNotify();
                }
                if (!this.mFirstFrameSeeFlag[videoIndex]) {
                    YYVideoLibMgr.instance().onFirstFrameSeeNotify(this.mUserGroupId[videoIndex], this.mStreamId[videoIndex], System.currentTimeMillis() - this.mFirstFrameTs[videoIndex]);
                    this.mFirstFrameSeeFlag[videoIndex] = true;
                }
                if (this.mVideoInfoCallback != null) {
                    this.mVideoInfoCallback.onUpdatePts(this.mStreamId[videoIndex], this.mFrameBuffer[videoIndex].getCurFramePts());
                }
                GLES20.glViewport((int)this.mDrawPosition[videoIndex].mX, (int)this.mDrawPosition[videoIndex].mY, (int)this.mDrawPosition[videoIndex].mWidth, (int)this.mDrawPosition[videoIndex].mHeight);
                if (!this.mIsVrStream) {
                    this.mVideoScreen.drawFrame(this.mYChannel.textureId, this.mUChannel.textureId, this.mVChannel.textureId, this.mTransform);
                } else {
                    this.mVRLibrary.drawFrame(-1, this.mTransform, this.mYChannel.textureId, this.mUChannel.textureId, this.mVChannel.textureId);
                }
            }
            catch (Throwable t) {
                PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mMultiStreamID, "2", "102", t.getMessage());
                YMFLog.error((Object)this, "[Render  ]", "drawCurrentFrame exception:" + t.getMessage());
                this.handleSurfaceDestroyed(this.mSurfaceScaleInfo[videoIndex].surface);
            }
        }
    }

    private void InitEGL() {
        this.mEglCore = new EglCore();
        this.mEnvSurface = this.mEglCore.createOffscreenSurface(320, 240);
        this.mEglCore.makeCurrent(this.mEnvSurface);
        this.mVideoScreen = new FullFrameRect(new Texture2dProgram(Texture2dProgram.ProgramType.TEXTURE_YUV));
        this.mVideoScreen.setUseMultiVideoview(true);
        this.mBackgroundScreen = new FullFrameRect(new Texture2dProgram(Texture2dProgram.ProgramType.TEXTURE_2D));
        this.mVRLibrary = new VRLibrary(this.getContext().getApplicationContext());
        this.mVRLibrary.initLibrary(false);
        this.mSrcTransform = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix.rotateM((float[])this.mSrcTransform, (int)0, (float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Matrix.translateM((float[])this.mSrcTransform, (int)0, (float)0.0f, (float)-1.0f, (float)0.0f);
        this.mTransform = new float[16];
        System.arraycopy(this.mSrcTransform, 0, this.mTransform, 0, 16);
        this.mYChannel.textureId = this.genTexture();
        this.mUChannel.textureId = this.genTexture();
        this.mVChannel.textureId = this.genTexture();
        this.mPlayNotify = new PlayNotify();
        this.mPlayNotify.Init();
        this.mVideoRenderNotifys.clear();
        if (this.mBackGroundBitmap != null) {
            this.mBackGroundTexture = GLUtil.genTextureWithBitmap(this.mBackGroundBitmap);
        }
        this.mFrameCallbck = new YYRenderFrameBuffer.newYUVFrameArrivedCallBack(){

            @Override
            public void onNewYUVFrameArrive() {
                if (YCustomGLVideoViewHighEGLMultiVideo.this.mReady.get()) {
                    YCustomGLVideoViewHighEGLMultiVideo.this.mHandler.sendMessage(YCustomGLVideoViewHighEGLMultiVideo.this.mHandler.obtainMessage(18));
                } else if (YCustomGLVideoViewHighEGLMultiVideo.this.mFrameBuffer != null) {
                    for (int i = 0; i < YCustomGLVideoViewHighEGLMultiVideo.this.mTotalVideoCnt; ++i) {
                        if (YCustomGLVideoViewHighEGLMultiVideo.this.mFrameBuffer[i] == null) continue;
                        YCustomGLVideoViewHighEGLMultiVideo.this.mFrameBuffer[i].setFrameRendered();
                    }
                }
            }
        };
        if (this.mFrameBuffer != null) {
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                if (this.mFrameBuffer[i] == null) continue;
            }
        }
    }

    private int genTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        return textures[0];
    }

    private void releaseTexture(TexturePack texturePack) {
        if (texturePack.textureId >= 0) {
            int[] textures = new int[]{texturePack.textureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            texturePack.textureId = -1;
            texturePack.width = -1;
            texturePack.height = -1;
        }
    }

    private void DeInitEGL() {
        int i;
        YMFLog.info(this, "[Render  ]", "YCustomGLVideoView DeInitEGL");
        this.mVsyncRelay.UnRegisterVsyncNotifier(this);
        this.tryLockSurfaceDestoryLock();
        for (i = 0; i < this.mTotalVideoCnt && this.mFrameBuffer != null; ++i) {
            if (this.mFrameBuffer[i] == null) continue;
            this.mFrameBuffer[i].release();
            this.mFrameBuffer[i] = null;
        }
        this.mFrameBuffer = null;
        if (this.mPlayNotify != null) {
            this.mPlayNotify.Release();
            this.mPlayNotify = null;
        }
        if (this.mSurfaceScaleInfo != null) {
            for (i = 0; i < this.mTotalVideoCnt; ++i) {
                if (this.mSurfaceScaleInfo[i] == null) continue;
                this.mSurfaceScaleInfo[i].videoView = null;
                this.mSurfaceScaleInfo[i].surface = null;
                this.mSurfaceScaleInfo[i] = null;
            }
            this.mSurfaceScaleInfo = null;
        }
        if (this.mYChannel != null) {
            this.releaseTexture(this.mYChannel);
        }
        if (this.mUChannel != null) {
            this.releaseTexture(this.mUChannel);
        }
        if (this.mVChannel != null) {
            this.releaseTexture(this.mVChannel);
        }
        for (i = 0; i < this.mTotalVideoCnt; ++i) {
            if (this.mDrawPosition == null || this.mDrawPosition[i] == null) continue;
            this.mDrawPosition[i] = null;
        }
        this.mDrawPosition = null;
        if (this.mBackGroundTexture > 0) {
            int[] textures = new int[]{this.mBackGroundTexture};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mBackGroundTexture = -1;
        }
        if (this.mVideoScreen != null) {
            this.mVideoScreen.release(true);
            this.mVideoScreen = null;
        }
        if (this.mBackgroundScreen != null) {
            this.mBackgroundScreen.release(true);
            this.mBackgroundScreen = null;
        }
        if (this.mVRLibrary != null) {
            this.mVRLibrary.destroyLibrary();
        }
        if (this.mVideoWindowSurface != null) {
            this.mVideoWindowSurface.release();
            this.mVideoWindowSurface = null;
        }
        if (this.mEnvSurface != null) {
            this.mEglCore.makeNothingCurrent();
            this.mEglCore.releaseSurface(this.mEnvSurface);
            this.mEnvSurface = null;
        }
        this.tryUnlockSurfaceDestroyLock();
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    private void updateDisplayRegion(int videoIndex) {
        VideoSizeUtils.Size si;
        if (this.mSurfaceScaleInfo == null) {
            return;
        }
        if (this.mSurfaceScaleInfo[videoIndex].orientationType == YSpVideoView.OrientationType.Force || this.mSurfaceScaleInfo[videoIndex].orientationType == YSpVideoView.OrientationType.Auto && this.mVideoSizes[videoIndex].mVideoWidth < this.mVideoSizes[videoIndex].mVideoHeight != this.mVideoSizes[videoIndex].mVideoSurfaceWidth < this.mVideoSizes[videoIndex].mVideoSurfaceHeight) {
            si = this.mSurfaceScaleInfo[videoIndex].rotateAngle != 0 && this.mSurfaceScaleInfo[videoIndex].rotateAngle != 180 ? VideoSizeUtils.CalcFitSize(this.mVideoSizes[videoIndex].mVideoHeight, this.mVideoSizes[videoIndex].mVideoWidth, this.mVideoSizes[videoIndex].mVideoSurfaceWidth, this.mVideoSizes[videoIndex].mVideoSurfaceHeight, this.mSurfaceScaleInfo[videoIndex].scaleMode) : VideoSizeUtils.CalcFitSize(this.mVideoSizes[videoIndex].mVideoWidth, this.mVideoSizes[videoIndex].mVideoHeight, this.mVideoSizes[videoIndex].mVideoSurfaceWidth, this.mVideoSizes[videoIndex].mVideoSurfaceHeight, this.mSurfaceScaleInfo[videoIndex].scaleMode);
            Matrix.translateM((float[])this.mTransform, (int)0, (float[])this.mSrcTransform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
            Matrix.rotateM((float[])this.mTransform, (int)0, (float)this.mSurfaceScaleInfo[videoIndex].rotateAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.translateM((float[])this.mTransform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        } else {
            si = VideoSizeUtils.CalcFitSize(this.mVideoSizes[videoIndex].mVideoWidth, this.mVideoSizes[videoIndex].mVideoHeight, this.mVideoSizes[videoIndex].mVideoSurfaceWidth, this.mVideoSizes[videoIndex].mVideoSurfaceHeight, this.mSurfaceScaleInfo[videoIndex].scaleMode);
        }
        this.mVideoSizes[videoIndex].mViewX = si.x;
        this.mVideoSizes[videoIndex].mViewY = si.y;
        this.mVideoSizes[videoIndex].mViewWidth = si.width;
        this.mVideoSizes[videoIndex].mViewHeight = si.height;
    }

    private void handleSurfaceRedrawNeeded(Surface surface) {
        long startTime = System.currentTimeMillis();
        this.tryLockSurfaceDestoryLock();
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.drawCurrentFrame(i);
        }
        this.tryUnlockSurfaceDestroyLock();
        long renderTime = System.currentTimeMillis() - startTime;
        VideoDataStatHelper.putRenderTime(renderTime);
    }

    private void handleSurfaceCreated(Surface surface) {
        this.tryLockSurfaceDestoryLock();
        if (this.mVideoWindowSurface != null) {
            this.mEglCore.makeCurrent(this.mEnvSurface);
            this.mVideoWindowSurface.release();
            this.mVideoWindowSurface = null;
        }
        try {
            this.mVideoWindowSurface = new WindowSurface(this.mEglCore, surface, false);
            this.mVideoWindowSurface.makeCurrent();
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Render  ]", "handleSurfaceCreated exception:" + t.getMessage());
        }
        finally {
            this.tryUnlockSurfaceDestroyLock();
        }
        this.mSmoothnessCounter.ResetToInitialState();
        this.mVsyncRelay.RegisterVsyncNotifier(this);
    }

    private void updateVideoLayout() {
        if (this.mTotalVideoCnt == 1 && this.originposition[0].mWidth == -2 && this.originposition[0].mHeight == -2) {
            this.mDrawPosition[0].mX = 0;
            this.mDrawPosition[0].mY = 0;
            this.mDrawPosition[0].mWidth = this.mSurfaceWidth;
            this.mDrawPosition[0].mHeight = this.mSurfaceHeight;
            this.mBackGroundPosition.mY = 0;
        } else {
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                this.mDrawPosition[i].mX = this.originposition[i].mX;
                this.mDrawPosition[i].mY = this.mSurfaceHeight - this.originposition[i].mY - this.originposition[i].mHeight;
                this.mDrawPosition[i].mWidth = this.originposition[i].mWidth;
                this.mDrawPosition[i].mHeight = this.originposition[i].mHeight;
            }
            this.mBackGroundPosition.mY = this.mSurfaceHeight - this.originBackGroundPosition.mY - this.originBackGroundPosition.mHeight;
            this.mBackGroundPosition.mHeight = this.originBackGroundPosition.mHeight;
            this.mBackGroundPosition.mWidth = this.originBackGroundPosition.mWidth;
        }
    }

    private void handleSurfaceChanged(Surface surface, int width, int height) {
        int i;
        for (i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mVideoSizes[i].mVideoSurfaceWidth = width;
            this.mVideoSizes[i].mVideoSurfaceHeight = height;
        }
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (this.mVRLibrary != null) {
            this.mVRLibrary.updateViewport(this.mVideoSizes[0].mVideoSurfaceWidth, this.mVideoSizes[0].mVideoSurfaceHeight);
        }
        this.updateVideoLayout();
        StateMonitor.NotifyMultiVideoSurfaceChangePosition(this.mDrawPosition, this.mBackGroundPosition);
        for (i = 0; i < this.mTotalVideoCnt; ++i) {
            this.updateDisplayRegion(i);
        }
        this.tryLockSurfaceDestoryLock();
        for (i = 0; i < this.mTotalVideoCnt; ++i) {
            this.drawCurrentFrame(i);
        }
        this.tryUnlockSurfaceDestroyLock();
        this.mViewVideoInfo.viewX = this.mVideoSizes[0].mViewX;
        this.mViewVideoInfo.viewY = this.mVideoSizes[0].mViewY;
    }

    private void tryLockSurfaceDestoryLock() {
        if (this.mSurfaceDestoryedLock.getHoldCount() == 0) {
            this.mSurfaceDestoryedLock.lock();
        }
    }

    private void tryUnlockSurfaceDestroyLock() {
        try {
            while (this.mSurfaceDestoryedLock.getHoldCount() != 0) {
                this.mSurfaceDestoryedLock.unlock();
            }
        }
        catch (IllegalMonitorStateException e) {
            YMFLog.warn(this, "[Render  ]", "tryUnlockSurfaceDestroyLock more than once, exception:" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSurfaceDestroyed(Surface surface) {
        this.mVsyncRelay.UnRegisterVsyncNotifier(this);
        this.tryLockSurfaceDestoryLock();
        if (this.mVideoWindowSurface != null) {
            try {
                this.mEglCore.makeCurrent(this.mEnvSurface);
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Render  ]", "exception:" + e);
            }
            finally {
                this.mVideoWindowSurface.release();
                this.mVideoWindowSurface = null;
            }
        }
        if (this.mSurfaceScaleInfo != null) {
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                if (this.mSurfaceScaleInfo[i] == null) continue;
                this.mSurfaceScaleInfo[i].videoView = null;
                this.mSurfaceScaleInfo[i].surface = null;
            }
        }
        this.tryUnlockSurfaceDestroyLock();
        Object object = this.mSurfaceDestroyLock;
        synchronized (object) {
            this.mSurfaceDestroyLock.notifyAll();
        }
    }

    private void handleSetScaleMode(VideoConstant.ScaleMode scaleMode) {
        int i;
        for (i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mSurfaceScaleInfo[i].scaleMode = scaleMode;
            this.updateDisplayRegion(i);
        }
        this.tryLockSurfaceDestoryLock();
        for (i = 0; i < this.mTotalVideoCnt; ++i) {
            this.drawCurrentFrame(i);
        }
        this.tryUnlockSurfaceDestroyLock();
    }

    private void handleSetScaleModeEx(ScaleModeEx scaleMode) {
        int videoIndex = scaleMode.videoIndex;
        if (videoIndex < 0 || videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)this, "[Render  ]", "handleSetScaleModeEx, videoIndex is illegal...");
            return;
        }
        if (this.mSurfaceScaleInfo == null) {
            YMFLog.error((Object)this, "[Render  ]", "handleSetScaleModeEx, mSurfaceScaleInfo is null...");
            return;
        }
        this.mSurfaceScaleInfo[videoIndex].scaleMode = scaleMode.scaleMode;
        this.updateDisplayRegion(videoIndex);
        this.tryLockSurfaceDestoryLock();
        this.drawCurrentFrame(videoIndex);
        this.tryUnlockSurfaceDestroyLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetScreenShot(ScreenShotInfo info) {
        try {
            info.isSuccess = false;
            YYRenderFrameBuffer.RGB565ImageWithNoPadding img = new YYRenderFrameBuffer.RGB565ImageWithNoPadding();
            if (this.mStreamId[info.videoIndex] != 0L && this.mFrameBuffer[info.videoIndex].GetCurrentPictureDataRGB565(img)) {
                info.height = img.mHeight;
                info.width = img.mWidth;
                info.pixelBuffer = ByteBuffer.wrap(img.mData);
                info.isSuccess = true;
            }
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Render  ]", "handleGetScreenShot wxception:" + t.getMessage());
        }
        Object object = this.mScreenShotLock;
        synchronized (object) {
            this.mScreenShotLock.notifyAll();
        }
    }

    private void handleSetPlayListner(PlayNotify.PlayListner playListner) {
        this.mPlayNotify.setPlayListner(playListner);
    }

    private void handleLinktoStream(long userGroupId, long streamId) {
        this.mUserGroupId[0] = userGroupId;
        this.mStreamId[0] = streamId;
        this.mFrameBuffer[0].linkToStream(userGroupId, streamId);
        this.mPlayNotify.EndPlay(false);
        this.mPlayNotify.setVideoIds(userGroupId, streamId);
    }

    private void handleLinktoStreamExt(long userGroupId, long streamId, int videoIndex) {
        YMFLog.info(this, "[Render  ]", " handleLinktoStreamExt streamID:" + streamId + " videoIndex:" + videoIndex);
        this.mUserGroupId[videoIndex] = userGroupId;
        this.mStreamId[videoIndex] = streamId;
        this.mFrameBuffer[videoIndex].linkToStream(userGroupId, streamId);
        this.mPlayNotify.EndPlay(false);
        this.mPlayNotify.setVideoIds(userGroupId, streamId);
    }

    private void handleUnlinktoStream(long userGroupId, long streamId) {
        StateMonitor.NotifyClearPts(streamId);
        this.mFrameBuffer[0].unLinkFromStream(userGroupId, streamId);
        this.mUserGroupId[0] = -1L;
        this.mStreamId[0] = -1L;
        if (this.mPlayNotify != null) {
            this.mPlayNotify.EndPlay(true);
        }
    }

    private void handleUnlinktoStreamExt(long userGroupId, long streamId, int videoIndex) {
        YMFLog.info(this, "[Render  ]", "handleUnlinktoStreamExt streamID:" + streamId + " videoIndex:" + videoIndex);
        this.mFrameBuffer[videoIndex].unLinkFromStream(userGroupId, streamId);
        this.mUserGroupId[videoIndex] = -1L;
        this.mStreamId[videoIndex] = -1L;
        if (this.mPlayNotify != null) {
            this.mPlayNotify.EndPlay(true);
        }
    }

    private void handleSetOrientation(int rotateAngle, YSpVideoView.OrientationType orientationType) {
        int i;
        for (i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mSurfaceScaleInfo[i].rotateAngle = rotateAngle;
            this.mSurfaceScaleInfo[i].orientationType = orientationType;
            this.updateDisplayRegion(i);
        }
        this.tryLockSurfaceDestoryLock();
        for (i = 0; i < this.mTotalVideoCnt; ++i) {
            this.drawCurrentFrame(i);
        }
        this.tryUnlockSurfaceDestroyLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetVideoScreenshotExt(ScreenShotInfo info) {
        try {
            info.isSuccess = false;
            YYRenderFrameBuffer.RGB565ImageWithNoPadding img = new YYRenderFrameBuffer.RGB565ImageWithNoPadding();
            if (this.mStreamId[info.videoIndex] != 0L && this.mFrameBuffer[info.videoIndex].GetCurrentPictureDataRGB565(img)) {
                info.height = img.mHeight;
                info.width = img.mWidth;
                info.pixelBuffer = ByteBuffer.wrap(img.mData);
                info.isSuccess = true;
                YMFLog.info(this, "[Render  ]", "handleGetVideoScreenshotExt:" + this.mStreamId[info.videoIndex]);
            }
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Render  ]", "handleGetScreenShot exception:" + t.getMessage());
        }
        Object object = this.mScreenShotLock;
        synchronized (object) {
            this.mScreenShotLock.notifyAll();
        }
    }

    public void handleSetVideoInfoCallback(IVideoInfoCallback callback) {
        this.mVideoInfoCallback = callback;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(16, iVideoInfoCallback));
        }
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        if (this.mViewVideoInfo != null) {
            return this.mViewVideoInfo;
        }
        YMFLog.error((Object)this, "[Render  ]", "getVideoViewPostionInfo return null");
        return null;
    }

    private static class RenderHandler
    extends Handler {
        private WeakReference<YCustomGLVideoViewHighEGLMultiVideo> mWeakWay;

        public RenderHandler(YCustomGLVideoViewHighEGLMultiVideo hardDecodeWay) {
            this.mWeakWay = new WeakReference<YCustomGLVideoViewHighEGLMultiVideo>(hardDecodeWay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            int what = msg.what;
            if (0 == what) {
                Looper loop = Looper.myLooper();
                if (null == loop) return;
                loop.quit();
                this.removeCallbacksAndMessages(null);
                this.mWeakWay = null;
                YMFLog.info((Object)this, "[Render  ]", "handleMessage: mWeakWay = null");
                return;
            }
            YCustomGLVideoViewHighEGLMultiVideo customGLVideoView = (YCustomGLVideoViewHighEGLMultiVideo)this.mWeakWay.get();
            if (customGLVideoView == null) {
                YMFLog.warn((Object)this, "[Render  ]", "handleMessage: hardDecodeWay is null");
                return;
            }
            try {
                switch (what) {
                    case 1: {
                        customGLVideoView.handleSurfaceRedrawNeeded((Surface)msg.obj);
                        return;
                    }
                    case 2: {
                        customGLVideoView.handleSurfaceCreated((Surface)msg.obj);
                        return;
                    }
                    case 3: {
                        customGLVideoView.handleSurfaceChanged((Surface)msg.obj, msg.arg1, msg.arg2);
                        return;
                    }
                    case 4: {
                        customGLVideoView.handleSurfaceDestroyed((Surface)msg.obj);
                        return;
                    }
                    case 5: {
                        customGLVideoView.handleSetScaleMode((VideoConstant.ScaleMode)((Object)msg.obj));
                        return;
                    }
                    case 14: {
                        customGLVideoView.handleSetScaleModeEx((ScaleModeEx)msg.obj);
                        return;
                    }
                    case 6: {
                        customGLVideoView.handleGetScreenShot((ScreenShotInfo)msg.obj);
                        return;
                    }
                    case 7: {
                        customGLVideoView.handleSetPlayListner((PlayNotify.PlayListner)msg.obj);
                        return;
                    }
                    case 8: {
                        StreamInfo si = (StreamInfo)msg.obj;
                        customGLVideoView.handleLinktoStream(si.userGroupId, si.streamId);
                        return;
                    }
                    case 9: {
                        StreamInfo si1 = (StreamInfo)msg.obj;
                        customGLVideoView.handleUnlinktoStream(si1.userGroupId, si1.streamId);
                        return;
                    }
                    case 12: {
                        StreamInfo siE = (StreamInfo)msg.obj;
                        customGLVideoView.handleLinktoStreamExt(siE.userGroupId, siE.streamId, siE.videoIndex);
                        return;
                    }
                    case 13: {
                        StreamInfo sie = (StreamInfo)msg.obj;
                        customGLVideoView.handleUnlinktoStreamExt(sie.userGroupId, sie.streamId, sie.videoIndex);
                        return;
                    }
                    case 10: {
                        customGLVideoView.handleSetOrientation(msg.arg1, (YSpVideoView.OrientationType)((Object)msg.obj));
                        return;
                    }
                    case 11: {
                        customGLVideoView.handleOnVsyncArrived((Long)msg.obj);
                        return;
                    }
                    case 15: {
                        customGLVideoView.handleGetVideoScreenshotExt((ScreenShotInfo)msg.obj);
                        return;
                    }
                    case 16: {
                        customGLVideoView.handleSetVideoInfoCallback((IVideoInfoCallback)msg.obj);
                        return;
                    }
                    case 17: {
                        customGLVideoView.handleUpdateMultiVideoViewParams((YMultiVideoViewParams)msg.obj);
                        return;
                    }
                    case 18: {
                        customGLVideoView.handleNewYUVFrameArrived();
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Render  ]", " handleMessage exception::" + YMFLog.stackTraceOf(e));
                return;
            }
            finally {
                customGLVideoView.tryUnlockSurfaceDestroyLock();
            }
        }
    }

    private static class TexturePack {
        public int textureId = -1;
        public int width = -1;
        public int height = -1;

        private TexturePack() {
        }
    }

    private static class StreamInfo {
        public long userGroupId;
        public long streamId;
        public int videoIndex;

        private StreamInfo() {
        }
    }

    private static class ScreenShotInfo {
        public boolean isSuccess;
        public Buffer pixelBuffer;
        public int width;
        public int height;
        public int videoIndex;

        private ScreenShotInfo() {
        }
    }

    private static class SurfaceScaleInfo {
        public View videoView;
        public Surface surface;
        public int width = 64;
        public int height = 64;
        public int parentWidth = 64;
        public int parentHeight = 64;
        public int rotateAngle = 0;
        public YSpVideoView.OrientationType orientationType = YSpVideoView.OrientationType.Normal;
        public VideoConstant.ScaleMode scaleMode = VideoConstant.ScaleMode.AspectFit;

        private SurfaceScaleInfo() {
        }
    }

    public class ScaleModeEx {
        public int videoIndex;
        public VideoConstant.ScaleMode scaleMode;
    }
}

