/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Choreographer;
import com.yy.videoplayer.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class VsyncRelay
implements Runnable,
Choreographer.FrameCallback {
    public static final String TAG = "VsyncRelay";
    private static final int MSG_QUIT = 0;
    private static final int MSG_REGISTER_CALLBACK = 1;
    private static final int MSG_UNREGISTER_CALLBACK = 2;
    private List<VsyncNotifier> mVsyncNotifierList;
    private VsyncHandler mVsyncHandler;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private final Object mStartLock = new Object();
    private final Object mQuitLock = new Object();
    private boolean mIsCatchingVsync = false;
    private Thread mThread;
    private Choreographer mChoreographer;
    private static VsyncRelay sVsyncRelay;
    static int sInstances;

    public static synchronized VsyncRelay getInstance() {
        if (sVsyncRelay == null) {
            sVsyncRelay = new VsyncRelay();
            sVsyncRelay.Start();
        }
        return sVsyncRelay;
    }

    public static void Exit() {
        if (sVsyncRelay != null) {
            sVsyncRelay.Quit();
        }
        sVsyncRelay = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Start() {
        YMFLog.info(this, "[Decoder ]", "VsyncRelay Start");
        this.mThread = new Thread(this);
        this.mThread.setName("YY_yylivesdk_VsyncRelay_Thread");
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                this.mThread.start();
                this.mStartLock.wait(500L);
            }
            catch (Throwable e) {
                YMFLog.error((Object)this, "[Decoder ]", "startLock exception:" + e.getMessage());
            }
        }
    }

    public void RegisterVsyncNotifier(VsyncNotifier VsyncNotifier2) {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "RegisterVsyncNotifier...");
            this.mVsyncHandler.sendMessage(this.mVsyncHandler.obtainMessage(1, VsyncNotifier2));
        } else {
            YMFLog.info(this, "[Decoder ]", "RegisterVsyncNotifier not ready");
        }
    }

    public void UnRegisterVsyncNotifier(VsyncNotifier VsyncNotifier2) {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "UnRegisterVsyncNotifier...");
            this.mVsyncHandler.sendMessage(this.mVsyncHandler.obtainMessage(2, VsyncNotifier2));
        } else {
            YMFLog.info(this, "[Decoder ]", "UnRegisterVsyncNotifier not ready");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Quit() {
        if (this.mReady.get()) {
            Object object = this.mQuitLock;
            synchronized (object) {
                try {
                    this.mVsyncHandler.sendMessage(this.mVsyncHandler.obtainMessage(0));
                    this.mQuitLock.wait(500L);
                    YMFLog.info(this, "[Decoder ]", "VsyncRelay Quit");
                }
                catch (Throwable e) {
                    YMFLog.error((Object)this, "[Decoder ]", "VsyncRelay Quit exception:" + e.getMessage());
                }
            }
            this.mThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        YMFLog.info(this, "[Decoder ]", "VsyncRelayThread START, instances:" + ++sInstances);
        try {
            Looper.prepare();
            this.mVsyncHandler = new VsyncHandler(this);
            this.mChoreographer = Choreographer.getInstance();
            this.mVsyncNotifierList = new LinkedList<VsyncNotifier>();
            this.mReady.set(true);
            object = this.mStartLock;
            synchronized (object) {
                this.mStartLock.notifyAll();
            }
            Looper.loop();
            this.mReady.set(false);
            this.stopCatchVsync();
            this.mVsyncNotifierList.clear();
            this.mVsyncNotifierList = null;
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Decoder ]", "VsyncRelayThread exception:" + t.getMessage());
            t.printStackTrace();
        }
        finally {
            object = this.mQuitLock;
            synchronized (object) {
                this.mQuitLock.notifyAll();
            }
        }
        YMFLog.info(this, "[Decoder ]", "VsyncRelayThread end");
        --sInstances;
    }

    private void handleRegisterVsyncNotifier(VsyncNotifier vsyncNotifier) {
        this.mVsyncNotifierList.remove(vsyncNotifier);
        this.mVsyncNotifierList.add(vsyncNotifier);
        this.startCatchVsync();
    }

    private void handleUnRegisterVsyncNotifier(VsyncNotifier vsyncNotifier) {
        this.mVsyncNotifierList.remove(vsyncNotifier);
        if (this.mVsyncNotifierList.isEmpty()) {
            this.stopCatchVsync();
        }
    }

    private void startCatchVsync() {
        if (!this.mIsCatchingVsync) {
            this.mIsCatchingVsync = true;
            this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    private void stopCatchVsync() {
        if (this.mIsCatchingVsync) {
            this.mIsCatchingVsync = false;
            this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    public void doFrame(long frameTimeNanos) {
        if (this.mVsyncNotifierList != null) {
            for (VsyncNotifier VsyncNotifier2 : this.mVsyncNotifierList) {
                try {
                    VsyncNotifier2.OnVsyncArrived(frameTimeNanos);
                }
                catch (Throwable t) {
                    YMFLog.error((Object)this, "[Decoder ]", "OnVsyncArrived exception:" + t.getMessage());
                }
            }
        }
        if (this.mIsCatchingVsync) {
            this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    static {
        sInstances = 0;
    }

    public static interface VsyncNotifier {
        public void OnVsyncArrived(long var1);
    }

    private static class VsyncHandler
    extends Handler {
        private WeakReference<VsyncRelay> mWeakRelay;

        public VsyncHandler(VsyncRelay vsyncRelay) {
            this.mWeakRelay = new WeakReference<VsyncRelay>(vsyncRelay);
        }

        public void handleMessage(Message msg) {
            int what = msg.what;
            if (0 == what) {
                Looper loop = Looper.myLooper();
                if (null != loop) {
                    loop.quit();
                    this.removeCallbacksAndMessages(null);
                }
                return;
            }
            VsyncRelay vsyncRelay = (VsyncRelay)this.mWeakRelay.get();
            if (vsyncRelay == null) {
                YMFLog.warn((Object)this, "[Decoder ]", "handleMessage: vsyncRelay is null");
                return;
            }
            switch (what) {
                case 1: {
                    vsyncRelay.handleRegisterVsyncNotifier((VsyncNotifier)msg.obj);
                    break;
                }
                case 2: {
                    vsyncRelay.handleUnRegisterVsyncNotifier((VsyncNotifier)msg.obj);
                    break;
                }
            }
        }
    }
}

