/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.util.Log;
import com.yy.videoplayer.utils.BasicFileUtils;
import com.yy.videoplayer.utils.ILog;
import com.yy.videoplayer.utils.LogToES;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.IllegalFormatException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class YMFLog {
    private static ILog mLogger = null;
    private static boolean mIsDebug = false;
    private static boolean mShowLines = true;
    private static boolean mShowFileName = true;
    private static boolean mShowFuncName = false;
    private static boolean mShowIdentity = true;
    private static boolean mIsSaveToFile = false;
    private static boolean mCloseLog = false;
    private static String mLogPath = null;
    private static ExecutorService mSingleThreadPool = Executors.newSingleThreadExecutor(new YMFLogThreadFactory());

    private static String tag() {
        return "YMFPlay";
    }

    private static boolean isDebuggable() {
        return mIsDebug;
    }

    private static boolean isSaveToFile() {
        return mIsSaveToFile;
    }

    public static void CloseLog() {
        mCloseLog = true;
    }

    public static void OpenLog() {
        mCloseLog = false;
    }

    public static void setFilePath(String path) {
        mLogPath = path;
        LogToES.setLogPath(path);
    }

    public static void setDebug(boolean enable) {
        mIsDebug = enable;
    }

    public static void setSaveToFile(boolean enable) {
        mIsSaveToFile = enable;
    }

    public static void registerLogger(Object logger) {
        mLogger = (ILog)logger;
    }

    public static void debug(Object obj, String Tag2, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        if (YMFLog.isDebuggable()) {
            try {
                String msg = String.format(format, args);
                String logText = YMFLog.msgForTextLog(obj, Tag2, msg);
                if (mLogger != null) {
                    mLogger.debug(YMFLog.tag(), logText);
                } else {
                    Log.d((String)YMFLog.tag(), (String)logText);
                }
                if (YMFLog.isSaveToFile() && BasicFileUtils.externalStorageExist()) {
                    YMFLog.logToFile(logText);
                }
            }
            catch (IllegalFormatException e) {
                Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
            }
            catch (NullPointerException e) {
                Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
            }
        }
    }

    public static String debug(Object obj, String Tag2, String msg) {
        if (mCloseLog) {
            return null;
        }
        if (YMFLog.isDebuggable()) {
            String logText = YMFLog.msgForTextLog(obj, Tag2, msg);
            if (mLogger != null) {
                mLogger.debug(YMFLog.tag(), logText);
            } else {
                Log.d((String)YMFLog.tag(), (String)logText);
            }
        }
        return msg;
    }

    public static void debug(Object obj, String Tag2, Throwable t) {
        if (mCloseLog) {
            return;
        }
        if (YMFLog.isDebuggable()) {
            String logText = YMFLog.msgForTextLog(obj, Tag2, "");
            if (mLogger != null) {
                mLogger.debug(YMFLog.tag(), logText);
            } else {
                Log.d((String)YMFLog.tag(), (String)logText, (Throwable)t);
            }
            if (YMFLog.isSaveToFile() && BasicFileUtils.externalStorageExist()) {
                YMFLog.logToFile(logText, t);
            }
        }
    }

    public static void info(Object obj, String tag2, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            String logText = YMFLog.msgForTextLog(obj, tag2, msg);
            if (mLogger != null) {
                mLogger.info(YMFLog.tag(), logText);
            } else {
                Log.i((String)YMFLog.tag(), (String)logText);
                YMFLog.logToFile(logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void info(Object obj, String tag2, String msg) {
        if (mCloseLog) {
            return;
        }
        String logText = YMFLog.msgForTextLog(obj, tag2, msg);
        if (mLogger != null) {
            mLogger.info(YMFLog.tag(), logText);
        } else {
            Log.i((String)YMFLog.tag(), (String)logText);
            YMFLog.logToFile(logText);
        }
    }

    public static void warn(Object obj, String tag2, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            String logText = YMFLog.msgForTextLog(obj, tag2, msg);
            if (mLogger != null) {
                mLogger.warn(YMFLog.tag(), logText);
            } else {
                Log.w((String)YMFLog.tag(), (String)logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void warn(Object obj, String tag2, String msg) {
        if (mCloseLog) {
            return;
        }
        String logText = YMFLog.msgForTextLog(obj, tag2, msg);
        if (mLogger != null) {
            mLogger.warn(YMFLog.tag(), logText);
        } else {
            Log.w((String)YMFLog.tag(), (String)logText);
        }
    }

    public static void error(Object obj, String tag2, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            String logText = YMFLog.msgForTextLog(obj, tag2, msg);
            if (mLogger != null) {
                mLogger.error(YMFLog.tag(), logText);
            } else {
                Log.e((String)YMFLog.tag(), (String)logText);
                YMFLog.logToFile(logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void error(Object obj, String tag2, String msg) {
        String logText = YMFLog.msgForTextLog(obj, tag2, msg);
        if (mLogger != null) {
            mLogger.error(YMFLog.tag(), logText);
        } else {
            Log.e((String)YMFLog.tag(), (String)logText);
            YMFLog.logToFile(logText);
        }
    }

    public static void error(Object obj, String tag2, Throwable t) {
        String logText = YMFLog.msgForTextLog(obj, tag2, "");
        if (mLogger != null) {
            mLogger.error(YMFLog.tag(), logText, t);
        } else {
            Log.e((String)YMFLog.tag(), (String)logText, (Throwable)t);
            YMFLog.logToFile(logText);
        }
    }

    private static String objClassName(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.getClass().getSimpleName();
    }

    private static void logToFile(String logText) {
        YMFLog.writeToLog(logText);
    }

    private static void writeToLog(final String logText) {
        if (mCloseLog) {
            return;
        }
        if (mLogPath == null) {
            return;
        }
        mSingleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                if (BasicFileUtils.externalStorageExist()) {
                    try {
                        LogToES.writeLogToFile(LogToES.getAbsolutionLogPath(), "yyvideoplayer.txt", logText);
                    }
                    catch (Throwable e) {
                        Log.e((String)"YMFLogs", (String)("writeLogToFile fail, " + e));
                    }
                }
            }
        });
    }

    private static void logToFile(String logText, Throwable t) {
        if (mCloseLog) {
            return;
        }
        StringWriter sw = new StringWriter();
        sw.write(logText);
        sw.write("\n");
        PrintWriter pw = new PrintWriter(sw);
        pw.println(t.getMessage());
        YMFLog.writeToLog(sw.toString());
    }

    private static String msgForTextLog(Object obj, String tag2, String msg) {
        StackTraceElement[] element = null;
        if (!(mShowFileName && mShowFuncName && mShowLines)) {
            element = Thread.currentThread().getStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tag2);
        if (mShowFileName || mShowIdentity || mShowFuncName) {
            sb.append("[");
            if (mShowFileName && element != null) {
                String filename = element[4].getFileName();
                if (obj == null || "".equals(YMFLog.objClassName(obj))) {
                    sb.append(filename, 0, filename.length() - 5);
                } else {
                    sb.append(YMFLog.objClassName(obj));
                }
            }
            if (mShowIdentity && obj != null) {
                sb.append(" @");
                sb.append(Integer.toHexString(System.identityHashCode(obj)));
            }
            if (mShowFuncName && element != null) {
                sb.append(" ");
                sb.append(element[4].getMethodName());
            }
            sb.append("] ");
        } else {
            sb.append(" ");
        }
        sb.append(msg);
        sb.append("(");
        sb.append(Thread.currentThread().getId());
        if (mShowLines && element != null) {
            sb.append(":");
            sb.append(element[4].getLineNumber());
        }
        sb.append(")");
        String ret = sb.toString();
        return ret;
    }

    public static String stackTraceOf(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String threadStack() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            pw.println(e.toString());
        }
        return sw.toString();
    }

    private static class YMFLogThreadFactory
    implements ThreadFactory {
        private YMFLogThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "YMFLog_Thread");
        }
    }
}

