/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class LogToES {
    private static String TAG = "LogToES";
    private static final String BAK_EXT = ".bak";
    public static final int MAX_FILE_SIZE = 2;
    private static final ThreadLocal<DateFormat> logFormater = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy:MM:dd kk:mm:ss.SSS", Locale.getDefault());
        }
    };
    private static final long DAY_DELAY = 864000000L;
    private static final int BAK_FILE_NUM_LIMIT = 2;
    private static String s_LogPath = null;
    private static String s_AbsoluteLogPath = null;
    private static final SimpleDateFormat FILE_NAME_FORMAT = new SimpleDateFormat("MM-dd_HH-mm-ss", Locale.getDefault());
    private static final String[] LOGCAT_CMD = new String[]{"logcat", "-d", "-v", "time"};
    private static final String LOG_NAME_PREFIX = "yysdk_adapter";
    private static final String LOG_PATH = "/logs";
    private static String mLogFileName = "";
    private static String mLogFilePath = "";

    public static String getLogPath() {
        return s_LogPath == null ? "/yyvideoplayer" : s_LogPath;
    }

    public static String getAbsolutionLogPath() {
        return s_AbsoluteLogPath;
    }

    public static void setLogPath(String logPath) {
        s_LogPath = File.separator + logPath;
        File esdf = Environment.getExternalStorageDirectory();
        s_AbsoluteLogPath = esdf.getAbsolutePath() + s_LogPath;
    }

    public static synchronized void writeLogToFile(String path, String fileName, String msg) throws IOException {
        LogToES.writeLog(path, fileName, msg);
    }

    public static synchronized void writeLogToCacheFile(String path, String fileName, String msg) throws IOException {
        LogToES.writeLog(path, fileName, msg);
    }

    public static void writeLog(String path, String fileName, String msg) throws IOException {
        File logFile;
        Date date = new Date();
        File dirFile = new File(path);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if (!(logFile = new File(path + File.separator + fileName)).exists()) {
            try {
                Log.i((String)TAG, (String)("try to create new log file:" + logFile.toString() + " path:" + path + " fileName:" + fileName));
                logFile.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("create new log file fail:" + e.getMessage()));
                return;
            }
        } else {
            long fileSize = logFile.length() >>> 20;
            if (fileSize > 2L) {
                LogToES.deleteOldLogs();
                SimpleDateFormat simpleDateFormate = new SimpleDateFormat("-MM-dd-kk-mm-ss", Locale.getDefault());
                String fileExt = simpleDateFormate.format(date);
                StringBuilder sb = new StringBuilder(path);
                sb.append(File.separator).append(fileName).append(fileExt).append(BAK_EXT);
                File fileNameTo = new File(sb.toString());
                logFile.renameTo(fileNameTo);
                Log.d((String)"LogToES", (String)"LogToES log keep volume.");
                LogToES.limitVolume();
            }
        }
        String strLog = logFormater.get().format(date);
        StringBuilder sb = new StringBuilder(strLog);
        sb.append(' ');
        sb.append(msg);
        sb.append('\n');
        strLog = sb.toString();
        FileWriter fileWriter = new FileWriter(logFile, true);
        fileWriter.write(strLog);
        fileWriter.flush();
        fileWriter.close();
    }

    private static void deleteOldLogs() {
        File esdf = Environment.getExternalStorageDirectory();
        if (!esdf.exists()) {
            return;
        }
        String dir = esdf.getAbsolutePath() + LogToES.getLogPath();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return;
        }
        long now = System.currentTimeMillis();
        File[] files = dirFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            long lastModifiedTime;
            if (!file.getName().endsWith(BAK_EXT) || now - (lastModifiedTime = file.lastModified()) <= 864000000L) continue;
            file.delete();
        }
    }

    private static void limitVolume() {
        File esdf = Environment.getExternalStorageDirectory();
        if (!esdf.exists()) {
            return;
        }
        String dir = esdf.getAbsolutePath() + LogToES.getLogPath();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return;
        }
        File[] files = dirFile.listFiles();
        if (files == null || files.length <= Math.max(0, 2)) {
            return;
        }
        int numOfDeletable = 0;
        int N = files.length;
        for (int i = 0; i < N; ++i) {
            File file = files[i];
            if (!file.getName().endsWith(BAK_EXT)) continue;
            ++numOfDeletable;
        }
        if (numOfDeletable <= 0) {
            return;
        }
        Log.d((String)"LogToES", (String)("LogToES there ARE " + numOfDeletable + " deletables."));
        File[] deletables = new File[numOfDeletable];
        int i = 0;
        for (File e : files) {
            if (i >= numOfDeletable) break;
            if (!e.getName().endsWith(BAK_EXT)) continue;
            deletables[i++] = e;
        }
        LogToES.deleteIfOutOfBound(deletables);
    }

    private static void deleteIfOutOfBound(File[] files) {
        int i;
        if (files.length <= 2) {
            return;
        }
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                return rhs.getName().compareTo(lhs.getName());
            }
        };
        Arrays.sort(files, comparator);
        int filesNum = files.length;
        for (i = 0; i < 2; ++i) {
            Log.d((String)"LogToES", (String)("LogToES keep file " + files[i]));
        }
        for (i = 2; i < filesNum; ++i) {
            File file = files[i];
            if (!file.delete()) {
                Log.e((String)"LogToES", (String)("LogToES failed to delete file " + file));
                continue;
            }
            Log.d((String)"LogToES", (String)("LogToES delete file " + file));
        }
    }

    public static void writeAllLogsToFile() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String fileName;
                    File file;
                    String line;
                    Date date = new Date();
                    Process process = Runtime.getRuntime().exec(LOGCAT_CMD);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
                    StringBuilder sb = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        sb.append(line);
                        sb.append(System.getProperty("line.separator"));
                    }
                    bufferedReader.close();
                    File esdf = Environment.getExternalStorageDirectory();
                    String dir = esdf.getAbsolutePath() + LogToES.getLogPath();
                    File dirFile = new File(dir);
                    if (!dirFile.exists()) {
                        dirFile.mkdirs();
                    }
                    if (!(file = new File(fileName = dir + File.separator + FILE_NAME_FORMAT.format(date) + ".log")).exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(sb.toString().getBytes());
                    fos.flush();
                    fos.close();
                }
                catch (IOException e) {
                    Log.e((String)"yy", (String)("Failed to writeAllLogsToFile " + e));
                }
            }
        }, "YY_yyvideolib_LogToES_Thread").start();
    }

    private static String findLastModifYMFLogFile() {
        File esdf = Environment.getExternalStorageDirectory();
        if (!esdf.exists()) {
            return LogToES.createLogFileName();
        }
        String dir = esdf.getAbsolutePath() + LogToES.getLogFilePath();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return LogToES.createLogFileName();
        }
        File[] files = dirFile.listFiles();
        if (files == null) {
            return LogToES.createLogFileName();
        }
        File targetFile = null;
        for (File file : files) {
            if (!file.getName().startsWith(LOG_NAME_PREFIX) || targetFile != null && targetFile.lastModified() >= file.lastModified()) continue;
            targetFile = file;
        }
        if (targetFile != null) {
            return targetFile.getName();
        }
        return LogToES.createLogFileName();
    }

    private static String createLogFileName() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormate = new SimpleDateFormat("-MM-dd-kk-mm");
        String fileExt = simpleDateFormate.format(date);
        String fileName = LOG_NAME_PREFIX + fileExt + ".txt";
        return fileName;
    }

    public static void setLogFilePath(String path) {
        mLogFilePath = path;
    }

    public static String getLogFilePath() {
        if (mLogFilePath == null || mLogFilePath.trim().length() == 0) {
            mLogFilePath = "/yysdk/logs";
        }
        return mLogFilePath;
    }

    public static String getLogFileName() {
        if (mLogFileName == null || mLogFileName.trim().length() == 0) {
            mLogFileName = LogToES.findLastModifYMFLogFile();
        }
        return mLogFileName;
    }
}

