/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.utils.YMFLog;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class InfoUtil {
    private static final String TAG = "InfoUtil";

    public static String getAndroidId() {
        String androidId = Settings.Secure.getString((ContentResolver)YYVideoLibMgr.instance().getAppContext().getContentResolver(), (String)"android_id");
        return androidId;
    }

    public static String getAppPackage() {
        String pkName = YYVideoLibMgr.instance().getAppContext().getPackageName();
        return pkName;
    }

    public static String getAppVerCode() {
        Context context = YYVideoLibMgr.instance().getAppContext();
        String pkName = InfoUtil.getAppPackage();
        int versionCode = 0;
        try {
            versionCode = context.getPackageManager().getPackageInfo((String)pkName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        return versionCode + "";
    }

    public static String getVersionName() {
        Context context = YYVideoLibMgr.instance().getAppContext();
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packInfo = null;
        try {
            packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        String version = packInfo.versionName;
        return version;
    }

    public static String getMacAddr() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        return "02:00:00:00:00:00";
    }
}

