/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.yy.videoplayer.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GLUtil {
    private static final String TAG = "GLUtil";
    private static final int SIZEOF_FLOAT = 4;

    public static int genTexture(int target, int width, int height) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)target, (int)textures[0]);
        GLES20.glTexParameterf((int)target, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)target, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)target, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)target, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        return textures[0];
    }

    public static FloatBuffer createFloatBuffer(float[] coords) {
        ByteBuffer bb = ByteBuffer.allocateDirect(coords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(coords);
        fb.position(0);
        return fb;
    }

    public static int genTextureWithBitmap(Bitmap bitmap) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glActiveTexture((int)33989);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        return textures[0];
    }

    public static int updateTextureWithBitmap(int texture, Bitmap bitmap) {
        GLES20.glActiveTexture((int)33989);
        GLES20.glBindTexture((int)3553, (int)texture);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        return 0;
    }

    public static void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String msg = op + ": glError 0x" + Integer.toHexString(error);
            YMFLog.error(null, "[Util    ]", msg);
        }
    }
}

