/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.content.Context;
import android.opengl.GLES20;
import com.yy.videoplayer.utils.YMFLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.util.HashMap;

public class GLShaderProgram {
    static final String Tag = "GLShaderProgram";
    private int mProgram = -1;
    private int mShaderVertex = -1;
    private int mShaderFragment = -1;
    private String vertexSource;
    private String fragmentSource;
    private final HashMap<String, Integer> mShaderHandleMap = new HashMap();

    public void setProgram(int vertexShader, int fragmentShader, Context context) {
        this.vertexSource = this.loadRawString(vertexShader, context);
        this.fragmentSource = this.loadRawString(fragmentShader, context);
        this.setProgram(this.vertexSource, this.fragmentSource);
    }

    public void setProgram(String vertexSource, String fragmentSource) {
        this.mShaderVertex = this.loadShader(35633, vertexSource);
        this.mShaderFragment = this.loadShader(35632, fragmentSource);
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)this.mShaderVertex);
            GLES20.glAttachShader((int)program, (int)this.mShaderFragment);
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                String error = GLES20.glGetProgramInfoLog((int)program);
                this.destory();
                YMFLog.error(null, "[Util    ]", "Link shader error:" + error);
                return;
            }
        }
        this.mProgram = program;
        this.mShaderHandleMap.clear();
    }

    public void useProgram() {
        GLES20.glUseProgram((int)this.mProgram);
    }

    public void destory() {
        if (this.mProgram != -1) {
            GLES20.glDeleteShader((int)this.mShaderVertex);
            GLES20.glDeleteShader((int)this.mShaderFragment);
            GLES20.glDeleteProgram((int)this.mProgram);
            this.mShaderFragment = -1;
            this.mShaderVertex = -1;
            this.mProgram = -1;
        }
    }

    public int programHandle() {
        return this.mProgram;
    }

    public int getHandle(String name) {
        if (this.mShaderHandleMap.containsKey(name)) {
            return this.mShaderHandleMap.get(name);
        }
        int handle = GLES20.glGetAttribLocation((int)this.mProgram, (String)name);
        if (handle == -1) {
            handle = GLES20.glGetUniformLocation((int)this.mProgram, (String)name);
        }
        if (handle == -1) {
            YMFLog.error(null, "[Util    ]", "Could not get attrib location for " + name);
        } else {
            this.mShaderHandleMap.put(name, handle);
        }
        return handle;
    }

    public int[] getHandles(String ... names) {
        int[] res = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            res[i] = this.getHandle(names[i]);
        }
        return res;
    }

    private int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                String error = GLES20.glGetShaderInfoLog((int)shader);
                GLES20.glDeleteShader((int)shader);
                YMFLog.error(null, "[Util    ]", "Compile shader error:" + error);
                return -1;
            }
        }
        return shader;
    }

    private String loadRawString(int rawId, Context context) {
        InputStream is = context.getResources().openRawResource(rawId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
        }
        catch (IOException ioe) {
            YMFLog.info(null, "[Util    ]", "loadRawString exception:" + ioe.getMessage());
        }
        return baos.toString();
    }

    public void setUniform1i(String name, int x) {
        int location = this.getHandle(name);
        GLES20.glUniform1i((int)location, (int)x);
    }

    public void setUniform2i(String name, int x, int y) {
        int location = this.getHandle(name);
        GLES20.glUniform2i((int)location, (int)x, (int)y);
    }

    public void setUniform1f(String name, float x) {
        int location = this.getHandle(name);
        GLES20.glUniform1f((int)location, (float)x);
    }

    public void setUniform2f(String name, float x, float y) {
        int location = this.getHandle(name);
        GLES20.glUniform2f((int)location, (float)x, (float)y);
    }

    public void setUniformMatrix4fv(String name, int count, boolean transpose, float[] value, int offset) {
        int location = this.getHandle(name);
        GLES20.glUniformMatrix4fv((int)location, (int)count, (boolean)transpose, (float[])value, (int)offset);
    }

    public void setVertexAttribPointer(String name, int size, int type, boolean normalized, int stride, Buffer ptr) {
        int index = this.getHandle(name);
        GLES20.glEnableVertexAttribArray((int)index);
        GLES20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (Buffer)ptr);
    }

    public void disableVertexAttribPointer(String name) {
        int index = this.getHandle(name);
        GLES20.glDisableVertexAttribArray((int)index);
    }

    public void setUniformTexture(String name, int x, int textureID, int target) {
        int location = this.getHandle(name);
        GLES20.glUniform1i((int)location, (int)x);
        GLES20.glActiveTexture((int)(33984 + x));
        GLES20.glBindTexture((int)target, (int)textureID);
    }
}

