/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.yy.videoplayer.utils.YMFLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;

public class FP {
    public static <A, B, C> Tuple<A, B, C> makeTuple(A a, B b, C c) {
        return new Tuple<A, B, C>(a, b, c);
    }

    public static <E> Pred<E> negate(final Pred<E> p) {
        return new Pred<E>(){

            @Override
            public boolean pred(E x) {
                return !p.pred(x);
            }
        };
    }

    public static int limit(int x, int low, int high) {
        return Math.min(Math.max(low, x), high);
    }

    public static int maximum(int ... xs) {
        int m = Integer.MIN_VALUE;
        for (int x : xs) {
            m = Math.max(m, x);
        }
        return m;
    }

    public static <E> E find(Pred<E> p, List<E> xs) {
        if (!FP.empty(xs)) {
            for (E x : xs) {
                if (!p.pred(x)) continue;
                return x;
            }
        }
        return null;
    }

    public static <E> E find(final E x, List<E> xs) {
        return (E)FP.find(new Pred<E>(){

            @Override
            public boolean pred(E y) {
                return y.equals(x);
            }
        }, xs);
    }

    public static <E> int findIndex(Pred<E> p, List<E> xs) {
        int i;
        int n = FP.length(xs);
        for (i = 0; i < n && !p.pred(xs.get(i)); ++i) {
        }
        return i == n ? -1 : i;
    }

    public static <K, V> V lookup(K k, List<Pair<K, V>> xs) {
        if (!FP.empty(xs)) {
            for (Pair<K, V> x : xs) {
                if (k != x.first) continue;
                return (V)x.second;
            }
        }
        return null;
    }

    public static <E> E lookup(int k, SparseArray<E> xs) {
        return (E)(FP.empty(xs) ? null : xs.get(k));
    }

    public static <E> List<E> nubBy(final Eq<E> cmp, List<E> xs) {
        ArrayList<E> ys = new ArrayList<E>();
        if (!FP.empty(xs)) {
            for (final E x : xs) {
                if (FP.find(new Pred<E>(){

                    @Override
                    public boolean pred(E y) {
                        return cmp.eq(x, y);
                    }
                }, ys) != null) continue;
                ys.add(x);
            }
        }
        return ys;
    }

    public static <E> List<E> nub(List<E> xs) {
        return FP.nubBy(new Eq<E>(){

            @Override
            public boolean eq(E x, E y) {
                return y.equals(x);
            }
        }, xs);
    }

    public static boolean empty(Collection<?> xs) {
        return xs == null || xs.isEmpty();
    }

    public static <T> boolean empty(T[] xs) {
        return xs == null || xs.length == 0;
    }

    public static boolean empty(SparseArray<?> xs) {
        return xs == null || xs.size() == 0;
    }

    public static boolean empty(SparseIntArray xs) {
        return xs == null || xs.size() == 0;
    }

    public static boolean empty(int[] xs) {
        return xs == null || xs.length == 0;
    }

    public static boolean empty(long[] xs) {
        return xs == null || xs.length == 0;
    }

    public static boolean empty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean empty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static int size(Collection<?> xs) {
        return xs == null ? 0 : xs.size();
    }

    public static int size(CharSequence s) {
        return s == null ? 0 : s.length();
    }

    public static <T> int size(T[] xs) {
        return xs == null ? 0 : xs.length;
    }

    public static int size(int[] xs) {
        return xs == null ? 0 : xs.length;
    }

    public static int size(Map<?, ?> m) {
        return m == null ? 0 : m.size();
    }

    public static int size(SparseArray<?> xs) {
        return xs == null ? 0 : xs.size();
    }

    public static int size(SparseIntArray xs) {
        return xs == null ? 0 : xs.size();
    }

    public static int length(Collection<?> xs) {
        return FP.size(xs);
    }

    public static int length(CharSequence s) {
        return FP.size(s);
    }

    public static <T> int length(T[] xs) {
        return FP.size(xs);
    }

    public static int length(int[] xs) {
        return FP.size(xs);
    }

    public static int length(Map<?, ?> m) {
        return FP.size(m);
    }

    public static int length(SparseArray<?> xs) {
        return FP.size(xs);
    }

    public static int length(SparseIntArray xs) {
        return FP.size(xs);
    }

    public static <T> boolean elem(T x, T[] xs) {
        return !FP.empty(xs) && Arrays.asList(xs).contains(x);
    }

    public static <T> boolean elem(T x, Collection<T> xs) {
        return !FP.empty(xs) && xs.contains(x);
    }

    public static <T> void swap(List<T> xs, int i, int j) {
        T tmp = xs.get(i);
        xs.set(i, xs.get(j));
        xs.set(j, tmp);
    }

    public static <T> void swap(T[] xs, int i, int j) {
        T tmp = xs[i];
        xs[i] = xs[j];
        xs[j] = tmp;
    }

    public static <T> void shift(List<T> xs, int from, int to) {
        int d;
        T tmp = xs.get(from);
        int n = d = from < to ? 1 : -1;
        while (from != to) {
            xs.set(from, xs.get(from + d));
            from += d;
        }
        xs.set(to, tmp);
    }

    public static <T> void shift(T[] xs, int from, int to) {
        int d;
        T tmp = xs[from];
        int n = d = from < to ? 1 : -1;
        while (from != to) {
            xs[from] = xs[from + d];
            from += d;
        }
        xs[to] = tmp;
    }

    public static <E> List<E> add(List<E> xs, E x) {
        if (xs == null) {
            xs = new ArrayList();
        }
        xs.add(x);
        return xs;
    }

    public static <E> List<E> delBy(Eq<E> cmp, List<E> xs, E x) {
        int i;
        int n = FP.length(xs);
        for (i = 0; i < n && !cmp.eq(xs.get(i), x); ++i) {
        }
        if (i < n) {
            xs.remove(i);
        }
        return xs;
    }

    public static <E> List<E> del(List<E> xs, E x) {
        return FP.delBy(new Eq<E>(){

            @Override
            public boolean eq(E x, E y) {
                return FP.eq(x, y);
            }
        }, xs, x);
    }

    public static <E> Pair<List<E>, List<E>> span(Pred<E> p, List<E> xs) {
        return Pair.create(FP.takeWhile(p, xs), FP.dropWhile(p, xs));
    }

    public static <E> List<E> take(int n, List<E> xs) {
        ArrayList<E> ys = new ArrayList<E>();
        if (FP.empty(xs) || n <= 0) {
            return ys;
        }
        ys.addAll(xs.subList(0, Math.min(n, FP.length(xs))));
        return ys;
    }

    public static String take(int n, String s) {
        return s.substring(0, FP.limit(n, 0, FP.length(s)));
    }

    public static <K, V> Map<K, V> take(int n, Map<K, V> xs) {
        HashMap<K, V> ys = new HashMap<K, V>();
        for (K k : xs.keySet()) {
            if (n-- <= 0) continue;
            ys.put(k, xs.get(k));
        }
        return ys;
    }

    public static <E> List<E> takeWhile(Pred<E> p, List<E> xs) {
        int i;
        int n = FP.length(xs);
        for (i = 0; i < n && p.pred(xs.get(i)); ++i) {
        }
        return FP.take(i, xs);
    }

    public static <E> List<E> drop(int n, List<E> xs) {
        ArrayList<E> ys = new ArrayList<E>();
        if (xs == null || n > FP.length(xs)) {
            return ys;
        }
        ys.addAll(xs.subList(Math.max(0, n), FP.length(xs)));
        return ys;
    }

    public static String drop(int n, String s) {
        if (s == null || n > FP.length(s)) {
            return "";
        }
        return s.substring(Math.max(0, n));
    }

    public static <E> List<E> dropWhile(Pred<E> p, List<E> xs) {
        int n = FP.length(xs);
        for (int i = 0; i < n && p.pred(xs.get(i)); ++i) {
        }
        return FP.drop(n, xs);
    }

    public static <E> E head(LinkedList<E> xs) {
        return FP.empty(xs) ? null : (E)xs.element();
    }

    public static <E> LinkedList<E> tail(LinkedList<E> xs) {
        if (FP.empty(xs)) {
            return xs;
        }
        LinkedList<E> ys = new LinkedList<E>(xs);
        ys.remove();
        return ys;
    }

    public static <E> LinkedList<E> cons(E x, LinkedList<E> xs) {
        xs = FP.empty(xs) ? new LinkedList<E>() : xs;
        xs.addFirst(x);
        return xs;
    }

    public static <E> E first(List<E> xs) {
        return FP.empty(xs) ? null : (E)xs.get(0);
    }

    public static <E> E second(List<E> xs) {
        return FP.size(xs) < 2 ? null : (E)xs.get(1);
    }

    public static <E> E last(List<E> xs) {
        return FP.empty(xs) ? null : (E)xs.get(FP.lastIndex(xs));
    }

    public static int lastIndex(List<?> xs) {
        return FP.empty(xs) ? -1 : xs.size() - 1;
    }

    public static <E> E first(Collection<E> xs) {
        if (FP.empty(xs)) {
            return null;
        }
        return xs.iterator().next();
    }

    public static <E> List<E> toList(Collection<? extends E> xs) {
        return FP.empty(xs) ? new ArrayList() : new ArrayList<E>(xs);
    }

    public static <T> List<T> toList(T x) {
        return Collections.singletonList(x);
    }

    public static <T> List<T> toList(T[] xs) {
        ArrayList<T> ys = new ArrayList<T>();
        if (!FP.empty(xs)) {
            for (T x : xs) {
                ys.add(x);
            }
        }
        return ys;
    }

    public static List<Integer> toList(int[] xs) {
        ArrayList<Integer> ys = new ArrayList<Integer>();
        if (!FP.empty(xs)) {
            for (int x : xs) {
                ys.add(x);
            }
        }
        return ys;
    }

    public static List<Long> toList(long[] xs) {
        ArrayList<Long> ys = new ArrayList<Long>();
        if (!FP.empty(xs)) {
            for (long x : xs) {
                ys.add(x);
            }
        }
        return ys;
    }

    public static <E> List<Pair<Integer, E>> toList(SparseArray<E> xs) {
        ArrayList<Pair<Integer, Pair>> ys = new ArrayList<Pair<Integer, Pair>>();
        if (!FP.empty(xs)) {
            for (int i = 0; i < xs.size(); ++i) {
                ys.add(Pair.create((Object)xs.keyAt(i), (Object)xs.valueAt(i)));
            }
        }
        return ys;
    }

    public static List<Pair<Integer, Integer>> toList(SparseIntArray xs) {
        ArrayList<Pair<Integer, Integer>> ys = new ArrayList<Pair<Integer, Integer>>();
        if (!FP.empty(xs)) {
            for (int i = 0; i < xs.size(); ++i) {
                ys.add((Pair<Integer, Integer>)Pair.create((Object)xs.keyAt(i), (Object)xs.valueAt(i)));
            }
        }
        return ys;
    }

    public static int[] toArray(List<Integer> xs) {
        int n = FP.length(xs);
        int[] ys = new int[n];
        for (int i = 0; i < n; ++i) {
            ys[i] = xs.get(i);
        }
        return ys;
    }

    public static <E> List<E> ref(List<E> xs) {
        return xs == null ? new ArrayList() : xs;
    }

    public static <E> E[] ref(E[] xs) {
        return xs == null ? new Object[]{} : xs;
    }

    public static int[] ref(int[] xs) {
        return xs == null ? new int[]{} : xs;
    }

    public static String ref(String s) {
        return s == null ? "" : s;
    }

    public static <A, B> List<Pair<A, B>> zip(List<A> as, List<B> bs) {
        ArrayList<Pair<A, B>> xs = new ArrayList<Pair<A, B>>();
        if (!FP.empty(as) && !FP.empty(bs)) {
            Iterator<A> a = as.iterator();
            Iterator<B> b = bs.iterator();
            while (a.hasNext() && b.hasNext()) {
                xs.add(Pair.create(a.next(), b.next()));
            }
        }
        return xs;
    }

    public static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && a.equals(b);
    }

    public static boolean isPrefixOf(String prefix, String s) {
        if (FP.empty(prefix)) {
            return true;
        }
        return !FP.empty(s) && s.startsWith(prefix);
    }

    public static <E> boolean isPrefixOf(List<E> prefix, List<E> xs) {
        if (FP.empty(prefix)) {
            return true;
        }
        return !FP.empty(xs) && FP.eq(prefix, FP.take(FP.length(prefix), xs));
    }

    public static <T> void convert(T[] dst, Object[] src) {
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src;
        }
    }

    public static <T> List<T> concat(List<T> xs, List<T> ys) {
        List<T> zs = FP.ref(xs);
        zs.addAll(FP.ref(ys));
        return zs;
    }

    public static <T> T[] concat(T[] xs, T[] ys) {
        Object[] zs = new Object[FP.length(xs) + FP.length(ys)];
        int i = 0;
        for (T x : xs) {
            zs[i++] = x;
        }
        for (T y : ys) {
            zs[i++] = y;
        }
        return zs;
    }

    public static int[] concat(int[] xs, int[] ys) {
        int[] zs = new int[FP.length(xs) + FP.length(ys)];
        int i = 0;
        for (int x : xs) {
            zs[i++] = x;
        }
        for (int y : ys) {
            zs[i++] = y;
        }
        return zs;
    }

    public static <T> List<T> unionBy(Eq<T> cmp, List<T> xs, List<T> ys) {
        ys = FP.ref(ys);
        if (FP.empty(xs)) {
            return ys;
        }
        for (T y : ys) {
            boolean e = false;
            for (T x : xs) {
                if (!cmp.eq(x, y)) continue;
                e = true;
                break;
            }
            if (e) continue;
            xs.add(y);
        }
        return xs;
    }

    public static <T> List<T> union(List<T> xs, List<T> ys) {
        return FP.unionBy(new Eq<T>(){

            @Override
            public boolean eq(T x, T y) {
                return FP.eq(x, y);
            }
        }, xs, ys);
    }

    public static <T> List<T> diffBy(Eq<T> eq, List<T> xs, List<T> ys) {
        List<List<T>> zs = FP.toList(xs);
        for (T y : ys) {
            zs = FP.delBy(eq, zs, y);
        }
        return zs;
    }

    public static <T> List<T> diff(List<T> xs, List<T> ys) {
        return FP.diffBy(new Eq<T>(){

            @Override
            public boolean eq(T x, T y) {
                return FP.eq(x, y);
            }
        }, xs, ys);
    }

    public static <A, B> List<B> map(UnaryFunc<B, A> f, List<A> xs) {
        ArrayList<B> ys = new ArrayList<B>();
        for (A x : FP.ref(xs)) {
            ys.add(f.apply(x));
        }
        return ys;
    }

    public static <E> List<E> filter(Pred<E> p, List<E> xs) {
        ArrayList<E> ys = new ArrayList<E>();
        for (E x : xs) {
            if (!p.pred(x)) continue;
            ys.add(x);
        }
        return ys;
    }

    public static <S, E> S fold(BinaryFunc<S, S, E> f, S s, Collection<E> xs) {
        if (!FP.empty(xs)) {
            for (E x : xs) {
                s = f.apply(s, x);
            }
        }
        return s;
    }

    public static <E> List<E> insert(Comparator<E> cmp, E x, List<E> xs) {
        int pos = Collections.binarySearch(xs, x, cmp);
        pos = pos < 0 ? -pos - 1 : pos;
        xs.add(-pos - 1, x);
        return xs;
    }

    public static <E> List<E> sort(Comparator<E> cmp, List<E> xs) {
        xs = FP.ref(xs);
        try {
            Collections.sort(xs, cmp);
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "Failed to sort %s, exception:%s", xs, e.toString());
        }
        return xs;
    }

    public static int sum(Integer[] xs) {
        int n = 0;
        Integer[] integerArray = xs;
        int n2 = integerArray.length;
        for (int i = 0; i < n2; ++i) {
            int x = integerArray[i];
            n += x;
        }
        return n;
    }

    public static long sum(Long[] xs) {
        long n = 0L;
        Long[] longArray = xs;
        int n2 = longArray.length;
        for (int i = 0; i < n2; ++i) {
            long x = longArray[i];
            n += x;
        }
        return n;
    }

    public static int sum(List<Integer> xs) {
        int n = 0;
        for (int x : xs) {
            n += x;
        }
        return n;
    }

    public static int ord(boolean x) {
        return x ? 1 : 0;
    }

    public static int ord(Integer x) {
        return x == null ? 0 : x;
    }

    public static <E> List<E> replicate(int n, E x) {
        ArrayList<E> xs = new ArrayList<E>();
        while (n-- > 0) {
            xs.add(x);
        }
        return xs;
    }

    public static <E> List<E> replicate(int n, Callable<E> gen) {
        ArrayList<E> xs = new ArrayList<E>();
        try {
            while (n-- > 0) {
                xs.add(gen.call());
            }
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "replicate failed, exception:", e);
        }
        return xs;
    }

    public static class M {
        public static <K, V> List<Pair<K, V>> toList(Map<K, V> m) {
            ArrayList<Pair<K, V>> xs = new ArrayList<Pair<K, V>>();
            if (!FP.empty(m)) {
                for (Map.Entry<K, V> e : m.entrySet()) {
                    xs.add(Pair.create(e.getKey(), e.getValue()));
                }
            }
            return xs;
        }

        public static <K extends Comparable<K>, V> Map<K, V> fromList(List<Pair<K, V>> xs) {
            TreeMap<Object, Object> m = new TreeMap<Object, Object>();
            if (!FP.empty(xs)) {
                for (Pair<K, V> p : xs) {
                    m.put(p.first, p.second);
                }
            }
            return m;
        }

        public static <V> Map<Integer, V> fromList(SparseArray<V> xs) {
            TreeMap<Integer, Object> m = new TreeMap<Integer, Object>();
            if (!FP.empty(xs)) {
                for (int i = 0; i < xs.size(); ++i) {
                    m.put(xs.keyAt(i), xs.valueAt(i));
                }
            }
            return m;
        }

        public static <V> List<V> values(SparseArray<V> m) {
            ArrayList<Object> xs = new ArrayList<Object>();
            int n = FP.size(m);
            for (int i = 0; i < n; ++i) {
                xs.add(m.valueAt(i));
            }
            return xs;
        }
    }

    public static class Tuple<A, B, C> {
        public A a;
        public B b;
        public C c;

        public Tuple(A x, B y, C z) {
            this.a = x;
            this.b = y;
            this.c = z;
        }
    }

    public static abstract class Eq<A>
    implements BinaryFunc<Boolean, A, A> {
        @Override
        public Boolean apply(A x, A y) {
            return this.eq(x, y);
        }

        public abstract boolean eq(A var1, A var2);
    }

    public static abstract class Pred<A>
    implements UnaryFunc<Boolean, A> {
        @Override
        public Boolean apply(A x) {
            return this.pred(x);
        }

        public abstract boolean pred(A var1);
    }

    public static interface BinaryFunc<R, A, B> {
        public R apply(A var1, B var2);
    }

    public static interface UnaryFunc<R, A> {
        public R apply(A var1);
    }
}

