/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import com.yy.videoplayer.utils.YMFLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CPUTool {
    private static final String kCpuInfoMaxFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
    private static final String TAG = "CPUTool";
    private static final String kCpuInfoMinFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq";
    private static final String kCpuInfoCurFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxCpuFreq() {
        int result = 0;
        File file = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            String text;
            file = new File(kCpuInfoMaxFreqFilePath);
            if (file != null && file.exists() && (text = (br = new BufferedReader(fr = new FileReader(file))).readLine()) != null && !text.isEmpty()) {
                result = Integer.parseInt(text.trim());
            }
        }
        catch (FileNotFoundException e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinCpuFreq() {
        int result = 0;
        File file = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            String text;
            file = new File(kCpuInfoMinFreqFilePath);
            if (file != null && file.exists() && (text = (br = new BufferedReader(fr = new FileReader(file))).readLine()) != null && !text.isEmpty()) {
                result = Integer.parseInt(text.trim());
            }
        }
        catch (FileNotFoundException e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "Exception:" + e.toString());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCurCpuFreq() {
        int result = 0;
        File file = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            String text;
            file = new File(kCpuInfoCurFreqFilePath);
            if (file != null && file.exists() && (text = (br = new BufferedReader(fr = new FileReader(file))).readLine()) != null && !text.isEmpty()) {
                result = Integer.parseInt(text.trim());
            }
        }
        catch (FileNotFoundException e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
                }
            }
        }
        return result;
    }

    public static String getCpuInfo() {
        String cpuName = CPUTool.getCpuInfoBySystemProperties();
        if (cpuName != null) {
            return cpuName;
        }
        cpuName = CPUTool.getCpuInfoByProcNode();
        if (cpuName != null) {
            return cpuName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuInfoByProcNode() {
        String strInfo = "/proc/cpuinfo";
        String cpuName = "unknown";
        String tmpName = "";
        BufferedReader localBufferedReader = null;
        FileReader fr = null;
        try {
            fr = new FileReader(strInfo);
            localBufferedReader = new BufferedReader(fr);
            while ((cpuName = localBufferedReader.readLine()) != null) {
                if (!cpuName.contains("Hardware")) continue;
                String[] array = cpuName.split(":");
                if (array.length == 2) {
                    tmpName = array[1];
                } else if (array.length == 1) {
                    tmpName = array[0];
                }
                if (tmpName == null) continue;
                String[] arrayCpuName = tmpName.split(" ");
                if (arrayCpuName.length > 1) {
                    String string = arrayCpuName[arrayCpuName.length - 1];
                    return string;
                }
                String string = arrayCpuName[0];
                return string;
            }
            localBufferedReader.close();
            fr.close();
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
        }
        finally {
            try {
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                YMFLog.error(null, "[Util    ]", "exception:" + e.toString());
            }
        }
        return cpuName;
    }

    public static String getCpuInfoBySystemProperties() {
        try {
            Class<?> classtype = Class.forName("android.os.SystemProperties");
            Method method = classtype.getDeclaredMethod("get", String.class);
            String value = (String)method.invoke(classtype, "ro.board.platform");
            return value;
        }
        catch (ClassNotFoundException e) {
            YMFLog.info(null, "[Util    ]", "getCpuInfo exception:" + e);
        }
        catch (NoSuchMethodException e) {
            YMFLog.info(null, "[Util    ]", "getCpuInfo exception:" + e);
        }
        catch (InvocationTargetException e) {
            YMFLog.info(null, "[Util    ]", "getCpuInfo exception:" + e);
        }
        catch (IllegalAccessException e) {
            YMFLog.info(null, "[Util    ]", "getCpuInfo exception:" + e);
        }
        return null;
    }
}

