/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.os.Environment;
import android.os.StatFs;
import com.yy.videoplayer.utils.FP;
import com.yy.videoplayer.utils.StringUtils;
import com.yy.videoplayer.utils.YMFLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BasicFileUtils {
    private static String TAG = "BasicFileUtils";
    public static final String ZIP_EXT = ".zip";
    public static final String JPG_EXT = ".jpg";
    public static final String SPEEX_EXT = ".aud";
    private static Map<String, String> FILE_MIMES = new HashMap<String, String>();
    private static final int MAX_BUFF_SIZE = 0x100000;
    private static final int MIN_BUFF_SIZE = 4096;

    public static boolean isSDCardMounted() {
        return BasicFileUtils.availableMemInSDcard();
    }

    public static boolean availableMemInSDcard() {
        if (!BasicFileUtils.externalStorageExist()) {
            return false;
        }
        File sdcard = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(sdcard.getPath());
        long blockSize = statFs.getBlockSize();
        long avaliableBlocks = statFs.getAvailableBlocks();
        long total = avaliableBlocks * blockSize / 1024L;
        return total >= 10L;
    }

    public static boolean externalStorageExist() {
        boolean ret = false;
        String state = Environment.getExternalStorageState();
        if (state != null) {
            ret = state.equalsIgnoreCase("mounted");
        }
        return ret;
    }

    public static String getFileExt(String fileName) {
        int pos = fileName.lastIndexOf(".");
        return pos == -1 ? "" : fileName.toLowerCase().substring(pos);
    }

    public static String getFileName(String filePath) {
        if (filePath != null) {
            String slash = "/";
            int pos = filePath.lastIndexOf("/") + 1;
            if (pos > 0) {
                return filePath.substring(pos);
            }
        }
        return null;
    }

    public static String getFileMime(String fileName) {
        String mime = FILE_MIMES.get(BasicFileUtils.getFileExt(fileName));
        if (mime != null) {
            return mime;
        }
        return "*/*";
    }

    public static void ensureDirExists(String dirPath) {
        File dirFile = new File(dirPath);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
    }

    public static void createDir(String dirPath, boolean nomedia) {
        BasicFileUtils.ensureDirExists(dirPath);
        if (nomedia) {
            File nomediafile = new File(dirPath + "/.nomedia");
            try {
                nomediafile.createNewFile();
            }
            catch (IOException e) {
                YMFLog.error(null, "[Util    ]", "Create new file failed, exception:" + e.toString());
            }
        }
    }

    public static File createFileOnSD(String dir, String name) {
        File file = null;
        if (BasicFileUtils.isSDCardMounted()) {
            BasicFileUtils.createDir(dir, true);
            String path = dir + File.separator + name;
            file = new File(path);
            try {
                if (!file.exists() && !file.createNewFile()) {
                    file = null;
                }
            }
            catch (IOException e) {
                YMFLog.error(null, "[Util    ]", "can not create file on SD card, path:" + path);
                file = null;
            }
        }
        return file;
    }

    public static boolean isFileExisted(String filePath) {
        if (StringUtils.isNullOrEmpty(filePath)) {
            return false;
        }
        try {
            File file = new File(filePath);
            return file.exists() && file.length() > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getDirOfFilePath(String filePath) {
        if (StringUtils.isNullOrEmpty(filePath)) {
            return null;
        }
        int sepPos = filePath.lastIndexOf(File.separatorChar);
        if (sepPos == -1) {
            return null;
        }
        return filePath.substring(0, sepPos);
    }

    public static void renameFile(String oldFile, String newFile) {
        try {
            File file = new File(oldFile);
            file.renameTo(new File(newFile));
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "renameFile fail, oldFile:%s, exception:%s", oldFile, e.toString());
        }
    }

    public static void removeFile(String filename) {
        if (!StringUtils.isNullOrEmpty(filename)) {
            File file = new File(filename);
            file.delete();
        }
    }

    public static void removeDir(String dirPath) {
        File[] fileList;
        File dir = new File(dirPath);
        if (dir.isDirectory() && (fileList = dir.listFiles()) != null && fileList.length > 0) {
            for (File file : fileList) {
                file.delete();
            }
        }
        dir.delete();
    }

    public static void rm(String fname) {
        BasicFileUtils.rm(new File(fname));
    }

    public static void rm(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File i : FP.ref(f.listFiles())) {
                    BasicFileUtils.rm(i);
                }
            } else {
                f.delete();
            }
        }
    }

    public static void copyFile(File src, File des) throws IOException {
        if (des.exists()) {
            des.delete();
        }
        des.createNewFile();
        FileInputStream in = new FileInputStream(src);
        int length = in.available();
        if (length == 0) {
            length = 4096;
        } else if (length >= 0x100000) {
            length = 0x100000;
        }
        FileOutputStream out = new FileOutputStream(des);
        byte[] buffer = new byte[length];
        while (true) {
            int ins;
            if ((ins = in.read(buffer)) == -1) {
                in.close();
                out.flush();
                out.close();
                return;
            }
            out.write(buffer, 0, ins);
        }
    }

    public static boolean copyFile(String inFileName, String outFileName) {
        try {
            BasicFileUtils.copyFile(new File(inFileName), new File(outFileName));
            return true;
        }
        catch (Exception e) {
            YMFLog.error(null, "[Util    ]", "lcy copy file failed, exception:%s", e.toString());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStreamToFile(String filePath, byte[] data, int length) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath, true);
            fos.write(data, 0, length);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            YMFLog.error(null, "[Util    ]", "init save video stream exception:" + e.toString());
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                YMFLog.error(null, "[Util    ]", "save video stream exception:" + e);
            }
        }
    }

    static {
        FILE_MIMES.put(ZIP_EXT, "application/zip");
        FILE_MIMES.put(".bmp", "image/bmp");
        FILE_MIMES.put(".gif", "image/gif");
        FILE_MIMES.put(".jpe", "image/jpeg");
        FILE_MIMES.put(".jpeg", "image/jpeg");
        FILE_MIMES.put(JPG_EXT, "image/jpeg");
        FILE_MIMES.put(".png", "image/png");
        FILE_MIMES.put(".speex", "audio/speex");
        FILE_MIMES.put(".spx", "audio/speex");
        FILE_MIMES.put(SPEEX_EXT, "audio/speex");
    }
}

