/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.render;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.os.SystemClock;
import com.yy.videoplayer.decoder.CatchError;
import com.yy.videoplayer.decoder.Monitor;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.SmoothnessCounter;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoShader;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.Camera;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.utils.GLShaderProgram;
import com.yy.videoplayer.utils.GLUtil;
import com.yy.videoplayer.utils.TextureRotationUtil;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.VideoPosition;
import com.yy.videoplayer.videoview.YMultiVideoViewParams;
import com.yy.videoplayer.videoview.YSpVideoView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLVideoRenderMultiVideo
implements GLSurfaceView.Renderer {
    private static final String TAG = "GLVideoRenderMultiVideo";
    private Camera mCamera;
    private Monitor mMonitor;
    private VideoShader mVideoShader;
    private BackGround mBackground;
    VideoConstant.ScaleMode[] mScaleMode;
    YSpVideoView.OrientationType mOrientationType = YSpVideoView.OrientationType.Normal;
    int mRotateAngle = 0;
    private SmoothnessCounter mSmoothnessCounter = new SmoothnessCounter(5000L);
    private YYRenderFrameBuffer[] mFrameBuffer;
    private boolean mNeedRepaint = false;
    private long[] mUserGroupId;
    private long[] mStreamId;
    private static final int VIDEO_DATA_LOG = 500;
    private long[] mVideoDataCnt;
    private long[] mRenderFailCnt;
    PlayNotify playNotify;
    private int[] mRenderCnt;
    private long[] mCurTime;
    private long[] mLastTime;
    private int mRowCnt = 0;
    private int mColCnt = 0;
    private int mTotalVideoCnt = 0;
    private int mViewWidth = 0;
    private int mViewHeight = 0;
    private VideoPosition[] mDrawPosition;
    private VideoPosition[] originposition;
    private Bitmap mBackgroundBitmap = null;
    private int mBackgroundTexture = -1;
    private static final int mBackgoundTextureLayer = 4;
    private VideoPosition mBackGroundPosition;
    private VideoPosition originBackGroundPosition;
    private boolean[] mFirstFrameSeeFlag;
    private final String mRenderName = "GLThread YYSDKGLVideoRender";
    private boolean mStopRender = false;
    private boolean bGPUFormatConvert = false;
    private int mSurfaceWidth = 0;
    private int mSurfaceHeight = 0;
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys = new ArrayList();
    static final long kNotifyTimeGap = 500L;
    static final int kNofifySizeGap = 15;

    public void updateVideoPosition() {
        int width_offset = this.mViewWidth / this.mRowCnt;
        int height_offset = this.mViewHeight / this.mColCnt;
        int x = 0;
        int y = 0 + this.mViewHeight - height_offset;
        int width = width_offset;
        int height = height_offset;
        int videoIndex = 0;
        YMFLog.info(this, "[Render  ]", "updateVideoPosition mViewWidth:" + this.mViewWidth + "mViewHeight:" + this.mViewHeight + " x:" + x + " y:" + y + " width:" + width + " height:" + height);
        for (int i = 0; i < this.mColCnt; ++i) {
            for (int j = 0; j < this.mRowCnt; ++j) {
                this.mDrawPosition[videoIndex].mIndex = videoIndex;
                this.mDrawPosition[videoIndex].mX = x;
                this.mDrawPosition[videoIndex].mY = y;
                this.mDrawPosition[videoIndex].mWidth = width;
                this.mDrawPosition[videoIndex].mHeight = height;
                YMFLog.info(this, "[Render  ]", "updateVideoPosition videoIndex:" + videoIndex + " x:" + this.mDrawPosition[videoIndex].mX + " y:" + this.mDrawPosition[videoIndex].mY + " w:" + this.mDrawPosition[videoIndex].mWidth + " h:" + this.mDrawPosition[videoIndex].mHeight);
                ++videoIndex;
                x += width_offset;
            }
            x = 0;
            y -= height_offset;
        }
    }

    public GLVideoRenderMultiVideo(PlayNotify playNotify, boolean GPUFormatConvert, YMultiVideoViewParams params) {
        this.playNotify = playNotify;
        this.bGPUFormatConvert = GPUFormatConvert;
        this.initParams(params);
        StateMonitor.NotifyMultiVideoOriginPosition(this.mDrawPosition, this.mBackGroundPosition);
    }

    public GLVideoRenderMultiVideo(PlayNotify playNotify, boolean GPUFormatConvert, int row_count, int col_count, Bitmap bitmap) {
        this.playNotify = playNotify;
        this.mRowCnt = row_count;
        this.mColCnt = col_count;
        this.mTotalVideoCnt = this.mRowCnt * this.mColCnt;
        this.mDrawPosition = new VideoPosition[this.mTotalVideoCnt];
        this.mFrameBuffer = new YYRenderFrameBuffer[this.mTotalVideoCnt];
        this.mVideoDataCnt = new long[this.mTotalVideoCnt];
        this.mRenderFailCnt = new long[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.mCurTime = new long[this.mTotalVideoCnt];
        this.mLastTime = new long[this.mTotalVideoCnt];
        this.mFirstFrameSeeFlag = new boolean[this.mTotalVideoCnt];
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mFrameBuffer[i] = new YYRenderFrameBuffer(GPUFormatConvert);
            this.mDrawPosition[i] = new VideoPosition();
            this.mVideoDataCnt[i] = 0L;
            this.mRenderFailCnt[i] = 0L;
            this.mRenderCnt[i] = 0;
            this.mCurTime[i] = 0L;
            this.mLastTime[i] = 0L;
            this.mFirstFrameSeeFlag[i] = false;
        }
        this.mStreamId = new long[this.mTotalVideoCnt];
        this.mUserGroupId = new long[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.mBackgroundBitmap = bitmap;
    }

    private void initParams(YMultiVideoViewParams params) {
        YMFLog.info(this, "[Render  ]", "handleUpdateMultiVideoViewParams begin...");
        this.mTotalVideoCnt = params.mTotalVideoCnt;
        this.mDrawPosition = new VideoPosition[this.mTotalVideoCnt];
        this.originposition = new VideoPosition[this.mTotalVideoCnt];
        this.mFrameBuffer = new YYRenderFrameBuffer[this.mTotalVideoCnt];
        this.mVideoDataCnt = new long[this.mTotalVideoCnt];
        this.mRenderFailCnt = new long[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.mCurTime = new long[this.mTotalVideoCnt];
        this.mLastTime = new long[this.mTotalVideoCnt];
        this.mFirstFrameSeeFlag = new boolean[this.mTotalVideoCnt];
        this.mScaleMode = new VideoConstant.ScaleMode[this.mTotalVideoCnt];
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mFrameBuffer[i] = new YYRenderFrameBuffer(this.bGPUFormatConvert);
            this.mDrawPosition[i] = new VideoPosition();
            this.originposition[i] = new VideoPosition();
            YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.mDrawPosition[i]);
            YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.originposition[i]);
            this.mScaleMode[i] = VideoConstant.ScaleMode.AspectFit;
            this.mVideoDataCnt[i] = 0L;
            this.mRenderFailCnt[i] = 0L;
            this.mRenderCnt[i] = 0;
            this.mCurTime[i] = 0L;
            this.mLastTime[i] = 0L;
            this.mFirstFrameSeeFlag[i] = false;
        }
        this.mStreamId = new long[this.mTotalVideoCnt];
        this.mUserGroupId = new long[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.mBackgroundBitmap = params.background;
        this.mBackGroundPosition = new VideoPosition();
        this.originBackGroundPosition = new VideoPosition();
        if (this.mBackgroundBitmap != null) {
            YMultiVideoViewParams.clonePosition(params.backgroudPosition, this.originBackGroundPosition);
            YMultiVideoViewParams.clonePosition(params.backgroudPosition, this.mBackGroundPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateMultiVideoViewParams(YMultiVideoViewParams params) {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            if (params != null && params.mTotalVideoCnt != this.mTotalVideoCnt) {
                this.initParams(params);
            } else {
                if (params.background != null) {
                    this.mBackgroundBitmap = params.background;
                    if (this.mBackgroundBitmap != null && this.mBackgroundTexture >= 0) {
                        GLUtil.updateTextureWithBitmap(this.mBackgroundTexture, this.mBackgroundBitmap);
                    }
                }
                YMultiVideoViewParams.clonePosition(params.backgroudPosition, this.originBackGroundPosition);
                for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                    YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.mDrawPosition[i]);
                    YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.originposition[i]);
                }
            }
            this.updateVideoLayout();
        }
        StateMonitor.NotifyMultiVideoOriginPosition(this.originposition, this.originBackGroundPosition);
    }

    public void init(PlayNotify playNotify, boolean GPUFormatConvert) {
        this.playNotify = playNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapExt(int videoIndex) {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            if (this.mFrameBuffer == null || videoIndex >= this.mTotalVideoCnt) {
                return null;
            }
            YYRenderFrameBuffer.RGB565ImageWithNoPadding img = new YYRenderFrameBuffer.RGB565ImageWithNoPadding();
            if (this.mStreamId[videoIndex] != 0L && this.mFrameBuffer[videoIndex].GetCurrentPictureDataRGB565(img)) {
                Bitmap bmp = Bitmap.createBitmap((int)img.mWidth, (int)img.mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                if (bmp != null) {
                    bmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(img.mData));
                } else {
                    YMFLog.error((Object)this, "[Render  ]", "Bitmap.createBitmap failed!");
                }
                return bmp;
            }
            if (this.mStreamId[videoIndex] == 0L) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.mDrawPosition[videoIndex].mWidth, (int)this.mDrawPosition[videoIndex].mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                if (bitmap != null) {
                    bitmap.eraseColor(-16777216);
                } else {
                    YMFLog.error((Object)this, "[Render  ]", "Bitmap.createBitmap failed!");
                }
                YMFLog.info(this, "[Render  ]", "getBitmapExt black ");
                return bitmap;
            }
            YMFLog.error((Object)this, "[Render  ]", "getBitmapExt SOMETHING WRONG!" + this.mStreamId[videoIndex]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmap() {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            YYRenderFrameBuffer.RGB565ImageWithNoPadding img = new YYRenderFrameBuffer.RGB565ImageWithNoPadding();
            if (!this.mFrameBuffer[0].GetCurrentPictureDataRGB565(img)) {
                return null;
            }
            Bitmap bmp = Bitmap.createBitmap((int)img.mWidth, (int)img.mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
            if (bmp != null) {
                bmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(img.mData));
            } else {
                YMFLog.error((Object)this, "[Render  ]", "Bitmap.createBitmap failed!");
            }
            return bmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            this.mScaleMode[0] = scaleMode;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        if (videoIndex < 0 || videoIndex >= this.mTotalVideoCnt) {
            return false;
        }
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            this.mScaleMode[videoIndex] = scaleMode;
        }
        return true;
    }

    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode[0];
    }

    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        if (videoIndex < 0 || videoIndex >= this.mTotalVideoCnt) {
            return VideoConstant.ScaleMode.AspectFit;
        }
        return this.mScaleMode[videoIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            this.mOrientationType = orientationType;
            this.mRotateAngle = rotateAngle;
            if (null != this.mMonitor) {
                this.mMonitor.setOrientation(orientationType, rotateAngle, adjustImmediately);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkToStream(long userGroupId, long streamId, int videoIndex) {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            if (videoIndex >= this.mTotalVideoCnt) {
                return;
            }
            this.mUserGroupId[videoIndex] = userGroupId;
            this.mStreamId[videoIndex] = streamId;
            this.mFrameBuffer[videoIndex].linkToStream(userGroupId, streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLinkFromStream(long userGroupId, long streamId, int videoIndex) {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            if (videoIndex >= this.mTotalVideoCnt) {
                return;
            }
            this.mFrameBuffer[videoIndex].unLinkFromStream(userGroupId, streamId);
            this.mUserGroupId[videoIndex] = -1L;
            this.mStreamId[videoIndex] = -1L;
        }
        StateMonitor.NotifyClearPts(streamId);
    }

    public YYRenderFrameBuffer getRenderFrameBuffer() {
        return this.mFrameBuffer[0];
    }

    public void stopRender() {
        YMFLog.info(this, "[Render  ]", "stopRender...");
        this.mStopRender = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            this.stopRender();
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                if (this.mFrameBuffer != null && this.mFrameBuffer[i] != null) {
                    this.mFrameBuffer[i].release();
                    this.mFrameBuffer[i] = null;
                }
                if (this.mDrawPosition == null || this.mDrawPosition[i] == null) continue;
                this.mDrawPosition[i] = null;
            }
            this.mFrameBuffer = null;
        }
    }

    private void setThreadName() {
        Thread currThread = Thread.currentThread();
        String name = currThread.getName();
        String threadName = "GLThread YYSDKGLVideoRender " + currThread.getId();
        if (name.startsWith("GLThread") && !name.equals(threadName)) {
            currThread.setName(threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        YMFLog.info(this, "[Render  ]", "GLVideoRender surface created");
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            this.setThreadName();
            this.destroy();
            this.init();
            this.mSmoothnessCounter.ResetToInitialState();
        }
    }

    public void surfaceDestroyed() {
        YMFLog.info(this, "[Render  ]", "GLVideoRender surface destory ");
        if (this.mBackground != null) {
            this.mBackground.release();
            this.mBackground = null;
        }
        if (this.mBackgroundTexture > 0) {
            int[] textures = new int[]{this.mBackgroundTexture};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mBackgroundTexture = -1;
        }
        YMFLog.info(this, "[Decoder ]", "surfaceDestroyed done.");
    }

    private void updateVideoLayout() {
        if (this.mTotalVideoCnt == 1 && this.originposition[0].mWidth == -2 && this.originposition[0].mHeight == -2) {
            if (this.mDrawPosition != null && this.mDrawPosition[0] != null) {
                this.mDrawPosition[0].mX = 0;
                this.mDrawPosition[0].mY = 0;
                this.mDrawPosition[0].mWidth = this.mViewWidth;
                this.mDrawPosition[0].mHeight = this.mViewHeight;
                this.mBackGroundPosition.mY = 0;
            }
        } else {
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                if (this.mDrawPosition == null || this.mDrawPosition[i] == null) continue;
                this.mDrawPosition[i].mX = this.originposition[i].mX;
                this.mDrawPosition[i].mY = this.mViewHeight - this.originposition[i].mY - this.originposition[i].mHeight;
                this.mDrawPosition[i].mWidth = this.originposition[i].mWidth;
                this.mDrawPosition[i].mHeight = this.originposition[i].mHeight;
            }
            this.mBackGroundPosition.mY = this.mViewHeight - this.originBackGroundPosition.mY - this.originBackGroundPosition.mHeight;
            this.mBackGroundPosition.mHeight = this.originBackGroundPosition.mHeight;
            this.mBackGroundPosition.mWidth = this.originBackGroundPosition.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        YMFLog.info(this, "[Render  ]", "GLVideoRender surface changed width:" + width + " height:" + height);
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            this.mCamera.sharpFocusing(-1.0f, 1.0f);
            this.mMonitor.setSize(width, height, this.mScaleMode[0]);
            this.mMonitor.setOrientation(this.mOrientationType, this.mRotateAngle, true);
            this.mViewWidth = width;
            this.mViewHeight = height;
            this.updateVideoLayout();
            StateMonitor.NotifyMultiVideoSurfaceChangePosition(this.mDrawPosition, this.mBackGroundPosition);
            this.mNeedRepaint = true;
        }
    }

    private boolean checkFrameArrived() {
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            boolean frameChanged = this.mFrameBuffer[i].hasFrame();
            ByteBuffer frame = this.mFrameBuffer[i].getFrame();
            if (null == frame || !frameChanged) continue;
            return true;
        }
        return false;
    }

    public void drawCurrentFrame(int videoIndex) {
        boolean frameChanged = this.mFrameBuffer[videoIndex].hasFrame();
        ByteBuffer frame = this.mFrameBuffer[videoIndex].getFrame();
        int pts = this.mFrameBuffer[videoIndex].getCurFramePts();
        if (null != frame && this.mFrameBuffer[videoIndex].checkDataComplete()) {
            StateMonitor.NotifyPts(this.mStreamId[videoIndex], pts);
            ViewLiveStatManager.getInstace().reportFrameEvent(0);
            if (this.mVideoDataCnt[videoIndex] == 0L) {
                ViewLiveStatManager.getInstace().notifyEventTime(2, 3, new ViewLiveStatManager.StatVideoHeaderInfo(this.mFrameBuffer[videoIndex].getWidth(), this.mFrameBuffer[videoIndex].getHeight()));
            }
            int n = videoIndex;
            long l = this.mVideoDataCnt[n];
            this.mVideoDataCnt[n] = l + 1L;
            if (l % 500L == 0L) {
                YMFLog.info(this, "[Render  ]", "GLVideoRender onDrawFrame frame count:" + this.mVideoDataCnt[videoIndex]);
            }
            if (this.playNotify != null) {
                this.playNotify.DrawNotify();
            }
            if (!this.mFirstFrameSeeFlag[videoIndex]) {
                YYVideoLibMgr.instance().onFirstFrameSeeNotify(this.mUserGroupId[videoIndex], this.mStreamId[videoIndex], System.currentTimeMillis() - this.mFrameBuffer[videoIndex].mFirstFrameArrivedTime);
                this.mFirstFrameSeeFlag[videoIndex] = true;
            }
            this.mNeedRepaint = false;
            this.mVideoShader.use();
            this.mCamera.pressShutter(this.mVideoShader.mMatrixHandle);
            int frameFormat = this.mFrameBuffer[videoIndex].getFrameFormat();
            this.mMonitor.setRenderFormat(this.mVideoShader.mFormat, frameFormat);
            this.mMonitor.updateRenderSizeIfNeedMultiVideo(this.mFrameBuffer[videoIndex].getWidth(), this.mFrameBuffer[videoIndex].getHeight(), this.mDrawPosition[videoIndex].mWidth, this.mDrawPosition[videoIndex].mHeight, this.mScaleMode[videoIndex]);
            if (0 == frameFormat) {
                this.mMonitor.updateAsRGB(this.mFrameBuffer[videoIndex].getWidthY(), this.mFrameBuffer[videoIndex].getHeightY(), 5121, frame);
            } else if (3 == frameFormat) {
                this.mMonitor.updateAsRGB(this.mFrameBuffer[videoIndex].getWidth(), this.mFrameBuffer[videoIndex].getHeight(), 33635, frame);
            } else if (4 != frameFormat) {
                this.mMonitor.updateAsYUV(this.mFrameBuffer[videoIndex]);
            } else {
                YMFLog.error((Object)this, "[Render  ]", "GLVideoRender UNKNOWN FRAME FORMAT");
            }
            if (frameChanged) {
                long currentTs;
                this.onVideoRenderNotify(this.mUserGroupId[videoIndex], this.mStreamId[videoIndex], this.mFrameBuffer[videoIndex].getCurFramePts(), TimeUtil.getTickCountLong(), this.mFrameBuffer[videoIndex].getLastDecodeTimeStamp());
                ViewLiveStatManager.getInstace().reportFrameEvent(1);
                if (this.mVideoDataCnt[videoIndex] == 1L) {
                    StateMonitor.NotifyFirstFrameRendered(this.mStreamId[videoIndex], TimeUtil.getTickCount());
                    ViewLiveStatManager.getInstace().notifyEventTime(3, 4);
                }
                if (this.mSmoothnessCounter.RenderOneFrame(this.mStreamId[videoIndex], currentTs = System.currentTimeMillis())) {
                    double coef = this.mSmoothnessCounter.ComputeCoefficientOfVariationAndReset();
                    YYVideoLibMgr.instance().onCoefficientOfVariationOfRenderInterval(this.mUserGroupId[videoIndex], this.mStreamId[videoIndex], this.mSmoothnessCounter.GetIntervalMilliTs(), coef);
                }
                int n2 = videoIndex;
                this.mRenderCnt[n2] = this.mRenderCnt[n2] + 1;
                this.mCurTime[videoIndex] = TimeUtil.getTickCountLong();
                if (this.mLastTime[videoIndex] == 0L) {
                    this.mLastTime[videoIndex] = this.mCurTime[videoIndex];
                }
                if (this.mCurTime[videoIndex] - this.mLastTime[videoIndex] >= 1000L) {
                    StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId[videoIndex], this.mRenderCnt[videoIndex]);
                    this.mLastTime[videoIndex] = this.mCurTime[videoIndex];
                    this.mRenderCnt[videoIndex] = 0;
                }
            }
            this.mMonitor.refresh(this.mVideoShader.mPositionHandle, this.mVideoShader.mTextureHandle, this.mVideoShader.mSampleY, this.mVideoShader.mSampleU, this.mVideoShader.mSampleV);
            this.mFrameBuffer[videoIndex].setFrameRendered();
        } else if (frame == null) {
            ViewLiveStatManager.getInstace().reportDecError(0);
            int n = videoIndex;
            long l = this.mRenderFailCnt[n];
            this.mRenderFailCnt[n] = l + 1L;
            if (l % 500L == 0L) {
                YMFLog.info(this, "[Render  ]", "GLVideoRender onDrawFrame failed, frameChanged:" + frameChanged + ", count:" + this.mRenderFailCnt[videoIndex]);
            }
        }
        CatchError.catchError("onDrawFrame  ");
    }

    public int genTextureWithBitmap(Bitmap bitmap, int textureLayer) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glActiveTexture((int)(33984 + textureLayer));
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        return textures[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        if (this.mStopRender) {
            YMFLog.error((Object)this, "[Render  ]", "onDrawFrame has stopRender ");
            return;
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            GLES20.glViewport((int)this.mBackGroundPosition.mX, (int)this.mBackGroundPosition.mY, (int)this.mBackGroundPosition.mWidth, (int)this.mBackGroundPosition.mHeight);
            if (this.mBackground == null) {
                this.mBackground = new BackGround(this.mViewWidth, this.mViewHeight);
            }
            if (this.mBackgroundTexture < 0 && this.mBackgroundBitmap != null) {
                this.mBackgroundTexture = this.genTextureWithBitmap(this.mBackgroundBitmap, 4);
            }
            if (this.mBackgroundTexture >= 0) {
                this.mBackground.draw(this.mBackgroundTexture);
            }
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                if (this.mDrawPosition == null || this.mDrawPosition[i] == null || this.mStreamId[i] == -1L) continue;
                GLES20.glViewport((int)this.mDrawPosition[i].mX, (int)this.mDrawPosition[i].mY, (int)this.mDrawPosition[i].mWidth, (int)this.mDrawPosition[i].mHeight);
                this.drawCurrentFrame(i);
            }
        }
    }

    private void onVideoRenderNotify(long userGroupId, long streamId, long pts, long renderTimeStamp, long decodeStamp) {
        if (this.mVideoRenderNotifys == null) {
            return;
        }
        this.mVideoRenderNotifys.add(new VideoRenderNotify(userGroupId, streamId, pts, renderTimeStamp, decodeStamp));
        Iterator<VideoRenderNotify> it = this.mVideoRenderNotifys.iterator();
        if (!it.hasNext()) {
            return;
        }
        long firstPts = it.next().mPts;
        if (pts - firstPts < 500L && this.mVideoRenderNotifys.size() < 15) {
            return;
        }
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.mVideoShader = new VideoShader();
            this.mVideoShader.use();
            float top = 1.0f;
            float bottom = -1.0f;
            float near = 1.0f;
            float eyeZ = -near;
            float nearZ = near + eyeZ;
            this.mCamera = new Camera(top, bottom, near, 2.0f * near, eyeZ);
            this.mMonitor = new Monitor(this.mVideoShader.mPositionHandle, this.mVideoShader.mTextureHandle, top, bottom, nearZ);
            this.mCamera.setUp();
            this.GLOESReport();
            this.mStopRender = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        GLVideoRenderMultiVideo gLVideoRenderMultiVideo = this;
        synchronized (gLVideoRenderMultiVideo) {
            this.mStopRender = true;
            if (null != this.mMonitor) {
                this.mMonitor.destroy(this.mVideoShader.mPositionHandle, this.mVideoShader.mTextureHandle);
                this.mMonitor = null;
            }
            if (null != this.mVideoShader) {
                this.mVideoShader.destroy();
                this.mVideoShader = null;
            }
        }
    }

    private void GLOESReport() {
    }

    private class BackGround {
        GLShaderProgram mShaderProgram;
        FloatBuffer mMasterVertexBuffer;
        FloatBuffer mGLTextureBuffer;
        private int mWidth;
        private int mHight;
        final float[] CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
        public static final String vertexShader = "attribute vec4 aPosition;          \nattribute vec4 aTextureCoord;      \nvarying vec2 vTexCoord;            \nvoid main()                        \n{                                  \n    gl_Position = aPosition;       \n    vTexCoord = aTextureCoord.xy;  \n}";
        public static final String fragmentShader = "precision mediump float;                                           \nvarying vec2 vTexCoord;                                            \nuniform sampler2D uTexture0;                                       \nvoid main()                                                        \n{                                                                  \n    vec4 color = texture2D(uTexture0, vTexCoord);                  \n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);  \n}";

        public BackGround(int width, int height) {
            this.mWidth = width;
            this.mHight = height;
            this.mShaderProgram = new GLShaderProgram();
            this.mShaderProgram.setProgram(vertexShader, fragmentShader);
            this.mMasterVertexBuffer = ByteBuffer.allocateDirect(this.CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.mMasterVertexBuffer.put(this.CUBE).position(0);
            this.mGLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.FULL_RECTANGLE_TEX_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.mGLTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
        }

        public void draw(int texture_background) {
            this.mShaderProgram.useProgram();
            this.mShaderProgram.setUniformTexture("uTexture0", 4, texture_background, 3553);
            this.mMasterVertexBuffer.position(0);
            this.mGLTextureBuffer.position(0);
            this.mShaderProgram.setVertexAttribPointer("aPosition", 2, 5126, false, 0, this.mMasterVertexBuffer);
            this.mShaderProgram.setVertexAttribPointer("aTextureCoord", 2, 5126, false, 0, this.mGLTextureBuffer);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glUseProgram((int)0);
        }

        public void release() {
            if (this.mShaderProgram != null) {
                this.mShaderProgram.destory();
                this.mShaderProgram = null;
            }
        }
    }

    private class RenderSlowStatistics {
        private int mCount = 0;
        private int mCurrent = 0;
        private long mInterval = 0L;
        private long mStart = 0L;
        private long mMin = 50L;

        public RenderSlowStatistics(int fps, long minInterval) {
            this.mInterval = 1000 / fps;
            this.mCount = fps * 2;
            this.mMin = minInterval;
        }

        public void start() {
            this.mStart = SystemClock.elapsedRealtime();
        }

        public void statistics() {
            long diff = SystemClock.elapsedRealtime() - this.mStart;
            if (diff <= this.mInterval || diff < this.mMin) {
                this.mCurrent = 0;
                return;
            }
            ++this.mCurrent;
            if (this.mCurrent > this.mCount) {
                this.mCurrent = 0;
            }
        }
    }
}

