/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.render;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.SystemClock;
import com.yy.videoplayer.decoder.CatchError;
import com.yy.videoplayer.decoder.Monitor;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.SmoothnessCounter;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoShader;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.YSpVideoView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLVideoRender
implements GLSurfaceView.Renderer {
    private Monitor mMonitor;
    private VideoShader mVideoShader;
    VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    YSpVideoView.OrientationType mOrientationType = YSpVideoView.OrientationType.Normal;
    int mRotateAngle = 0;
    private SmoothnessCounter mSmoothnessCounter = new SmoothnessCounter(5000L);
    private YYRenderFrameBuffer mFrameBuffer;
    private boolean mNeedRepaint = false;
    private long mUserGroupId = 0L;
    private long mStreamId = 0L;
    private static final int VIDEO_DATA_LOG = 500;
    private long mVideoDataCnt = 0L;
    private long mRenderFailCnt = 0L;
    PlayNotify playNotify;
    private int mRenderCnt = 0;
    private long mCurTime = 0L;
    private long mLastTime = 0L;
    private boolean mFirstFrameSeeFlag = false;
    private boolean mStopRender = false;
    private final String mRenderName = "GLThread YYSDKGLVideoRender";
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys = new ArrayList();
    static final long kNotifyTimeGap = 500L;
    static final int kNofifySizeGap = 15;

    public GLVideoRender(PlayNotify playNotify, boolean GPUFormatConvert) {
        this.playNotify = playNotify;
        this.mFrameBuffer = new YYRenderFrameBuffer(GPUFormatConvert);
    }

    public void init(PlayNotify playNotify, boolean GPUFormatConvert) {
        this.playNotify = playNotify;
        this.mFrameBuffer = new YYRenderFrameBuffer(GPUFormatConvert);
    }

    public Bitmap getBitmap() {
        YYRenderFrameBuffer.RGB565ImageWithNoPadding img = new YYRenderFrameBuffer.RGB565ImageWithNoPadding();
        if (!this.mFrameBuffer.GetCurrentPictureDataRGB565(img)) {
            return null;
        }
        Bitmap bmp = Bitmap.createBitmap((int)img.mWidth, (int)img.mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
        if (bmp != null) {
            bmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(img.mData));
        } else {
            YMFLog.error((Object)this, "[Render  ]", "Bitmap.createBitmap failed!");
        }
        return bmp;
    }

    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        return true;
    }

    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        this.mOrientationType = orientationType;
        this.mRotateAngle = rotateAngle;
        if (null != this.mMonitor) {
            this.mMonitor.setOrientation(orientationType, rotateAngle, adjustImmediately);
        }
    }

    public void linkToStream(long userGroupId, long streamId) {
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
        this.mFrameBuffer.linkToStream(userGroupId, streamId);
    }

    public void unLinkFromStream(long userGroupId, long streamId) {
        this.mFrameBuffer.unLinkFromStream(userGroupId, streamId);
    }

    public YYRenderFrameBuffer getRenderFrameBuffer() {
        return this.mFrameBuffer;
    }

    public void release() {
        this.mFrameBuffer.release();
    }

    private void setThreadName() {
        Thread currThread = Thread.currentThread();
        String name = currThread.getName();
        String threadName = "GLThread YYSDKGLVideoRender " + currThread.getId();
        if (name.startsWith("GLThread") && !name.equals(threadName)) {
            currThread.setName(threadName);
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        YMFLog.info(this, "[Render  ]", "GLVideoRender surface created");
        this.setThreadName();
        this.destroy();
        this.init();
        this.mSmoothnessCounter.ResetToInitialState();
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        YMFLog.info(this, "[Render  ]", "GLVideoRender surface changed width:" + width + " height:" + height);
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        this.mMonitor.setSize(width, height, this.mScaleMode);
        this.mMonitor.setOrientation(this.mOrientationType, this.mRotateAngle, true);
        this.mNeedRepaint = true;
    }

    public void stopRender() {
        YMFLog.info(this, "[Render  ]", "stopRender...");
        this.mStopRender = true;
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mStopRender) {
            YMFLog.info(this, "[Render  ]", "onDrawFrame has stopRender.");
            return;
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        boolean frameChanged = this.mFrameBuffer.hasFrame();
        ByteBuffer frame = this.mFrameBuffer.getFrame();
        if (null != frame && (frameChanged || this.mNeedRepaint)) {
            long currentTs;
            ViewLiveStatManager.getInstace().reportFrameEvent(0);
            if (this.mVideoDataCnt == 0L) {
                ViewLiveStatManager.getInstace().notifyEventTime(2, 3, new ViewLiveStatManager.StatVideoHeaderInfo(this.mFrameBuffer.getWidth(), this.mFrameBuffer.getHeight()));
            }
            if (this.mVideoDataCnt++ % 500L == 0L) {
                YMFLog.info(this, "[Render  ]", "GLVideoRender onDrawFrame frame count:" + this.mVideoDataCnt);
            }
            if (this.playNotify != null) {
                this.playNotify.DrawNotify();
            }
            if (!this.mFirstFrameSeeFlag) {
                YYVideoLibMgr.instance().onFirstFrameSeeNotify(this.mUserGroupId, this.mStreamId, System.currentTimeMillis() - this.mFrameBuffer.mFirstFrameArrivedTime);
                this.mFirstFrameSeeFlag = true;
            }
            if (!this.mFrameBuffer.getMissRenderFlag()) {
                this.onVideoRenderNotify(this.mUserGroupId, this.mStreamId, this.mFrameBuffer.getCurFramePts(), TimeUtil.getTickCountLong(), this.mFrameBuffer.getLastDecodeTimeStamp());
            } else {
                YMFLog.info(this, "[Render  ]", "YCustomGLVideoView getMissRenderFlag true pts:" + this.mFrameBuffer.getCurFramePts() + " decode:" + this.mFrameBuffer.getLastDecodeTimeStamp() + "/" + TimeUtil.getTickCountLong());
            }
            this.mNeedRepaint = false;
            int frameFormat = this.mFrameBuffer.getFrameFormat();
            this.mMonitor.setRenderFormat(this.mVideoShader.mFormat, frameFormat);
            this.mMonitor.updateRenderSizeIfNeed(this.mFrameBuffer.getWidth(), this.mFrameBuffer.getHeight(), this.mFrameBuffer.getPixWidth(), this.mScaleMode);
            if (0 == frameFormat) {
                this.mMonitor.updateAsRGB(this.mFrameBuffer.getWidthY(), this.mFrameBuffer.getHeightY(), 5121, frame);
            } else if (3 == frameFormat) {
                this.mMonitor.updateAsRGB(this.mFrameBuffer.getWidth(), this.mFrameBuffer.getHeight(), 33635, frame);
            } else if (4 != frameFormat) {
                this.mMonitor.updateAsYUV(this.mFrameBuffer);
            } else {
                YMFLog.error((Object)this, "[Render  ]", "GLVideoRender UNKNOWN FRAME FORMAT");
            }
            ViewLiveStatManager.getInstace().reportFrameEvent(1);
            if (this.mVideoDataCnt == 1L) {
                StateMonitor.NotifyFirstFrameRendered(this.mStreamId, TimeUtil.getTickCount());
                ViewLiveStatManager.getInstace().notifyEventTime(3, 4);
            }
            if (this.mSmoothnessCounter.RenderOneFrame(this.mStreamId, currentTs = System.currentTimeMillis())) {
                double coef = this.mSmoothnessCounter.ComputeCoefficientOfVariationAndReset();
                YYVideoLibMgr.instance().onCoefficientOfVariationOfRenderInterval(this.mUserGroupId, this.mStreamId, this.mSmoothnessCounter.GetIntervalMilliTs(), coef);
            }
            ++this.mRenderCnt;
            this.mCurTime = TimeUtil.getTickCountLong();
            if (this.mLastTime == 0L) {
                this.mLastTime = this.mCurTime;
            }
            if (this.mCurTime - this.mLastTime >= 1000L) {
                StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId, this.mRenderCnt);
                this.mLastTime = this.mCurTime;
                this.mRenderCnt = 0;
            }
        } else if (frame == null) {
            ViewLiveStatManager.getInstace().reportDecError(0);
            if (this.mRenderFailCnt++ % 500L == 0L) {
                YMFLog.info(this, "[Render  ]", "GLVideoRender onDrawFrame failed, frameChanged:" + frameChanged + ", count:" + this.mRenderFailCnt);
            }
        }
        this.mMonitor.refresh(this.mVideoShader.mPositionHandle, this.mVideoShader.mTextureHandle, this.mVideoShader.mSampleY, this.mVideoShader.mSampleU, this.mVideoShader.mSampleV);
        this.mFrameBuffer.setFrameRendered();
        CatchError.catchError("onDrawFrame");
    }

    private void onVideoRenderNotify(long userGroupId, long streamId, long pts, long renderTimeStamp, long decodeStamp) {
        if (this.mVideoRenderNotifys == null) {
            return;
        }
        this.mVideoRenderNotifys.add(new VideoRenderNotify(userGroupId, streamId, pts, renderTimeStamp, decodeStamp));
        Iterator<VideoRenderNotify> it = this.mVideoRenderNotifys.iterator();
        if (!it.hasNext()) {
            return;
        }
        long firstPts = it.next().mPts;
        if (pts - firstPts < 500L && this.mVideoRenderNotifys.size() < 15) {
            return;
        }
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
    }

    private void init() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.mVideoShader = new VideoShader();
        this.mVideoShader.use();
        float top = 1.0f;
        float bottom = -1.0f;
        float near = 1.0f;
        float eyeZ = -near;
        float nearZ = near + eyeZ;
        this.mMonitor = new Monitor(this.mVideoShader.mPositionHandle, this.mVideoShader.mTextureHandle, top, bottom, nearZ);
        this.GLOESReport();
        this.mStopRender = false;
    }

    private void destroy() {
        this.mStopRender = true;
        if (null != this.mMonitor) {
            this.mMonitor.destroy(this.mVideoShader.mPositionHandle, this.mVideoShader.mTextureHandle);
            this.mMonitor = null;
        }
        if (null != this.mVideoShader) {
            this.mVideoShader.destroy();
            this.mVideoShader = null;
        }
    }

    private void GLOESReport() {
    }

    private class RenderSlowStatistics {
        private int mCount = 0;
        private int mCurrent = 0;
        private long mInterval = 0L;
        private long mStart = 0L;
        private long mMin = 50L;

        public RenderSlowStatistics(int fps, long minInterval) {
            this.mInterval = 1000 / fps;
            this.mCount = fps * 2;
            this.mMin = minInterval;
        }

        public void start() {
            this.mStart = SystemClock.elapsedRealtime();
        }

        public void statistics() {
            long diff = SystemClock.elapsedRealtime() - this.mStart;
            if (diff <= this.mInterval || diff < this.mMin) {
                this.mCurrent = 0;
                return;
            }
            ++this.mCurrent;
            if (this.mCurrent > this.mCount) {
                this.mCurrent = 0;
            }
        }
    }
}

