/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.opengles;

import android.opengl.Matrix;
import com.yy.videoplayer.utils.GLUtil;
import com.yy.videoplayer.utils.YMFLog;
import java.nio.FloatBuffer;

public class YMFShaderData {
    private static final String TAG = "YMFShaderData";
    private static final int SIZEOF_FLOAT = 4;
    public static final int COORD_SIZE = 2;
    private int mVertexCount;
    private int mVertexCoordStride = 8;
    private int mTexCoordStride = 8;
    private boolean bFlipVertial;
    private boolean bFlipHorizontal;
    private float[] mIdentityMatrixVertex = new float[16];
    private float[] mIdentityMatrixTexture = new float[16];
    private FloatBuffer mVertexCoordArray;
    private FloatBuffer mTextureCoordArray;
    private FloatBuffer mWaterCoordArray;
    private static final float[] VERTEX_COORDINATE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] TEXTURE_COORDINATE = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final float[] TEXTURE_COORDINATE_UP_DOWN = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};

    public YMFShaderData() {
        this.mVertexCount = VERTEX_COORDINATE.length / 2;
        this.mVertexCoordArray = GLUtil.createFloatBuffer(VERTEX_COORDINATE);
        this.mTextureCoordArray = GLUtil.createFloatBuffer(TEXTURE_COORDINATE);
        this.mWaterCoordArray = GLUtil.createFloatBuffer(TEXTURE_COORDINATE_UP_DOWN);
        Matrix.setIdentityM((float[])this.mIdentityMatrixVertex, (int)0);
        Matrix.setIdentityM((float[])this.mIdentityMatrixTexture, (int)0);
    }

    public FloatBuffer getVertexCoordData() {
        return this.mVertexCoordArray;
    }

    public int getVertexCoordStride() {
        return this.mVertexCoordStride;
    }

    public int getVertexCount() {
        return this.mVertexCount;
    }

    public FloatBuffer getTextureCoordData() {
        return this.mTextureCoordArray;
    }

    public int getTextureCoordStride() {
        return this.mTexCoordStride;
    }

    public FloatBuffer getWaterMarkCoordData() {
        return this.mWaterCoordArray;
    }

    public float[] getVertexMatrix() {
        return this.mIdentityMatrixVertex;
    }

    public float[] getTextureMatrix() {
        return this.mIdentityMatrixTexture;
    }

    public void clip(int inWidth, int inHeight, int outWidth, int outHeight, int clipMode) {
        this.mTextureCoordArray = GLUtil.createFloatBuffer(TEXTURE_COORDINATE);
        if (this.bFlipVertial) {
            this.flipVertical(false);
        }
        if (this.bFlipHorizontal) {
            this.flipHorizontal(false);
        }
        int absWidthDiff = Math.abs(inWidth - outWidth);
        int absHeightDiff = Math.abs(inHeight - outHeight);
        float[] mTmpTextureCord = new float[8];
        this.mTextureCoordArray.rewind();
        this.mTextureCoordArray.get(mTmpTextureCord);
        if (absWidthDiff > 0) {
            float clipWithValue = (float)absWidthDiff / (float)inWidth;
            switch (clipMode) {
                case 2: {
                    mTmpTextureCord[0] = mTmpTextureCord[0] + clipWithValue / 2.0f;
                    mTmpTextureCord[4] = mTmpTextureCord[4] + clipWithValue / 2.0f;
                    mTmpTextureCord[2] = mTmpTextureCord[2] - clipWithValue / 2.0f;
                    mTmpTextureCord[6] = mTmpTextureCord[6] - clipWithValue / 2.0f;
                    break;
                }
                case 0: {
                    mTmpTextureCord[0] = mTmpTextureCord[0] + clipWithValue;
                    mTmpTextureCord[4] = mTmpTextureCord[4] + clipWithValue;
                    break;
                }
                case 1: {
                    mTmpTextureCord[2] = mTmpTextureCord[2] - clipWithValue;
                    mTmpTextureCord[6] = mTmpTextureCord[6] - clipWithValue;
                    break;
                }
            }
        }
        if (absHeightDiff > 0) {
            float clipHeightValue = (float)absHeightDiff / (float)inHeight;
            switch (clipMode) {
                case 5: {
                    mTmpTextureCord[1] = mTmpTextureCord[1] + clipHeightValue / 2.0f;
                    mTmpTextureCord[3] = mTmpTextureCord[3] + clipHeightValue / 2.0f;
                    mTmpTextureCord[5] = mTmpTextureCord[5] - clipHeightValue / 2.0f;
                    mTmpTextureCord[7] = mTmpTextureCord[7] - clipHeightValue / 2.0f;
                    break;
                }
                case 3: {
                    mTmpTextureCord[1] = mTmpTextureCord[1] + clipHeightValue;
                    mTmpTextureCord[3] = mTmpTextureCord[3] + clipHeightValue;
                    break;
                }
                case 4: {
                    mTmpTextureCord[5] = mTmpTextureCord[5] - clipHeightValue;
                    mTmpTextureCord[7] = mTmpTextureCord[7] - clipHeightValue;
                    break;
                }
            }
        }
        this.mTextureCoordArray = GLUtil.createFloatBuffer(mTmpTextureCord);
    }

    public void flipVertical(boolean mark) {
        float[] mTmpTextureCord = new float[8];
        this.mTextureCoordArray.rewind();
        this.mTextureCoordArray.get(mTmpTextureCord);
        mTmpTextureCord[1] = 1.0f - mTmpTextureCord[1];
        mTmpTextureCord[3] = 1.0f - mTmpTextureCord[3];
        mTmpTextureCord[5] = 1.0f - mTmpTextureCord[5];
        mTmpTextureCord[7] = 1.0f - mTmpTextureCord[7];
        this.mTextureCoordArray = GLUtil.createFloatBuffer(mTmpTextureCord);
        if (mark) {
            this.bFlipVertial = !this.bFlipVertial;
        }
        YMFLog.info(this, "[Util    ]", this.hashCode() + " flipVertical:" + this.bFlipVertial);
    }

    public void flipHorizontal(boolean mark) {
        float[] mTmpTextureCord = new float[8];
        this.mTextureCoordArray.rewind();
        this.mTextureCoordArray.get(mTmpTextureCord);
        mTmpTextureCord[0] = 1.0f - mTmpTextureCord[0];
        mTmpTextureCord[2] = 1.0f - mTmpTextureCord[2];
        mTmpTextureCord[4] = 1.0f - mTmpTextureCord[4];
        mTmpTextureCord[6] = 1.0f - mTmpTextureCord[6];
        this.mTextureCoordArray = GLUtil.createFloatBuffer(mTmpTextureCord);
        if (mark) {
            this.bFlipHorizontal = !this.bFlipHorizontal;
        }
        YMFLog.info(this, "[Util    ]", this.hashCode() + " flipHorizontal:" + this.bFlipHorizontal);
    }

    public void setRotation(float angle) {
        Matrix.rotateM((float[])this.mIdentityMatrixVertex, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
    }
}

