/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.opengles;

import com.yy.videoplayer.opengles.YMFProgramBase;

public class YMFProgram2D
extends YMFProgramBase {
    private boolean mEnableWaterMark = false;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nattribute vec4 aTextureCoordWater;\nvarying vec2 vTextureCoord;\nvarying vec2 vTextureCoordWater;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n    vTextureCoordWater = (aTextureCoordWater).xy;\n}\n";
    private static String FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTextureCoord;\nvarying vec2 vTextureCoordWater;\nuniform sampler2D uTexture0;\nuniform sampler2D uTextureWater;\nuniform int uWaterMarkEnabled;\n\nvoid main()\n{\n    vec4 outputColor = texture2D(uTexture0, vTextureCoord);\n    if (uWaterMarkEnabled == 1) {\n        vec4 overlay = texture2D(uTextureWater, vTextureCoordWater);\n        outputColor.r = overlay.r + outputColor.r * outputColor.a * (1.0 - overlay.a);\n        outputColor.g = overlay.g + outputColor.g * outputColor.a * (1.0 - overlay.a);\n        outputColor.b = overlay.b + outputColor.b * outputColor.a * (1.0 - overlay.a);\n        outputColor.a = overlay.a + outputColor.a * (1.0 - overlay.a);\n    }\n    gl_FragColor = outputColor; //vec4(color.y, color.y, color.y, 1.0);\n}";

    public YMFProgram2D() {
        super(VERTEX_SHADER, FRAGMENT_SHADER);
    }

    @Override
    public int programType() {
        return 0;
    }

    @Override
    protected void onSetAttributeValue() {
        this.setVertexAttribPointer("aPosition", 2, 5126, false, this.getVertexCoordStride(), this.getVertexCoordData());
        this.setVertexAttribPointer("aTextureCoord", 2, 5126, false, this.getTextureCoordStride(), this.getTextureCoordData());
        this.setVertexAttribPointer("aTextureCoordWater", 2, 5126, false, this.getTextureCoordStride(), this.getWaterMarkCoordData());
    }

    @Override
    protected void onSetUniformValue() {
        this.setUniformMatrix4fv("uMVPMatrix", 1, false, this.getVertexMatrix(), 0);
        this.setUniformMatrix4fv("uTexMatrix", 1, false, this.getTextureMatrix(), 0);
        this.setUniform1i("uTexture0", 0);
        if (this.mEnableWaterMark) {
            this.setUniform1i("uWaterMarkEnabled", 1);
        } else {
            this.setUniform1i("uWaterMarkEnabled", 0);
        }
        this.setUniform1i("uTextureWater", 1);
    }

    @Override
    public void enableWaterMarker(boolean enable) {
        this.mEnableWaterMark = enable;
    }
}

