/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.opengles;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import com.yy.videoplayer.IYMFDecoderListener;
import com.yy.videoplayer.YMFEventManager;
import com.yy.videoplayer.YMFStreamManager;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoSizeUtils;
import com.yy.videoplayer.opengles.IRender;
import com.yy.videoplayer.opengles.YMFImageBuffer;
import com.yy.videoplayer.opengles.YMFRender;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.render.YYSoftDecRender;
import com.yy.videoplayer.stat.PlayerExceptionDataStat;
import com.yy.videoplayer.stat.YMFPlayerUsrBehaviorStat;
import com.yy.videoplayer.utils.GLUtil;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class YMFPlayerView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
SurfaceHolder.Callback,
YSpVideoView,
IYMFDecoderListener {
    private String hash = Integer.toHexString(System.identityHashCode(this));
    private String TAG = "YMFPlayerView:" + this.hash;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private boolean mFirstFrameRenderd = false;
    private int mVideoWidth;
    private int mVideoHeight;
    private IRender mRender = null;
    private YMFImageBuffer mVideoFrame = null;
    private byte[] mTmpBuffer = null;
    private boolean mSurfaceCreated = false;
    private VideoSizeUtils.Size mSize = new VideoSizeUtils.Size();
    private ReentrantLock mRenderLock = new ReentrantLock(true);
    private AtomicBoolean mRenderReady = new AtomicBoolean(false);
    private AtomicBoolean mGlThreadReady = new AtomicBoolean(false);
    private AtomicBoolean mDataArrive = new AtomicBoolean(false);
    private VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    private long mUserGroupId = 0L;
    private long mStreamId = -1L;
    private YYRenderFrameBuffer mFrameBuffer;
    private AtomicBoolean mDrawBlackScreen = new AtomicBoolean(false);
    private boolean mCurrentDrawBlack = true;
    private int mCurrentDrawBlackTime = 0;
    private int mNoRenderFrameNum = 0;

    public YMFPlayerView(Context context) {
        super(context);
        this.initEgl();
        this.initFrameBuffer();
        YMFStreamManager.instance().registerListener(this);
    }

    public YMFPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initEgl();
        this.initFrameBuffer();
        YMFStreamManager.instance().registerListener(this);
    }

    private void printImageInfo(long streamId, YMFImageBuffer image) {
        int width = image.mWidth;
        int height = image.mHeight;
        long pts = image.mPts;
        YMFLog.info(this, "[PlayView]", "Image stream id:" + streamId + " width:" + width + " height:" + height + " pts:" + pts);
    }

    @Override
    public void onDecodedFrameAvailable(long streamId, YMFImageBuffer image) {
        if (streamId != this.mStreamId) {
            return;
        }
        this.processMediaSample(image);
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.CustomGLView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        this.mRenderLock.lock();
        this.mScaleMode = scaleMode;
        this.updateDrawPosition();
        this.mRenderLock.unlock();
        YMFLog.info(this, "[PlayView]", "setScaleMode:" + (Object)((Object)scaleMode));
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        YMFLog.error((Object)this, "[PlayView]", "setScaleModeEx not supported yet !");
        return false;
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        YMFLog.error((Object)this, "[PlayView]", "getScaleModeEx not supported yet !");
        return null;
    }

    @Override
    public Bitmap getVideoScreenshot() {
        try {
            YYRenderFrameBuffer.RGB565ImageWithNoPadding img = new YYRenderFrameBuffer.RGB565ImageWithNoPadding();
            if (this.mFrameBuffer != null && this.mFrameBuffer.GetCurrentPictureDataRGB565(img)) {
                Bitmap bmp = Bitmap.createBitmap((int)img.mWidth, (int)img.mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                bmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(img.mData));
                return bmp;
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[PlayView]", "getScrennShot exception:" + e.getMessage());
        }
        return null;
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        YMFLog.info(this, "[PlayView]", "PlayListner not used.");
    }

    @Override
    public void linkToStream(long userGroupId, long streamId) {
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.linkToStream(userGroupId, streamId);
        }
        this.mRenderLock.lock();
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
        StateMonitor.instance().NotifyAddView(streamId, 0, VideoConstant.ViewType.GL_VIDEO_VIEW_GLSURFACE, this.TAG);
        YMFLog.info(this, "[PlayView]", "linkToStream:" + streamId);
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewLinkStream(0, streamId, true);
        this.mRenderLock.unlock();
    }

    private void unLinkStream(long userGroupId, long streamId) {
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.unLinkFromStream(userGroupId, streamId);
        }
        this.mRenderLock.lock();
        StateMonitor.NotifyClearPts(streamId);
        if (this.mStreamId == streamId) {
            this.mStreamId = -1L;
        }
        StateMonitor.instance().NotifyRemoveView(streamId);
        StateMonitor.NotifyClearPts(streamId);
        YMFLog.info(this, "[PlayView]", "unLinkFromStream:" + streamId);
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewLinkStream(0, streamId, false);
        this.mRenderLock.unlock();
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        this.unLinkStream(userGroupId, streamId);
    }

    @Override
    public void unLinkFromStream() {
        this.unLinkStream(this.mUserGroupId, this.mStreamId);
    }

    @Override
    public void init() {
    }

    @Override
    public void release() {
        YMFPlayerUsrBehaviorStat.getInstance().notifyVideoPlayerViewState(0, false);
        YMFPlayerUsrBehaviorStat.getInstance().notifyGlManagerState(0, false);
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.release();
            this.mFrameBuffer = null;
        }
        YMFStreamManager.instance().unregisterListener(this);
        YMFLog.info(this, "[PlayView]", "release finish.");
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        YMFLog.error((Object)this, "[PlayView]", "setOrientation not supported yet !");
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
        YMFLog.info(this, "[PlayView]", this.hash + " onParentSizeChanged  width:" + w + " height:" + h);
    }

    @Override
    public boolean isReleased() {
        return false;
    }

    @Override
    public YYSoftDecRender getRenderFrameBuffer() {
        return this.mFrameBuffer;
    }

    @Override
    public void setVrStream(boolean vrStream) {
        YMFLog.error((Object)this, "[PlayView]", "setVrStream not supported yet !");
    }

    @Override
    public void stopRender() {
        YMFLog.error((Object)this, "[PlayView]", "stopRender not supported yet !");
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
        YMFLog.error((Object)this, "[PlayView]", "linkToStreamExt not supported yet !");
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        YMFLog.error((Object)this, "[PlayView]", "unLinkFromStreamExt not supported yet !");
    }

    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        YMFLog.error((Object)this, "[PlayView]", "getVideoScreenshotExt not supported yet !");
        return null;
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        YMFLog.error((Object)this, "[PlayView]", "getVideoViewInfo not supported yet !");
        return null;
    }

    private void initEgl() {
        YMFPlayerUsrBehaviorStat.getInstance().notifyVideoPlayerViewState(0, true);
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(new ConfigChooser(5, 6, 5, 0, 0, 0));
        this.setDebugFlags(1);
        this.setRenderer(this);
        YMFPlayerUsrBehaviorStat.getInstance().notifyGlManagerState(0, true);
        this.setRenderMode(0);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mGlThreadReady.set(true);
        this.mDrawBlackScreen.set(false);
    }

    private void initFrameBuffer() {
        this.mFrameBuffer = new YYRenderFrameBuffer(true);
        YYRenderFrameBuffer.newYUVFrameArrivedCallBack FrameArriveCallBack = new YYRenderFrameBuffer.newYUVFrameArrivedCallBack(){

            @Override
            public void onNewYUVFrameArrive() {
                boolean ret = YMFPlayerView.this.processMediaSample();
                if (!ret) {
                    YMFPlayerView.this.mFrameBuffer.setFrameRendered();
                }
            }
        };
        this.mFrameBuffer.setYUVFrameArriveCallback(FrameArriveCallBack);
        this.mVideoFrame = new YMFImageBuffer(32, 32, 2, false);
        YMFLog.info(this, "[PlayView]", "init finish.");
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(this, "[PlayView]", "surfaceDestroyed start.");
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewOnSurface(0, false);
        this.mRenderLock.lock();
        this.mSurfaceCreated = false;
        this.mRenderLock.unlock();
        this.postToGlThread(new Runnable(){

            @Override
            public void run() {
                YMFPlayerView.this.releaseRender();
            }
        });
        super.surfaceDestroyed(holder);
        YMFLog.info(this, "[PlayView]", "surfaceDestroyed end. not detach");
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        YMFLog.info(this, "[PlayView]", "onSurfaceCreated .");
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewOnSurface(0, true);
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mRenderLock.lock();
        this.mSurfaceCreated = true;
        if (this.mSurfaceWidth != width || this.mSurfaceHeight != height) {
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
            this.updateDrawPosition();
        }
        this.requestRender();
        YMFLog.info(this, "[PlayView]", "onSurfaceChanged width:" + width + " height:" + height + " now:" + TimeUtil.getTickCountLong());
        this.mRenderLock.unlock();
    }

    private void releaseRender() {
        if (this.mRender != null) {
            this.mRender.release();
            this.mRender = null;
        }
        this.mRenderReady.set(false);
        YMFLog.info(this, "[PlayView]", "releaseRender .");
    }

    public void postToGlThread(Runnable runable) {
        if (this.mGlThreadReady.get()) {
            this.queueEvent(runable);
        }
    }

    private void notifyRenderInfo(long streamId, long pts, long dts, int rct) {
        YMFEventManager.instance().notifyRenderEvnet(streamId, pts, dts, TimeUtil.getTickCountLong(), rct);
    }

    private void notifyRenderException(String msg) {
        PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "2", "102", msg);
        YMFLog.error((Object)this, "[PlayView]", "onDrawFrame Error ! " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        try {
            this.mRenderLock.lock();
            GLUtil.checkGlError("onDrawFrame enter ");
            if (!this.mRenderReady.get() && this.mSurfaceCreated && this.mRender == null) {
                this.mRender = new YMFRender(2);
                this.mRenderReady.set(true);
            }
            if (this.mRenderReady.get() && this.mRender != null && this.mDrawBlackScreen.get()) {
                if (!this.mCurrentDrawBlack) {
                    if (this.mSize.width > 0 && this.mSize.height > 0) {
                        gl.glViewport(this.mSize.x, this.mSize.y, this.mSize.width, this.mSize.height);
                    }
                    gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                    gl.glClear(16384);
                    if (this.mCurrentDrawBlackTime++ > 2) {
                        this.mCurrentDrawBlack = true;
                    }
                    YMFLog.error((Object)this, "[PlayView]", "onDrawFrame mCurrentDrawBlack ");
                }
                return;
            }
            if (this.mRenderReady.get() && this.mVideoFrame != null && this.mRender != null && this.mDataArrive.get()) {
                long startRenderTime = System.currentTimeMillis();
                if (this.mSize.width > 0 && this.mSize.height > 0) {
                    gl.glViewport(this.mSize.x, this.mSize.y, this.mSize.width, this.mSize.height);
                } else {
                    YMFLog.error((Object)this, "[PlayView]", " glViewport error, width:" + this.mSize.width + " height:" + this.mSize.height);
                }
                if (this.mScaleMode.compareTo(VideoConstant.ScaleMode.AspectFit) == 0) {
                    gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                    gl.glClear(16384);
                }
                if (this.mRender.prepareInputImageData(this.mVideoFrame)) {
                    if (this.mVideoFrame.mCropRight > 0) {
                        this.mRender.clip(this.mVideoWidth, this.mVideoHeight, this.mVideoFrame.mCropRight, this.mVideoFrame.mHeight, 1);
                    }
                    this.mRender.render();
                    if (!this.mFirstFrameRenderd) {
                        YMFPlayerUsrBehaviorStat.getInstance().notifyFirstFrameRendered(1);
                        this.mFirstFrameRenderd = true;
                    }
                }
                this.mDataArrive.set(false);
                this.mCurrentDrawBlack = false;
                this.mCurrentDrawBlackTime = 0;
                this.mNoRenderFrameNum = 0;
                long renderCostTime = System.currentTimeMillis() - startRenderTime;
                this.notifyRenderInfo(this.mVideoFrame.mStreamId, this.mVideoFrame.mPts, this.mVideoFrame.mDts, (int)renderCostTime);
            } else if (this.mNoRenderFrameNum++ % 100 == 0) {
                YMFLog.warn(this, "onDrawFrame ", this.mStreamId + "," + this.mRenderReady.get() + "," + this.mDataArrive.get() + "," + this.mSurfaceCreated + ",pts:" + (this.mVideoFrame == null ? 0L : this.mVideoFrame.mPts) + ",  now:" + TimeUtil.getTickCountLong());
            }
            GLUtil.checkGlError(this.TAG + " onDrawFrame out ");
        }
        catch (Throwable t) {
            this.notifyRenderException(t.getMessage() + " " + t.toString());
        }
        finally {
            this.mRenderLock.unlock();
            if (this.mFrameBuffer != null) {
                this.mFrameBuffer.setFrameRendered();
            }
        }
    }

    private void updateDrawPosition() {
        this.mSize = VideoSizeUtils.CalcFitSize(this.mVideoWidth, this.mVideoHeight, this.mSurfaceWidth, this.mSurfaceHeight, this.mScaleMode);
    }

    private void checkSizeUpdate(int width, int height) {
        if (this.mVideoWidth != width || this.mVideoHeight != height) {
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            this.updateDrawPosition();
            YMFLog.info(this, "[PlayView]", "checkSizeUpdate video width:" + width + " height:" + height);
        }
    }

    private void copyHardwareBuffer(YMFImageBuffer image) {
        if (this.mVideoFrame.mWidth != image.mWidth || this.mVideoFrame.mHeight != image.mHeight || this.mVideoFrame.mFormat != image.mFormat || this.mVideoFrame == null) {
            this.mVideoFrame = new YMFImageBuffer(image.mWidth, image.mHeight, image.mFormat, true);
        }
        if (this.mTmpBuffer == null || this.mTmpBuffer.length != image.mWidth * image.mHeight * 3 / 2) {
            this.mTmpBuffer = new byte[image.mWidth * image.mHeight * 3 / 2];
        }
        if (image.mData.hasArray() && this.mVideoFrame.mData.hasArray()) {
            System.arraycopy(image.mData.array(), image.mData.arrayOffset(), this.mVideoFrame.mData.array(), this.mVideoFrame.mData.arrayOffset(), image.mBufSize);
        } else {
            image.mData.rewind();
            if (image.mData.remaining() < this.mTmpBuffer.length) {
                YMFLog.error((Object)this, "[PlayView]", "copyHardwareBuffer " + image.mData.remaining() + " != " + this.mTmpBuffer.length + "," + image.mWidth + "x" + image.mHeight);
            }
            image.mData.get(this.mTmpBuffer);
            this.mVideoFrame.mData.rewind();
            this.mVideoFrame.mData.put(this.mTmpBuffer);
        }
        this.mVideoFrame.mHardware = image.mHardware;
        this.mVideoFrame.mStreamId = image.mStreamId;
        this.mVideoFrame.mDts = image.mDts;
        this.mVideoFrame.mPts = image.mPts;
        this.mVideoFrame.mCropRight = image.mCropRight;
    }

    public boolean processMediaSample(YMFImageBuffer image) {
        if (!this.mSurfaceCreated) {
            return false;
        }
        try {
            this.mRenderLock.lock();
            this.checkSizeUpdate(image.mWidth, image.mHeight);
            if (this.mVideoFrame != null) {
                if (image.mHardware) {
                    this.copyHardwareBuffer(image);
                } else {
                    this.mVideoFrame.assign(image);
                }
                this.mDataArrive.set(true);
            }
            this.requestRender();
        }
        catch (Exception e) {
            this.notifyRenderException(e.getMessage() + " processMediaSample " + e.toString());
        }
        finally {
            this.mRenderLock.unlock();
        }
        return true;
    }

    public boolean processMediaSample() {
        if (!this.mSurfaceCreated || this.mFrameBuffer == null) {
            return false;
        }
        boolean frameChanged = this.mFrameBuffer.hasFrame();
        ByteBuffer frame = this.mFrameBuffer.getFrame();
        if (frame == null || !frameChanged) {
            return false;
        }
        int width = this.mFrameBuffer.getWidth();
        int height = this.mFrameBuffer.getHeight();
        long pts = this.mFrameBuffer.getCurFramePts();
        long dts = this.mFrameBuffer.getLastDecodeTimeStamp();
        long streamId = this.mFrameBuffer.getStreamId();
        this.checkSizeUpdate(width, height);
        this.mRenderLock.lock();
        if (this.mVideoFrame != null) {
            this.mVideoFrame.assign(frame, width, height, 2, pts, dts, false, streamId, 0);
            this.mDataArrive.set(true);
        }
        this.requestRender();
        this.mRenderLock.unlock();
        return true;
    }

    public void drawBlackScreen(boolean black) {
        YMFLog.info(this, "[PlayView]", "drawBlackScreen video" + black);
        this.mDrawBlackScreen.set(black);
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private int mRedSize;
        private int mGreenSize;
        private int mBlueSize;
        private int mAlphaSize;
        private int mDepthSize;
        private int mStencilSize;
        private int EGL_OPENGL_ES2_BIT = 4;
        private int[] mDefaultValue = new int[1];
        private int[] mConfigAttr = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, this.EGL_OPENGL_ES2_BIT, 12344};

        private ConfigChooser(int r, int g, int b, int a, int d, int s) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = d;
            this.mStencilSize = s;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] numConfig = new int[1];
            egl.eglChooseConfig(display, this.mConfigAttr, null, 0, numConfig);
            int num = numConfig[0];
            if (num > 0) {
                EGLConfig[] configs = new EGLConfig[num];
                egl.eglChooseConfig(display, this.mConfigAttr, configs, num, numConfig);
                return this.chooseConfig(egl, display, configs);
            }
            return null;
        }

        private EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mDefaultValue)) {
                return this.mDefaultValue[0];
            }
            return defaultValue;
        }
    }
}

