/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.glesunder43;

import android.opengl.GLES20;
import android.util.Log;
import com.yy.videoplayer.glesunder43.GlUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class Texture2dProgram {
    private static final String TAG = "Grafika";
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    private static final String VERTEX_SHADER_WATERMARK = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvarying vec2 waterTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    waterTextureCoord = aTextureCoord.xy;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    private static final String FRAGMENT_SHADER_2D = "precision highp float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String FRAGMENT_SHADER_EXT = "#extension GL_OES_EGL_image_external : require\nprecision highp float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String FRAGMENT_SHADER_WATERMARK = "precision highp float;\nvarying vec2 vTextureCoord;\nvarying vec2 glPositionCoord;\nvarying vec2 waterTextureCoord;\nuniform sampler2D sTexture;\nuniform sampler2D waterTexture;\nuniform int waterEnabled;\nvoid main() {\n    if (waterEnabled == 1) {\n        vec4 wColor = texture2D(waterTexture, waterTextureCoord);\n        gl_FragColor = vec4(texture2D(sTexture, vTextureCoord).rgb * wColor.a + wColor.rgb, 1.0);\n    }\n    else {\n        gl_FragColor = texture2D(sTexture, vTextureCoord);\n    }\n}\n";
    public static final String FRAGMENT_SHADER_YUV = "precision highp float;varying vec2 vTextureCoord;uniform sampler2D tex_y;uniform sampler2D tex_u;uniform sampler2D tex_v;void main() {    vec3 yuv;    yuv.x = texture2D(tex_y, vTextureCoord).r;    yuv.y = texture2D(tex_u, vTextureCoord).r - 0.5;    yuv.z = texture2D(tex_v, vTextureCoord).r - 0.5;    yuv.x = 1.1643 * yuv.x - 0.0728;    vec3 rgb = vec3(        yuv.x + 1.5958 * yuv.z,        yuv.x - 0.39173 * yuv.y - 0.8129 * yuv.z,        yuv.x + 2.017 * yuv.y    );    gl_FragColor = vec4(rgb, 1);}";
    private ProgramType mProgramType;
    private int mProgramHandle;
    private int muMVPMatrixLoc;
    private int muTexMatrixLoc;
    private int maPositionLoc;
    private int maTextureCoordLoc;
    private int mWaterTextureLoc;
    private int mWaterEnabledLoc;
    protected int mSampleYLoc;
    protected int mSampleULoc;
    protected int mSampleVLoc;
    private int mTextureTarget;

    public Texture2dProgram(ProgramType programType) {
        this.mProgramType = programType;
        switch (programType) {
            case TEXTURE_2D: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_2D);
                break;
            }
            case TEXTURE_EXT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT);
                break;
            }
            case TEXTURE_WATERMARK: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER_WATERMARK, FRAGMENT_SHADER_WATERMARK);
                break;
            }
            case TEXTURE_YUV: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_YUV);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled type " + (Object)((Object)programType));
            }
        }
        if (this.mProgramHandle == 0) {
            throw new RuntimeException("Unable to create program");
        }
        Log.d((String)TAG, (String)("Created program " + this.mProgramHandle + " (" + (Object)((Object)programType) + ")"));
        this.maPositionLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
        GlUtil.checkLocation(this.maPositionLoc, "aPosition");
        this.maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aTextureCoord");
        GlUtil.checkLocation(this.maTextureCoordLoc, "aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uMVPMatrix");
        GlUtil.checkLocation(this.muMVPMatrixLoc, "uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexMatrix");
        GlUtil.checkLocation(this.muTexMatrixLoc, "uTexMatrix");
        this.mWaterTextureLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"waterTexture");
        this.mWaterEnabledLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"waterEnabled");
        this.mSampleYLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"tex_y");
        this.mSampleULoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"tex_u");
        this.mSampleVLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"tex_v");
    }

    public void release() {
        Log.d((String)TAG, (String)("deleting program " + this.mProgramHandle));
        GLES20.glDeleteProgram((int)this.mProgramHandle);
        this.mProgramHandle = -1;
    }

    public ProgramType getProgramType() {
        return this.mProgramType;
    }

    public int createTextureObject() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GlUtil.checkGlError("glGenTextures");
        int texId = textures[0];
        GLES20.glBindTexture((int)this.mTextureTarget, (int)texId);
        GlUtil.checkGlError("glBindTexture " + texId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError("glTexParameter");
        return texId;
    }

    public void draw(float[] mvpMatrix, FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, float[] texMatrix, FloatBuffer texBuffer, int textureId, int texStride, int waterMarkTextureId, int ytextureId, int utextureId, int vtextureId) {
        GlUtil.checkGlError("draw start");
        GLES20.glUseProgram((int)this.mProgramHandle);
        GlUtil.checkGlError("glUseProgram");
        if (this.mSampleYLoc >= 0) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)ytextureId);
            GLES20.glUniform1i((int)this.mSampleYLoc, (int)0);
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)utextureId);
            GLES20.glUniform1i((int)this.mSampleULoc, (int)1);
            GLES20.glActiveTexture((int)33986);
            GLES20.glBindTexture((int)3553, (int)vtextureId);
            GLES20.glUniform1i((int)this.mSampleVLoc, (int)2);
        } else {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)this.mTextureTarget, (int)textureId);
        }
        if (this.mWaterEnabledLoc >= 0) {
            if (waterMarkTextureId != -1) {
                GLES20.glUniform1i((int)this.mWaterEnabledLoc, (int)1);
                GLES20.glActiveTexture((int)33986);
                GLES20.glBindTexture((int)3553, (int)waterMarkTextureId);
                GLES20.glUniform1i((int)this.mWaterTextureLoc, (int)2);
            } else {
                GLES20.glUniform1i((int)this.mWaterEnabledLoc, (int)0);
                GLES20.glUniform1i((int)this.mWaterTextureLoc, (int)0);
            }
        }
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.maPositionLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maPositionLoc, (int)coordsPerVertex, (int)5126, (boolean)false, (int)vertexStride, (Buffer)vertexBuffer);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)texBuffer);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glDrawArrays((int)5, (int)firstVertex, (int)vertexCount);
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.maPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.maTextureCoordLoc);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }

    public static enum ProgramType {
        TEXTURE_2D,
        TEXTURE_EXT,
        TEXTURE_WATERMARK,
        TEXTURE_YUV;

    }
}

