/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.content.Context;
import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.decoder.GLVersionUtils;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.PlayerExceptionDataStat;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class YYVideoLibMgr {
    private static final String TAG = "YYVideoLibMgr";
    private String mAppVersion = "";
    private Context mApplicationContext = null;
    private String mAppName = "";
    private String mDeviceOsVersion = "";
    private String mDeviceModel = "";
    private String mLogPath = null;
    private ConcurrentLinkedQueue<IVideoLibInfoExt> mYYVideoLibInfoList = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<IVideoInfoCallback> mVideoInfoCBList = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<String, IVideoLibInfoExt> mYYVideoLibInfoMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, IVideoInfoCallback> mVideoInfoCBMap = new ConcurrentHashMap();
    private static YYVideoLibMgr mInstance = null;
    private static byte[] SYNC_FLAG = new byte[1];
    private ReentrantReadWriteLock syncLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYVideoLibMgr instance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YYVideoLibMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init(Context applicationContext, String strAppVersion, String strAppName, String deviceOsVersion, String deviceModel, String logPath) {
        this.mApplicationContext = applicationContext.getApplicationContext();
        this.mAppVersion = strAppVersion;
        this.mAppName = strAppName;
        this.mDeviceOsVersion = deviceOsVersion;
        this.mDeviceModel = deviceModel;
        this.mLogPath = logPath;
        if (this.mLogPath != null) {
            YMFLog.setFilePath(this.mLogPath);
        }
        GLVersionUtils.holdGLVersion(this.mApplicationContext);
        StateMonitor.instance().init();
        String Info = " ********************************************************************\n * YYVideoPlayer Version  : 200.1.14\n * Application Name    : " + this.mAppName + "\n * Application Version : " + this.mAppVersion + "\n * Device Model        : " + this.mDeviceModel + "\n * Android Version     : " + this.mDeviceOsVersion + "\n * OpenGL ES Version   : " + Integer.toHexString(GLVersionUtils.getGlVersion()) + "\n ********************************************************************";
        YMFLog.info(this, "[Api     ]", Info);
    }

    public void deInit(String strAppName) {
        IVideoInfoCallback callback;
        this.mAppVersion = "";
        this.mAppName = "";
        this.mDeviceOsVersion = "";
        this.mDeviceModel = "";
        this.mLogPath = null;
        YMFLog.setFilePath(null);
        this.syncLock.writeLock().lock();
        IVideoLibInfoExt ext = this.mYYVideoLibInfoMap.remove(strAppName);
        if (ext != null) {
            this.mYYVideoLibInfoList.remove(ext);
        }
        if ((callback = this.mVideoInfoCBMap.remove(strAppName)) != null) {
            this.mVideoInfoCBList.remove(callback);
        }
        this.syncLock.writeLock().unlock();
        mInstance = null;
        YMFLog.info(this, "[Api     ]", "deInit " + this.mYYVideoLibInfoMap.size() + ":" + this.mVideoInfoCBMap.size());
    }

    public long getUserId() {
        return 0L;
    }

    public long getTopSid() {
        return 0L;
    }

    public long getSubSid() {
        return 0L;
    }

    public String getLogFilePath() {
        return this.mLogPath;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public Context getAppContext() {
        return this.mApplicationContext;
    }

    public String getDeviceOsVersion() {
        return this.mDeviceOsVersion;
    }

    public String getDeviceModel() {
        return this.mDeviceModel;
    }

    public void setVideoInfoListener(String strAppName, IVideoLibInfoExt listener) {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() != 0) {
            for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
                if (!ext.equals(listener)) continue;
                this.syncLock.readLock().unlock();
                return;
            }
        }
        this.syncLock.readLock().unlock();
        this.syncLock.writeLock().lock();
        this.mYYVideoLibInfoList.add(listener);
        this.mYYVideoLibInfoMap.put(strAppName, listener);
        this.syncLock.writeLock().unlock();
    }

    public void setVideoInfoCallback(String strAppName, IVideoInfoCallback cb) {
        this.syncLock.readLock().lock();
        if (this.mVideoInfoCBList.size() != 0) {
            for (IVideoInfoCallback ext : this.mVideoInfoCBList) {
                if (!ext.equals(cb)) continue;
                this.syncLock.readLock().unlock();
                return;
            }
        }
        this.syncLock.readLock().unlock();
        this.syncLock.writeLock().lock();
        this.mVideoInfoCBList.add(cb);
        this.mVideoInfoCBMap.put(strAppName, cb);
        this.syncLock.writeLock().unlock();
    }

    public void onViewPlayEventNotify(long userGroupId, long streamId, int eventType, long happenTime) {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.onViewPlayEventNotify(userGroupId, streamId, eventType, happenTime);
        }
        this.syncLock.readLock().unlock();
    }

    public void onVideoRenderNotify(ArrayList<VideoRenderNotify> notifys) {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.onVideoRenderNotify(notifys);
        }
        this.syncLock.readLock().unlock();
    }

    public void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec, int eatenFrames) {
        YMFLog.info(this, "[Render  ]", "onFirstFrameRenderNotify userGroupId:" + userGroupId + " streamId:" + streamId + ",now " + TimeUtil.getTickCountLong());
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() != 0) {
            for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
                ext.onFirstFrameRenderNotify(userGroupId, streamId, currentSystemMilliSecond, firstFrameToRenderInMilliSec, eatenFrames);
            }
        }
        this.syncLock.readLock().unlock();
    }

    public void onCoefficientOfVariationOfRenderInterval(long userGroupId, long streamId, long intervalMilliTs, double coef) {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.onCoefficientOfVariationOfRenderInterval(userGroupId, streamId, intervalMilliTs, coef);
        }
        this.syncLock.readLock().unlock();
    }

    public void setConfigs(int appId, Map<Integer, Integer> configs) {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.setConfigs(appId, configs);
        }
        this.syncLock.readLock().unlock();
    }

    public int getConfig(int configKey) {
        return 0;
    }

    public void notifyHardwareCodecConfigured(boolean h264DecodeOn, boolean h264EncodeOn, boolean h265DecodeOn, boolean h265EncodeOn) {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList == null) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.notifyHardwareCodecConfigured(h264DecodeOn, h264EncodeOn, h265DecodeOn, h265EncodeOn);
        }
        this.syncLock.readLock().unlock();
    }

    public boolean isLibraryLoaded() {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return false;
        }
        IVideoLibInfoExt ext = this.mYYVideoLibInfoList.peek();
        this.syncLock.readLock().unlock();
        return ext.isLibraryLoaded();
    }

    public Context getmCtx() {
        return null;
    }

    public void setRunTimeStamp(String key, long ts) {
    }

    public boolean getIsRooted() {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return false;
        }
        IVideoLibInfoExt ext = this.mYYVideoLibInfoList.peek();
        this.syncLock.readLock().unlock();
        return ext.HWCodecConfigGetIsRooted();
    }

    public void onFirstFrameSeeNotify(long userGroupId, long streamId, long happenTime) {
        YMFLog.info(this, "[Render  ]", "onFirstFrameSeeNotify userGroupI:d" + userGroupId + " streamId:" + streamId);
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.onFirstFrameSeeNotify(userGroupId, streamId, happenTime);
        }
        this.syncLock.readLock().unlock();
    }

    public void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        YMFLog.error((Object)this, "[Decoder ]", "onHardwareDecodeErrorNotify userGroupId:" + userGroupId + " streamId:" + streamId + " errorType:" + errorType);
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.onHardwareDecodeErrorNotify(userGroupId, streamId, errorType);
        }
        this.syncLock.readLock().unlock();
        PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(streamId, "1", "3", "onHardwareDecodeErrorNotify errorType:" + errorType);
    }

    public void onHardwareDecodeWrongFrameNotify(long streamId, String name, byte[] header, byte[] data) {
        YMFLog.error((Object)this, "[Decoder ]", "onHardwareDecodeWrongFrameNotify streamID:" + streamId + " name:" + name);
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.onHardwareDecodeWrongFrameNotify(streamId, name, header, data);
        }
        this.syncLock.readLock().unlock();
    }

    public void onDecodedFrameData(long uid, int w, int h, byte[] data, int dateLen, long renderTimeMs) {
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            try {
                ext.onDecodedFrameData(uid, w, h, data, dateLen, renderTimeMs);
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Decoder ]", "onDecodedFrameData exception:" + e.toString());
            }
        }
        this.syncLock.readLock().unlock();
    }

    public void onFirstDecodedFrame(long streamId, long pts, long happenTime) {
        YMFLog.info(this, "[Decoder ]", "onFirstDecodedFrame " + streamId + ", pts:" + pts + ", happenTime:" + happenTime);
        this.syncLock.readLock().lock();
        if (this.mYYVideoLibInfoList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoLibInfoExt ext : this.mYYVideoLibInfoList) {
            ext.onFirstDecodedFrame(streamId, pts, happenTime);
        }
        this.syncLock.readLock().unlock();
    }

    public void onUpdatePts(long streamid, long pts) {
        this.syncLock.readLock().lock();
        if (this.mVideoInfoCBList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoInfoCallback callback : this.mVideoInfoCBList) {
            callback.onUpdatePts(streamid, pts);
        }
        this.syncLock.readLock().unlock();
    }

    public void onUpdateVideoSizeChanged(long streamid, int width, int height) {
        this.syncLock.readLock().lock();
        if (this.mVideoInfoCBList.size() == 0) {
            this.syncLock.readLock().unlock();
            return;
        }
        for (IVideoInfoCallback callback : this.mVideoInfoCBList) {
            callback.onUpdateVideoSizeChanged(streamid, width, height);
        }
        this.syncLock.readLock().unlock();
    }

    static {
        try {
            System.loadLibrary("Ittiamhevcdec");
            System.loadLibrary("yyvideoplayer");
        }
        catch (Throwable e) {
            YMFLog.error(null, "[Decoder ]", " loadLibrary yyvideoplayer exception:" + YMFLog.stackTraceOf(e));
        }
    }

    public static class MediaDecodeConfigKey {
        public static final int CCK_H265_HARDWARE_DECODE = 316;
        public static final int CCK_HARDWARE_DECODE = 302;
    }
}

