/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import com.yy.videoplayer.decoder.ISetThreadToPool;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.utils.YMFLog;
import java.util.HashMap;

public class ViewLiveStatManager {
    private static final String TAG = "ViewLiveStatManager";
    public static final int STAT_VIDEO_STREAM_ARRIVE = 0;
    public static final int STAT_RECV_HEADER = 1;
    public static final int STAT_RECV_FIRST_FRAME = 2;
    public static final int STAT_FIRST_FRAME_OUT = 3;
    public static final int STAT_VIDEO_STREAM_END = 4;
    public static final int STAT_SURFACE_VIDEO_VIEW = 0;
    public static final int STAT_TEXTURE_VIDEO_VIEW = 1;
    public static final int STAT_CUSTOM_GL_VIDEO_VIEW_LOW = 2;
    public static final int STAT_CUSTOM_GL_VIDEO_VIEW_HIGH = 3;
    public static final int STAT_GL_VIDEO_VIEW = 4;
    public static final int STAT_GLSURFACE_VIEW = 5;
    public static final int STAT_RECV_FRAME_NUM = 0;
    public static final int STAT_RENDER_FRAME_NUM = 1;
    private static Object mReadyFence = new Object();
    private boolean mReported = false;
    private int mWidth = -1;
    private int mHeight = -1;
    private static ISetThreadToPool mISetThreadToPool = null;
    private static ViewLiveStatManager vlsMgr = null;
    private static HashMap<String, Object> mLiveStatContent = new HashMap();

    public void setISetThreadToPool(ISetThreadToPool iSetThreadToPool) {
        mISetThreadToPool = iSetThreadToPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewLiveStatManager getInstace() {
        Object object = mReadyFence;
        synchronized (object) {
            if (vlsMgr == null) {
                vlsMgr = new ViewLiveStatManager();
                YMFLog.info(null, "[Stat    ]", "ViewLiveStatManager getInstace");
            }
        }
        return vlsMgr;
    }

    private ViewLiveStatManager() {
        YMFLog.info(null, "[Stat    ]", "ViewLiveStatManager Create");
    }

    private void startStat(int viewType) {
        this.clear();
        mLiveStatContent.put("dr12", YYVideoLibMgr.instance().getIsRooted() ? 1 : 0);
        mLiveStatContent.put("dr13", viewType);
        this.statUpload();
    }

    public HashMap getLiveStatContent() {
        this.statUpload();
        return mLiveStatContent;
    }

    public void notifyEventTime(int evtType, int viewType) {
        try {
            this.notifyEventTime(evtType, viewType, null);
        }
        catch (Throwable t) {
            YMFLog.info(null, "[Stat    ]", "notifyEventTime some sth. error, exception:" + t);
        }
    }

    public void notifyEventTime(int evtType, int viewType, Object obj) {
        YMFLog.info(null, "[Stat    ]", "ViewLiveStatManager:notifyEventTime, evtType:" + evtType + ", viewType:" + viewType);
        long now = System.currentTimeMillis();
        switch (evtType) {
            case 0: {
                this.startStat(viewType);
                if (this.mReported || viewType != 0) break;
                this.statUpload();
                break;
            }
            case 1: {
                this.setHeaderInfo(obj);
                break;
            }
            case 2: {
                this.setHeaderInfo(obj);
                break;
            }
            case 4: {
                if (!this.mReported && viewType == 3) {
                    this.statUpload();
                }
                this.clear();
                break;
            }
        }
    }

    private void setHeaderInfo(Object info) {
        if (info instanceof StatVideoHeaderInfo) {
            this.mWidth = ((StatVideoHeaderInfo)info).mWidth;
            this.mHeight = ((StatVideoHeaderInfo)info).mHeight;
        }
    }

    public void reportFrameEvent(int evt) {
    }

    public void reportDecError(int err) {
    }

    public void clear() {
        this.mWidth = -1;
        this.mHeight = -1;
        this.mReported = false;
    }

    private void statUpload() {
        this.mReported = true;
    }

    public static class StatVideoHeaderInfo {
        public int mWidth;
        public int mHeight;

        public StatVideoHeaderInfo() {
            this.mWidth = -1;
            this.mHeight = -1;
        }

        public StatVideoHeaderInfo(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }
    }
}

