/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import com.yy.videoplayer.YMFEventManager;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.HardDecodeWayBuffer;
import com.yy.videoplayer.decoder.HardDecodeWayGpu;
import com.yy.videoplayer.decoder.HardDecodeWaySimplified;
import com.yy.videoplayer.decoder.HardDecoderPool;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VP8DecRender;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.YLightweightVideoViewExt;
import com.yy.videoplayer.videoview.YSpVideoView;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.text.SimpleDateFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VideoDecoderCenterExt {
    private static final String TAG = "VideoDecoderCenterExt";
    private static ConcurrentMap<Long, HardDecodeWay> streamIdDecoderMap = new ConcurrentHashMap<Long, HardDecodeWay>();
    private static ConcurrentMap<Long, YLightweightVideoViewExt> streamIdViewMap = new ConcurrentHashMap<Long, YLightweightVideoViewExt>();
    private static final int GPUMaxRenderFrameRate = 40;
    private static String videoStreamFile = null;
    private static SimpleDateFormat dateFormat = null;
    private static long mLength;
    private static long mTime;
    private static boolean mYUVDecodeMode;
    private static HardDecoderStaffVersion currentHardDecoderStaffVersion;

    public static HardDecodeWay getDecoderStaff(long streamId) {
        return (HardDecodeWay)streamIdDecoderMap.get(streamId);
    }

    public static void Link(long streamId, YLightweightVideoViewExt view) {
        streamIdViewMap.put(streamId, view);
    }

    public static void Unlink(long streamId) {
        streamIdViewMap.remove(streamId);
    }

    private static boolean PreLinktoStreamIfNeed(long userGroupId, long streamId, int micpos) {
        YLightweightVideoViewExt view = (YLightweightVideoViewExt)streamIdViewMap.get(streamId);
        if (view == null) {
            view = (YLightweightVideoViewExt)streamIdViewMap.get(micpos);
            if (view != null) {
                if (((YSpVideoView)((Object)view)).isReleased()) {
                    YMFLog.error(null, "[Decoder ]", "PreLinktoStreamIfNeed view has been released, userGroupId:" + userGroupId + ", streamId:" + streamId + ", micpos:" + micpos);
                    return false;
                }
                ((YSpVideoView)((Object)view)).linkToStream(userGroupId, streamId);
                YMFLog.info(null, "[Decoder ]", "PreLinktoStreamIfNeed userGroupId:" + userGroupId + ", streamId:" + streamId + ", micpos:" + micpos);
                streamIdViewMap.remove(micpos);
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean setOnlyDecoded(long streamId, boolean onlyDecoded) {
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (hardDecodeWay != null && hardDecodeWay instanceof HardDecodeWayBuffer) {
            ((HardDecodeWayBuffer)hardDecodeWay).setOnlyDecoded(onlyDecoded);
            return true;
        }
        return false;
    }

    public static void VideoStreamStart(long userGroupId, long streamId, int streamType, int micpos, int fps, boolean onlyDecoded, int width, int height) {
        HardDecodeWay hardDecodeWay = null;
        if (onlyDecoded || mYUVDecodeMode) {
            StateMonitor.instance();
            StateMonitor.NotifyBlueRayInfo(streamId, VideoPlayerDataStat.BluRayType.Non_BluRay.ordinal());
            hardDecodeWay = HardDecoderPool.BorrowOrCreateDecoderByType(HardDecoderStaffVersion.YUVBUFFER);
            if (mYUVDecodeMode) {
                ((HardDecodeWayBuffer)hardDecodeWay).setYUVDecodeMode(true);
                YMFEventManager.instance().notifyStreamStart(streamId);
            }
            if (onlyDecoded) {
                ((HardDecodeWayBuffer)hardDecodeWay).setOnlyDecoded(true);
            }
        } else if (fps >= 40) {
            StateMonitor.instance();
            StateMonitor.NotifyBlueRayInfo(streamId, VideoPlayerDataStat.BluRayType.BluRay.ordinal());
            hardDecodeWay = HardDecoderPool.BorrowOrCreateDecoderByType(HardDecoderStaffVersion.SIMPLIFIED);
        } else {
            StateMonitor.instance();
            StateMonitor.NotifyBlueRayInfo(streamId, VideoPlayerDataStat.BluRayType.Non_BluRay.ordinal());
            hardDecodeWay = HardDecoderPool.BorrowOrCreateDecoderByType(HardDecoderStaffVersion.GPURENDER);
        }
        if (hardDecodeWay == null) {
            YMFLog.warn(null, "[Decoder ]", "VideoStreamStart BorrowOrCreateDecoderByType error!");
            hardDecodeWay = VideoDecoderCenterExt.GetNewHardDecodeWay();
        }
        hardDecodeWay.SetVideoIds(userGroupId, streamId);
        streamIdDecoderMap.put(streamId, hardDecodeWay);
        if (hardDecodeWay != null) {
            String mime = "video/avc";
            if (1 == streamType) {
                mime = "video/hevc";
            } else if (2 == streamType) {
                mime = "video/x-vnd.on2.vp8";
            }
            hardDecodeWay.OnCreateRenderAhead(width, height, mime);
        } else {
            YMFLog.error(null, "[Decoder]", "CreateRenderAhead HardDecodeWay with streamId = " + streamId + " not found");
        }
        YMFLog.info(null, "[Decoder ]", "VideoStreamStart HardDecodeWay count:" + streamIdDecoderMap.size() + ", add streamId:" + streamId + ", fps:" + fps + " used:" + hardDecodeWay);
        YLightweightVideoViewExt view = (YLightweightVideoViewExt)streamIdViewMap.get(streamId);
        if (view != null) {
            view.HoldDecoderStaff();
        }
    }

    private static HardDecodeWay newHardDecoderWaySimple() {
        YMFLog.info(null, "[Decoder ]", "resetHardDecoderWay to Simplify");
        HardDecodeWaySimplified hardDecodeWay = new HardDecodeWaySimplified();
        hardDecodeWay.Start();
        return hardDecodeWay;
    }

    public static void DeliverVideoConfig(long streamId, int streamType, byte[] header, int width, int height, int framerate) {
        YMFLog.info(null, "[Decoder ]", "DeliverVideoConfig streamId:" + streamId + " streamType:" + streamType + " width:" + width + " height:" + height + " framerate:" + framerate);
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (header != null) {
            mLength += (long)header.length;
        }
        if (hardDecodeWay != null) {
            String mime = "video/avc";
            if (1 == streamType) {
                mime = "video/hevc";
            } else if (2 == streamType) {
                mime = "video/x-vnd.on2.vp8";
            }
            hardDecodeWay.OnVideoConfig(header, width, height, mime);
        } else {
            YMFLog.error(null, "[Decoder ]", "DeliverVideoConfig HardDecodeWay with streamId:" + streamId + " not found");
        }
    }

    private static void notifyBiteRateInfo(long streamId, byte[] data) {
        long diffTime;
        if (data != null) {
            mLength += (long)data.length;
        }
        if (mTime == 0L) {
            mTime = System.currentTimeMillis();
        }
        if ((diffTime = System.currentTimeMillis() - mTime) > 10000L) {
            float bitrate = mLength / diffTime * 1000L * 8L;
            StateMonitor.instance();
            StateMonitor.NotifyBiteRateInfo(streamId, (int)bitrate);
            mLength = 0L;
            mTime = System.currentTimeMillis();
        }
    }

    public static void DeliverVideoData(long userGroupId, long streamId, byte[] data, long pts, int micpos) {
        VideoDecoderCenterExt.notifyBiteRateInfo(streamId, data);
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (hardDecodeWay != null) {
            hardDecodeWay.OnVideoDataArrived(data, pts);
            VideoDecoderCenterExt.PreLinktoStreamIfNeed(userGroupId, streamId, micpos);
        } else {
            YMFLog.error(null, "[Decoder ]", "HardDecodeWay with streamId:" + streamId + " not found");
        }
    }

    public static void VideoStreamEnd(long streamId) {
        YMFLog.info(null, "[Decoder ]", "VideoStreamEnd HardDecodeWay count:" + streamIdDecoderMap.size() + ", remove streamId:" + streamId);
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (hardDecodeWay != null) {
            hardDecodeWay.OnStreamEnd();
            hardDecodeWay.Quit();
            VideoPlayerDataStat.getInstance().clearVideoRenderPtsStatistics(streamId);
            streamIdDecoderMap.remove(streamId);
            hardDecodeWay = VideoDecoderCenterExt.GetNewHardDecodeWay();
            HardDecoderPool.ReturnDecoder(hardDecodeWay);
        } else {
            YMFLog.error(null, "[Decoder ]", "VideoStreamEnd fatal error! HardDecodeWay not found, streamId:" + streamId);
        }
        if (mYUVDecodeMode) {
            YMFEventManager.instance().notifyStreamEnd(streamId);
        }
    }

    public static boolean IsHardDecoderAvailable(int streamType) {
        if (1 == streamType) {
            return H265DecRender.IsAvailable();
        }
        if (0 == streamType) {
            return H264DecRender.IsAvailable();
        }
        if (2 == streamType) {
            return VP8DecRender.IsAvailable();
        }
        return false;
    }

    public static boolean IsDecoderNeedReconfig(long streamId) {
        HardDecodeWay hardDecodeWay = (HardDecodeWay)streamIdDecoderMap.get(streamId);
        if (hardDecodeWay != null) {
            return hardDecodeWay.IsDecoderNeedReconfig();
        }
        return false;
    }

    public static void PreSetVideoView(YSpVideoView firstly, YSpVideoView secondly) {
        if (firstly != null && firstly instanceof YLightweightVideoViewExt) {
            VideoDecoderCenterExt.Link(0L, (YLightweightVideoViewExt)((Object)firstly));
            YMFLog.info(null, "[Decoder ]", "PreSetVideoView 0");
        } else {
            streamIdViewMap.remove(0L);
            YMFLog.info(null, "[Decoder ]", "PreSetVideoView remove 0");
        }
        if (secondly != null && secondly instanceof YLightweightVideoViewExt) {
            VideoDecoderCenterExt.Link(1L, (YLightweightVideoViewExt)((Object)secondly));
            YMFLog.info(null, "[Decoder ]", "PreSetVideoView 1");
        } else {
            streamIdViewMap.remove(1L);
            YMFLog.info(null, "[Decoder ]", "PreSetVideoView remove 1");
        }
    }

    public static void UnSetVideoView() {
        streamIdViewMap.remove(0L);
        streamIdViewMap.remove(1L);
        YMFLog.info(null, "[Decoder ]", "UnSetVideoView");
    }

    public static void ChooseHardDecoderStaff(HardDecoderStaffVersion hardDecoderStaffVersion) {
        YMFLog.info(null, "[Decoder ]", "ChooseHardDecoderStaff hardDecoderStaffVersion:" + (Object)((Object)hardDecoderStaffVersion));
        currentHardDecoderStaffVersion = hardDecoderStaffVersion;
    }

    public static HardDecoderStaffVersion GetCurrentHardDecoderStaffVersion() {
        return currentHardDecoderStaffVersion;
    }

    public static HardDecodeWay GetNewHardDecodeWay() {
        YMFLog.info(null, "[Decoder ]", "GetNewHardDecodeWay version:" + (Object)((Object)currentHardDecoderStaffVersion));
        Runnable hardDecodeWay = currentHardDecoderStaffVersion == HardDecoderStaffVersion.SIMPLIFIED ? new HardDecodeWaySimplified() : (currentHardDecoderStaffVersion == HardDecoderStaffVersion.YUVBUFFER ? new HardDecodeWayBuffer() : new HardDecodeWayGpu());
        hardDecodeWay.Start();
        return hardDecodeWay;
    }

    static {
        mYUVDecodeMode = true;
        currentHardDecoderStaffVersion = HardDecoderStaffVersion.GPURENDER;
    }

    public static class FileUtil {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static byte[] file2Byte(String filePath) {
            ByteArrayOutputStream bos = null;
            BufferedInputStream in = null;
            try {
                File file = new File(filePath);
                if (!file.exists()) {
                    throw new FileNotFoundException("file not exists");
                }
                bos = new ByteArrayOutputStream((int)file.length());
                in = new BufferedInputStream(new FileInputStream(file));
                int buf_size = 1024;
                byte[] buffer = new byte[buf_size];
                int len = 0;
                while (-1 != (len = in.read(buffer, 0, buf_size))) {
                    bos.write(buffer, 0, len);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void byte2File(byte[] bfile, String filePath, String fileName) {
            FilterOutputStream bos = null;
            FileOutputStream fos = null;
            File file = null;
            try {
                File dir = new File(filePath);
                if (!dir.exists() && dir.isDirectory()) {
                    dir.mkdirs();
                }
                file = new File(filePath + fileName);
                fos = new FileOutputStream(file, true);
                bos = new BufferedOutputStream(fos);
                bos.write(bfile);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public static enum HardDecoderStaffVersion {
        SIMPLIFIED,
        GPURENDER,
        YUVBUFFER;

    }

    public static class VideoStreamType {
        public static final int NOT_SET = -1;
        public static final int H264 = 0;
        public static final int H265 = 1;
        public static final int VP8 = 2;
    }
}

