/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.opengl.GLES20;
import com.yy.videoplayer.decoder.CatchError;
import java.nio.Buffer;

public class VBO {
    private int mID = -1;

    public VBO(int target, int size, Buffer data, int usage) {
        int[] id = new int[1];
        GLES20.glGenBuffers((int)1, (int[])id, (int)0);
        this.mID = id[0];
        GLES20.glBindBuffer((int)target, (int)this.mID);
        GLES20.glBufferData((int)target, (int)size, (Buffer)data, (int)usage);
        GLES20.glBindBuffer((int)target, (int)0);
        CatchError.catchError("VBO");
    }

    public int getId() {
        return this.mID;
    }

    public void subBuffer(int target, int size, Buffer data) {
        GLES20.glBindBuffer((int)target, (int)this.mID);
        GLES20.glBufferSubData((int)target, (int)0, (int)size, (Buffer)data);
        CatchError.catchError("subBuffer");
        GLES20.glBindBuffer((int)target, (int)0);
    }

    public void delete() {
        if (-1 != this.mID) {
            int[] id = new int[]{this.mID};
            GLES20.glDeleteBuffers((int)1, (int[])id, (int)0);
            CatchError.catchError("deleteVBOBuffer");
            this.mID = -1;
        }
    }
}

