/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.opengl.GLES20;
import com.yy.videoplayer.decoder.CatchError;
import com.yy.videoplayer.utils.YMFLog;

public class ShaderUtils {
    public static int compileShader(int type, String shaderCode) {
        CatchError.catchError("compileShader0");
        int shaderHandle = GLES20.glCreateShader((int)type);
        CatchError.catchError("compileShader1");
        GLES20.glShaderSource((int)shaderHandle, (String)shaderCode);
        CatchError.catchError("compileShader2");
        GLES20.glCompileShader((int)shaderHandle);
        CatchError.catchError("compileShader3");
        int status = ShaderUtils.checkShaderStatus(shaderHandle, 35713);
        CatchError.catchError("compileShader4");
        if (0 == status) {
            GLES20.glDeleteShader((int)shaderHandle);
            CatchError.catchError("compileShader5");
            return 0;
        }
        return shaderHandle;
    }

    public static int linkShader(int ... shaderList) {
        int program = GLES20.glCreateProgram();
        for (int shader : shaderList) {
            GLES20.glAttachShader((int)program, (int)shader);
            CatchError.catchError("linkShader 0 shader " + shader);
        }
        GLES20.glLinkProgram((int)program);
        int status = ShaderUtils.checkProgramStatus(program, 35714);
        if (0 == status) {
            ShaderUtils.deleteShaderProgram(program, shaderList);
            return 0;
        }
        return program;
    }

    public static int validateShaderProgram(int program) {
        GLES20.glValidateProgram((int)program);
        return ShaderUtils.checkProgramStatus(program, 35715);
    }

    public static int deleteShaderProgram(int program, int ... shaderList) {
        for (int shader : shaderList) {
            if (GLES20.glIsShader((int)shader)) {
                GLES20.glDetachShader((int)program, (int)shader);
                GLES20.glDeleteShader((int)shader);
                CatchError.catchError("deleteShaderProgram program " + program + " shader " + shader);
            }
            if (!GLES20.glIsShader((int)shader) || 0 != ShaderUtils.checkShaderStatus(shader, 35712)) continue;
            return 0;
        }
        if (GLES20.glIsProgram((int)program)) {
            GLES20.glDeleteProgram((int)program);
        }
        if (GLES20.glIsProgram((int)program) && 0 == ShaderUtils.checkProgramStatus(program, 35712)) {
            return 0;
        }
        return 1;
    }

    private static int checkProgramStatus(int program, int programStatus) {
        int[] status = new int[]{1};
        GLES20.glGetProgramiv((int)program, (int)programStatus, (int[])status, (int)0);
        CatchError.catchError("checkProgramStatus");
        if (1 == status[0]) {
            return 1;
        }
        YMFLog.error(null, "[Util    ]", "checkShaderStatus " + GLES20.glGetProgramInfoLog((int)program) + " " + status[0]);
        CatchError.catchError("checkProgramStatus1");
        return 0;
    }

    private static int checkShaderStatus(int shader, int shaderStatus) {
        int[] status = new int[]{1};
        GLES20.glGetShaderiv((int)shader, (int)shaderStatus, (int[])status, (int)0);
        CatchError.catchError("checkShaderStatus");
        if (1 == status[0]) {
            return 1;
        }
        YMFLog.error(null, "[Util    ]", "checkProgramStatus " + GLES20.glGetShaderInfoLog((int)shader) + " " + status[0]);
        CatchError.catchError("checkShaderStatus1");
        return 0;
    }
}

