/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import android.view.View;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.HardDecRender;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.SmoothnessCounter;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VP8DecRender;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.decoder.VideoSizeUtils;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.decoder.gles_decoder.EglCore;
import com.yy.videoplayer.decoder.gles_decoder.FullFrameRect;
import com.yy.videoplayer.decoder.gles_decoder.GlUtil;
import com.yy.videoplayer.decoder.gles_decoder.Texture2dProgram;
import com.yy.videoplayer.decoder.gles_decoder.WindowSurface;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.VideoEntities;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import com.yy.videoplayer.vr.VRLibrary;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class HardDecodeWayGpu
implements Runnable,
HardDecodeWay,
SurfaceTexture.OnFrameAvailableListener,
HardDecRender.IDecoderDataOutCallBack {
    private static final String TAG = "HardDecodeWayGpu";
    private static final int MSG_VIDEO_SURFACE_CHANGED = 1;
    private static final int MSG_VIDEO_SURFACE_DESTROYED = 2;
    private static final int MSG_VIDEO_SURFACE_REDRAW = 3;
    private static final int MSG_GET_SCREENSHOT = 4;
    private static final int MSG_VIDEO_CONFIG = 5;
    private static final int MSG_VIDEO_DATA = 6;
    private static final int MSG_END_OF_STREAM = 7;
    private static final int MSG_QUIT = 8;
    private static final int MSG_VSYNC_ARRIVED = 9;
    private static final int MSG_VIDEO_SURFACE_CREATED = 10;
    private static final int MSG_SETVIDEINFOCALLBACK = 11;
    private static final int VIDEO_DATA_LOG = 500;
    private long mVideoDataCnt = 0L;
    private boolean mRecIFrame = false;
    private RenderHandler mHandler;
    private HardDecRender mOuterDecoder = null;
    private AtomicLong mOuterOutPts = new AtomicLong(0L);
    private EglCore mEglCore;
    private EGLSurface mEnvSurface;
    private FullFrameRect mVideoScreen;
    private WindowSurface mVideoWindowSurface;
    private Surface mVideoSurface;
    private SurfaceTexture mDecoderSurfaceTexture;
    private Surface mDecoderSurface;
    private int mDecoderTextureId = -1;
    private float[] mSrcTransform;
    private float[] mTmpTransform;
    private float[] mTransform;
    private VideoEntities.VideoSizes mVideoSizes = new VideoEntities.VideoSizes();
    private SurfaceScaleInfo mSurfaceScaleInfo;
    private boolean mIsDecoderNeedReconfig = false;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private AtomicBoolean mSurfaceDestoryedState = new AtomicBoolean(false);
    private final Object mStartLock = new Object();
    private final Object mQuitLock = new Object();
    private final Object mScreenShotLock = new Object();
    private final Object mSurfaceDestroyLock = new Object();
    private Thread mThread;
    private int mFrames = -1;
    private boolean mFirstFrameOut = false;
    private boolean mFirstFrameRendered = false;
    private boolean mFirstFrameDecodered = false;
    private long mFirstFrameTs = 0L;
    private PlayNotify mPlayNotify;
    private long mUserGroupId = 0L;
    private long mStreamId = 0L;
    private long mVsyncTime = 0L;
    private long mDiff = 0L;
    private long mFramePtsDiff = 0L;
    private long mVsyncTimeDiff = 0L;
    private long mBasicVsync = 0L;
    private long mPreVsync = 0L;
    private long mPreFramePts = 0L;
    private long mSum = 0L;
    private int mFrameCnt = 0;
    private int mRenderCnt = 0;
    private long mCurTime = 0L;
    private long mLastTime = 0L;
    private int mDecodeCnt = 0;
    private long mCurTime1 = 0L;
    private long mLastTime1 = 0L;
    private boolean mFirstFrameSeeFlag = false;
    private long mTempPts;
    private int mFrameWidth;
    private int mFrameHeight;
    private SmoothnessCounter mSmoothnessCounter = new SmoothnessCounter(5000L);
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys = new ArrayList();
    public YspVideoViewInfo mYspVideoViewInfo = new YspVideoViewInfo();
    private IVideoInfoCallback mVideoInfoCallback = null;
    private Hashtable<Long, Long> mDecoderTimeStampMap = new Hashtable();
    private VRLibrary mVRLibrary;
    private boolean mIsVrStream = false;
    private ReentrantLock mSurfaceDestoryedLock = new ReentrantLock(true);
    private long mLastDecodedTimeStampTime = 0L;
    long vsyncT = 0L;
    long vsyncCnt = 0L;
    static final long kNotifyTimeGap = 500L;
    static final int kNofifySizeGap = 15;
    private HardDecRender mNewOutDecoder = null;
    private int mNewWidth = 0;
    private int mNewHeight = 0;
    private HandlerThread mAsyncHandlerThread = null;
    private Handler mAsyncHandler = null;
    private AtomicBoolean mUsedNewOutDecoder = new AtomicBoolean(false);
    private Queue<VideoEntities.VideoData> mDecodingQueue = new ConcurrentLinkedQueue<VideoEntities.VideoData>();
    private SurfaceTexture mNewDecoderSurfaceTexture;
    private Surface mNewDecoderSurface;
    private int mNewDecoderTextureId = -1;
    private boolean mNewDecodedOutFirstFrame = false;

    @Override
    public VideoDecoderCenterExt.HardDecoderStaffVersion getHardDecodeType() {
        return VideoDecoderCenterExt.HardDecoderStaffVersion.GPURENDER;
    }

    @Override
    public long getUserGroupId() {
        return this.mUserGroupId;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback callback) {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "setVideoInfoCallback");
            this.mHandler.sendMessage(this.mHandler.obtainMessage(11, callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Start() {
        YMFLog.info(this, "[Decoder ]", "HardDecodeWayGpu Start...");
        this.mAsyncHandlerThread = new HandlerThread("YY_yylivesdk_HardDecodeWayGpu_AsyncThread");
        this.mAsyncHandlerThread.start();
        this.mAsyncHandler = new Handler(this.mAsyncHandlerThread.getLooper());
        this.mThread = new Thread(this);
        this.mThread.setName("YY_yylivesdk_HardDecodeWayGpu_Thread");
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                this.mThread.start();
                this.mStartLock.wait(500L);
            }
            catch (Throwable e) {
                YMFLog.error((Object)this, "[Decoder ]", "HardDecodeWayGpu thread start exception:" + e.getMessage());
            }
        }
        YMFLog.info(this, "[Decoder ]", "HardDecodeWayGpu Start done");
    }

    @Override
    public boolean IsDecoderNeedReconfig() {
        return this.mIsDecoderNeedReconfig;
    }

    @Override
    public void SetPlayNotify(PlayNotify playNotify) {
        this.mPlayNotify = playNotify;
    }

    @Override
    public void SetVideoIds(long userGroupId, long streamId) {
        YMFLog.info(this, "[Decoder ]", "SetVideoIds userGroupId:" + userGroupId + ", streamId:" + streamId);
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
    }

    @Override
    public void OnSurfaceCreated() {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(10));
        }
    }

    @Override
    public void OnSurfaceRedraw() {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
        }
    }

    @Override
    public void OnSurfaceChanged(View videoView, Surface surface, int width, int height, int parentWidth, int parentHeight, int rotateAngle, YSpVideoView.OrientationType orientationType, VideoConstant.ScaleMode scaleMode) {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "OnSurfaceChanged width:" + width + " height:" + height + " parentWidth:" + parentWidth + " parentHeight:" + parentHeight);
            SurfaceScaleInfo sinfo = new SurfaceScaleInfo();
            sinfo.videoView = videoView;
            sinfo.surface = surface;
            sinfo.width = width;
            sinfo.height = height;
            sinfo.parentWidth = parentWidth;
            sinfo.parentHeight = parentHeight;
            sinfo.rotateAngle = rotateAngle;
            sinfo.orientationType = orientationType;
            sinfo.scaleMode = scaleMode;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, sinfo));
        }
    }

    @Override
    public void OnSurfaceDestroyed(Surface surface) {
        if (this.mReady.get()) {
            this.mHandler.removeMessages(9);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, surface));
            this.tryLockSurfaceDestoryLock();
            this.mSurfaceDestoryedState.set(true);
            this.tryUnlockSurfaceDestroyLock();
            YMFLog.info(this, "[Decoder ]", "OnSurfaceDestroyed mSurfaceDestoryedState true");
        } else {
            YMFLog.error((Object)this, "[Decoder ]", "OnSurfaceDestroyed mReady == false!");
        }
        StateMonitor.NotifyClearPts(this.mStreamId);
    }

    @Override
    public void OnStreamEnd() {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "OnStreamEnd");
            this.mHandler.sendMessage(this.mHandler.obtainMessage(7));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap GetScreenShot() {
        Bitmap bmp = null;
        ScreenShotInfo info = new ScreenShotInfo();
        info.isSuccess = false;
        if (this.mReady.get()) {
            Object object = this.mScreenShotLock;
            synchronized (object) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(4, info));
                try {
                    this.mScreenShotLock.wait(500L);
                }
                catch (Throwable t) {
                    YMFLog.info(this, "[Decoder ]", "getScreenShot wait exception:" + t.getMessage());
                }
            }
        }
        if (info.isSuccess) {
            bmp = Bitmap.createBitmap((int)info.width, (int)info.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bmp != null) {
                bmp.copyPixelsFromBuffer(info.pixelBuffer);
            } else {
                YMFLog.error((Object)this, "[Decoder ]", "Bitmap.createBitmap failed!");
            }
        }
        YMFLog.info(this, "[Decoder ]", "GetScreenShot isSuccess:" + info.isSuccess + " width:" + info.width + " height:" + info.height);
        return bmp;
    }

    private String bin2hex(byte[] data) {
        String hex = null;
        int len = data == null ? 0 : data.length;
        for (int i = 0; i < len; ++i) {
            hex = hex != null ? hex + String.format("%02x ", data[i]) : String.format("%02x ", data[i]);
        }
        return hex;
    }

    @Override
    public void OnCreateRenderAhead(int width, int height, String mime) {
    }

    @Override
    public void OnVideoConfig(final byte[] header, final int width, final int height, final String mime) {
        if (this.mReady.get()) {
            YMFLog.info(this, "[Decoder ]", "OnVideoConfig width:" + width + " height:" + height + " mime:" + mime + " streamId:" + this.mStreamId + " data:" + this.bin2hex(header));
            if (this.mOuterDecoder == null) {
                if ("video/hevc".equals(mime)) {
                    this.mOuterDecoder = new H265DecRender(this.mDecoderSurface, width, height, this.mUserGroupId, this.mStreamId);
                    StateMonitor.NotifyCreateRender(this.mStreamId, 1);
                } else if ("video/avc".equals(mime)) {
                    this.mOuterDecoder = new H264DecRender(this.mDecoderSurface, width, height, this.mUserGroupId, this.mStreamId);
                    StateMonitor.NotifyCreateRender(this.mStreamId, 0);
                } else if ("video/x-vnd.on2.vp8".equals(mime)) {
                    this.mOuterDecoder = new VP8DecRender(this.mDecoderSurface, width, height);
                }
                this.mOuterDecoder.setStreamId(this.mStreamId);
            } else if ((width < height && this.mFrameWidth < this.mFrameHeight || width >= height && this.mFrameWidth >= this.mFrameHeight) && this.mFirstFrameOut) {
                if (this.mAsyncHandler != null) {
                    if (this.mDecodingQueue.size() != 0) {
                        YMFLog.warn(this, "[Decoder ]", "createDecoderAsync clean mDecodingQueue");
                        this.mDecodingQueue.clear();
                    }
                    this.mAsyncHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            HardDecodeWayGpu.this.createDecoderAsync(header, width, height, mime);
                        }
                    });
                    this.mNewDecodedOutFirstFrame = false;
                    this.mUsedNewOutDecoder.set(true);
                    return;
                }
            } else {
                if (this.mAsyncHandler != null) {
                    if (this.mDecodingQueue.size() != 0) {
                        YMFLog.warn(this, "[Decoder ]", "createDecoderAsync clean mDecodingQueue");
                        this.mDecodingQueue.clear();
                    }
                    this.mAsyncHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            HardDecodeWayGpu.this.destoryAsyncEnv();
                        }
                    });
                }
                this.mUsedNewOutDecoder.set(false);
                this.mOuterDecoder.reset(this.mDecoderSurface, width, height);
            }
            this.mRecIFrame = false;
            this.mVideoDataCnt = 0L;
            this.mOuterOutPts.set(0L);
            this.mFrames = 0;
            this.mIsDecoderNeedReconfig = false;
            this.mFirstFrameOut = false;
            this.mVideoRenderNotifys.clear();
            this.mOuterDecoder.PushFrame(this.mDecoderSurface, header, 0L, true);
            this.mOuterDecoder.ConfigDone();
            if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
                this.mIsDecoderNeedReconfig = true;
                this.mOuterDecoder.EndofStream();
            }
            VideoHeaderInfo vhi = new VideoHeaderInfo();
            vhi.header = header;
            vhi.width = width;
            vhi.height = height;
            vhi.mime = mime;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, vhi));
        }
    }

    @Override
    public void OnVideoDataArrived(byte[] data, long pts) {
        if (this.mReady.get()) {
            if (this.mVideoDataCnt++ % 500L == 0L || (!this.mFirstFrameOut || !this.mRecIFrame) && this.mFrames <= 50) {
                YMFLog.info(this, "[Decoder ]", "OnVideoDataArrived streamId:" + this.mStreamId + ", pts:" + pts);
            }
            if (this.mUsedNewOutDecoder.get() && !this.mNewDecodedOutFirstFrame) {
                VideoEntities.VideoData vd = new VideoEntities.VideoData();
                vd.data = data;
                vd.pts = pts;
                this.mDecodingQueue.add(vd);
                if (this.mAsyncHandler != null) {
                    this.mAsyncHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            HardDecodeWayGpu.this.decodeFrameAsync();
                        }
                    });
                    this.handleGetCacheFrame();
                }
            } else if (this.mUsedNewOutDecoder.get() && this.mNewDecodedOutFirstFrame) {
                this.changeToNewDecoder();
            }
            if (!this.mUsedNewOutDecoder.get()) {
                this.handleOuterVideoData(data, pts);
            }
        } else {
            YMFLog.warn(this, "[Decoder ]", "mReady false, OnVideoDataArrived streamId:" + this.mStreamId + ", pts:" + pts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Quit() {
        if (this.mReady.get()) {
            Object object = this.mQuitLock;
            synchronized (object) {
                try {
                    if (this.mOuterDecoder != null) {
                        StateMonitor.NotifyReleaseRender(this.mStreamId);
                        this.mOuterDecoder.release();
                        this.mOuterDecoder.EndofStream();
                        this.mOuterDecoder = null;
                    }
                    if (this.mAsyncHandler != null) {
                        this.mAsyncHandler.removeCallbacksAndMessages(null);
                        final CountDownLatch syncFlag = new CountDownLatch(1);
                        this.mAsyncHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (HardDecodeWayGpu.this.mUsedNewOutDecoder.get() && HardDecodeWayGpu.this.mNewOutDecoder != null) {
                                    HardDecodeWayGpu.this.mNewOutDecoder.release();
                                    HardDecodeWayGpu.this.mNewOutDecoder.EndofStream();
                                    HardDecodeWayGpu.this.mNewOutDecoder = null;
                                }
                                syncFlag.countDown();
                            }
                        });
                        try {
                            syncFlag.await();
                        }
                        catch (Exception e) {
                            YMFLog.error((Object)this, "[Decoder ]", "HardDecodeWayGpu Quit syncFlag.await():" + e.toString());
                        }
                        this.mAsyncHandlerThread.quit();
                        this.mAsyncHandlerThread = null;
                        this.mAsyncHandler = null;
                    }
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(8));
                    this.mQuitLock.wait(500L);
                    YMFLog.info(this, "[Decoder ]", "HardDecodeWayGpu Quit");
                }
                catch (Throwable e) {
                    YMFLog.error((Object)this, "[Decoder ]", "HardDecodeWayGpu Quit exception:" + e.getMessage());
                }
            }
        }
    }

    @Override
    public void setVrStream(boolean vrStream) {
        YMFLog.info(this, "[Decoder ]", "vrStream:" + vrStream);
        this.mIsVrStream = vrStream;
    }

    private void handleOuterVideoData(byte[] data, long pts) {
        if (this.mIsDecoderNeedReconfig) {
            YMFLog.warn(this, "[Decoder ]", "handleOuterVideoData mIsDecoderNeedReconfig true streamId:" + this.mStreamId + ", pts:" + pts);
            return;
        }
        if (this.mFrames <= 0) {
            ViewLiveStatManager.getInstace().notifyEventTime(2, 0);
        }
        ViewLiveStatManager.getInstace().reportFrameEvent(0);
        ++this.mFrames;
        if (this.mOuterDecoder != null) {
            if (!(this.mFirstFrameOut && this.mRecIFrame || this.mFrames > 50)) {
                int type = 0;
                if (!(this.mOuterDecoder instanceof VP8DecRender)) {
                    type = data == null ? 255 : (data[0] == 0 && data[1] == 0 && data[2] == 1 ? data[3] & 0x1F : (data[0] == 0 && data[1] == 0 && data[2] == 0 && data[3] == 1 ? data[4] & 0x1F : -1));
                }
                if (type == 5) {
                    this.mRecIFrame = true;
                }
                YMFLog.info(this, "[Decoder ]", "handleOuterVideoData streamId:" + this.mStreamId + ", frames:" + this.mFrames + ", type:" + type + ", len:" + (data == null ? 0 : data.length) + ", pts:" + pts);
            }
            this.mOuterOutPts.set(this.mOuterDecoder.PushFrame(this.mDecoderSurface, data, pts, false));
            if (this.mOuterOutPts.get() <= 0L) {
                if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
                    YMFLog.warn(this, "[Decoder ]", "handleOuterVideoData decoder exception! Need to recconfig!");
                    this.mIsDecoderNeedReconfig = true;
                    this.mOuterDecoder.EndofStream();
                }
            } else {
                if (this.mDecoderTimeStampMap.size() <= 100) {
                    this.mDecoderTimeStampMap.put(this.mOuterOutPts.get(), TimeUtil.getTickCountLong());
                } else {
                    YMFLog.info(this, "[Decoder ]", "handleOuterVideoData mDecoderTimeStampMap full ");
                    this.mDecoderTimeStampMap.clear();
                }
                if (!this.mFirstFrameOut) {
                    StateMonitor.instance().NotifyDecodeDelayFrameCountInfo(this.mStreamId, this.mFrames);
                    YMFLog.info(this, "[Decoder ]", "handleOuterVideoData first frame out, frames:" + this.mFrames);
                }
                this.mFirstFrameOut = true;
                this.mLastDecodedTimeStampTime = TimeUtil.getTickCountLong();
                ++this.mDecodeCnt;
                this.mCurTime1 = TimeUtil.getTickCountLong();
                if (this.mLastTime1 == 0L) {
                    this.mLastTime1 = this.mCurTime1;
                }
                if (this.mCurTime1 - this.mLastTime1 >= 1000L) {
                    StateMonitor.NotifyDecoderFrameRateOUT(this.mStreamId, this.mDecodeCnt);
                    this.mLastTime1 = this.mCurTime1;
                    this.mDecodeCnt = 0;
                }
            }
        } else {
            YMFLog.error((Object)this, "[Decoder ]", "handleOuterVideoData mOuterDecoder:" + this.mOuterDecoder);
        }
    }

    private void InitEGL() {
        this.mEglCore = new EglCore(null, 0);
        this.mEnvSurface = this.mEglCore.createOffscreenSurface(320, 240);
        this.mEglCore.makeCurrent(this.mEnvSurface);
        this.mVideoScreen = new FullFrameRect(new Texture2dProgram(Texture2dProgram.ProgramType.TEXTURE_EXT));
        this.mVRLibrary = new VRLibrary(YYVideoLibMgr.instance().getAppContext());
        this.mVRLibrary.initLibrary(true);
        this.mDecoderTextureId = this.genExtTexture();
        this.mDecoderSurfaceTexture = new SurfaceTexture(this.mDecoderTextureId);
        this.mDecoderSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.mDecoderSurface = new Surface(this.mDecoderSurfaceTexture);
        this.mSrcTransform = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix.rotateM((float[])this.mSrcTransform, (int)0, (float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Matrix.translateM((float[])this.mSrcTransform, (int)0, (float)0.0f, (float)-1.0f, (float)0.0f);
        this.mTransform = new float[16];
        this.mTmpTransform = new float[16];
        System.arraycopy(this.mSrcTransform, 0, this.mTransform, 0, 16);
        this.mVideoRenderNotifys.clear();
    }

    private int genExtTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError("genExtTexture OES");
        return textures[0];
    }

    private int genTexture(int width, int height) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        return textures[0];
    }

    private void DeInitEGL() {
        this.tryLockSurfaceDestoryLock();
        if (this.mUsedNewOutDecoder.get()) {
            if (this.mNewDecoderSurface != null) {
                this.mNewDecoderSurface.release();
                this.mNewDecoderSurface = null;
            }
            if (this.mNewDecoderSurfaceTexture != null) {
                this.mNewDecoderSurfaceTexture.release();
                this.mNewDecoderSurfaceTexture = null;
            }
            if (this.mNewDecoderTextureId > 0) {
                int[] textures = new int[]{this.mNewDecoderTextureId};
                GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
                this.mNewDecoderTextureId = -1;
            }
        }
        if (this.mSurfaceScaleInfo != null) {
            this.mSurfaceScaleInfo.videoView = null;
            this.mSurfaceScaleInfo.surface = null;
            this.mSurfaceScaleInfo = null;
        }
        this.releaseDecoderStaffs();
        if (this.mVideoScreen != null) {
            this.mVideoScreen.release(true);
            this.mVideoScreen = null;
        }
        if (this.mVRLibrary != null) {
            this.mVRLibrary.destroyLibrary();
        }
        if (this.mVideoWindowSurface != null) {
            this.mVideoWindowSurface.release();
            this.mVideoWindowSurface = null;
        }
        if (this.mEnvSurface != null) {
            this.mEglCore.makeNothingCurrent();
            this.mEglCore.releaseSurface(this.mEnvSurface);
            this.mEnvSurface = null;
        }
        this.tryUnlockSurfaceDestroyLock();
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mHandler = new RenderHandler(this);
            this.mIsDecoderNeedReconfig = true;
            this.mReady.set(true);
            this.InitEGL();
            YMFLog.info(this, "[Decoder ]", "HardDecodeWayGpu construct done GLThread");
            Object object = this.mStartLock;
            synchronized (object) {
                this.mStartLock.notifyAll();
            }
            Looper.loop();
            this.mReady.set(false);
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Decoder ]", "HardDecodeWayGpu end looper exception:" + t.getMessage() + " " + t.toString());
        }
        finally {
            YMFLog.info(this, "[Decoder ]", "HardDecodeWayGpu end GLThread");
            try {
                this.DeInitEGL();
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Decoder ]", "HardDecodeWayGpu DeInitEGL exception:" + t.getMessage());
            }
            Object t = this.mQuitLock;
            synchronized (t) {
                this.mQuitLock.notifyAll();
            }
        }
    }

    public void renderFrame() {
        ++this.vsyncCnt;
        long t1 = System.currentTimeMillis();
        if (t1 - this.vsyncT > 6000L) {
            this.vsyncT = t1;
            YMFLog.info(this, "[Decoder ]", "vsync count in 6 seconds " + this.vsyncCnt);
            this.vsyncCnt = 0L;
        }
        this.updateSurfaceTexture();
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        long drawStartTime = System.currentTimeMillis();
        surfaceTexture.updateTexImage();
        if (this.mFirstFrameOut) {
            if (this.mVideoSizes.mVideoWidth != this.mFrameWidth || this.mVideoSizes.mVideoHeight != this.mFrameHeight) {
                this.mVideoSizes.mVideoWidth = this.mFrameWidth;
                this.mVideoSizes.mVideoHeight = this.mFrameHeight;
                this.updateDisplayRegion();
                this.updateVideoSizeInfo();
            }
            this.renderFrame();
        }
        if (this.mVideoWindowSurface != null) {
            this.notifyVideoRender(surfaceTexture.getTimestamp() / 1000000L);
        }
        long renderTime = System.currentTimeMillis() - drawStartTime;
        VideoDataStatHelper.putRenderTime(renderTime);
    }

    private void updateVideoSizeInfo() {
        if (this.mVideoInfoCallback != null) {
            if (this.mYspVideoViewInfo != null && (this.mYspVideoViewInfo.width != this.mVideoSizes.mVideoWidth || this.mYspVideoViewInfo.height != this.mVideoSizes.mVideoHeight)) {
                this.mYspVideoViewInfo.width = this.mVideoSizes.mVideoWidth;
                this.mYspVideoViewInfo.height = this.mVideoSizes.mVideoHeight;
                this.mVideoInfoCallback.onUpdateVideoSizeChanged(this.mStreamId, this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight);
            }
            if (this.mYspVideoViewInfo.viewX != this.mVideoSizes.mViewX || this.mYspVideoViewInfo.viewY != this.mVideoSizes.mViewY) {
                this.mYspVideoViewInfo.viewX = this.mVideoSizes.mViewX;
                this.mYspVideoViewInfo.viewY = this.mVideoSizes.mViewY;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetScreenShot(ScreenShotInfo info) {
        try {
            info.isSuccess = false;
            info.width = this.mVideoSizes.mVideoWidth;
            info.height = this.mVideoSizes.mVideoHeight;
            info.pixelBuffer = ByteBuffer.allocateDirect(info.width * info.height * 4);
            int[] frameBuffers = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
            int offScreenTextureId = this.genTexture(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight);
            GLES20.glViewport((int)0, (int)0, (int)this.mVideoSizes.mVideoWidth, (int)this.mVideoSizes.mVideoHeight);
            GLES20.glBindFramebuffer((int)36160, (int)frameBuffers[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)offScreenTextureId, (int)0);
            float[] transform = new float[16];
            Matrix.rotateM((float[])transform, (int)0, (float[])this.mSrcTransform, (int)0, (float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.translateM((float[])transform, (int)0, (float)0.0f, (float)-1.0f, (float)0.0f);
            if (!this.mIsVrStream) {
                this.mVideoScreen.drawFrame(this.mDecoderTextureId, transform, -1);
            } else {
                this.mVRLibrary.drawFrame(this.mDecoderTextureId, this.mTransform, -1, -1, -1);
            }
            GLES20.glReadPixels((int)0, (int)0, (int)this.mVideoSizes.mVideoWidth, (int)this.mVideoSizes.mVideoHeight, (int)6408, (int)5121, (Buffer)info.pixelBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glDeleteFramebuffers((int)1, (int[])frameBuffers, (int)0);
            int[] textures = new int[]{offScreenTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            info.isSuccess = true;
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Decoder ]", "handleGetScreenShot exception:" + t.getMessage());
        }
        Object object = this.mScreenShotLock;
        synchronized (object) {
            this.mScreenShotLock.notifyAll();
        }
    }

    private void tryLockSurfaceDestoryLock() {
        if (this.mSurfaceDestoryedLock.getHoldCount() == 0) {
            this.mSurfaceDestoryedLock.lock();
        }
    }

    private void tryUnlockSurfaceDestroyLock() {
        try {
            while (this.mSurfaceDestoryedLock.getHoldCount() != 0) {
                this.mSurfaceDestoryedLock.unlock();
            }
        }
        catch (IllegalMonitorStateException e) {
            YMFLog.warn(this, "[Decoder ]", "tryUnlockSurfaceDestroyLock exception:" + e.toString());
        }
    }

    private void handleVideoSurfaceChanged(SurfaceScaleInfo sinfo) {
        this.tryLockSurfaceDestoryLock();
        YMFLog.info(this, "[Decoder ]", "handleVideoSurfaceChanged , streamId:" + this.mStreamId + " surface:" + sinfo.surface);
        if (this.mSurfaceDestoryedState.get()) {
            this.tryUnlockSurfaceDestroyLock();
            YMFLog.info(this, "[Decoder ]", "handleVideoSurfaceChanged mSurfaceDestoryedState:" + this.mSurfaceDestoryedState.get());
            return;
        }
        if (this.mVideoSurface != sinfo.surface) {
            if (this.mVideoWindowSurface != null) {
                this.mEglCore.makeCurrent(this.mEnvSurface);
                this.mVideoWindowSurface.release();
                this.mVideoWindowSurface = null;
            }
            try {
                if (sinfo.surface.isValid()) {
                    this.mVideoWindowSurface = new WindowSurface(this.mEglCore, sinfo.surface, false);
                    this.mVideoWindowSurface.makeCurrent();
                    this.mVideoSurface = sinfo.surface;
                } else {
                    YMFLog.error((Object)this, "[Decoder ]", "surface may be destroyed");
                }
            }
            catch (Throwable t) {
                this.tryUnlockSurfaceDestroyLock();
                YMFLog.error((Object)this, "[Decoder ]", "handleVideoSurfaceChanged exception:" + t.getMessage());
            }
        }
        this.tryUnlockSurfaceDestroyLock();
        this.mVideoSizes.mVideoSurfaceWidth = sinfo.width;
        this.mVideoSizes.mVideoSurfaceHeight = sinfo.height;
        this.mSurfaceScaleInfo = sinfo;
        if (this.mVRLibrary != null && this.mIsVrStream) {
            this.mVRLibrary.updateViewport(this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight);
        }
        this.updateDisplayRegion();
        if (this.mDecoderSurfaceTexture != null && this.mFirstFrameRendered) {
            this.handleOnVideoFrameAvailable(this.mDecoderSurfaceTexture, 0L);
        }
    }

    private void updateDisplayRegion() {
        VideoSizeUtils.Size si;
        if (this.mSurfaceScaleInfo == null) {
            return;
        }
        if (this.mSurfaceScaleInfo.orientationType == YSpVideoView.OrientationType.Force || this.mSurfaceScaleInfo.orientationType == YSpVideoView.OrientationType.Auto && this.mVideoSizes.mVideoWidth < this.mVideoSizes.mVideoHeight != this.mVideoSizes.mVideoSurfaceWidth < this.mVideoSizes.mVideoSurfaceHeight) {
            si = this.mSurfaceScaleInfo.rotateAngle != 0 && this.mSurfaceScaleInfo.rotateAngle != 180 ? VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight, this.mSurfaceScaleInfo.scaleMode) : VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight, this.mSurfaceScaleInfo.scaleMode);
            Matrix.translateM((float[])this.mTransform, (int)0, (float[])this.mSrcTransform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
            Matrix.rotateM((float[])this.mTransform, (int)0, (float)this.mSurfaceScaleInfo.rotateAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.translateM((float[])this.mTransform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        } else {
            si = VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight, this.mSurfaceScaleInfo.scaleMode);
        }
        this.mVideoSizes.mViewX = si.x;
        this.mVideoSizes.mViewY = si.y;
        this.mVideoSizes.mViewWidth = si.width;
        this.mVideoSizes.mViewHeight = si.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVideoSurfaceDestroyed(Surface surface) {
        this.tryLockSurfaceDestoryLock();
        YMFLog.info(this, "[Decoder ]", "handleVideoSurfaceDestroyed , streamId:" + this.mStreamId + " surface:" + surface);
        if (this.mVideoWindowSurface != null) {
            this.mVideoWindowSurface.checkCurrentEgl();
            this.mEglCore.makeCurrent(this.mEnvSurface);
            this.mVideoWindowSurface.release();
            this.mVideoWindowSurface = null;
        }
        this.mVideoSurface = null;
        if (this.mSurfaceScaleInfo != null) {
            this.mSurfaceScaleInfo.videoView = null;
            this.mSurfaceScaleInfo.surface = null;
        }
        this.tryUnlockSurfaceDestroyLock();
        Object object = this.mSurfaceDestroyLock;
        synchronized (object) {
            this.mSurfaceDestroyLock.notifyAll();
        }
    }

    private void handleVideoSurfaceCreated() {
        this.mSurfaceDestoryedState.set(false);
    }

    private void handleVideoSurfaceRedraw() {
        if (this.mDecoderSurfaceTexture != null && this.mFirstFrameRendered) {
            this.handleOnVideoFrameAvailable(this.mDecoderSurfaceTexture, 0L);
        }
    }

    private void onVideoRenderNotify(long userGroupId, long streamId, long pts, long renderTimeStamp, long decodeStamp) {
        if (this.mVideoRenderNotifys == null) {
            return;
        }
        this.mVideoRenderNotifys.add(new VideoRenderNotify(userGroupId, streamId, pts, renderTimeStamp, decodeStamp));
        Iterator<VideoRenderNotify> it = this.mVideoRenderNotifys.iterator();
        if (!it.hasNext()) {
            return;
        }
        long firstPts = it.next().mPts;
        if (pts - firstPts < 500L && this.mVideoRenderNotifys.size() < 15 && this.mFirstFrameDecodered) {
            return;
        }
        if (!this.mFirstFrameDecodered) {
            YMFLog.info(this, "[Decoder ]", "first frame finish decode");
            this.mFirstFrameDecodered = true;
        }
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
    }

    private void handleOnVideoFrameAvailable(SurfaceTexture surfaceTexture, long pts) {
        this.tryLockSurfaceDestoryLock();
        long currentTs = System.currentTimeMillis();
        if (this.mSmoothnessCounter.RenderOneFrame(this.mStreamId, currentTs)) {
            double coef = this.mSmoothnessCounter.ComputeCoefficientOfVariationAndReset();
            YYVideoLibMgr.instance().onCoefficientOfVariationOfRenderInterval(this.mUserGroupId, this.mStreamId, this.mSmoothnessCounter.GetIntervalMilliTs(), coef);
        }
        if (!this.mFirstFrameRendered) {
            YMFLog.info(this, "[Decoder ]", "handleOnVideoFrameAvailable notify first frame out, frames:" + this.mFrames);
            YYVideoLibMgr.instance().onFirstFrameRenderNotify(this.mUserGroupId, this.mStreamId, currentTs, currentTs - this.mFirstFrameTs, this.mFrames);
        }
        if (surfaceTexture == this.mDecoderSurfaceTexture && this.mVideoWindowSurface != null) {
            StateMonitor.NotifyPts(this.mStreamId, pts);
            try {
                if (this.mPlayNotify != null) {
                    this.mPlayNotify.DrawNotify();
                }
                if (!this.mFirstFrameSeeFlag) {
                    YYVideoLibMgr.instance().onFirstFrameSeeNotify(this.mUserGroupId, this.mStreamId, System.currentTimeMillis() - this.mFirstFrameTs);
                    this.mFirstFrameSeeFlag = true;
                }
                if (this.mUsedNewOutDecoder.get()) {
                    YMFLog.info(this, "[Decoder ]", "handleOnVideoFrameAvailable real render:" + pts);
                }
                this.mDecoderSurfaceTexture.getTransformMatrix(this.mTmpTransform);
                if (!Arrays.equals(this.mSrcTransform, this.mTmpTransform)) {
                    System.arraycopy(this.mTmpTransform, 0, this.mSrcTransform, 0, 16);
                    System.arraycopy(this.mSrcTransform, 0, this.mTransform, 0, 16);
                    this.updateDisplayRegion();
                }
                if (!this.mSurfaceDestoryedState.get()) {
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlUtil.checkGlErrorNoException("glClearColor");
                    GLES20.glClear((int)16640);
                    GlUtil.checkGlErrorNoException("glClear");
                    GLES20.glViewport((int)this.mVideoSizes.mViewX, (int)this.mVideoSizes.mViewY, (int)this.mVideoSizes.mViewWidth, (int)this.mVideoSizes.mViewHeight);
                    GlUtil.checkGlErrorNoException("glViewport");
                    if (!this.mIsVrStream) {
                        this.mVideoScreen.drawFrame(this.mDecoderTextureId, this.mTransform, -1);
                    } else {
                        this.mVRLibrary.drawFrame(this.mDecoderTextureId, this.mTransform, -1, -1, -1);
                    }
                    this.mVideoWindowSurface.swapBuffers();
                    if (this.mVideoInfoCallback != null) {
                        this.mYspVideoViewInfo.pts = pts;
                        this.mVideoInfoCallback.onUpdatePts(this.mStreamId, pts);
                    }
                }
                if (!this.mFirstFrameRendered) {
                    StateMonitor.instance();
                    StateMonitor.NotifyFirstFrameRendered(this.mStreamId, TimeUtil.getTickCount());
                    ViewLiveStatManager.getInstace().notifyEventTime(3, 0, this.mFrames);
                    YMFLog.info(this, "[Decoder ]", "handleOnVideoFrameAvailable first frame render cost time:" + (System.currentTimeMillis() - currentTs));
                }
                ++this.mRenderCnt;
                this.mCurTime = TimeUtil.getTickCountLong();
                if (this.mLastTime == 0L) {
                    this.mLastTime = this.mCurTime;
                }
                if (this.mCurTime - this.mLastTime >= 1000L) {
                    StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId, this.mRenderCnt);
                    this.mLastTime = this.mCurTime;
                    this.mRenderCnt = 0;
                }
            }
            catch (Throwable t) {
                this.tryUnlockSurfaceDestroyLock();
                YMFLog.error((Object)this, "[Decoder ]", "handleOnVideoFrameAvailable exception:" + t.getMessage());
                this.handleVideoSurfaceDestroyed(null);
            }
        } else if (!this.mFirstFrameRendered) {
            YMFLog.info(this, "[Decoder ]", "handleOnVideoFrameAvailable Frame Loss, eaten frames:" + this.mFrames);
        }
        this.mFirstFrameRendered = true;
        this.tryUnlockSurfaceDestroyLock();
    }

    private void handleVideoConfig(VideoHeaderInfo vhi) {
        YMFLog.info(this, "[Decoder ]", "handleVideoConfig width:" + vhi.width + ", height:" + vhi.height + ", mine:" + vhi.mime + ", streamId:" + this.mStreamId);
        ViewLiveStatManager.getInstace().notifyEventTime(1, 0, new ViewLiveStatManager.StatVideoHeaderInfo(vhi.width, vhi.height));
        this.mFrameWidth = vhi.width;
        this.mFrameHeight = vhi.height;
        this.mFirstFrameTs = System.currentTimeMillis();
        this.mFrames = 0;
        this.mFirstFrameDecodered = false;
        this.mSmoothnessCounter.ResetToInitialState();
    }

    private void releaseDecoderStaffs() {
        if (this.mDecoderSurface != null) {
            this.mDecoderSurface.release();
            this.mDecoderSurface = null;
        }
        if (this.mDecoderSurfaceTexture != null) {
            this.mDecoderSurfaceTexture.release();
            this.mDecoderSurfaceTexture = null;
        }
        if (this.mDecoderTextureId > 0) {
            int[] textures = new int[]{this.mDecoderTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mDecoderTextureId = -1;
        }
        YMFLog.info(this, "[Decoder ]", "releaseDecoderStaffs...");
    }

    private void handleEndofStream() {
        YMFLog.info(this, "[Decoder ]", "handleEndofStream...");
        this.mFirstFrameRendered = false;
        this.mFirstFrameDecodered = false;
    }

    private void updateSurfaceTexture() {
        this.decodeAnalysis();
        this.handleOnVideoFrameAvailable(this.mDecoderSurfaceTexture, this.mDecoderSurfaceTexture.getTimestamp() / 1000000L);
        ViewLiveStatManager.getInstace().reportFrameEvent(1);
    }

    private void notifyVideoRender(long pts) {
        try {
            if (pts != 0L && pts != this.mTempPts && this.mVideoWindowSurface != null && this.mDecoderTimeStampMap.get(pts) != null) {
                this.mTempPts = pts;
                Iterator<Map.Entry<Long, Long>> it = this.mDecoderTimeStampMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Long, Long> entry = it.next();
                    if (entry.getKey() == pts) {
                        this.onVideoRenderNotify(this.mUserGroupId, this.mStreamId, pts, TimeUtil.getTickCountLong(), entry.getValue());
                        it.remove();
                        continue;
                    }
                    if (entry.getKey() >= pts) continue;
                    it.remove();
                }
            } else if (this.mOuterOutPts.get() != this.mTempPts && this.mOuterOutPts.get() != 0L) {
                this.onVideoRenderNotify(this.mUserGroupId, this.mStreamId, this.mOuterOutPts.get(), TimeUtil.getTickCountLong(), this.mLastDecodedTimeStampTime);
                this.mTempPts = this.mOuterOutPts.get();
                this.mDecoderTimeStampMap.remove(this.mOuterOutPts.get());
            }
        }
        catch (Exception e) {
            YMFLog.info(this, "[Decoder ]", "notifyVideoRender exception:" + e.toString());
        }
    }

    private void decodeAnalysis() {
        if (this.mBasicVsync == 0L) {
            this.mPreVsync = this.mBasicVsync = System.currentTimeMillis();
            this.mPreFramePts = this.mDecoderSurfaceTexture.getTimestamp() / 1000000L;
            this.mSum = 0L;
            this.mFrameCnt = 0;
        } else {
            this.mVsyncTime = System.currentTimeMillis();
            if (this.mVsyncTime - this.mBasicVsync >= 6000L) {
                this.mBasicVsync = 0L;
            }
            this.mVsyncTimeDiff = this.mVsyncTime - this.mPreVsync;
            this.mFramePtsDiff = this.mDecoderSurfaceTexture.getTimestamp() / 1000000L - this.mPreFramePts;
            this.mDiff = Math.abs(this.mVsyncTimeDiff - this.mFramePtsDiff);
            if (this.mDiff > 300L) {
                YMFLog.info(this, "[Decoder ]", "Vsync or pts exception,Vsync diff:" + this.mVsyncTimeDiff + " Frame diff:" + this.mFramePtsDiff + " Diff:" + this.mDiff);
            } else {
                this.mSum += this.mDiff;
                ++this.mFrameCnt;
                if ((double)this.mSum * 1.0 / (double)this.mFrameCnt > 150.0) {
                    YMFLog.info(this, "[Decoder ]", "Vsync or pts exception,diff:" + this.mDiff);
                }
            }
            this.mPreVsync = this.mVsyncTime;
            this.mPreFramePts = this.mDecoderSurfaceTexture.getTimestamp() / 1000000L;
        }
    }

    public void handleSetVideoInfoCallback(IVideoInfoCallback callback) {
        YMFLog.info(this, "[Decoder ]", " handleSetVideoInfoCallback");
        this.mVideoInfoCallback = callback;
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        if (streamid != this.mStreamId) {
            YMFLog.error((Object)this, "[Decoder ]", "getVideoViewInfo error, mStreamId:" + this.mStreamId + ", streamid:" + streamid);
        }
        return this.mYspVideoViewInfo;
    }

    private void destoryGLEnv() {
        if (this.mNewDecoderSurface != null) {
            this.mNewDecoderSurface.release();
            this.mNewDecoderSurface = null;
        }
        if (this.mNewDecoderSurfaceTexture != null) {
            this.mNewDecoderSurfaceTexture.release();
            this.mNewDecoderSurfaceTexture = null;
        }
        if (this.mNewDecoderTextureId > 0) {
            int[] textures = new int[]{this.mNewDecoderTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mNewDecoderTextureId = -1;
        }
        YMFLog.info(this, "[Decoder ]", "destoryGLEnv...");
    }

    private void destoryAsyncEnv() {
        if (this.mNewDecoderTextureId != -1) {
            final CountDownLatch syncFlag = new CountDownLatch(1);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    HardDecodeWayGpu.this.destoryGLEnv();
                    syncFlag.countDown();
                }
            });
            try {
                syncFlag.await();
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Decoder ]", "[destoryAsyncEnv syncFlag.await exception:" + e.toString());
            }
        }
        if (this.mNewOutDecoder != null) {
            this.mNewOutDecoder.release();
            this.mNewOutDecoder = null;
        }
        YMFLog.error((Object)this, "[Decoder ]", "destoryAsyncEnv end");
    }

    private void createDecoderAsync(byte[] header, int width, int height, String mime) {
        long beginTime = System.currentTimeMillis();
        if (this.mNewDecoderTextureId == -1) {
            final CountDownLatch syncFlag = new CountDownLatch(1);
            if (this.mHandler.getLooper().getThread().equals(Thread.currentThread()) || this.mHandler.getLooper().getThread().equals(this.mAsyncHandlerThread.getLooper().getThread())) {
                YMFLog.error((Object)this, "[Decoder ]", "createDecoderAsync thread same");
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    HardDecodeWayGpu.this.mNewDecoderTextureId = HardDecodeWayGpu.this.genExtTexture();
                    HardDecodeWayGpu.this.mNewDecoderSurfaceTexture = new SurfaceTexture(HardDecodeWayGpu.this.mNewDecoderTextureId);
                    HardDecodeWayGpu.this.mNewDecoderSurface = new Surface(HardDecodeWayGpu.this.mNewDecoderSurfaceTexture);
                    if (HardDecodeWayGpu.this.mNewDecoderSurface.isValid()) {
                        YMFLog.info(this, "[Decoder ]", "createDecoderAsync create new surface");
                    }
                    syncFlag.countDown();
                }
            });
            try {
                syncFlag.await();
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Decoder ]", "createDecoderAsync syncFlag.await exception:" + e.toString());
            }
        }
        if (this.mNewOutDecoder == null) {
            if ("video/hevc".equals(mime)) {
                this.mNewOutDecoder = new H265DecRender(this.mNewDecoderSurface, width, height, this.mUserGroupId, this.mStreamId);
                StateMonitor.NotifyCreateRender(this.mStreamId, 1);
            } else if ("video/avc".equals(mime)) {
                this.mNewOutDecoder = new H264DecRender(this.mNewDecoderSurface, width, height, this.mUserGroupId, this.mStreamId);
                StateMonitor.NotifyCreateRender(this.mStreamId, 0);
            } else if ("video/x-vnd.on2.vp8".equals(mime)) {
                this.mNewOutDecoder = new VP8DecRender(this.mNewDecoderSurface, width, height);
            }
            this.mNewOutDecoder.setStreamId(this.mStreamId);
            this.mNewOutDecoder.setDecoderDataOutCallBack(this);
        } else {
            this.mNewOutDecoder.reset(this.mNewDecoderSurface, width, height);
        }
        this.mRecIFrame = false;
        this.mVideoDataCnt = 0L;
        this.mIsDecoderNeedReconfig = false;
        this.mNewOutDecoder.PushFrame(this.mNewDecoderSurface, header, 0L, true);
        this.mNewOutDecoder.ConfigDone();
        if (this.mNewOutDecoder.GetAndClearExceptionFlag()) {
            YMFLog.error((Object)this, "[Decoder ]", "createDecoderAsync mNewOutDecoder exception");
            this.mIsDecoderNeedReconfig = true;
            this.mNewOutDecoder.EndofStream();
        }
        this.mNewWidth = width;
        this.mNewHeight = height;
        this.mNewDecodedOutFirstFrame = false;
        YMFLog.info(this, "[Decoder ]", "createDecoderAsync: width:" + width + ", height:" + height + ", mine:" + mime + ", streamId:" + this.mStreamId + " cost Time:" + (System.currentTimeMillis() - beginTime));
    }

    private void decodeFrameAsync() {
        if (this.mDecodingQueue.size() == 0) {
            YMFLog.error((Object)this, "[Decoder ]", "someThing wrong ,the mDecodingQueue.size == 0! ");
            return;
        }
        VideoEntities.VideoData vd = this.mDecodingQueue.peek();
        if (vd != null) {
            if (this.mIsDecoderNeedReconfig) {
                YMFLog.warn(this, "[Decoder ]", "decodeFrameAsync mIsDecoderNeedReconfig true streamId:" + this.mStreamId + ", pts:" + vd.pts);
                return;
            }
            if (this.mFrames <= 0) {
                ViewLiveStatManager.getInstace().notifyEventTime(2, 0);
            }
            ViewLiveStatManager.getInstace().reportFrameEvent(0);
            ++this.mFrames;
            if (this.mNewOutDecoder != null) {
                if (!(this.mFirstFrameOut && this.mRecIFrame || this.mFrames > 50)) {
                    int type = 0;
                    if (!(this.mOuterDecoder instanceof VP8DecRender)) {
                        type = vd.data == null ? 255 : (vd.data[0] == 0 && vd.data[1] == 0 && vd.data[2] == 1 ? vd.data[3] & 0x1F : (vd.data[0] == 0 && vd.data[1] == 0 && vd.data[2] == 0 && vd.data[3] == 1 ? vd.data[4] & 0x1F : -1));
                    }
                    if (type == 5) {
                        this.mRecIFrame = true;
                    }
                    YMFLog.info(this, "[Decoder ]", "handleOuterVideoData streamId:" + this.mStreamId + ", frames:" + this.mFrames + ", type:" + type + ", len:" + (vd.data == null ? 0 : vd.data.length) + ", pts:" + vd.pts);
                }
                this.mOuterOutPts.set(this.mNewOutDecoder.PushFrame(this.mNewDecoderSurface, vd.data, vd.pts, false));
                this.mDecodingQueue.poll();
                if (this.mOuterOutPts.get() <= 0L) {
                    if (this.mNewOutDecoder.GetAndClearExceptionFlag()) {
                        YMFLog.warn(this, "[Decoder ]", "decodeFrameAsync decoder exception! Need to recconfig!");
                        this.mIsDecoderNeedReconfig = true;
                        this.mNewOutDecoder.EndofStream();
                    }
                } else {
                    if (this.mDecoderTimeStampMap.size() <= 100) {
                        this.mDecoderTimeStampMap.put(this.mOuterOutPts.get(), TimeUtil.getTickCountLong());
                    } else {
                        YMFLog.info(this, "[Decoder ]", "decodeFrameAsync mDecoderTimeStampMap full ");
                        this.mDecoderTimeStampMap.clear();
                    }
                    if (!this.mFirstFrameOut) {
                        StateMonitor.instance().NotifyDecodeDelayFrameCountInfo(this.mStreamId, this.mFrames);
                        YMFLog.info(this, "[Decoder ]", "decodeFrameAsync first frame out, frames:" + this.mFrames);
                    }
                    this.mLastDecodedTimeStampTime = TimeUtil.getTickCountLong();
                    ++this.mDecodeCnt;
                    this.mCurTime1 = TimeUtil.getTickCountLong();
                    if (this.mLastTime1 == 0L) {
                        this.mLastTime1 = this.mCurTime1;
                    }
                    if (this.mCurTime1 - this.mLastTime1 >= 1000L) {
                        StateMonitor.NotifyDecoderFrameRateOUT(this.mStreamId, this.mDecodeCnt);
                        this.mLastTime1 = this.mCurTime1;
                        this.mDecodeCnt = 0;
                    }
                }
            }
        }
    }

    private void handleGetCacheFrame() {
        if (this.mOuterDecoder != null) {
            this.mOuterOutPts.set(this.mOuterDecoder.getCacheFrame());
            if (this.mOuterOutPts.get() <= 0L) {
                if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
                    YMFLog.warn(this, "[Decoder ]", "handleGetCacheFrame decoder exception! error error!");
                    this.mIsDecoderNeedReconfig = true;
                    this.mOuterDecoder.EndofStream();
                }
            } else {
                if (this.mDecoderTimeStampMap.size() <= 100) {
                    this.mDecoderTimeStampMap.put(this.mOuterOutPts.get(), TimeUtil.getTickCountLong());
                } else {
                    YMFLog.info(this, "[Decoder ]", "handleGetCacheFrame mDecoderTimeStampMap full ");
                    this.mDecoderTimeStampMap.clear();
                }
                this.mLastDecodedTimeStampTime = TimeUtil.getTickCountLong();
                ++this.mDecodeCnt;
                this.mCurTime1 = TimeUtil.getTickCountLong();
                if (this.mLastTime1 == 0L) {
                    this.mLastTime1 = this.mCurTime1;
                }
                if (this.mCurTime1 - this.mLastTime1 >= 1000L) {
                    StateMonitor.NotifyDecoderFrameRateOUT(this.mStreamId, this.mDecodeCnt);
                    this.mLastTime1 = this.mCurTime1;
                    this.mDecodeCnt = 0;
                }
            }
        }
    }

    @Override
    public void onFirstDecodedDataOut() {
        YMFLog.info(this, "[Decoder ]", "newOuterDecoder onFirstDecodedDataOut");
        this.changeGlEnv();
        this.mNewDecodedOutFirstFrame = true;
    }

    private void changeToNewDecoder() {
        long beginTime = System.currentTimeMillis();
        YMFLog.info(this, "[Decoder ]", "changeToNewDecoder mDecodingQueue.size:" + this.mDecodingQueue.size());
        int i = 0;
        final CountDownLatch syncFlag = new CountDownLatch(1);
        this.mAsyncHandler.post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Decoder ]", "changeToNewDecoder mAsyncHandler idle size:" + HardDecodeWayGpu.this.mDecodingQueue.size());
                syncFlag.countDown();
            }
        });
        try {
            syncFlag.await();
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Decoder ]", "onFirstDecodedDataOut syncFlag.await exception:" + e.toString());
            return;
        }
        while (this.mDecodingQueue.size() != 0) {
            try {
                Thread.sleep(5L);
                if (i++ % 30 != 0) continue;
                YMFLog.error((Object)this, "[Decoder ]", "changeToNewDecoder sleep 150ms -> " + this.mDecodingQueue.size());
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Decoder ]", "changeToNewDecoder sleep exception:" + e.toString());
            }
        }
        final HardDecRender oldDecoder = this.mOuterDecoder;
        this.mNewOutDecoder.setDecoderDataOutCallBack(null);
        this.mOuterDecoder = this.mNewOutDecoder;
        this.mNewOutDecoder = null;
        this.mAsyncHandler.post(new Runnable(){

            @Override
            public void run() {
                oldDecoder.release();
            }
        });
        this.mUsedNewOutDecoder.set(false);
        YMFLog.info(this, "[Decoder ]", "changeToNewDecoder end mDecodingQueue.size:" + this.mDecodingQueue.size() + " cost:" + (System.currentTimeMillis() - beginTime));
    }

    private void changeGlEnv() {
        YMFLog.info(this, "[Decoder ]", "changeGlEnv begin");
        if (this.mDecoderSurfaceTexture != null) {
            final CountDownLatch syncFlag = new CountDownLatch(1);
            final HardDecodeWayGpu parent = this;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        HardDecodeWayGpu.this.tryLockSurfaceDestoryLock();
                        HardDecodeWayGpu.this.mDecoderSurfaceTexture.setOnFrameAvailableListener(null);
                        HardDecodeWayGpu.this.mNewDecoderSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)parent);
                        HardDecodeWayGpu.this.releaseDecoderStaffs();
                        HardDecodeWayGpu.this.mDecoderSurfaceTexture = HardDecodeWayGpu.this.mNewDecoderSurfaceTexture;
                        HardDecodeWayGpu.this.mDecoderSurface = HardDecodeWayGpu.this.mNewDecoderSurface;
                        HardDecodeWayGpu.this.mDecoderTextureId = HardDecodeWayGpu.this.mNewDecoderTextureId;
                        HardDecodeWayGpu.this.mNewDecoderSurface = null;
                        HardDecodeWayGpu.this.mNewDecoderSurfaceTexture = null;
                        HardDecodeWayGpu.this.mNewDecoderTextureId = -1;
                        HardDecodeWayGpu.this.mFrameWidth = HardDecodeWayGpu.this.mNewWidth;
                        HardDecodeWayGpu.this.mFrameHeight = HardDecodeWayGpu.this.mNewHeight;
                        HardDecodeWayGpu.this.tryUnlockSurfaceDestroyLock();
                        syncFlag.countDown();
                    }
                    catch (Exception e) {
                        YMFLog.error((Object)this, "[Decoder ]", "changeGlEnv exception:" + e.toString());
                    }
                }
            });
            try {
                syncFlag.await();
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Decoder ]", "onFirstDecodedDataOut syncFlag.await exception:" + e.toString());
                return;
            }
        }
        YMFLog.info(this, "[Decoder ]", "changeGlEnv end");
    }

    private static class RenderHandler
    extends Handler {
        private WeakReference<HardDecodeWayGpu> mWeakWay;

        public RenderHandler(HardDecodeWayGpu hardDecodeWay) {
            this.mWeakWay = new WeakReference<HardDecodeWayGpu>(hardDecodeWay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            int what = msg.what;
            if (8 == what) {
                Looper loop = Looper.myLooper();
                if (null == loop) return;
                loop.quit();
                return;
            }
            HardDecodeWayGpu hardDecodeWay = (HardDecodeWayGpu)this.mWeakWay.get();
            if (hardDecodeWay == null) {
                YMFLog.warn((Object)this, "[Decoder ]", "handleMessage: hardDecodeWay is null");
                return;
            }
            try {
                switch (what) {
                    case 1: {
                        hardDecodeWay.handleVideoSurfaceChanged((SurfaceScaleInfo)msg.obj);
                        return;
                    }
                    case 2: {
                        hardDecodeWay.handleVideoSurfaceDestroyed((Surface)msg.obj);
                        return;
                    }
                    case 3: {
                        hardDecodeWay.handleVideoSurfaceRedraw();
                        return;
                    }
                    case 5: {
                        hardDecodeWay.handleVideoConfig((VideoHeaderInfo)msg.obj);
                        return;
                    }
                    case 4: {
                        hardDecodeWay.handleGetScreenShot((ScreenShotInfo)msg.obj);
                        return;
                    }
                    case 7: {
                        hardDecodeWay.handleEndofStream();
                        return;
                    }
                    case 10: {
                        hardDecodeWay.handleVideoSurfaceCreated();
                        return;
                    }
                    case 11: {
                        hardDecodeWay.handleSetVideoInfoCallback((IVideoInfoCallback)msg.obj);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Decoder ]", "handleMessage exception:" + YMFLog.stackTraceOf(e));
                return;
            }
            finally {
                hardDecodeWay.tryUnlockSurfaceDestroyLock();
            }
        }
    }

    private static class SurfaceScaleInfo {
        public View videoView;
        public Surface surface;
        public int width = 64;
        public int height = 64;
        public int parentWidth = 64;
        public int parentHeight = 64;
        public int rotateAngle = 0;
        public YSpVideoView.OrientationType orientationType = YSpVideoView.OrientationType.Normal;
        public VideoConstant.ScaleMode scaleMode = VideoConstant.ScaleMode.AspectFit;

        private SurfaceScaleInfo() {
        }
    }

    private static class ScreenShotInfo {
        public boolean isSuccess;
        public Buffer pixelBuffer;
        public int width;
        public int height;

        private ScreenShotInfo() {
        }
    }

    private static class VideoHeaderInfo {
        public int width;
        public int height;
        public byte[] header;
        public String mime;

        private VideoHeaderInfo() {
        }
    }
}

