/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.graphics.Bitmap;
import android.media.MediaFormat;
import android.view.Surface;
import android.view.View;
import com.yy.videoplayer.IYMFDecoderListener;
import com.yy.videoplayer.YMFStreamManager;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.HardDecRender;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VP8DecRender;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.opengles.YMFImageBuffer;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.stat.YMFPlayerUsrBehaviorStat;
import com.yy.videoplayer.utils.ByteVector;
import com.yy.videoplayer.utils.ImageUtil;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class HardDecodeWayBuffer
implements Runnable,
HardDecodeWay,
HardDecRender.IDecoderDataOutCallBack,
HardDecRender.OnDecoderYUVListener {
    private static final String TAG = "HardDecodeWayBuffer";
    private boolean mIsDecoderNeedReconfig = false;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private HardDecRender mOuterDecoder = null;
    private long mUserGroupId = 0L;
    private long mStreamId = 0L;
    private boolean mFirstFrameOut = false;
    private boolean mFirstFrameRenderSdk = false;
    private boolean mFirstFrameRenderLibMgr = false;
    private boolean mYUVDecodeMode = false;
    private boolean mOnlyDecode = false;
    private int mFrames = 0;
    private int renderType = 0;
    private long mVideoDataCnt = 0L;
    private boolean mRecIFrame = false;
    private long mCurTime = 0L;
    private long mLastTime = 0L;
    private int mDecodeCnt = 0;
    private static final int VIDEO_DATA_LOG = 500;
    public ByteVector mBytesVector = null;
    public ByteVector mTmpBytesVector = null;
    private YMFImageBuffer mImage = null;
    private IYMFDecoderListener mDecoderListener;
    private boolean isFirstOnVideoConfig = false;
    private boolean mFirstDecodedFrame = false;

    @Override
    public void Start() {
    }

    @Override
    public void OnSurfaceCreated() {
    }

    @Override
    public void OnSurfaceChanged(View videoView, Surface surface, int surfaceWidth, int surfaceHeight, int parentWidth, int parentHeight, int rotateAngle, YSpVideoView.OrientationType orientationType, VideoConstant.ScaleMode scaleMode) {
    }

    @Override
    public void OnSurfaceDestroyed(Surface surface) {
    }

    @Override
    public void OnSurfaceRedraw() {
    }

    @Override
    public boolean IsDecoderNeedReconfig() {
        return this.mIsDecoderNeedReconfig;
    }

    @Override
    public void SetPlayNotify(PlayNotify playNotify) {
    }

    @Override
    public void SetVideoIds(long userGroupId, long streamId) {
        YMFLog.info(this, "[Decoder ]", "SetVideoIds userGroupId:" + userGroupId + ", streamId:" + streamId);
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
    }

    @Override
    public void OnStreamEnd() {
    }

    @Override
    public Bitmap GetScreenShot() {
        return null;
    }

    public void setDecoderListener(IYMFDecoderListener listener) {
        this.mDecoderListener = listener;
    }

    private void notifyHardwareDecoderFrameRate() {
        ++this.mDecodeCnt;
        this.mCurTime = TimeUtil.getTickCountLong();
        if (this.mLastTime == 0L) {
            this.mLastTime = this.mCurTime;
        }
        if (this.mCurTime - this.mLastTime >= 1000L) {
            StateMonitor.NotifyDecoderFrameRateOUT(this.mStreamId, this.mDecodeCnt);
            this.mLastTime = this.mCurTime;
            this.mDecodeCnt = 0;
        }
    }

    private void sendFrameToView(int width, int height, ByteBuffer data, long pts, int colorFormat, MediaFormat mediaFormat) {
        if (this.mYUVDecodeMode && this.mDecoderListener != null) {
            this.notifyHardwareDecoderFrameRate();
            int format = 2;
            switch (colorFormat) {
                case 19: {
                    break;
                }
                case 21: {
                    format = 1;
                    break;
                }
                default: {
                    YMFLog.error((Object)this, "[Decoder ]", "unsupported colorFormat:" + colorFormat);
                }
            }
            if (this.mImage == null || this.mImage.mWidth != width || this.mImage.mHeight != height) {
                if (this.mImage != null) {
                    this.mImage.mData = null;
                    this.mImage = null;
                }
                this.mImage = new YMFImageBuffer(width, height, format, false);
            }
            int cropRight = 0;
            if (mediaFormat != null && mediaFormat.containsKey("crop-right")) {
                cropRight = mediaFormat.getInteger("crop-right");
            }
            this.mImage.assign(data, width, height, format, pts, TimeUtil.getTickCountLong(), true, this.mStreamId, cropRight);
            this.mDecoderListener.onDecodedFrameAvailable(this.mStreamId, this.mImage);
        }
    }

    @Override
    public void OnDecoderYUVListener(int width, int height, ByteBuffer data, int bufferLen, long pts, int frameFlag, int colorFormat, MediaFormat mediaFormat) {
        int cropRight = 0;
        int stride = width;
        if (mediaFormat != null && mediaFormat.containsKey("crop-right")) {
            cropRight = mediaFormat.getInteger("crop-right");
            stride = mediaFormat.getInteger("stride");
        }
        if (!this.mFirstDecodedFrame) {
            YYVideoLibMgr.instance().onFirstDecodedFrame(this.mStreamId, pts, TimeUtil.getTickCountLong());
            this.mFirstDecodedFrame = true;
        }
        if (this.mYUVDecodeMode) {
            this.sendFrameToView(stride != 0 ? stride : width, height, data, pts, colorFormat, mediaFormat);
        }
        if (!this.mOnlyDecode) {
            return;
        }
        if (this.mBytesVector == null) {
            this.mBytesVector = new ByteVector(bufferLen);
        }
        this.mBytesVector.reserve(bufferLen);
        if (colorFormat == 21) {
            if (this.mTmpBytesVector == null) {
                this.mTmpBytesVector = new ByteVector(bufferLen);
            }
            this.mTmpBytesVector.reserve(bufferLen);
            data.rewind();
            data.get(this.mTmpBytesVector.getBytes(), 0, bufferLen);
            if (stride != width) {
                ImageUtil.NV12ToYUV420WithStride(this.mTmpBytesVector.getBytes(), this.mBytesVector.getBytes(), width, height, stride);
            } else {
                ImageUtil.NV12ToYUV420(this.mTmpBytesVector.getBytes(), this.mBytesVector.getBytes(), width, height);
            }
        } else if (stride != width) {
            if (this.mTmpBytesVector == null) {
                this.mTmpBytesVector = new ByteVector(bufferLen);
            }
            this.mTmpBytesVector.reserve(bufferLen);
            data.rewind();
            data.get(this.mTmpBytesVector.getBytes(), 0, bufferLen);
            ImageUtil.NV12ToYUV420WithStride(this.mTmpBytesVector.getBytes(), this.mBytesVector.getBytes(), width, height, stride);
        } else {
            data.rewind();
            data.get(this.mBytesVector.getBytes(), 0, bufferLen);
        }
        long timeStart = System.currentTimeMillis();
        YYVideoLibMgr.instance().onDecodedFrameData(this.mStreamId >> 32, width, height, this.mBytesVector.getBytes(), (int)((double)(width * height) * 1.5), pts);
        VideoDataStatHelper.putVideoLibMgrRenderTime(System.currentTimeMillis() - timeStart);
        if (!this.mFirstFrameRenderLibMgr) {
            this.mFirstFrameRenderLibMgr = true;
            YMFPlayerUsrBehaviorStat.getInstance().notifyFirstFrameRendered(0);
        }
    }

    private String bin2hex(byte[] data) {
        String hex = null;
        int len = data == null ? 0 : data.length;
        for (int i = 0; i < len; ++i) {
            hex = hex != null ? hex + String.format("%02x ", data[i]) : String.format("%02x ", data[i]);
        }
        return hex;
    }

    @Override
    public void OnCreateRenderAhead(int width, int height, String mime) {
        YMFLog.info(this, "[Decoder]", "HardDecodeWayBuffer OnCreateRenderAhead width:" + width + " ,height:" + height + " ,mime:" + mime + " ,streamId:" + this.mStreamId);
        if (this.mOuterDecoder == null && width != 0 && height != 0) {
            if ("video/hevc".equals(mime)) {
                this.mOuterDecoder = new H265DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                StateMonitor.NotifyCreateRender(this.mStreamId, 1);
            } else if ("video/avc".equals(mime)) {
                this.mOuterDecoder = new H264DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                StateMonitor.NotifyCreateRender(this.mStreamId, 0);
            } else if ("video/x-vnd.on2.vp8".equals(mime)) {
                this.mOuterDecoder = new VP8DecRender(null, width, height);
            }
            this.mOuterDecoder.setStreamId(this.mStreamId);
            this.mOuterDecoder.setOnDecoderYUVListener(this);
        }
        this.isFirstOnVideoConfig = true;
    }

    @Override
    public void OnVideoConfig(byte[] header, int width, int height, String mime) {
        YMFLog.info(this, "[Decoder ]", "OnVideoConfig width:" + width + " height:" + height + " mime:" + mime + " streamId:" + this.mStreamId + " data:" + this.bin2hex(header) + " isFirstOnVideoConfig:" + this.isFirstOnVideoConfig);
        if (this.isFirstOnVideoConfig || this.mOuterDecoder == null) {
            if (this.mOuterDecoder == null) {
                if ("video/hevc".equals(mime)) {
                    this.mOuterDecoder = new H265DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                    this.renderType = 1;
                } else if ("video/avc".equals(mime)) {
                    this.mOuterDecoder = new H264DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                    this.renderType = 0;
                } else if ("video/x-vnd.on2.vp8".equals(mime)) {
                    this.mOuterDecoder = new VP8DecRender(null, width, height);
                    this.renderType = 5;
                }
                if (!this.mYUVDecodeMode) {
                    StateMonitor.NotifyCreateRender(this.mStreamId, this.renderType);
                }
                this.mOuterDecoder.setStreamId(this.mStreamId);
                this.mOuterDecoder.setOnDecoderYUVListener(this);
            } else if (width != this.mOuterDecoder.mWidth || height != this.mOuterDecoder.mHeight) {
                YMFLog.info(this, "[Decoder ]", "reset decoder because of width or height inequality!");
                this.mOuterDecoder.reset(null, width, height);
                if (!this.mYUVDecodeMode) {
                    StateMonitor.NotifyCreateRender(this.mStreamId, this.renderType);
                }
                this.mOuterDecoder.setStreamId(this.mStreamId);
                this.mOuterDecoder.setOnDecoderYUVListener(this);
            }
        } else {
            this.mOuterDecoder.reset(null, width, height);
        }
        long mStartTime = System.currentTimeMillis();
        this.mOuterDecoder.PushFrame(null, header, 0L, true);
        VideoDataStatHelper.putDecodeTime(System.currentTimeMillis() - mStartTime);
        this.mOuterDecoder.ConfigDone();
        if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
            this.mIsDecoderNeedReconfig = true;
            this.mOuterDecoder.EndofStream();
        }
        this.mFirstFrameOut = false;
        this.isFirstOnVideoConfig = false;
        if (this.mYUVDecodeMode) {
            YMFStreamManager.instance().addStream(this.mStreamId, this);
        }
        ViewLiveStatManager.getInstace().notifyEventTime(1, 0, new ViewLiveStatManager.StatVideoHeaderInfo(width, height));
    }

    @Override
    public void OnVideoDataArrived(byte[] data, long pts) {
        if (this.mVideoDataCnt++ % 500L == 0L || (!this.mFirstFrameOut || !this.mRecIFrame) && this.mFrames <= 50) {
            YMFLog.info(this, "[Decoder ]", "OnVideoDataArrived streamId:" + this.mStreamId + ", pts:" + pts);
        }
        if (this.mOuterDecoder != null) {
            if (!(this.mFirstFrameOut && this.mRecIFrame || this.mFrames > 50)) {
                int type = 0;
                if (!(this.mOuterDecoder instanceof VP8DecRender)) {
                    type = data == null ? 255 : (data[0] == 0 && data[1] == 0 && data[2] == 1 ? data[3] & 0x1F : (data[0] == 0 && data[1] == 0 && data[2] == 0 && data[3] == 1 ? data[4] & 0x1F : -1));
                }
                if (type == 5) {
                    this.mRecIFrame = true;
                }
                YMFLog.info(this, "[Decoder ]", "handleOuterVideoData streamId:" + this.mStreamId + ", frames:" + this.mFrames + ", type:" + type + ", len:" + (data == null ? 0 : data.length) + ", pts:" + pts);
            }
            long mStartTime = System.currentTimeMillis();
            if (this.mOuterDecoder.PushFrame(null, data, pts, false) <= 0L) {
                VideoDataStatHelper.putDecodeTime(System.currentTimeMillis() - mStartTime);
                if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
                    YMFLog.warn(this, "[Decoder ]", "handleOuterVideoData decoder exception! Need to recconfig!");
                    this.mIsDecoderNeedReconfig = true;
                    this.mOuterDecoder.EndofStream();
                }
            } else {
                VideoDataStatHelper.putDecodeTime(System.currentTimeMillis() - mStartTime);
                if (!this.mFirstFrameOut) {
                    StateMonitor.instance().NotifyDecodeDelayFrameCountInfo(this.mStreamId, this.mFrames);
                    YMFPlayerUsrBehaviorStat.getInstance().notifyFirstFrameDecode();
                    YMFLog.info(this, "[Decoder ]", "handleOuterVideoData first frame out, frames:" + this.mFrames);
                }
                this.mFirstFrameOut = true;
            }
        }
    }

    @Override
    public void Quit() {
        if (this.mOuterDecoder != null) {
            if (!this.mYUVDecodeMode) {
                StateMonitor.NotifyReleaseRender(this.mStreamId);
            }
            this.mOuterDecoder.release();
            this.mOuterDecoder.EndofStream();
            this.mOuterDecoder = null;
        }
        if (this.mYUVDecodeMode) {
            YMFStreamManager.instance().removeStream(this.mStreamId);
        }
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    public void setYUVDecodeMode(boolean b) {
        this.mYUVDecodeMode = b;
    }

    public void setOnlyDecoded(boolean b) {
        YMFLog.info(this, "[Decoder ]", "setOnlyDecoded streamId:" + this.mStreamId + "," + b);
        this.mOnlyDecode = b;
    }

    @Override
    public VideoDecoderCenterExt.HardDecoderStaffVersion getHardDecodeType() {
        return VideoDecoderCenterExt.HardDecoderStaffVersion.YUVBUFFER;
    }

    @Override
    public long getUserGroupId() {
        return 0L;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback callback) {
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        return null;
    }

    @Override
    public void onFirstDecodedDataOut() {
    }

    @Override
    public void run() {
    }
}

