/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.stat.PlayerExceptionDataStat;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class HardDecodeMonitorThread
implements Runnable {
    private static final String TAG = "[HardDecodeMonitorThread]";
    private static HardDecodeMonitorThread mInstance = null;
    private HardDecodeMonitorHandler mHandler;
    private static final byte[] SYNC_FLAG = new byte[1];
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private HashMap<Long, Object> mHardDecMap;
    private final Object mStartLock = new Object();
    private int mGlobalMessageDelayed = 0;
    private static final int MSG_QUIT = 0;
    private static final int MSG_CONFIGURE_DECODER = 1;
    private static final int MSG_STOP_DECODER = 2;
    private static final int MSG_RELEASE_DECODER = 3;
    private static final int MSG_RESET_DECODER = 4;
    private static final int MSG_REGISTER_DECODER = 5;
    private static final int MSG_UNREGISTER_DECODER = 6;
    private static final int MSG_DUMP_IDRFRAME = 7;

    public void registerMediaCodecMonitorClient(HashMap<String, Object> decoderInfo) {
        if (decoderInfo == null || null == this.mHandler || decoderInfo.isEmpty()) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, decoderInfo));
    }

    private void handleRegisterMediaCodecClient(HashMap<String, Object> decoderInfo) {
        long streamId = (Long)decoderInfo.get("dr7");
        if (decoderInfo == null || decoderInfo.isEmpty()) {
            return;
        }
        this.mHardDecMap.put(streamId, decoderInfo);
        YMFLog.info(this, "[Decoder ]", "handleRegisterMediaCodecClient, streamId:" + streamId);
    }

    public void unRegisterMediaCodecMonitorClient(long streamId) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(6, streamId), this.mGlobalMessageDelayed);
    }

    private void handleUnRegisterMediaCodecClient(long streamId) {
        YMFLog.info(this, "[Decoder ]", "handleUnRegisterMediaCodecClient remove streamId:" + streamId);
        this.mHardDecMap.remove(streamId);
    }

    public void stopMediaCodec(long streamId) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        YMFLog.info(this, "[Decoder ]", "stopMediaCodec send message");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, streamId));
    }

    private void handleStopMediaCodec(long streamId) {
        HashMap decodeInfoMap;
        YMFLog.info(this, "[Decoder ]", "handleStopMediaCodec streamId:" + streamId);
        if (this.mHardDecMap.containsKey(streamId) && (decodeInfoMap = (HashMap)this.mHardDecMap.get(streamId)) != null && !decodeInfoMap.isEmpty()) {
            YMFLog.info(this, "[Decoder ]", "MediaCodec stop block!");
            decodeInfoMap.remove("dr0");
            decodeInfoMap.put("dr5", "0");
            decodeInfoMap.put("dr6", VideoDataStatHelper.toURLEncoded("MediaCodec stop block!"));
            PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(streamId, decodeInfoMap);
        }
    }

    public void dumpDecodeIDRFrameData(long streamId, String name, byte[] spsPps, byte[] data) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        DecoderDumpData dumpData = new DecoderDumpData();
        dumpData.mStreamId = streamId;
        dumpData.mSpsPps = spsPps;
        dumpData.name = name;
        dumpData.data = data;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, dumpData));
    }

    private void handleDumpDecodeIDRFrameData(DecoderDumpData dumpData) {
        if (dumpData == null) {
            return;
        }
        YYVideoLibMgr.instance().onHardwareDecodeWrongFrameNotify(dumpData.mStreamId, dumpData.name, dumpData.mSpsPps, dumpData.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HardDecodeMonitorThread instance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new HardDecodeMonitorThread();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public HardDecodeMonitorThread() {
        this.mHardDecMap = new HashMap();
        this.InitThread();
    }

    public void init() {
        YMFLog.info(this, "[Decoder ]", "Init.");
    }

    public void deInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitThread() {
        Thread mThread = new Thread(this);
        mThread.setName("YYVideoLib-HardDecodeMonitorThread");
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                mThread.start();
                this.mStartLock.wait(500L);
            }
            catch (Throwable e) {
                YMFLog.error((Object)this, "[Decoder ]", "InitThread wait exception:" + e.getMessage());
            }
        }
        YMFLog.info(this, "[Decoder ]", "construct done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mHandler = new HardDecodeMonitorHandler(this);
            this.mReady.set(true);
            Object object = this.mStartLock;
            synchronized (object) {
                this.mStartLock.notifyAll();
            }
            Looper.loop();
            this.mReady.set(false);
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Decoder ]", "end looper exception:" + t.getMessage() + " " + t.toString());
            t.printStackTrace();
        }
        finally {
            YMFLog.info(this, "[Decoder ]", "end looper!!!");
            this.deInit();
        }
    }

    private static class HardDecodeMonitorHandler
    extends Handler {
        private WeakReference<HardDecodeMonitorThread> mHardDecMonitorThread;

        private HardDecodeMonitorHandler(HardDecodeMonitorThread decodeMonitorThread) {
            this.mHardDecMonitorThread = new WeakReference<HardDecodeMonitorThread>(decodeMonitorThread);
        }

        public void handleMessage(Message msg) {
            int what = msg.what;
            if (0 == what) {
                Looper loop = Looper.myLooper();
                if (null != loop) {
                    loop.quit();
                    this.removeCallbacksAndMessages(null);
                }
                return;
            }
            HardDecodeMonitorThread decodeMonitorThread = (HardDecodeMonitorThread)this.mHardDecMonitorThread.get();
            if (decodeMonitorThread == null) {
                YMFLog.warn((Object)this, "[Decoder ]", "handleMessage:stateManager is null");
                return;
            }
            try {
                switch (what) {
                    case 2: {
                        long streamId = (Long)msg.obj;
                        decodeMonitorThread.handleStopMediaCodec(streamId);
                        break;
                    }
                    case 5: {
                        HashMap hashMap = (HashMap)msg.obj;
                        if (decodeMonitorThread == null) break;
                        decodeMonitorThread.handleRegisterMediaCodecClient(hashMap);
                        break;
                    }
                    case 6: {
                        long streamId = (Long)msg.obj;
                        decodeMonitorThread.handleUnRegisterMediaCodecClient(streamId);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 7: {
                        DecoderDumpData dumpData = (DecoderDumpData)msg.obj;
                        if (dumpData == null) break;
                        decodeMonitorThread.handleDumpDecodeIDRFrameData(dumpData);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Decoder ]", "handler thread exception:" + t.toString());
            }
        }
    }

    private class DecoderDumpData {
        public long mStreamId;
        public String name;
        public byte[] mSpsPps;
        public byte[] data;

        private DecoderDumpData() {
        }
    }
}

