/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.view.Surface;
import com.yy.videoplayer.decoder.HardDecRender;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.utils.YMFLog;
import java.util.concurrent.atomic.AtomicBoolean;

public class H265DecRender
extends HardDecRender {
    static final String mCodecType = "video/hevc";
    static String mCodecName = "";
    public static final String crashTsFirst = "H265DecRenderCrashTsFirst";
    public static final String crashTsSecond = "H265DecRenderCrashTsSecond";
    private static final String[] supportedHevcHwCodecPrefixes = new String[]{"OMX.qcom.video.", "OMX.MTK."};
    private static final String[] unSupportedHevcHwCodecPrefixes = new String[0];

    public static void getDecodeInfoAsync() {
        DecodeInfoThread decodeInfoThread = new DecodeInfoThread();
        Thread thread = new Thread((Runnable)decodeInfoThread, "YY_yylivesdk_H265DecRenderDecodeInfo_Thread");
        thread.start();
    }

    private static MediaCodecInfo selectCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo.isEncoder()) continue;
            for (String type : codecInfo.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mimeType)) continue;
                YMFLog.info(null, "[Decoder ]", "SelectCodec:" + codecInfo.getName());
                return codecInfo;
            }
        }
        return null;
    }

    public H265DecRender(Surface surface, int width, int height) {
        this.mSurface = surface;
        this.mWidth = width;
        this.mHeight = height;
        YMFLog.info(this, "[Decoder ]", "H265DecRender init");
        this.InitFields();
        this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    public H265DecRender(Surface surface, int width, int height, long groupId, long streamID) {
        this.mSurface = surface;
        this.mWidth = width;
        this.mHeight = height;
        YMFLog.info(this, "[Decoder ]", "H265DecRender init");
        this.setGroupId(groupId);
        this.setStreamId(streamID);
        this.InitFields();
        this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    public H265DecRender(Surface surface, PlayNotify playNotify) {
        this.mSurface = surface;
        this.InitFields();
        this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    public static boolean upDateCodecIgnoreCodecWhiteList() {
        mCodecName = H265DecRender.findCodecName(mCodecType, supportedHevcHwCodecPrefixes, unSupportedHevcHwCodecPrefixes, true);
        return null != mCodecName;
    }

    public static boolean IsAvailable() {
        return H265DecRender.IsAvailable(mCodecName);
    }

    public static String getCodecName() {
        return mCodecName;
    }

    void InitFields() {
        this.mSecondTsWriten = new AtomicBoolean(false);
        this.mCrashTsFirst = crashTsFirst;
        this.mCrashTsSecond = crashTsSecond;
        this.mNoFrameCnt = 0;
    }

    @Override
    public int reset() {
        return this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    @Override
    public int reset(Surface surface, int width, int height) {
        return this.reset(surface, mCodecName, mCodecType, width, height);
    }

    @Override
    public long PushFrame(Surface surface, byte[] bf, long pts, boolean isHeader) {
        return this.PushFrame(surface, mCodecName, mCodecType, bf, pts, isHeader);
    }

    static {
        H265DecRender.getDecodeInfoAsync();
    }

    static class DecodeInfoThread
    implements Runnable {
        DecodeInfoThread() {
        }

        @Override
        public void run() {
            try {
                MediaCodecInfo mediaCodecInfo = H265DecRender.selectCodec(H265DecRender.mCodecType);
                if (mediaCodecInfo != null) {
                    mCodecName = mediaCodecInfo.getName();
                    YMFLog.info(null, "[Decoder ]", "H265DecRender mediaCodecInfo.getName() mCodecName:" + mCodecName);
                }
            }
            catch (Exception e) {
                YMFLog.error(null, "[Decoder ]", "H265DecRender DecoderInfo Load exception: " + e.getMessage());
            }
        }
    }
}

