/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer;

import com.yy.videoplayer.IYMFDecoderListener;
import com.yy.videoplayer.YMFEventManager;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.HardDecodeWayBuffer;
import com.yy.videoplayer.opengles.YMFImageBuffer;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class YMFStreamManager {
    private static final String TAG = "YMFStreamManager";
    private static final byte[] SYNC_FLAG = new byte[1];
    private static YMFStreamManager mInstance = null;
    private static ConcurrentLinkedQueue<IYMFDecoderListener> mDecoderListeners = new ConcurrentLinkedQueue();
    private static ConcurrentHashMap<Long, HardDecodeWay> mStreamHardDecoderMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Long, YMFImageBuffer> mStreamImageMap = new ConcurrentHashMap();
    private static IYMFDecoderListener mDecoderListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YMFStreamManager instance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YMFStreamManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private YMFStreamManager() {
        mDecoderListener = new IYMFDecoderListener(){

            @Override
            public void onDecodedFrameAvailable(long streamId, YMFImageBuffer image) {
                for (IYMFDecoderListener listener : mDecoderListeners) {
                    listener.onDecodedFrameAvailable(streamId, image);
                }
            }
        };
    }

    public void addStream(long stream, HardDecodeWay decoder) {
        mStreamHardDecoderMap.put(stream, decoder);
        if (decoder instanceof HardDecodeWayBuffer) {
            ((HardDecodeWayBuffer)decoder).setDecoderListener(mDecoderListener);
        }
    }

    public void removeStream(long stream) {
        for (Map.Entry<Long, HardDecodeWay> entry : mStreamHardDecoderMap.entrySet()) {
            if (entry.getKey() != stream) continue;
            mStreamHardDecoderMap.remove(stream);
        }
    }

    public void registerListener(IYMFDecoderListener listener) {
        mDecoderListeners.add(listener);
    }

    public void unregisterListener(IYMFDecoderListener listener) {
        mDecoderListeners.remove(listener);
    }

    public static ByteBuffer mallocBytebuffer(long streamId, int width, int height) {
        YMFImageBuffer buffer;
        if (mStreamImageMap.containsKey(streamId)) {
            buffer = mStreamImageMap.get(streamId);
            if (buffer.mWidth == width && buffer.mHeight == height) {
                return buffer.mData;
            }
            buffer.mData = null;
            buffer = null;
            mStreamImageMap.remove(streamId);
        }
        buffer = new YMFImageBuffer(width, height, 2, true);
        if (buffer.mData != null) {
            mStreamImageMap.put(streamId, buffer);
        } else {
            YMFLog.error(null, "[Decoder ]", "mallocBytebuffer error~. buffer.mData == null.");
        }
        return buffer.mData;
    }

    public static void onSoftDecodedFrameArrived(long streamId, int length, int width, int height, long pts) {
        YMFImageBuffer image = mStreamImageMap.get(streamId);
        if (image == null || length < 0) {
            return;
        }
        if (image.mWidth != width || image.mHeight != height) {
            YMFLog.error(null, "[Decoder ]", "Image buffer size un-match !, image:" + image.mWidth + "x" + image.mHeight + " decoder:" + width + "x" + height);
            return;
        }
        image.mDts = TimeUtil.getTickCountLong();
        image.mPts = pts;
        image.mStreamId = streamId;
        for (IYMFDecoderListener listener : mDecoderListeners) {
            listener.onDecodedFrameAvailable(streamId, image);
        }
    }

    public static void onStreamStart(long streamId) {
        YMFEventManager.instance().notifyStreamStart(streamId);
    }

    public static void onStreamEnd(long streamId) {
        if (mStreamImageMap.containsKey(streamId)) {
            mStreamImageMap.remove(streamId);
        }
        YMFEventManager.instance().notifyStreamEnd(streamId);
    }
}

